/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.Lien;
import fpml.consolidated.loan.FacilityFeature;
import fpml.consolidated.loan.meta.FacilityFeaturesModelMeta;
import fpml.consolidated.shared.CreditSeniority;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilityFeaturesModel", builder=FacilityFeaturesModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FacilityFeaturesModel", model="fpml", builder=FacilityFeaturesModelBuilderImpl.class, version="1.1.0")
public interface FacilityFeaturesModel
extends RosettaModelObject {
    public static final FacilityFeaturesModelMeta metaData = new FacilityFeaturesModelMeta();

    public List<? extends FacilityFeature> getFeature();

    public Lien getLien();

    public CreditSeniority getSeniority();

    public FacilityFeaturesModel build();

    public FacilityFeaturesModelBuilder toBuilder();

    public static FacilityFeaturesModelBuilder builder() {
        return new FacilityFeaturesModelBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityFeaturesModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityFeaturesModel> getType() {
        return FacilityFeaturesModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("feature"), processor, FacilityFeature.class, this.getFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lien"), processor, Lien.class, this.getLien(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.class, this.getSeniority(), new AttributeMeta[0]);
    }

    public static class FacilityFeaturesModelBuilderImpl
    implements FacilityFeaturesModelBuilder {
        protected List<FacilityFeature.FacilityFeatureBuilder> feature = new ArrayList<FacilityFeature.FacilityFeatureBuilder>();
        protected Lien.LienBuilder lien;
        protected CreditSeniority.CreditSeniorityBuilder seniority;

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public List<? extends FacilityFeature.FacilityFeatureBuilder> getFeature() {
            return this.feature;
        }

        @Override
        public FacilityFeature.FacilityFeatureBuilder getOrCreateFeature(int index) {
            if (this.feature == null) {
                this.feature = new ArrayList<FacilityFeature.FacilityFeatureBuilder>();
            }
            return (FacilityFeature.FacilityFeatureBuilder)this.getIndex(this.feature, index, () -> {
                FacilityFeature.FacilityFeatureBuilder newFeature = FacilityFeature.builder();
                return newFeature;
            });
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public Lien.LienBuilder getLien() {
            return this.lien;
        }

        @Override
        public Lien.LienBuilder getOrCreateLien() {
            Lien.LienBuilder result = this.lien != null ? this.lien : (this.lien = Lien.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority.CreditSeniorityBuilder getSeniority() {
            return this.seniority;
        }

        @Override
        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority() {
            CreditSeniority.CreditSeniorityBuilder result = this.seniority != null ? this.seniority : (this.seniority = CreditSeniority.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public FacilityFeaturesModelBuilder addFeature(FacilityFeature _feature) {
            if (_feature != null) {
                this.feature.add(_feature.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityFeaturesModelBuilder addFeature(FacilityFeature _feature, int idx) {
            this.getIndex(this.feature, idx, () -> _feature.toBuilder());
            return this;
        }

        @Override
        public FacilityFeaturesModelBuilder addFeature(List<? extends FacilityFeature> features) {
            if (features != null) {
                for (FacilityFeature facilityFeature : features) {
                    this.feature.add(facilityFeature.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="feature")
        public FacilityFeaturesModelBuilder setFeature(List<? extends FacilityFeature> features) {
            this.feature = features == null ? new ArrayList<FacilityFeature.FacilityFeatureBuilder>() : (List)features.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public FacilityFeaturesModelBuilder setLien(Lien _lien) {
            this.lien = _lien == null ? null : _lien.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public FacilityFeaturesModelBuilder setSeniority(CreditSeniority _seniority) {
            this.seniority = _seniority == null ? null : _seniority.toBuilder();
            return this;
        }

        @Override
        public FacilityFeaturesModel build() {
            return new FacilityFeaturesModelImpl(this);
        }

        @Override
        public FacilityFeaturesModelBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityFeaturesModelBuilder prune() {
            this.feature = this.feature.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lien != null && !this.lien.prune().hasData()) {
                this.lien = null;
            }
            if (this.seniority != null && !this.seniority.prune().hasData()) {
                this.seniority = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFeature() != null && this.getFeature().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLien() != null && this.getLien().hasData()) {
                return true;
            }
            return this.getSeniority() != null && this.getSeniority().hasData();
        }

        public FacilityFeaturesModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FacilityFeaturesModelBuilder o = (FacilityFeaturesModelBuilder)other;
            merger.mergeRosetta(this.getFeature(), o.getFeature(), this::getOrCreateFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLien(), (RosettaModelObjectBuilder)o.getLien(), this::setLien);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSeniority(), (RosettaModelObjectBuilder)o.getSeniority(), this::setSeniority);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FacilityFeaturesModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.feature, _that.getFeature())) {
                return false;
            }
            if (!Objects.equals(this.lien, _that.getLien())) {
                return false;
            }
            return Objects.equals(this.seniority, _that.getSeniority());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            _result = 31 * _result + (this.lien != null ? this.lien.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FacilityFeaturesModelBuilder {feature=" + this.feature + ", lien=" + this.lien + ", seniority=" + this.seniority + '}';
        }
    }

    public static interface FacilityFeaturesModelBuilder
    extends FacilityFeaturesModel,
    RosettaModelObjectBuilder {
        public FacilityFeature.FacilityFeatureBuilder getOrCreateFeature(int var1);

        public List<? extends FacilityFeature.FacilityFeatureBuilder> getFeature();

        public Lien.LienBuilder getOrCreateLien();

        @Override
        public Lien.LienBuilder getLien();

        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority();

        @Override
        public CreditSeniority.CreditSeniorityBuilder getSeniority();

        public FacilityFeaturesModelBuilder addFeature(FacilityFeature var1);

        public FacilityFeaturesModelBuilder addFeature(FacilityFeature var1, int var2);

        public FacilityFeaturesModelBuilder addFeature(List<? extends FacilityFeature> var1);

        public FacilityFeaturesModelBuilder setFeature(List<? extends FacilityFeature> var1);

        public FacilityFeaturesModelBuilder setLien(Lien var1);

        public FacilityFeaturesModelBuilder setSeniority(CreditSeniority var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("feature"), processor, FacilityFeature.FacilityFeatureBuilder.class, this.getFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lien"), processor, Lien.LienBuilder.class, this.getLien(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.CreditSeniorityBuilder.class, this.getSeniority(), new AttributeMeta[0]);
        }

        public FacilityFeaturesModelBuilder prune();
    }

    public static class FacilityFeaturesModelImpl
    implements FacilityFeaturesModel {
        private final List<? extends FacilityFeature> feature;
        private final Lien lien;
        private final CreditSeniority seniority;

        protected FacilityFeaturesModelImpl(FacilityFeaturesModelBuilder builder) {
            this.feature = Optional.ofNullable(builder.getFeature()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lien = Optional.ofNullable(builder.getLien()).map(f -> f.build()).orElse(null);
            this.seniority = Optional.ofNullable(builder.getSeniority()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public List<? extends FacilityFeature> getFeature() {
            return this.feature;
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public Lien getLien() {
            return this.lien;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority getSeniority() {
            return this.seniority;
        }

        @Override
        public FacilityFeaturesModel build() {
            return this;
        }

        @Override
        public FacilityFeaturesModelBuilder toBuilder() {
            FacilityFeaturesModelBuilder builder = FacilityFeaturesModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityFeaturesModelBuilder builder) {
            Optional.ofNullable(this.getFeature()).ifPresent(builder::setFeature);
            Optional.ofNullable(this.getLien()).ifPresent(builder::setLien);
            Optional.ofNullable(this.getSeniority()).ifPresent(builder::setSeniority);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FacilityFeaturesModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.feature, _that.getFeature())) {
                return false;
            }
            if (!Objects.equals(this.lien, _that.getLien())) {
                return false;
            }
            return Objects.equals(this.seniority, _that.getSeniority());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            _result = 31 * _result + (this.lien != null ? this.lien.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FacilityFeaturesModel {feature=" + this.feature + ", lien=" + this.lien + ", seniority=" + this.seniority + '}';
        }
    }
}

