/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.meta.BuyerSellerAmountsMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BuyerSellerAmounts", builder=BuyerSellerAmountsBuilderImpl.class, version="1.1.0")
@RuneDataType(value="BuyerSellerAmounts", model="fpml", builder=BuyerSellerAmountsBuilderImpl.class, version="1.1.0")
public interface BuyerSellerAmounts
extends RosettaModelObject {
    public static final BuyerSellerAmountsMeta metaData = new BuyerSellerAmountsMeta();

    public NonNegativeMoney getBuyersAmount();

    public NonNegativeMoney getSellersAmount();

    public BuyerSellerAmounts build();

    public BuyerSellerAmountsBuilder toBuilder();

    public static BuyerSellerAmountsBuilder builder() {
        return new BuyerSellerAmountsBuilderImpl();
    }

    default public RosettaMetaData<? extends BuyerSellerAmounts> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BuyerSellerAmounts> getType() {
        return BuyerSellerAmounts.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("buyersAmount"), processor, NonNegativeMoney.class, this.getBuyersAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sellersAmount"), processor, NonNegativeMoney.class, this.getSellersAmount(), new AttributeMeta[0]);
    }

    public static class BuyerSellerAmountsBuilderImpl
    implements BuyerSellerAmountsBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder buyersAmount;
        protected NonNegativeMoney.NonNegativeMoneyBuilder sellersAmount;

        @Override
        @RosettaAttribute(value="buyersAmount", isRequired=true)
        @RuneAttribute(value="buyersAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getBuyersAmount() {
            return this.buyersAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateBuyersAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.buyersAmount != null ? this.buyersAmount : (this.buyersAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="sellersAmount", isRequired=true)
        @RuneAttribute(value="sellersAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getSellersAmount() {
            return this.sellersAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateSellersAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.sellersAmount != null ? this.sellersAmount : (this.sellersAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="buyersAmount", isRequired=true)
        @RuneAttribute(value="buyersAmount", isRequired=true)
        public BuyerSellerAmountsBuilder setBuyersAmount(NonNegativeMoney _buyersAmount) {
            this.buyersAmount = _buyersAmount == null ? null : _buyersAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sellersAmount", isRequired=true)
        @RuneAttribute(value="sellersAmount", isRequired=true)
        public BuyerSellerAmountsBuilder setSellersAmount(NonNegativeMoney _sellersAmount) {
            this.sellersAmount = _sellersAmount == null ? null : _sellersAmount.toBuilder();
            return this;
        }

        @Override
        public BuyerSellerAmounts build() {
            return new BuyerSellerAmountsImpl(this);
        }

        @Override
        public BuyerSellerAmountsBuilder toBuilder() {
            return this;
        }

        @Override
        public BuyerSellerAmountsBuilder prune() {
            if (this.buyersAmount != null && !this.buyersAmount.prune().hasData()) {
                this.buyersAmount = null;
            }
            if (this.sellersAmount != null && !this.sellersAmount.prune().hasData()) {
                this.sellersAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBuyersAmount() != null && this.getBuyersAmount().hasData()) {
                return true;
            }
            return this.getSellersAmount() != null && this.getSellersAmount().hasData();
        }

        public BuyerSellerAmountsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BuyerSellerAmountsBuilder o = (BuyerSellerAmountsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyersAmount(), (RosettaModelObjectBuilder)o.getBuyersAmount(), this::setBuyersAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSellersAmount(), (RosettaModelObjectBuilder)o.getSellersAmount(), this::setSellersAmount);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BuyerSellerAmounts _that = this.getType().cast(o);
            if (!Objects.equals(this.buyersAmount, _that.getBuyersAmount())) {
                return false;
            }
            return Objects.equals(this.sellersAmount, _that.getSellersAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.buyersAmount != null ? this.buyersAmount.hashCode() : 0);
            _result = 31 * _result + (this.sellersAmount != null ? this.sellersAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BuyerSellerAmountsBuilder {buyersAmount=" + this.buyersAmount + ", sellersAmount=" + this.sellersAmount + '}';
        }
    }

    public static interface BuyerSellerAmountsBuilder
    extends BuyerSellerAmounts,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateBuyersAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getBuyersAmount();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateSellersAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getSellersAmount();

        public BuyerSellerAmountsBuilder setBuyersAmount(NonNegativeMoney var1);

        public BuyerSellerAmountsBuilder setSellersAmount(NonNegativeMoney var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("buyersAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getBuyersAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sellersAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getSellersAmount(), new AttributeMeta[0]);
        }

        public BuyerSellerAmountsBuilder prune();
    }

    public static class BuyerSellerAmountsImpl
    implements BuyerSellerAmounts {
        private final NonNegativeMoney buyersAmount;
        private final NonNegativeMoney sellersAmount;

        protected BuyerSellerAmountsImpl(BuyerSellerAmountsBuilder builder) {
            this.buyersAmount = Optional.ofNullable(builder.getBuyersAmount()).map(f -> f.build()).orElse(null);
            this.sellersAmount = Optional.ofNullable(builder.getSellersAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyersAmount", isRequired=true)
        @RuneAttribute(value="buyersAmount", isRequired=true)
        public NonNegativeMoney getBuyersAmount() {
            return this.buyersAmount;
        }

        @Override
        @RosettaAttribute(value="sellersAmount", isRequired=true)
        @RuneAttribute(value="sellersAmount", isRequired=true)
        public NonNegativeMoney getSellersAmount() {
            return this.sellersAmount;
        }

        @Override
        public BuyerSellerAmounts build() {
            return this;
        }

        @Override
        public BuyerSellerAmountsBuilder toBuilder() {
            BuyerSellerAmountsBuilder builder = BuyerSellerAmounts.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BuyerSellerAmountsBuilder builder) {
            Optional.ofNullable(this.getBuyersAmount()).ifPresent(builder::setBuyersAmount);
            Optional.ofNullable(this.getSellersAmount()).ifPresent(builder::setSellersAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BuyerSellerAmounts _that = this.getType().cast(o);
            if (!Objects.equals(this.buyersAmount, _that.getBuyersAmount())) {
                return false;
            }
            return Objects.equals(this.sellersAmount, _that.getSellersAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.buyersAmount != null ? this.buyersAmount.hashCode() : 0);
            _result = 31 * _result + (this.sellersAmount != null ? this.sellersAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BuyerSellerAmounts {buyersAmount=" + this.buyersAmount + ", sellersAmount=" + this.sellersAmount + '}';
        }
    }
}

