/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractFacilityEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.AccrualPeriod;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.AccruingPikPaymentMeta;
import fpml.consolidated.shared.PeriodModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AccruingPikPayment", builder=AccruingPikPaymentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AccruingPikPayment", model="fpml", builder=AccruingPikPaymentBuilderImpl.class, version="1.1.0")
public interface AccruingPikPayment
extends AbstractFacilityEvent {
    public static final AccruingPikPaymentMeta metaData = new AccruingPikPaymentMeta();

    public PeriodModel getPeriodModel();

    public MoneyWithParticipantShare getAmount();

    public List<? extends AccrualPeriod> getAccrualSchedule();

    @Override
    public AccruingPikPayment build();

    @Override
    public AccruingPikPaymentBuilder toBuilder();

    public static AccruingPikPaymentBuilder builder() {
        return new AccruingPikPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends AccruingPikPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccruingPikPayment> getType() {
        return AccruingPikPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualSchedule"), processor, AccrualPeriod.class, this.getAccrualSchedule(), new AttributeMeta[0]);
    }

    public static class AccruingPikPaymentBuilderImpl
    extends AbstractFacilityEvent.AbstractFacilityEventBuilderImpl
    implements AccruingPikPaymentBuilder {
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected List<AccrualPeriod.AccrualPeriodBuilder> accrualSchedule = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getAccrualSchedule() {
            return this.accrualSchedule;
        }

        @Override
        public AccrualPeriod.AccrualPeriodBuilder getOrCreateAccrualSchedule(int index) {
            if (this.accrualSchedule == null) {
                this.accrualSchedule = new ArrayList<AccrualPeriod.AccrualPeriodBuilder>();
            }
            return (AccrualPeriod.AccrualPeriodBuilder)this.getIndex(this.accrualSchedule, index, () -> {
                AccrualPeriod.AccrualPeriodBuilder newAccrualSchedule = AccrualPeriod.builder();
                return newAccrualSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AccruingPikPaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AccruingPikPaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AccruingPikPaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AccruingPikPaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AccruingPikPaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AccruingPikPaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AccruingPikPaymentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public AccruingPikPaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AccruingPikPaymentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public AccruingPikPaymentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public AccruingPikPaymentBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public AccruingPikPaymentBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public AccruingPikPaymentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public AccruingPikPaymentBuilder addAccrualSchedule(AccrualPeriod _accrualSchedule) {
            if (_accrualSchedule != null) {
                this.accrualSchedule.add(_accrualSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public AccruingPikPaymentBuilder addAccrualSchedule(AccrualPeriod _accrualSchedule, int idx) {
            this.getIndex(this.accrualSchedule, idx, () -> _accrualSchedule.toBuilder());
            return this;
        }

        @Override
        public AccruingPikPaymentBuilder addAccrualSchedule(List<? extends AccrualPeriod> accrualSchedules) {
            if (accrualSchedules != null) {
                for (AccrualPeriod accrualPeriod : accrualSchedules) {
                    this.accrualSchedule.add(accrualPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accrualSchedule")
        public AccruingPikPaymentBuilder setAccrualSchedule(List<? extends AccrualPeriod> accrualSchedules) {
            this.accrualSchedule = accrualSchedules == null ? new ArrayList<AccrualPeriod.AccrualPeriodBuilder>() : (List)accrualSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AccruingPikPayment build() {
            return new AccruingPikPaymentImpl(this);
        }

        @Override
        public AccruingPikPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public AccruingPikPaymentBuilder prune() {
            super.prune();
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            this.accrualSchedule = this.accrualSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getAccrualSchedule() != null && this.getAccrualSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public AccruingPikPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AccruingPikPaymentBuilder o = (AccruingPikPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta(this.getAccrualSchedule(), o.getAccrualSchedule(), this::getOrCreateAccrualSchedule);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccruingPikPayment _that = (AccruingPikPayment)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.accrualSchedule, _that.getAccrualSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accrualSchedule != null ? this.accrualSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AccruingPikPaymentBuilder {periodModel=" + this.periodModel + ", amount=" + this.amount + ", accrualSchedule=" + this.accrualSchedule + '}' + " " + super.toString();
        }
    }

    public static interface AccruingPikPaymentBuilder
    extends AccruingPikPayment,
    AbstractFacilityEvent.AbstractFacilityEventBuilder {
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public AccrualPeriod.AccrualPeriodBuilder getOrCreateAccrualSchedule(int var1);

        public List<? extends AccrualPeriod.AccrualPeriodBuilder> getAccrualSchedule();

        @Override
        public AccruingPikPaymentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AccruingPikPaymentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AccruingPikPaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AccruingPikPaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AccruingPikPaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AccruingPikPaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AccruingPikPaymentBuilder setComment(String var1);

        @Override
        public AccruingPikPaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public AccruingPikPaymentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public AccruingPikPaymentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public AccruingPikPaymentBuilder setFacilityReference(FacilityReference var1);

        public AccruingPikPaymentBuilder setPeriodModel(PeriodModel var1);

        public AccruingPikPaymentBuilder setAmount(MoneyWithParticipantShare var1);

        public AccruingPikPaymentBuilder addAccrualSchedule(AccrualPeriod var1);

        public AccruingPikPaymentBuilder addAccrualSchedule(AccrualPeriod var1, int var2);

        public AccruingPikPaymentBuilder addAccrualSchedule(List<? extends AccrualPeriod> var1);

        public AccruingPikPaymentBuilder setAccrualSchedule(List<? extends AccrualPeriod> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualSchedule"), processor, AccrualPeriod.AccrualPeriodBuilder.class, this.getAccrualSchedule(), new AttributeMeta[0]);
        }

        @Override
        public AccruingPikPaymentBuilder prune();
    }

    public static class AccruingPikPaymentImpl
    extends AbstractFacilityEvent.AbstractFacilityEventImpl
    implements AccruingPikPayment {
        private final PeriodModel periodModel;
        private final MoneyWithParticipantShare amount;
        private final List<? extends AccrualPeriod> accrualSchedule;

        protected AccruingPikPaymentImpl(AccruingPikPaymentBuilder builder) {
            super(builder);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.accrualSchedule = Optional.ofNullable(builder.getAccrualSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public List<? extends AccrualPeriod> getAccrualSchedule() {
            return this.accrualSchedule;
        }

        @Override
        public AccruingPikPayment build() {
            return this;
        }

        @Override
        public AccruingPikPaymentBuilder toBuilder() {
            AccruingPikPaymentBuilder builder = AccruingPikPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccruingPikPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getAccrualSchedule()).ifPresent(builder::setAccrualSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccruingPikPayment _that = (AccruingPikPayment)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return ListEquals.listEquals(this.accrualSchedule, _that.getAccrualSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.accrualSchedule != null ? this.accrualSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AccruingPikPayment {periodModel=" + this.periodModel + ", amount=" + this.amount + ", accrualSchedule=" + this.accrualSchedule + '}' + " " + super.toString();
        }
    }
}

