/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.FixedRateOption;
import fpml.consolidated.loan.LegacyFloatingRateOption;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanFloatingRateOption;
import fpml.consolidated.loan.meta.AccrualOptionChangeSequence0Meta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AccrualOptionChangeSequence0", builder=AccrualOptionChangeSequence0BuilderImpl.class, version="1.1.0")
@RuneDataType(value="AccrualOptionChangeSequence0", model="fpml", builder=AccrualOptionChangeSequence0BuilderImpl.class, version="1.1.0")
public interface AccrualOptionChangeSequence0
extends RosettaModelObject {
    public static final AccrualOptionChangeSequence0Meta metaData = new AccrualOptionChangeSequence0Meta();

    public FixedRateOption getFixedRateOption();

    public LoanFloatingRateOption getFloatingRateOption();

    public LegacyFloatingRateOption getLegacyFloatingRateOption();

    public List<? extends LoanContractReference> getLoanContractReference();

    public AccrualOptionChangeSequence0 build();

    public AccrualOptionChangeSequence0Builder toBuilder();

    public static AccrualOptionChangeSequence0Builder builder() {
        return new AccrualOptionChangeSequence0BuilderImpl();
    }

    default public RosettaMetaData<? extends AccrualOptionChangeSequence0> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccrualOptionChangeSequence0> getType() {
        return AccrualOptionChangeSequence0.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fixedRateOption"), processor, FixedRateOption.class, this.getFixedRateOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateOption"), processor, LoanFloatingRateOption.class, this.getFloatingRateOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyFloatingRateOption"), processor, LegacyFloatingRateOption.class, this.getLegacyFloatingRateOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
    }

    public static class AccrualOptionChangeSequence0BuilderImpl
    implements AccrualOptionChangeSequence0Builder {
        protected FixedRateOption.FixedRateOptionBuilder fixedRateOption;
        protected LoanFloatingRateOption.LoanFloatingRateOptionBuilder floatingRateOption;
        protected LegacyFloatingRateOption.LegacyFloatingRateOptionBuilder legacyFloatingRateOption;
        protected List<LoanContractReference.LoanContractReferenceBuilder> loanContractReference = new ArrayList<LoanContractReference.LoanContractReferenceBuilder>();

        @Override
        @RosettaAttribute(value="fixedRateOption")
        @RuneAttribute(value="fixedRateOption")
        public FixedRateOption.FixedRateOptionBuilder getFixedRateOption() {
            return this.fixedRateOption;
        }

        @Override
        public FixedRateOption.FixedRateOptionBuilder getOrCreateFixedRateOption() {
            FixedRateOption.FixedRateOptionBuilder result = this.fixedRateOption != null ? this.fixedRateOption : (this.fixedRateOption = FixedRateOption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRateOption")
        @RuneAttribute(value="floatingRateOption")
        public LoanFloatingRateOption.LoanFloatingRateOptionBuilder getFloatingRateOption() {
            return this.floatingRateOption;
        }

        @Override
        public LoanFloatingRateOption.LoanFloatingRateOptionBuilder getOrCreateFloatingRateOption() {
            LoanFloatingRateOption.LoanFloatingRateOptionBuilder result = this.floatingRateOption != null ? this.floatingRateOption : (this.floatingRateOption = LoanFloatingRateOption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateOption")
        @RuneAttribute(value="legacyFloatingRateOption")
        public LegacyFloatingRateOption.LegacyFloatingRateOptionBuilder getLegacyFloatingRateOption() {
            return this.legacyFloatingRateOption;
        }

        @Override
        public LegacyFloatingRateOption.LegacyFloatingRateOptionBuilder getOrCreateLegacyFloatingRateOption() {
            LegacyFloatingRateOption.LegacyFloatingRateOptionBuilder result = this.legacyFloatingRateOption != null ? this.legacyFloatingRateOption : (this.legacyFloatingRateOption = LegacyFloatingRateOption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public List<? extends LoanContractReference.LoanContractReferenceBuilder> getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference(int index) {
            if (this.loanContractReference == null) {
                this.loanContractReference = new ArrayList<LoanContractReference.LoanContractReferenceBuilder>();
            }
            return (LoanContractReference.LoanContractReferenceBuilder)this.getIndex(this.loanContractReference, index, () -> {
                LoanContractReference.LoanContractReferenceBuilder newLoanContractReference = LoanContractReference.builder();
                return newLoanContractReference;
            });
        }

        @Override
        @RosettaAttribute(value="fixedRateOption")
        @RuneAttribute(value="fixedRateOption")
        public AccrualOptionChangeSequence0Builder setFixedRateOption(FixedRateOption _fixedRateOption) {
            this.fixedRateOption = _fixedRateOption == null ? null : _fixedRateOption.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateOption")
        @RuneAttribute(value="floatingRateOption")
        public AccrualOptionChangeSequence0Builder setFloatingRateOption(LoanFloatingRateOption _floatingRateOption) {
            this.floatingRateOption = _floatingRateOption == null ? null : _floatingRateOption.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateOption")
        @RuneAttribute(value="legacyFloatingRateOption")
        public AccrualOptionChangeSequence0Builder setLegacyFloatingRateOption(LegacyFloatingRateOption _legacyFloatingRateOption) {
            this.legacyFloatingRateOption = _legacyFloatingRateOption == null ? null : _legacyFloatingRateOption.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public AccrualOptionChangeSequence0Builder addLoanContractReference(LoanContractReference _loanContractReference) {
            if (_loanContractReference != null) {
                this.loanContractReference.add(_loanContractReference.toBuilder());
            }
            return this;
        }

        @Override
        public AccrualOptionChangeSequence0Builder addLoanContractReference(LoanContractReference _loanContractReference, int idx) {
            this.getIndex(this.loanContractReference, idx, () -> _loanContractReference.toBuilder());
            return this;
        }

        @Override
        public AccrualOptionChangeSequence0Builder addLoanContractReference(List<? extends LoanContractReference> loanContractReferences) {
            if (loanContractReferences != null) {
                for (LoanContractReference loanContractReference : loanContractReferences) {
                    this.loanContractReference.add(loanContractReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanContractReference")
        public AccrualOptionChangeSequence0Builder setLoanContractReference(List<? extends LoanContractReference> loanContractReferences) {
            this.loanContractReference = loanContractReferences == null ? new ArrayList<LoanContractReference.LoanContractReferenceBuilder>() : (List)loanContractReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AccrualOptionChangeSequence0 build() {
            return new AccrualOptionChangeSequence0Impl(this);
        }

        @Override
        public AccrualOptionChangeSequence0Builder toBuilder() {
            return this;
        }

        @Override
        public AccrualOptionChangeSequence0Builder prune() {
            if (this.fixedRateOption != null && !this.fixedRateOption.prune().hasData()) {
                this.fixedRateOption = null;
            }
            if (this.floatingRateOption != null && !this.floatingRateOption.prune().hasData()) {
                this.floatingRateOption = null;
            }
            if (this.legacyFloatingRateOption != null && !this.legacyFloatingRateOption.prune().hasData()) {
                this.legacyFloatingRateOption = null;
            }
            this.loanContractReference = this.loanContractReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFixedRateOption() != null && this.getFixedRateOption().hasData()) {
                return true;
            }
            if (this.getFloatingRateOption() != null && this.getFloatingRateOption().hasData()) {
                return true;
            }
            if (this.getLegacyFloatingRateOption() != null && this.getLegacyFloatingRateOption().hasData()) {
                return true;
            }
            return this.getLoanContractReference() != null && this.getLoanContractReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AccrualOptionChangeSequence0Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AccrualOptionChangeSequence0Builder o = (AccrualOptionChangeSequence0Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedRateOption(), (RosettaModelObjectBuilder)o.getFixedRateOption(), this::setFixedRateOption);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateOption(), (RosettaModelObjectBuilder)o.getFloatingRateOption(), this::setFloatingRateOption);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegacyFloatingRateOption(), (RosettaModelObjectBuilder)o.getLegacyFloatingRateOption(), this::setLegacyFloatingRateOption);
            merger.mergeRosetta(this.getLoanContractReference(), o.getLoanContractReference(), this::getOrCreateLoanContractReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccrualOptionChangeSequence0 _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedRateOption, _that.getFixedRateOption())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateOption, _that.getFloatingRateOption())) {
                return false;
            }
            if (!Objects.equals(this.legacyFloatingRateOption, _that.getLegacyFloatingRateOption())) {
                return false;
            }
            return ListEquals.listEquals(this.loanContractReference, _that.getLoanContractReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRateOption != null ? this.fixedRateOption.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateOption != null ? this.floatingRateOption.hashCode() : 0);
            _result = 31 * _result + (this.legacyFloatingRateOption != null ? this.legacyFloatingRateOption.hashCode() : 0);
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccrualOptionChangeSequence0Builder {fixedRateOption=" + this.fixedRateOption + ", floatingRateOption=" + this.floatingRateOption + ", legacyFloatingRateOption=" + this.legacyFloatingRateOption + ", loanContractReference=" + this.loanContractReference + '}';
        }
    }

    public static interface AccrualOptionChangeSequence0Builder
    extends AccrualOptionChangeSequence0,
    RosettaModelObjectBuilder {
        public FixedRateOption.FixedRateOptionBuilder getOrCreateFixedRateOption();

        @Override
        public FixedRateOption.FixedRateOptionBuilder getFixedRateOption();

        public LoanFloatingRateOption.LoanFloatingRateOptionBuilder getOrCreateFloatingRateOption();

        @Override
        public LoanFloatingRateOption.LoanFloatingRateOptionBuilder getFloatingRateOption();

        public LegacyFloatingRateOption.LegacyFloatingRateOptionBuilder getOrCreateLegacyFloatingRateOption();

        @Override
        public LegacyFloatingRateOption.LegacyFloatingRateOptionBuilder getLegacyFloatingRateOption();

        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference(int var1);

        public List<? extends LoanContractReference.LoanContractReferenceBuilder> getLoanContractReference();

        public AccrualOptionChangeSequence0Builder setFixedRateOption(FixedRateOption var1);

        public AccrualOptionChangeSequence0Builder setFloatingRateOption(LoanFloatingRateOption var1);

        public AccrualOptionChangeSequence0Builder setLegacyFloatingRateOption(LegacyFloatingRateOption var1);

        public AccrualOptionChangeSequence0Builder addLoanContractReference(LoanContractReference var1);

        public AccrualOptionChangeSequence0Builder addLoanContractReference(LoanContractReference var1, int var2);

        public AccrualOptionChangeSequence0Builder addLoanContractReference(List<? extends LoanContractReference> var1);

        public AccrualOptionChangeSequence0Builder setLoanContractReference(List<? extends LoanContractReference> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fixedRateOption"), processor, FixedRateOption.FixedRateOptionBuilder.class, this.getFixedRateOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateOption"), processor, LoanFloatingRateOption.LoanFloatingRateOptionBuilder.class, this.getFloatingRateOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyFloatingRateOption"), processor, LegacyFloatingRateOption.LegacyFloatingRateOptionBuilder.class, this.getLegacyFloatingRateOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, this.getLoanContractReference(), new AttributeMeta[0]);
        }

        public AccrualOptionChangeSequence0Builder prune();
    }

    public static class AccrualOptionChangeSequence0Impl
    implements AccrualOptionChangeSequence0 {
        private final FixedRateOption fixedRateOption;
        private final LoanFloatingRateOption floatingRateOption;
        private final LegacyFloatingRateOption legacyFloatingRateOption;
        private final List<? extends LoanContractReference> loanContractReference;

        protected AccrualOptionChangeSequence0Impl(AccrualOptionChangeSequence0Builder builder) {
            this.fixedRateOption = Optional.ofNullable(builder.getFixedRateOption()).map(f -> f.build()).orElse(null);
            this.floatingRateOption = Optional.ofNullable(builder.getFloatingRateOption()).map(f -> f.build()).orElse(null);
            this.legacyFloatingRateOption = Optional.ofNullable(builder.getLegacyFloatingRateOption()).map(f -> f.build()).orElse(null);
            this.loanContractReference = Optional.ofNullable(builder.getLoanContractReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedRateOption")
        @RuneAttribute(value="fixedRateOption")
        public FixedRateOption getFixedRateOption() {
            return this.fixedRateOption;
        }

        @Override
        @RosettaAttribute(value="floatingRateOption")
        @RuneAttribute(value="floatingRateOption")
        public LoanFloatingRateOption getFloatingRateOption() {
            return this.floatingRateOption;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateOption")
        @RuneAttribute(value="legacyFloatingRateOption")
        public LegacyFloatingRateOption getLegacyFloatingRateOption() {
            return this.legacyFloatingRateOption;
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public List<? extends LoanContractReference> getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public AccrualOptionChangeSequence0 build() {
            return this;
        }

        @Override
        public AccrualOptionChangeSequence0Builder toBuilder() {
            AccrualOptionChangeSequence0Builder builder = AccrualOptionChangeSequence0.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccrualOptionChangeSequence0Builder builder) {
            Optional.ofNullable(this.getFixedRateOption()).ifPresent(builder::setFixedRateOption);
            Optional.ofNullable(this.getFloatingRateOption()).ifPresent(builder::setFloatingRateOption);
            Optional.ofNullable(this.getLegacyFloatingRateOption()).ifPresent(builder::setLegacyFloatingRateOption);
            Optional.ofNullable(this.getLoanContractReference()).ifPresent(builder::setLoanContractReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AccrualOptionChangeSequence0 _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedRateOption, _that.getFixedRateOption())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateOption, _that.getFloatingRateOption())) {
                return false;
            }
            if (!Objects.equals(this.legacyFloatingRateOption, _that.getLegacyFloatingRateOption())) {
                return false;
            }
            return ListEquals.listEquals(this.loanContractReference, _that.getLoanContractReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRateOption != null ? this.fixedRateOption.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateOption != null ? this.floatingRateOption.hashCode() : 0);
            _result = 31 * _result + (this.legacyFloatingRateOption != null ? this.legacyFloatingRateOption.hashCode() : 0);
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccrualOptionChangeSequence0 {fixedRateOption=" + this.fixedRateOption + ", floatingRateOption=" + this.floatingRateOption + ", legacyFloatingRateOption=" + this.legacyFloatingRateOption + ", loanContractReference=" + this.loanContractReference + '}';
        }
    }
}

