/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.AbstractPartyProfileId;
import fpml.consolidated.loan.PartyProfileDocumentation;
import fpml.consolidated.loan.PartyProfileIdentifier;
import fpml.consolidated.loan.meta.AbstractPartyProfileMeta;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.RelatedParty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractPartyProfile", builder=AbstractPartyProfileBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractPartyProfile", model="fpml", builder=AbstractPartyProfileBuilderImpl.class, version="1.1.0")
public interface AbstractPartyProfile
extends AbstractPartyProfileId {
    public static final AbstractPartyProfileMeta metaData = new AbstractPartyProfileMeta();

    public ZonedDateTime getEffectiveDate();

    public PartyReference getPartyReference();

    public List<? extends RelatedParty> getRelatedParty();

    public PartyProfileDocumentation getDocumentation();

    @Override
    public AbstractPartyProfile build();

    @Override
    public AbstractPartyProfileBuilder toBuilder();

    public static AbstractPartyProfileBuilder builder() {
        return new AbstractPartyProfileBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractPartyProfile> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractPartyProfile> getType() {
        return AbstractPartyProfile.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyProfileIdentifier"), processor, PartyProfileIdentifier.class, this.getPartyProfileIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("documentation"), processor, PartyProfileDocumentation.class, this.getDocumentation(), new AttributeMeta[0]);
    }

    public static class AbstractPartyProfileBuilderImpl
    extends AbstractPartyProfileId.AbstractPartyProfileIdBuilderImpl
    implements AbstractPartyProfileBuilder {
        protected ZonedDateTime effectiveDate;
        protected PartyReference.PartyReferenceBuilder partyReference;
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
        protected PartyProfileDocumentation.PartyProfileDocumentationBuilder documentation;

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference() {
            PartyReference.PartyReferenceBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public PartyProfileDocumentation.PartyProfileDocumentationBuilder getDocumentation() {
            return this.documentation;
        }

        @Override
        public PartyProfileDocumentation.PartyProfileDocumentationBuilder getOrCreateDocumentation() {
            PartyProfileDocumentation.PartyProfileDocumentationBuilder result = this.documentation != null ? this.documentation : (this.documentation = PartyProfileDocumentation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyProfileIdentifier", isRequired=true)
        @RuneAttribute(value="partyProfileIdentifier", isRequired=true)
        public AbstractPartyProfileBuilder addPartyProfileIdentifier(PartyProfileIdentifier _partyProfileIdentifier) {
            if (_partyProfileIdentifier != null) {
                this.partyProfileIdentifier.add(_partyProfileIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractPartyProfileBuilder addPartyProfileIdentifier(PartyProfileIdentifier _partyProfileIdentifier, int idx) {
            this.getIndex(this.partyProfileIdentifier, idx, () -> _partyProfileIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractPartyProfileBuilder addPartyProfileIdentifier(List<? extends PartyProfileIdentifier> partyProfileIdentifiers) {
            if (partyProfileIdentifiers != null) {
                for (PartyProfileIdentifier partyProfileIdentifier : partyProfileIdentifiers) {
                    this.partyProfileIdentifier.add(partyProfileIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyProfileIdentifier")
        public AbstractPartyProfileBuilder setPartyProfileIdentifier(List<? extends PartyProfileIdentifier> partyProfileIdentifiers) {
            this.partyProfileIdentifier = partyProfileIdentifiers == null ? new ArrayList() : (List)partyProfileIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AbstractPartyProfileBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public AbstractPartyProfileBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public AbstractPartyProfileBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractPartyProfileBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public AbstractPartyProfileBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public AbstractPartyProfileBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public AbstractPartyProfileBuilder setDocumentation(PartyProfileDocumentation _documentation) {
            this.documentation = _documentation == null ? null : _documentation.toBuilder();
            return this;
        }

        @Override
        public AbstractPartyProfile build() {
            return new AbstractPartyProfileImpl(this);
        }

        @Override
        public AbstractPartyProfileBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractPartyProfileBuilder prune() {
            super.prune();
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.documentation != null && !this.documentation.prune().hasData()) {
                this.documentation = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            if (this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDocumentation() != null && this.getDocumentation().hasData();
        }

        @Override
        public AbstractPartyProfileBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractPartyProfileBuilder o = (AbstractPartyProfileBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDocumentation(), (RosettaModelObjectBuilder)o.getDocumentation(), this::setDocumentation);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractPartyProfile _that = (AbstractPartyProfile)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            return Objects.equals(this.documentation, _that.getDocumentation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.documentation != null ? this.documentation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractPartyProfileBuilder {effectiveDate=" + this.effectiveDate + ", partyReference=" + this.partyReference + ", relatedParty=" + this.relatedParty + ", documentation=" + this.documentation + '}' + " " + super.toString();
        }
    }

    public static interface AbstractPartyProfileBuilder
    extends AbstractPartyProfile,
    AbstractPartyProfileId.AbstractPartyProfileIdBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPartyReference();

        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public PartyProfileDocumentation.PartyProfileDocumentationBuilder getOrCreateDocumentation();

        @Override
        public PartyProfileDocumentation.PartyProfileDocumentationBuilder getDocumentation();

        @Override
        public AbstractPartyProfileBuilder addPartyProfileIdentifier(PartyProfileIdentifier var1);

        @Override
        public AbstractPartyProfileBuilder addPartyProfileIdentifier(PartyProfileIdentifier var1, int var2);

        @Override
        public AbstractPartyProfileBuilder addPartyProfileIdentifier(List<? extends PartyProfileIdentifier> var1);

        @Override
        public AbstractPartyProfileBuilder setPartyProfileIdentifier(List<? extends PartyProfileIdentifier> var1);

        public AbstractPartyProfileBuilder setEffectiveDate(ZonedDateTime var1);

        public AbstractPartyProfileBuilder setPartyReference(PartyReference var1);

        public AbstractPartyProfileBuilder addRelatedParty(RelatedParty var1);

        public AbstractPartyProfileBuilder addRelatedParty(RelatedParty var1, int var2);

        public AbstractPartyProfileBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public AbstractPartyProfileBuilder setRelatedParty(List<? extends RelatedParty> var1);

        public AbstractPartyProfileBuilder setDocumentation(PartyProfileDocumentation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyProfileIdentifier"), processor, PartyProfileIdentifier.PartyProfileIdentifierBuilder.class, this.getPartyProfileIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("documentation"), processor, PartyProfileDocumentation.PartyProfileDocumentationBuilder.class, this.getDocumentation(), new AttributeMeta[0]);
        }

        @Override
        public AbstractPartyProfileBuilder prune();
    }

    public static class AbstractPartyProfileImpl
    extends AbstractPartyProfileId.AbstractPartyProfileIdImpl
    implements AbstractPartyProfile {
        private final ZonedDateTime effectiveDate;
        private final PartyReference partyReference;
        private final List<? extends RelatedParty> relatedParty;
        private final PartyProfileDocumentation documentation;

        protected AbstractPartyProfileImpl(AbstractPartyProfileBuilder builder) {
            super(builder);
            this.effectiveDate = builder.getEffectiveDate();
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.documentation = Optional.ofNullable(builder.getDocumentation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartyReference getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        @RosettaAttribute(value="documentation")
        @RuneAttribute(value="documentation")
        public PartyProfileDocumentation getDocumentation() {
            return this.documentation;
        }

        @Override
        public AbstractPartyProfile build() {
            return this;
        }

        @Override
        public AbstractPartyProfileBuilder toBuilder() {
            AbstractPartyProfileBuilder builder = AbstractPartyProfile.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractPartyProfileBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
            Optional.ofNullable(this.getDocumentation()).ifPresent(builder::setDocumentation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractPartyProfile _that = (AbstractPartyProfile)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            return Objects.equals(this.documentation, _that.getDocumentation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.documentation != null ? this.documentation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractPartyProfile {effectiveDate=" + this.effectiveDate + ", partyReference=" + this.partyReference + ", relatedParty=" + this.relatedParty + ", documentation=" + this.documentation + '}' + " " + super.toString();
        }
    }
}

