/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.meta.AbstractLoanStatementMeta;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AbstractLoanStatement", builder=AbstractLoanStatementBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractLoanStatement", model="fpml", builder=AbstractLoanStatementBuilderImpl.class, version="1.1.0")
public interface AbstractLoanStatement
extends CorrectableRequestMessage {
    public static final AbstractLoanStatementMeta metaData = new AbstractLoanStatementMeta();

    public ZonedDateTime getStatementDate();

    public String getComments();

    @Override
    public AbstractLoanStatement build();

    @Override
    public AbstractLoanStatementBuilder toBuilder();

    public static AbstractLoanStatementBuilder builder() {
        return new AbstractLoanStatementBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanStatement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanStatement> getType() {
        return AbstractLoanStatement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AbstractLoanStatementBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements AbstractLoanStatementBuilder {
        protected ZonedDateTime statementDate;
        protected String comments;

        @Override
        @RosettaAttribute(value="statementDate", isRequired=true)
        @RuneAttribute(value="statementDate", isRequired=true)
        public ZonedDateTime getStatementDate() {
            return this.statementDate;
        }

        @Override
        @RosettaAttribute(value="comments")
        @RuneAttribute(value="comments")
        public String getComments() {
            return this.comments;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public AbstractLoanStatementBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public AbstractLoanStatementBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public AbstractLoanStatementBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public AbstractLoanStatementBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public AbstractLoanStatementBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public AbstractLoanStatementBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public AbstractLoanStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public AbstractLoanStatementBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="statementDate", isRequired=true)
        @RuneAttribute(value="statementDate", isRequired=true)
        public AbstractLoanStatementBuilder setStatementDate(ZonedDateTime _statementDate) {
            this.statementDate = _statementDate == null ? null : _statementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="comments")
        @RuneAttribute(value="comments")
        public AbstractLoanStatementBuilder setComments(String _comments) {
            this.comments = _comments == null ? null : _comments;
            return this;
        }

        @Override
        public AbstractLoanStatement build() {
            return new AbstractLoanStatementImpl(this);
        }

        @Override
        public AbstractLoanStatementBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanStatementBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getStatementDate() != null) {
                return true;
            }
            return this.getComments() != null;
        }

        @Override
        public AbstractLoanStatementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLoanStatementBuilder o = (AbstractLoanStatementBuilder)other;
            merger.mergeBasic((Object)this.getStatementDate(), (Object)o.getStatementDate(), this::setStatementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getComments(), (Object)o.getComments(), this::setComments, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanStatement _that = (AbstractLoanStatement)this.getType().cast(o);
            if (!Objects.equals(this.statementDate, _that.getStatementDate())) {
                return false;
            }
            return Objects.equals(this.comments, _that.getComments());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.statementDate != null ? this.statementDate.hashCode() : 0);
            _result = 31 * _result + (this.comments != null ? this.comments.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanStatementBuilder {statementDate=" + this.statementDate + ", comments=" + this.comments + '}' + " " + super.toString();
        }
    }

    public static interface AbstractLoanStatementBuilder
    extends AbstractLoanStatement,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        @Override
        public AbstractLoanStatementBuilder setFpmlVersion(String var1);

        @Override
        public AbstractLoanStatementBuilder setExpectedBuild(Integer var1);

        @Override
        public AbstractLoanStatementBuilder setActualBuild(Integer var1);

        @Override
        public AbstractLoanStatementBuilder setHeader(RequestMessageHeader var1);

        @Override
        public AbstractLoanStatementBuilder setValidationModel(ValidationModel var1);

        @Override
        public AbstractLoanStatementBuilder setIsCorrection(Boolean var1);

        @Override
        public AbstractLoanStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public AbstractLoanStatementBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public AbstractLoanStatementBuilder setStatementDate(ZonedDateTime var1);

        public AbstractLoanStatementBuilder setComments(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public AbstractLoanStatementBuilder prune();
    }

    public static class AbstractLoanStatementImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements AbstractLoanStatement {
        private final ZonedDateTime statementDate;
        private final String comments;

        protected AbstractLoanStatementImpl(AbstractLoanStatementBuilder builder) {
            super(builder);
            this.statementDate = builder.getStatementDate();
            this.comments = builder.getComments();
        }

        @Override
        @RosettaAttribute(value="statementDate", isRequired=true)
        @RuneAttribute(value="statementDate", isRequired=true)
        public ZonedDateTime getStatementDate() {
            return this.statementDate;
        }

        @Override
        @RosettaAttribute(value="comments")
        @RuneAttribute(value="comments")
        public String getComments() {
            return this.comments;
        }

        @Override
        public AbstractLoanStatement build() {
            return this;
        }

        @Override
        public AbstractLoanStatementBuilder toBuilder() {
            AbstractLoanStatementBuilder builder = AbstractLoanStatement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanStatementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStatementDate()).ifPresent(builder::setStatementDate);
            Optional.ofNullable(this.getComments()).ifPresent(builder::setComments);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractLoanStatement _that = (AbstractLoanStatement)this.getType().cast(o);
            if (!Objects.equals(this.statementDate, _that.getStatementDate())) {
                return false;
            }
            return Objects.equals(this.comments, _that.getComments());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.statementDate != null ? this.statementDate.hashCode() : 0);
            _result = 31 * _result + (this.comments != null ? this.comments.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanStatement {statementDate=" + this.statementDate + ", comments=" + this.comments + '}' + " " + super.toString();
        }
    }
}

