/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.CovenantObligationId;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LoanCovenantObligationSummary;
import fpml.consolidated.loan.VersionedCovenantObligationId;
import fpml.consolidated.loan.meta.AbstractLoanCovenantObligationMeta;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractLoanCovenantObligation", builder=AbstractLoanCovenantObligationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractLoanCovenantObligation", model="fpml", builder=AbstractLoanCovenantObligationBuilderImpl.class, version="1.1.0")
public interface AbstractLoanCovenantObligation
extends LoanCovenantObligationSummary {
    public static final AbstractLoanCovenantObligationMeta metaData = new AbstractLoanCovenantObligationMeta();

    @Override
    public AbstractLoanCovenantObligation build();

    @Override
    public AbstractLoanCovenantObligationBuilder toBuilder();

    public static AbstractLoanCovenantObligationBuilder builder() {
        return new AbstractLoanCovenantObligationBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractLoanCovenantObligation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractLoanCovenantObligation> getType() {
        return AbstractLoanCovenantObligation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.class, this.getCovenantObligationId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("obligatedParty"), processor, PartyReference.class, this.getObligatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
    }

    public static class AbstractLoanCovenantObligationBuilderImpl
    extends LoanCovenantObligationSummary.LoanCovenantObligationSummaryBuilderImpl
    implements AbstractLoanCovenantObligationBuilder {
        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public AbstractLoanCovenantObligationBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public AbstractLoanCovenantObligationBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="covenantObligationId")
        @RuneAttribute(value="covenantObligationId")
        public AbstractLoanCovenantObligationBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId) {
            if (_covenantObligationId != null) {
                this.covenantObligationId.add(_covenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanCovenantObligationBuilder addCovenantObligationId(CovenantObligationId _covenantObligationId, int idx) {
            this.getIndex(this.covenantObligationId, idx, () -> _covenantObligationId.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanCovenantObligationBuilder addCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            if (covenantObligationIds != null) {
                for (CovenantObligationId covenantObligationId : covenantObligationIds) {
                    this.covenantObligationId.add(covenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="covenantObligationId")
        public AbstractLoanCovenantObligationBuilder setCovenantObligationId(List<? extends CovenantObligationId> covenantObligationIds) {
            this.covenantObligationId = covenantObligationIds == null ? new ArrayList() : (List)covenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedCovenantObligationId")
        @RuneAttribute(value="versionedCovenantObligationId")
        public AbstractLoanCovenantObligationBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId) {
            if (_versionedCovenantObligationId != null) {
                this.versionedCovenantObligationId.add(_versionedCovenantObligationId.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanCovenantObligationBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId _versionedCovenantObligationId, int idx) {
            this.getIndex(this.versionedCovenantObligationId, idx, () -> _versionedCovenantObligationId.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanCovenantObligationBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            if (versionedCovenantObligationIds != null) {
                for (VersionedCovenantObligationId versionedCovenantObligationId : versionedCovenantObligationIds) {
                    this.versionedCovenantObligationId.add(versionedCovenantObligationId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedCovenantObligationId")
        public AbstractLoanCovenantObligationBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> versionedCovenantObligationIds) {
            this.versionedCovenantObligationId = versionedCovenantObligationIds == null ? new ArrayList() : (List)versionedCovenantObligationIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public AbstractLoanCovenantObligationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AbstractLoanCovenantObligationBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="obligatedParty", isRequired=true)
        @RuneAttribute(value="obligatedParty", isRequired=true)
        public AbstractLoanCovenantObligationBuilder setObligatedParty(PartyReference _obligatedParty) {
            this.obligatedParty = _obligatedParty == null ? null : _obligatedParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public AbstractLoanCovenantObligationBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public AbstractLoanCovenantObligationBuilder addFacilityReference(FacilityReference _facilityReference) {
            if (_facilityReference != null) {
                this.facilityReference.add(_facilityReference.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractLoanCovenantObligationBuilder addFacilityReference(FacilityReference _facilityReference, int idx) {
            this.getIndex(this.facilityReference, idx, () -> _facilityReference.toBuilder());
            return this;
        }

        @Override
        public AbstractLoanCovenantObligationBuilder addFacilityReference(List<? extends FacilityReference> facilityReferences) {
            if (facilityReferences != null) {
                for (FacilityReference facilityReference : facilityReferences) {
                    this.facilityReference.add(facilityReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityReference")
        public AbstractLoanCovenantObligationBuilder setFacilityReference(List<? extends FacilityReference> facilityReferences) {
            this.facilityReference = facilityReferences == null ? new ArrayList() : (List)facilityReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AbstractLoanCovenantObligation build() {
            return new AbstractLoanCovenantObligationImpl(this);
        }

        @Override
        public AbstractLoanCovenantObligationBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractLoanCovenantObligationBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public AbstractLoanCovenantObligationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractLoanCovenantObligationBuilder o = (AbstractLoanCovenantObligationBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanCovenantObligationBuilder {} " + super.toString();
        }
    }

    public static interface AbstractLoanCovenantObligationBuilder
    extends AbstractLoanCovenantObligation,
    LoanCovenantObligationSummary.LoanCovenantObligationSummaryBuilder {
        @Override
        public AbstractLoanCovenantObligationBuilder setName(String var1);

        @Override
        public AbstractLoanCovenantObligationBuilder setPartyReference(PartyReference var1);

        @Override
        public AbstractLoanCovenantObligationBuilder addCovenantObligationId(CovenantObligationId var1);

        @Override
        public AbstractLoanCovenantObligationBuilder addCovenantObligationId(CovenantObligationId var1, int var2);

        @Override
        public AbstractLoanCovenantObligationBuilder addCovenantObligationId(List<? extends CovenantObligationId> var1);

        @Override
        public AbstractLoanCovenantObligationBuilder setCovenantObligationId(List<? extends CovenantObligationId> var1);

        @Override
        public AbstractLoanCovenantObligationBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1);

        @Override
        public AbstractLoanCovenantObligationBuilder addVersionedCovenantObligationId(VersionedCovenantObligationId var1, int var2);

        @Override
        public AbstractLoanCovenantObligationBuilder addVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        @Override
        public AbstractLoanCovenantObligationBuilder setVersionedCovenantObligationId(List<? extends VersionedCovenantObligationId> var1);

        @Override
        public AbstractLoanCovenantObligationBuilder setId(String var1);

        @Override
        public AbstractLoanCovenantObligationBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public AbstractLoanCovenantObligationBuilder setObligatedParty(PartyReference var1);

        @Override
        public AbstractLoanCovenantObligationBuilder setDealReference(DealReference var1);

        @Override
        public AbstractLoanCovenantObligationBuilder addFacilityReference(FacilityReference var1);

        @Override
        public AbstractLoanCovenantObligationBuilder addFacilityReference(FacilityReference var1, int var2);

        @Override
        public AbstractLoanCovenantObligationBuilder addFacilityReference(List<? extends FacilityReference> var1);

        @Override
        public AbstractLoanCovenantObligationBuilder setFacilityReference(List<? extends FacilityReference> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("covenantObligationId"), processor, CovenantObligationId.CovenantObligationIdBuilder.class, this.getCovenantObligationId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedCovenantObligationId"), processor, VersionedCovenantObligationId.VersionedCovenantObligationIdBuilder.class, this.getVersionedCovenantObligationId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("obligatedParty"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getObligatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
        }

        @Override
        public AbstractLoanCovenantObligationBuilder prune();
    }

    public static class AbstractLoanCovenantObligationImpl
    extends LoanCovenantObligationSummary.LoanCovenantObligationSummaryImpl
    implements AbstractLoanCovenantObligation {
        protected AbstractLoanCovenantObligationImpl(AbstractLoanCovenantObligationBuilder builder) {
            super(builder);
        }

        @Override
        public AbstractLoanCovenantObligation build() {
            return this;
        }

        @Override
        public AbstractLoanCovenantObligationBuilder toBuilder() {
            AbstractLoanCovenantObligationBuilder builder = AbstractLoanCovenantObligation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractLoanCovenantObligationBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractLoanCovenantObligation {} " + super.toString();
        }
    }
}

