/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractFacilityContractEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.PeriodRate;
import fpml.consolidated.loan.meta.AbstractFacilityRateChangeEventMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractFacilityRateChangeEvent", builder=AbstractFacilityRateChangeEventBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AbstractFacilityRateChangeEvent", model="fpml", builder=AbstractFacilityRateChangeEventBuilderImpl.class, version="1.1.0")
public interface AbstractFacilityRateChangeEvent
extends AbstractFacilityContractEvent {
    public static final AbstractFacilityRateChangeEventMeta metaData = new AbstractFacilityRateChangeEventMeta();

    public PeriodRate getRate();

    @Override
    public AbstractFacilityRateChangeEvent build();

    @Override
    public AbstractFacilityRateChangeEventBuilder toBuilder();

    public static AbstractFacilityRateChangeEventBuilder builder() {
        return new AbstractFacilityRateChangeEventBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractFacilityRateChangeEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractFacilityRateChangeEvent> getType() {
        return AbstractFacilityRateChangeEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rate"), processor, PeriodRate.class, this.getRate(), new AttributeMeta[0]);
    }

    public static class AbstractFacilityRateChangeEventBuilderImpl
    extends AbstractFacilityContractEvent.AbstractFacilityContractEventBuilderImpl
    implements AbstractFacilityRateChangeEventBuilder {
        protected PeriodRate.PeriodRateBuilder rate;

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public PeriodRate.PeriodRateBuilder getRate() {
            return this.rate;
        }

        @Override
        public PeriodRate.PeriodRateBuilder getOrCreateRate() {
            PeriodRate.PeriodRateBuilder result = this.rate != null ? this.rate : (this.rate = PeriodRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public AbstractFacilityRateChangeEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public AbstractFacilityRateChangeEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public AbstractFacilityRateChangeEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public AbstractFacilityRateChangeEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractFacilityRateChangeEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public AbstractFacilityRateChangeEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public AbstractFacilityRateChangeEventBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public AbstractFacilityRateChangeEventBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public AbstractFacilityRateChangeEventBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference")
        @RuneAttribute(value="loanContractReference")
        public AbstractFacilityRateChangeEventBuilder addLoanContractReference(LoanContractReference _loanContractReference) {
            if (_loanContractReference != null) {
                this.loanContractReference.add(_loanContractReference.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder addLoanContractReference(LoanContractReference _loanContractReference, int idx) {
            this.getIndex(this.loanContractReference, idx, () -> _loanContractReference.toBuilder());
            return this;
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder addLoanContractReference(List<? extends LoanContractReference> loanContractReferences) {
            if (loanContractReferences != null) {
                for (LoanContractReference loanContractReference : loanContractReferences) {
                    this.loanContractReference.add(loanContractReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanContractReference")
        public AbstractFacilityRateChangeEventBuilder setLoanContractReference(List<? extends LoanContractReference> loanContractReferences) {
            this.loanContractReference = loanContractReferences == null ? new ArrayList() : (List)loanContractReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public AbstractFacilityRateChangeEventBuilder setRate(PeriodRate _rate) {
            this.rate = _rate == null ? null : _rate.toBuilder();
            return this;
        }

        @Override
        public AbstractFacilityRateChangeEvent build() {
            return new AbstractFacilityRateChangeEventImpl(this);
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder prune() {
            super.prune();
            if (this.rate != null && !this.rate.prune().hasData()) {
                this.rate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getRate() != null && this.getRate().hasData();
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractFacilityRateChangeEventBuilder o = (AbstractFacilityRateChangeEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRate(), (RosettaModelObjectBuilder)o.getRate(), this::setRate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacilityRateChangeEvent _that = (AbstractFacilityRateChangeEvent)this.getType().cast(o);
            return Objects.equals(this.rate, _that.getRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityRateChangeEventBuilder {rate=" + this.rate + '}' + " " + super.toString();
        }
    }

    public static interface AbstractFacilityRateChangeEventBuilder
    extends AbstractFacilityRateChangeEvent,
    AbstractFacilityContractEvent.AbstractFacilityContractEventBuilder {
        public PeriodRate.PeriodRateBuilder getOrCreateRate();

        @Override
        public PeriodRate.PeriodRateBuilder getRate();

        @Override
        public AbstractFacilityRateChangeEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public AbstractFacilityRateChangeEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setComment(String var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setFacilityReference(FacilityReference var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder addLoanContractReference(LoanContractReference var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder addLoanContractReference(LoanContractReference var1, int var2);

        @Override
        public AbstractFacilityRateChangeEventBuilder addLoanContractReference(List<? extends LoanContractReference> var1);

        @Override
        public AbstractFacilityRateChangeEventBuilder setLoanContractReference(List<? extends LoanContractReference> var1);

        public AbstractFacilityRateChangeEventBuilder setRate(PeriodRate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, this.getLoanContractReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rate"), processor, PeriodRate.PeriodRateBuilder.class, this.getRate(), new AttributeMeta[0]);
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder prune();
    }

    public static class AbstractFacilityRateChangeEventImpl
    extends AbstractFacilityContractEvent.AbstractFacilityContractEventImpl
    implements AbstractFacilityRateChangeEvent {
        private final PeriodRate rate;

        protected AbstractFacilityRateChangeEventImpl(AbstractFacilityRateChangeEventBuilder builder) {
            super(builder);
            this.rate = Optional.ofNullable(builder.getRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public PeriodRate getRate() {
            return this.rate;
        }

        @Override
        public AbstractFacilityRateChangeEvent build() {
            return this;
        }

        @Override
        public AbstractFacilityRateChangeEventBuilder toBuilder() {
            AbstractFacilityRateChangeEventBuilder builder = AbstractFacilityRateChangeEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractFacilityRateChangeEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacilityRateChangeEvent _that = (AbstractFacilityRateChangeEvent)this.getType().cast(o);
            return Objects.equals(this.rate, _that.getRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityRateChangeEvent {rate=" + this.rate + '}' + " " + super.toString();
        }
    }
}

