/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.ird.NotionalStepRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="NotionalStepRuleChoice")
@ImplementedBy(value=Default.class)
public interface NotionalStepRuleChoice
extends Validator<NotionalStepRule> {
    public static final String NAME = "NotionalStepRuleChoice";
    public static final String DEFINITION = "optional choice notionalStepAmount, notionalStepRuleSequence";

    public static class NoOp
    implements NotionalStepRuleChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NotionalStepRule notionalStepRule) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements NotionalStepRuleChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NotionalStepRule notionalStepRule) {
            ComparisonResult result = this.executeDataRule(notionalStepRule);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)NotionalStepRuleChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NotionalStepRule", (RosettaPath)path, (String)NotionalStepRuleChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)NotionalStepRuleChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NotionalStepRule", (RosettaPath)path, (String)NotionalStepRuleChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(NotionalStepRule notionalStepRule) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)notionalStepRule), Arrays.asList("notionalStepAmount", "notionalStepRuleSequence"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

