/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.generic;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.PeriodExtendedEnum;
import fpml.consolidated.generic.UnderlyerReference;
import fpml.consolidated.generic.meta.GenericFrequencyMeta;
import fpml.consolidated.shared.Frequency;
import fpml.consolidated.shared.PartyReference;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="GenericFrequency", builder=GenericFrequencyBuilderImpl.class, version="1.1.0")
@RuneDataType(value="GenericFrequency", model="fpml", builder=GenericFrequencyBuilderImpl.class, version="1.1.0")
public interface GenericFrequency
extends Frequency {
    public static final GenericFrequencyMeta metaData = new GenericFrequencyMeta();

    public PartyReference getPayerPartyReference();

    public UnderlyerReference getUnderlyerReference();

    @Override
    public GenericFrequency build();

    @Override
    public GenericFrequencyBuilder toBuilder();

    public static GenericFrequencyBuilder builder() {
        return new GenericFrequencyBuilderImpl();
    }

    default public RosettaMetaData<? extends GenericFrequency> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GenericFrequency> getType() {
        return GenericFrequency.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("periodMultiplier"), Integer.class, (Object)this.getPeriodMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("period"), PeriodExtendedEnum.class, (Object)this.getPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerPartyReference"), processor, PartyReference.class, this.getPayerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyerReference"), processor, UnderlyerReference.class, this.getUnderlyerReference(), new AttributeMeta[0]);
    }

    public static class GenericFrequencyBuilderImpl
    extends Frequency.FrequencyBuilderImpl
    implements GenericFrequencyBuilder {
        protected PartyReference.PartyReferenceBuilder payerPartyReference;
        protected UnderlyerReference.UnderlyerReferenceBuilder underlyerReference;

        @Override
        @RosettaAttribute(value="payerPartyReference")
        @RuneAttribute(value="payerPartyReference")
        public PartyReference.PartyReferenceBuilder getPayerPartyReference() {
            return this.payerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePayerPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.payerPartyReference != null ? this.payerPartyReference : (this.payerPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyerReference")
        @RuneAttribute(value="underlyerReference")
        public UnderlyerReference.UnderlyerReferenceBuilder getUnderlyerReference() {
            return this.underlyerReference;
        }

        @Override
        public UnderlyerReference.UnderlyerReferenceBuilder getOrCreateUnderlyerReference() {
            UnderlyerReference.UnderlyerReferenceBuilder result = this.underlyerReference != null ? this.underlyerReference : (this.underlyerReference = UnderlyerReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodMultiplier")
        @RuneAttribute(value="periodMultiplier")
        public GenericFrequencyBuilder setPeriodMultiplier(Integer _periodMultiplier) {
            this.periodMultiplier = _periodMultiplier == null ? null : _periodMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="period")
        @RuneAttribute(value="period")
        public GenericFrequencyBuilder setPeriod(PeriodExtendedEnum _period) {
            this.period = _period == null ? null : _period;
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public GenericFrequencyBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerPartyReference")
        @RuneAttribute(value="payerPartyReference")
        public GenericFrequencyBuilder setPayerPartyReference(PartyReference _payerPartyReference) {
            this.payerPartyReference = _payerPartyReference == null ? null : _payerPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyerReference")
        @RuneAttribute(value="underlyerReference")
        public GenericFrequencyBuilder setUnderlyerReference(UnderlyerReference _underlyerReference) {
            this.underlyerReference = _underlyerReference == null ? null : _underlyerReference.toBuilder();
            return this;
        }

        @Override
        public GenericFrequency build() {
            return new GenericFrequencyImpl(this);
        }

        @Override
        public GenericFrequencyBuilder toBuilder() {
            return this;
        }

        @Override
        public GenericFrequencyBuilder prune() {
            super.prune();
            if (this.payerPartyReference != null && !this.payerPartyReference.prune().hasData()) {
                this.payerPartyReference = null;
            }
            if (this.underlyerReference != null && !this.underlyerReference.prune().hasData()) {
                this.underlyerReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayerPartyReference() != null && this.getPayerPartyReference().hasData()) {
                return true;
            }
            return this.getUnderlyerReference() != null && this.getUnderlyerReference().hasData();
        }

        @Override
        public GenericFrequencyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            GenericFrequencyBuilder o = (GenericFrequencyBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerPartyReference(), (RosettaModelObjectBuilder)o.getPayerPartyReference(), this::setPayerPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyerReference(), (RosettaModelObjectBuilder)o.getUnderlyerReference(), this::setUnderlyerReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GenericFrequency _that = (GenericFrequency)this.getType().cast(o);
            if (!Objects.equals(this.payerPartyReference, _that.getPayerPartyReference())) {
                return false;
            }
            return Objects.equals(this.underlyerReference, _that.getUnderlyerReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerPartyReference != null ? this.payerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.underlyerReference != null ? this.underlyerReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "GenericFrequencyBuilder {payerPartyReference=" + this.payerPartyReference + ", underlyerReference=" + this.underlyerReference + '}' + " " + super.toString();
        }
    }

    public static interface GenericFrequencyBuilder
    extends GenericFrequency,
    Frequency.FrequencyBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreatePayerPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getPayerPartyReference();

        public UnderlyerReference.UnderlyerReferenceBuilder getOrCreateUnderlyerReference();

        @Override
        public UnderlyerReference.UnderlyerReferenceBuilder getUnderlyerReference();

        @Override
        public GenericFrequencyBuilder setPeriodMultiplier(Integer var1);

        @Override
        public GenericFrequencyBuilder setPeriod(PeriodExtendedEnum var1);

        @Override
        public GenericFrequencyBuilder setId(String var1);

        public GenericFrequencyBuilder setPayerPartyReference(PartyReference var1);

        public GenericFrequencyBuilder setUnderlyerReference(UnderlyerReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("periodMultiplier"), Integer.class, (Object)this.getPeriodMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("period"), PeriodExtendedEnum.class, (Object)this.getPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPayerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyerReference"), processor, UnderlyerReference.UnderlyerReferenceBuilder.class, this.getUnderlyerReference(), new AttributeMeta[0]);
        }

        @Override
        public GenericFrequencyBuilder prune();
    }

    public static class GenericFrequencyImpl
    extends Frequency.FrequencyImpl
    implements GenericFrequency {
        private final PartyReference payerPartyReference;
        private final UnderlyerReference underlyerReference;

        protected GenericFrequencyImpl(GenericFrequencyBuilder builder) {
            super(builder);
            this.payerPartyReference = Optional.ofNullable(builder.getPayerPartyReference()).map(f -> f.build()).orElse(null);
            this.underlyerReference = Optional.ofNullable(builder.getUnderlyerReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerPartyReference")
        @RuneAttribute(value="payerPartyReference")
        public PartyReference getPayerPartyReference() {
            return this.payerPartyReference;
        }

        @Override
        @RosettaAttribute(value="underlyerReference")
        @RuneAttribute(value="underlyerReference")
        public UnderlyerReference getUnderlyerReference() {
            return this.underlyerReference;
        }

        @Override
        public GenericFrequency build() {
            return this;
        }

        @Override
        public GenericFrequencyBuilder toBuilder() {
            GenericFrequencyBuilder builder = GenericFrequency.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GenericFrequencyBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerPartyReference()).ifPresent(builder::setPayerPartyReference);
            Optional.ofNullable(this.getUnderlyerReference()).ifPresent(builder::setUnderlyerReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GenericFrequency _that = (GenericFrequency)this.getType().cast(o);
            if (!Objects.equals(this.payerPartyReference, _that.getPayerPartyReference())) {
                return false;
            }
            return Objects.equals(this.underlyerReference, _that.getUnderlyerReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerPartyReference != null ? this.payerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.underlyerReference != null ? this.underlyerReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "GenericFrequency {payerPartyReference=" + this.payerPartyReference + ", underlyerReference=" + this.underlyerReference + '}' + " " + super.toString();
        }
    }
}

