/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.targets;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.targets.FxSettlementPeriodBarrier;
import fpml.consolidated.fx.targets.FxTargetSettlementPeriodPayoff;
import fpml.consolidated.fx.targets.SettlementPeriod;
import fpml.consolidated.fx.targets.meta.FxTargetSettlementPeriodMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxTargetSettlementPeriod", builder=FxTargetSettlementPeriodBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxTargetSettlementPeriod", model="fpml", builder=FxTargetSettlementPeriodBuilderImpl.class, version="1.1.0")
public interface FxTargetSettlementPeriod
extends SettlementPeriod {
    public static final FxTargetSettlementPeriodMeta metaData = new FxTargetSettlementPeriodMeta();

    public BigDecimal getPivot();

    public List<? extends FxTargetSettlementPeriodPayoff> getPayoff();

    public List<? extends FxSettlementPeriodBarrier> getBarrier();

    @Override
    public FxTargetSettlementPeriod build();

    @Override
    public FxTargetSettlementPeriodBuilder toBuilder();

    public static FxTargetSettlementPeriodBuilder builder() {
        return new FxTargetSettlementPeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends FxTargetSettlementPeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxTargetSettlementPeriod> getType() {
        return FxTargetSettlementPeriod.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("expiryDate"), ZonedDateTime.class, (Object)this.getExpiryDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("pivot"), BigDecimal.class, (Object)this.getPivot(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payoff"), processor, FxTargetSettlementPeriodPayoff.class, this.getPayoff(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, FxSettlementPeriodBarrier.class, this.getBarrier(), new AttributeMeta[0]);
    }

    public static class FxTargetSettlementPeriodBuilderImpl
    extends SettlementPeriod.SettlementPeriodBuilderImpl
    implements FxTargetSettlementPeriodBuilder {
        protected BigDecimal pivot;
        protected List<FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder> payoff = new ArrayList<FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder>();
        protected List<FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder> barrier = new ArrayList<FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder>();

        @Override
        @RosettaAttribute(value="pivot")
        @RuneAttribute(value="pivot")
        public BigDecimal getPivot() {
            return this.pivot;
        }

        @Override
        @RosettaAttribute(value="payoff", isRequired=true)
        @RuneAttribute(value="payoff", isRequired=true)
        public List<? extends FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder> getPayoff() {
            return this.payoff;
        }

        @Override
        public FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder getOrCreatePayoff(int index) {
            if (this.payoff == null) {
                this.payoff = new ArrayList<FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder>();
            }
            return (FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder)this.getIndex(this.payoff, index, () -> {
                FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder newPayoff = FxTargetSettlementPeriodPayoff.builder();
                return newPayoff;
            });
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder getOrCreateBarrier(int index) {
            if (this.barrier == null) {
                this.barrier = new ArrayList<FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder>();
            }
            return (FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder)this.getIndex(this.barrier, index, () -> {
                FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder newBarrier = FxSettlementPeriodBarrier.builder();
                return newBarrier;
            });
        }

        @Override
        @RosettaAttribute(value="expiryDate", isRequired=true)
        @RuneAttribute(value="expiryDate", isRequired=true)
        public FxTargetSettlementPeriodBuilder setExpiryDate(ZonedDateTime _expiryDate) {
            this.expiryDate = _expiryDate == null ? null : _expiryDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public FxTargetSettlementPeriodBuilder setSettlementDate(ZonedDateTime _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public FxTargetSettlementPeriodBuilder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="pivot")
        @RuneAttribute(value="pivot")
        public FxTargetSettlementPeriodBuilder setPivot(BigDecimal _pivot) {
            this.pivot = _pivot == null ? null : _pivot;
            return this;
        }

        @Override
        @RosettaAttribute(value="payoff", isRequired=true)
        @RuneAttribute(value="payoff", isRequired=true)
        public FxTargetSettlementPeriodBuilder addPayoff(FxTargetSettlementPeriodPayoff _payoff) {
            if (_payoff != null) {
                this.payoff.add(_payoff.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetSettlementPeriodBuilder addPayoff(FxTargetSettlementPeriodPayoff _payoff, int idx) {
            this.getIndex(this.payoff, idx, () -> _payoff.toBuilder());
            return this;
        }

        @Override
        public FxTargetSettlementPeriodBuilder addPayoff(List<? extends FxTargetSettlementPeriodPayoff> payoffs) {
            if (payoffs != null) {
                for (FxTargetSettlementPeriodPayoff fxTargetSettlementPeriodPayoff : payoffs) {
                    this.payoff.add(fxTargetSettlementPeriodPayoff.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payoff")
        public FxTargetSettlementPeriodBuilder setPayoff(List<? extends FxTargetSettlementPeriodPayoff> payoffs) {
            this.payoff = payoffs == null ? new ArrayList<FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder>() : (List)payoffs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxTargetSettlementPeriodBuilder addBarrier(FxSettlementPeriodBarrier _barrier) {
            if (_barrier != null) {
                this.barrier.add(_barrier.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetSettlementPeriodBuilder addBarrier(FxSettlementPeriodBarrier _barrier, int idx) {
            this.getIndex(this.barrier, idx, () -> _barrier.toBuilder());
            return this;
        }

        @Override
        public FxTargetSettlementPeriodBuilder addBarrier(List<? extends FxSettlementPeriodBarrier> barriers) {
            if (barriers != null) {
                for (FxSettlementPeriodBarrier fxSettlementPeriodBarrier : barriers) {
                    this.barrier.add(fxSettlementPeriodBarrier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrier")
        public FxTargetSettlementPeriodBuilder setBarrier(List<? extends FxSettlementPeriodBarrier> barriers) {
            this.barrier = barriers == null ? new ArrayList<FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder>() : (List)barriers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxTargetSettlementPeriod build() {
            return new FxTargetSettlementPeriodImpl(this);
        }

        @Override
        public FxTargetSettlementPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public FxTargetSettlementPeriodBuilder prune() {
            super.prune();
            this.payoff = this.payoff.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.barrier = this.barrier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPivot() != null) {
                return true;
            }
            if (this.getPayoff() != null && this.getPayoff().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBarrier() != null && this.getBarrier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FxTargetSettlementPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxTargetSettlementPeriodBuilder o = (FxTargetSettlementPeriodBuilder)other;
            merger.mergeRosetta(this.getPayoff(), o.getPayoff(), this::getOrCreatePayoff);
            merger.mergeRosetta(this.getBarrier(), o.getBarrier(), this::getOrCreateBarrier);
            merger.mergeBasic((Object)this.getPivot(), (Object)o.getPivot(), this::setPivot, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxTargetSettlementPeriod _that = (FxTargetSettlementPeriod)this.getType().cast(o);
            if (!Objects.equals(this.pivot, _that.getPivot())) {
                return false;
            }
            if (!ListEquals.listEquals(this.payoff, _that.getPayoff())) {
                return false;
            }
            return ListEquals.listEquals(this.barrier, _that.getBarrier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.pivot != null ? this.pivot.hashCode() : 0);
            _result = 31 * _result + (this.payoff != null ? this.payoff.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxTargetSettlementPeriodBuilder {pivot=" + this.pivot + ", payoff=" + this.payoff + ", barrier=" + this.barrier + '}' + " " + super.toString();
        }
    }

    public static interface FxTargetSettlementPeriodBuilder
    extends FxTargetSettlementPeriod,
    SettlementPeriod.SettlementPeriodBuilder {
        public FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder getOrCreatePayoff(int var1);

        public List<? extends FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder> getPayoff();

        public FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder getOrCreateBarrier(int var1);

        public List<? extends FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder> getBarrier();

        @Override
        public FxTargetSettlementPeriodBuilder setExpiryDate(ZonedDateTime var1);

        @Override
        public FxTargetSettlementPeriodBuilder setSettlementDate(ZonedDateTime var1);

        @Override
        public FxTargetSettlementPeriodBuilder setNotionalAmount(BigDecimal var1);

        public FxTargetSettlementPeriodBuilder setPivot(BigDecimal var1);

        public FxTargetSettlementPeriodBuilder addPayoff(FxTargetSettlementPeriodPayoff var1);

        public FxTargetSettlementPeriodBuilder addPayoff(FxTargetSettlementPeriodPayoff var1, int var2);

        public FxTargetSettlementPeriodBuilder addPayoff(List<? extends FxTargetSettlementPeriodPayoff> var1);

        public FxTargetSettlementPeriodBuilder setPayoff(List<? extends FxTargetSettlementPeriodPayoff> var1);

        public FxTargetSettlementPeriodBuilder addBarrier(FxSettlementPeriodBarrier var1);

        public FxTargetSettlementPeriodBuilder addBarrier(FxSettlementPeriodBarrier var1, int var2);

        public FxTargetSettlementPeriodBuilder addBarrier(List<? extends FxSettlementPeriodBarrier> var1);

        public FxTargetSettlementPeriodBuilder setBarrier(List<? extends FxSettlementPeriodBarrier> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("expiryDate"), ZonedDateTime.class, (Object)this.getExpiryDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementDate"), ZonedDateTime.class, (Object)this.getSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("pivot"), BigDecimal.class, (Object)this.getPivot(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payoff"), processor, FxTargetSettlementPeriodPayoff.FxTargetSettlementPeriodPayoffBuilder.class, this.getPayoff(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, FxSettlementPeriodBarrier.FxSettlementPeriodBarrierBuilder.class, this.getBarrier(), new AttributeMeta[0]);
        }

        @Override
        public FxTargetSettlementPeriodBuilder prune();
    }

    public static class FxTargetSettlementPeriodImpl
    extends SettlementPeriod.SettlementPeriodImpl
    implements FxTargetSettlementPeriod {
        private final BigDecimal pivot;
        private final List<? extends FxTargetSettlementPeriodPayoff> payoff;
        private final List<? extends FxSettlementPeriodBarrier> barrier;

        protected FxTargetSettlementPeriodImpl(FxTargetSettlementPeriodBuilder builder) {
            super(builder);
            this.pivot = builder.getPivot();
            this.payoff = Optional.ofNullable(builder.getPayoff()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="pivot")
        @RuneAttribute(value="pivot")
        public BigDecimal getPivot() {
            return this.pivot;
        }

        @Override
        @RosettaAttribute(value="payoff", isRequired=true)
        @RuneAttribute(value="payoff", isRequired=true)
        public List<? extends FxTargetSettlementPeriodPayoff> getPayoff() {
            return this.payoff;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxSettlementPeriodBarrier> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxTargetSettlementPeriod build() {
            return this;
        }

        @Override
        public FxTargetSettlementPeriodBuilder toBuilder() {
            FxTargetSettlementPeriodBuilder builder = FxTargetSettlementPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxTargetSettlementPeriodBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPivot()).ifPresent(builder::setPivot);
            Optional.ofNullable(this.getPayoff()).ifPresent(builder::setPayoff);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxTargetSettlementPeriod _that = (FxTargetSettlementPeriod)this.getType().cast(o);
            if (!Objects.equals(this.pivot, _that.getPivot())) {
                return false;
            }
            if (!ListEquals.listEquals(this.payoff, _that.getPayoff())) {
                return false;
            }
            return ListEquals.listEquals(this.barrier, _that.getBarrier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.pivot != null ? this.pivot.hashCode() : 0);
            _result = 31 * _result + (this.payoff != null ? this.payoff.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxTargetSettlementPeriod {pivot=" + this.pivot + ", payoff=" + this.payoff + ", barrier=" + this.barrier + '}' + " " + super.toString();
        }
    }
}

