/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx.accruals;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fx.accruals.FxForwardStrikePrice;
import fpml.consolidated.fx.accruals.meta.FxAccrualLinearPayoffRegionSequenceMeta;
import fpml.consolidated.shared.NonNegativeAmountSchedule;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxAccrualLinearPayoffRegionSequence", builder=FxAccrualLinearPayoffRegionSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxAccrualLinearPayoffRegionSequence", model="fpml", builder=FxAccrualLinearPayoffRegionSequenceBuilderImpl.class, version="1.1.0")
public interface FxAccrualLinearPayoffRegionSequence
extends RosettaModelObject {
    public static final FxAccrualLinearPayoffRegionSequenceMeta metaData = new FxAccrualLinearPayoffRegionSequenceMeta();

    public FxForwardStrikePrice getStrike();

    public NonNegativeAmountSchedule getCounterCurrencyAmount();

    public FxAccrualLinearPayoffRegionSequence build();

    public FxAccrualLinearPayoffRegionSequenceBuilder toBuilder();

    public static FxAccrualLinearPayoffRegionSequenceBuilder builder() {
        return new FxAccrualLinearPayoffRegionSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAccrualLinearPayoffRegionSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAccrualLinearPayoffRegionSequence> getType() {
        return FxAccrualLinearPayoffRegionSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("strike"), processor, FxForwardStrikePrice.class, this.getStrike(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterCurrencyAmount"), processor, NonNegativeAmountSchedule.class, this.getCounterCurrencyAmount(), new AttributeMeta[0]);
    }

    public static class FxAccrualLinearPayoffRegionSequenceBuilderImpl
    implements FxAccrualLinearPayoffRegionSequenceBuilder {
        protected FxForwardStrikePrice.FxForwardStrikePriceBuilder strike;
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder counterCurrencyAmount;

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxForwardStrikePrice.FxForwardStrikePriceBuilder getStrike() {
            return this.strike;
        }

        @Override
        public FxForwardStrikePrice.FxForwardStrikePriceBuilder getOrCreateStrike() {
            FxForwardStrikePrice.FxForwardStrikePriceBuilder result = this.strike != null ? this.strike : (this.strike = FxForwardStrikePrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getCounterCurrencyAmount() {
            return this.counterCurrencyAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateCounterCurrencyAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.counterCurrencyAmount != null ? this.counterCurrencyAmount : (this.counterCurrencyAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxAccrualLinearPayoffRegionSequenceBuilder setStrike(FxForwardStrikePrice _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public FxAccrualLinearPayoffRegionSequenceBuilder setCounterCurrencyAmount(NonNegativeAmountSchedule _counterCurrencyAmount) {
            this.counterCurrencyAmount = _counterCurrencyAmount == null ? null : _counterCurrencyAmount.toBuilder();
            return this;
        }

        @Override
        public FxAccrualLinearPayoffRegionSequence build() {
            return new FxAccrualLinearPayoffRegionSequenceImpl(this);
        }

        @Override
        public FxAccrualLinearPayoffRegionSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAccrualLinearPayoffRegionSequenceBuilder prune() {
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            if (this.counterCurrencyAmount != null && !this.counterCurrencyAmount.prune().hasData()) {
                this.counterCurrencyAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStrike() != null && this.getStrike().hasData()) {
                return true;
            }
            return this.getCounterCurrencyAmount() != null && this.getCounterCurrencyAmount().hasData();
        }

        public FxAccrualLinearPayoffRegionSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxAccrualLinearPayoffRegionSequenceBuilder o = (FxAccrualLinearPayoffRegionSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCounterCurrencyAmount(), (RosettaModelObjectBuilder)o.getCounterCurrencyAmount(), this::setCounterCurrencyAmount);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxAccrualLinearPayoffRegionSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            return Objects.equals(this.counterCurrencyAmount, _that.getCounterCurrencyAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrencyAmount != null ? this.counterCurrencyAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxAccrualLinearPayoffRegionSequenceBuilder {strike=" + this.strike + ", counterCurrencyAmount=" + this.counterCurrencyAmount + '}';
        }
    }

    public static interface FxAccrualLinearPayoffRegionSequenceBuilder
    extends FxAccrualLinearPayoffRegionSequence,
    RosettaModelObjectBuilder {
        public FxForwardStrikePrice.FxForwardStrikePriceBuilder getOrCreateStrike();

        @Override
        public FxForwardStrikePrice.FxForwardStrikePriceBuilder getStrike();

        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateCounterCurrencyAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getCounterCurrencyAmount();

        public FxAccrualLinearPayoffRegionSequenceBuilder setStrike(FxForwardStrikePrice var1);

        public FxAccrualLinearPayoffRegionSequenceBuilder setCounterCurrencyAmount(NonNegativeAmountSchedule var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("strike"), processor, FxForwardStrikePrice.FxForwardStrikePriceBuilder.class, this.getStrike(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterCurrencyAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getCounterCurrencyAmount(), new AttributeMeta[0]);
        }

        public FxAccrualLinearPayoffRegionSequenceBuilder prune();
    }

    public static class FxAccrualLinearPayoffRegionSequenceImpl
    implements FxAccrualLinearPayoffRegionSequence {
        private final FxForwardStrikePrice strike;
        private final NonNegativeAmountSchedule counterCurrencyAmount;

        protected FxAccrualLinearPayoffRegionSequenceImpl(FxAccrualLinearPayoffRegionSequenceBuilder builder) {
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
            this.counterCurrencyAmount = Optional.ofNullable(builder.getCounterCurrencyAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxForwardStrikePrice getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public NonNegativeAmountSchedule getCounterCurrencyAmount() {
            return this.counterCurrencyAmount;
        }

        @Override
        public FxAccrualLinearPayoffRegionSequence build() {
            return this;
        }

        @Override
        public FxAccrualLinearPayoffRegionSequenceBuilder toBuilder() {
            FxAccrualLinearPayoffRegionSequenceBuilder builder = FxAccrualLinearPayoffRegionSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAccrualLinearPayoffRegionSequenceBuilder builder) {
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getCounterCurrencyAmount()).ifPresent(builder::setCounterCurrencyAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxAccrualLinearPayoffRegionSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            return Objects.equals(this.counterCurrencyAmount, _that.getCounterCurrencyAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrencyAmount != null ? this.counterCurrencyAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxAccrualLinearPayoffRegionSequence {strike=" + this.strike + ", counterCurrencyAmount=" + this.counterCurrencyAmount + '}';
        }
    }
}

