/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.FxAsianFeature;
import fpml.consolidated.fx.FxBarrierFeature;
import fpml.consolidated.fx.meta.FxOptionFeaturesSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxOptionFeaturesSequence", builder=FxOptionFeaturesSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxOptionFeaturesSequence", model="fpml", builder=FxOptionFeaturesSequenceBuilderImpl.class, version="1.1.0")
public interface FxOptionFeaturesSequence
extends RosettaModelObject {
    public static final FxOptionFeaturesSequenceMeta metaData = new FxOptionFeaturesSequenceMeta();

    public FxAsianFeature getAsian();

    public List<? extends FxBarrierFeature> getBarrier();

    public FxOptionFeaturesSequence build();

    public FxOptionFeaturesSequenceBuilder toBuilder();

    public static FxOptionFeaturesSequenceBuilder builder() {
        return new FxOptionFeaturesSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends FxOptionFeaturesSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxOptionFeaturesSequence> getType() {
        return FxOptionFeaturesSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("asian"), processor, FxAsianFeature.class, this.getAsian(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, FxBarrierFeature.class, this.getBarrier(), new AttributeMeta[0]);
    }

    public static class FxOptionFeaturesSequenceBuilderImpl
    implements FxOptionFeaturesSequenceBuilder {
        protected FxAsianFeature.FxAsianFeatureBuilder asian;
        protected List<FxBarrierFeature.FxBarrierFeatureBuilder> barrier = new ArrayList<FxBarrierFeature.FxBarrierFeatureBuilder>();

        @Override
        @RosettaAttribute(value="asian", isRequired=true)
        @RuneAttribute(value="asian", isRequired=true)
        public FxAsianFeature.FxAsianFeatureBuilder getAsian() {
            return this.asian;
        }

        @Override
        public FxAsianFeature.FxAsianFeatureBuilder getOrCreateAsian() {
            FxAsianFeature.FxAsianFeatureBuilder result = this.asian != null ? this.asian : (this.asian = FxAsianFeature.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxBarrierFeature.FxBarrierFeatureBuilder> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxBarrierFeature.FxBarrierFeatureBuilder getOrCreateBarrier(int index) {
            if (this.barrier == null) {
                this.barrier = new ArrayList<FxBarrierFeature.FxBarrierFeatureBuilder>();
            }
            return (FxBarrierFeature.FxBarrierFeatureBuilder)this.getIndex(this.barrier, index, () -> {
                FxBarrierFeature.FxBarrierFeatureBuilder newBarrier = FxBarrierFeature.builder();
                return newBarrier;
            });
        }

        @Override
        @RosettaAttribute(value="asian", isRequired=true)
        @RuneAttribute(value="asian", isRequired=true)
        public FxOptionFeaturesSequenceBuilder setAsian(FxAsianFeature _asian) {
            this.asian = _asian == null ? null : _asian.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxOptionFeaturesSequenceBuilder addBarrier(FxBarrierFeature _barrier) {
            if (_barrier != null) {
                this.barrier.add(_barrier.toBuilder());
            }
            return this;
        }

        @Override
        public FxOptionFeaturesSequenceBuilder addBarrier(FxBarrierFeature _barrier, int idx) {
            this.getIndex(this.barrier, idx, () -> _barrier.toBuilder());
            return this;
        }

        @Override
        public FxOptionFeaturesSequenceBuilder addBarrier(List<? extends FxBarrierFeature> barriers) {
            if (barriers != null) {
                for (FxBarrierFeature fxBarrierFeature : barriers) {
                    this.barrier.add(fxBarrierFeature.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrier")
        public FxOptionFeaturesSequenceBuilder setBarrier(List<? extends FxBarrierFeature> barriers) {
            this.barrier = barriers == null ? new ArrayList<FxBarrierFeature.FxBarrierFeatureBuilder>() : (List)barriers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxOptionFeaturesSequence build() {
            return new FxOptionFeaturesSequenceImpl(this);
        }

        @Override
        public FxOptionFeaturesSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public FxOptionFeaturesSequenceBuilder prune() {
            if (this.asian != null && !this.asian.prune().hasData()) {
                this.asian = null;
            }
            this.barrier = this.barrier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAsian() != null && this.getAsian().hasData()) {
                return true;
            }
            return this.getBarrier() != null && this.getBarrier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FxOptionFeaturesSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxOptionFeaturesSequenceBuilder o = (FxOptionFeaturesSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsian(), (RosettaModelObjectBuilder)o.getAsian(), this::setAsian);
            merger.mergeRosetta(this.getBarrier(), o.getBarrier(), this::getOrCreateBarrier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxOptionFeaturesSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.asian, _that.getAsian())) {
                return false;
            }
            return ListEquals.listEquals(this.barrier, _that.getBarrier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.asian != null ? this.asian.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxOptionFeaturesSequenceBuilder {asian=" + this.asian + ", barrier=" + this.barrier + '}';
        }
    }

    public static interface FxOptionFeaturesSequenceBuilder
    extends FxOptionFeaturesSequence,
    RosettaModelObjectBuilder {
        public FxAsianFeature.FxAsianFeatureBuilder getOrCreateAsian();

        @Override
        public FxAsianFeature.FxAsianFeatureBuilder getAsian();

        public FxBarrierFeature.FxBarrierFeatureBuilder getOrCreateBarrier(int var1);

        public List<? extends FxBarrierFeature.FxBarrierFeatureBuilder> getBarrier();

        public FxOptionFeaturesSequenceBuilder setAsian(FxAsianFeature var1);

        public FxOptionFeaturesSequenceBuilder addBarrier(FxBarrierFeature var1);

        public FxOptionFeaturesSequenceBuilder addBarrier(FxBarrierFeature var1, int var2);

        public FxOptionFeaturesSequenceBuilder addBarrier(List<? extends FxBarrierFeature> var1);

        public FxOptionFeaturesSequenceBuilder setBarrier(List<? extends FxBarrierFeature> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("asian"), processor, FxAsianFeature.FxAsianFeatureBuilder.class, this.getAsian(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, FxBarrierFeature.FxBarrierFeatureBuilder.class, this.getBarrier(), new AttributeMeta[0]);
        }

        public FxOptionFeaturesSequenceBuilder prune();
    }

    public static class FxOptionFeaturesSequenceImpl
    implements FxOptionFeaturesSequence {
        private final FxAsianFeature asian;
        private final List<? extends FxBarrierFeature> barrier;

        protected FxOptionFeaturesSequenceImpl(FxOptionFeaturesSequenceBuilder builder) {
            this.asian = Optional.ofNullable(builder.getAsian()).map(f -> f.build()).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="asian", isRequired=true)
        @RuneAttribute(value="asian", isRequired=true)
        public FxAsianFeature getAsian() {
            return this.asian;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxBarrierFeature> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxOptionFeaturesSequence build() {
            return this;
        }

        @Override
        public FxOptionFeaturesSequenceBuilder toBuilder() {
            FxOptionFeaturesSequenceBuilder builder = FxOptionFeaturesSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxOptionFeaturesSequenceBuilder builder) {
            Optional.ofNullable(this.getAsian()).ifPresent(builder::setAsian);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxOptionFeaturesSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.asian, _that.getAsian())) {
                return false;
            }
            return ListEquals.listEquals(this.barrier, _that.getBarrier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.asian != null ? this.asian.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxOptionFeaturesSequence {asian=" + this.asian + ", barrier=" + this.barrier + '}';
        }
    }
}

