/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.DayTypeEnum;
import fpml.consolidated.fx.FxFixingScheduleSimpleSequence;
import fpml.consolidated.fx.meta.FxFixingScheduleSimpleMeta;
import fpml.consolidated.shared.BusinessCentersOrReferenceModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxFixingScheduleSimple", builder=FxFixingScheduleSimpleBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxFixingScheduleSimple", model="fpml", builder=FxFixingScheduleSimpleBuilderImpl.class, version="1.1.0")
public interface FxFixingScheduleSimple
extends RosettaModelObject {
    public static final FxFixingScheduleSimpleMeta metaData = new FxFixingScheduleSimpleMeta();

    public ZonedDateTime getStartDate();

    public ZonedDateTime getEndDate();

    public DayTypeEnum getDayType();

    public BusinessCentersOrReferenceModel getBusinessCentersOrReferenceModel();

    public List<ZonedDateTime> getFixingDate();

    public FxFixingScheduleSimpleSequence getFxFixingScheduleSimpleSequence();

    public FxFixingScheduleSimple build();

    public FxFixingScheduleSimpleBuilder toBuilder();

    public static FxFixingScheduleSimpleBuilder builder() {
        return new FxFixingScheduleSimpleBuilderImpl();
    }

    default public RosettaMetaData<? extends FxFixingScheduleSimple> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxFixingScheduleSimple> getType() {
        return FxFixingScheduleSimple.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("startDate"), ZonedDateTime.class, (Object)this.getStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("endDate"), ZonedDateTime.class, (Object)this.getEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayType"), DayTypeEnum.class, (Object)this.getDayType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCentersOrReferenceModel"), processor, BusinessCentersOrReferenceModel.class, this.getBusinessCentersOrReferenceModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFixingScheduleSimpleSequence"), processor, FxFixingScheduleSimpleSequence.class, this.getFxFixingScheduleSimpleSequence(), new AttributeMeta[0]);
    }

    public static class FxFixingScheduleSimpleBuilderImpl
    implements FxFixingScheduleSimpleBuilder {
        protected ZonedDateTime startDate;
        protected ZonedDateTime endDate;
        protected DayTypeEnum dayType;
        protected BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder businessCentersOrReferenceModel;
        protected List<ZonedDateTime> fixingDate = new ArrayList<ZonedDateTime>();
        protected FxFixingScheduleSimpleSequence.FxFixingScheduleSimpleSequenceBuilder fxFixingScheduleSimpleSequence;

        @Override
        @RosettaAttribute(value="startDate", isRequired=true)
        @RuneAttribute(value="startDate", isRequired=true)
        public ZonedDateTime getStartDate() {
            return this.startDate;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public ZonedDateTime getEndDate() {
            return this.endDate;
        }

        @Override
        @RosettaAttribute(value="dayType")
        @RuneAttribute(value="dayType")
        public DayTypeEnum getDayType() {
            return this.dayType;
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getBusinessCentersOrReferenceModel() {
            return this.businessCentersOrReferenceModel;
        }

        @Override
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getOrCreateBusinessCentersOrReferenceModel() {
            BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder result = this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel : (this.businessCentersOrReferenceModel = BusinessCentersOrReferenceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public List<ZonedDateTime> getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="fxFixingScheduleSimpleSequence")
        @RuneAttribute(value="fxFixingScheduleSimpleSequence")
        public FxFixingScheduleSimpleSequence.FxFixingScheduleSimpleSequenceBuilder getFxFixingScheduleSimpleSequence() {
            return this.fxFixingScheduleSimpleSequence;
        }

        @Override
        public FxFixingScheduleSimpleSequence.FxFixingScheduleSimpleSequenceBuilder getOrCreateFxFixingScheduleSimpleSequence() {
            FxFixingScheduleSimpleSequence.FxFixingScheduleSimpleSequenceBuilder result = this.fxFixingScheduleSimpleSequence != null ? this.fxFixingScheduleSimpleSequence : (this.fxFixingScheduleSimpleSequence = FxFixingScheduleSimpleSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="startDate", isRequired=true)
        @RuneAttribute(value="startDate", isRequired=true)
        public FxFixingScheduleSimpleBuilder setStartDate(ZonedDateTime _startDate) {
            this.startDate = _startDate == null ? null : _startDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public FxFixingScheduleSimpleBuilder setEndDate(ZonedDateTime _endDate) {
            this.endDate = _endDate == null ? null : _endDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayType")
        @RuneAttribute(value="dayType")
        public FxFixingScheduleSimpleBuilder setDayType(DayTypeEnum _dayType) {
            this.dayType = _dayType == null ? null : _dayType;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public FxFixingScheduleSimpleBuilder setBusinessCentersOrReferenceModel(BusinessCentersOrReferenceModel _businessCentersOrReferenceModel) {
            this.businessCentersOrReferenceModel = _businessCentersOrReferenceModel == null ? null : _businessCentersOrReferenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public FxFixingScheduleSimpleBuilder addFixingDate(ZonedDateTime _fixingDate) {
            if (_fixingDate != null) {
                this.fixingDate.add(_fixingDate);
            }
            return this;
        }

        @Override
        public FxFixingScheduleSimpleBuilder addFixingDate(ZonedDateTime _fixingDate, int idx) {
            this.getIndex(this.fixingDate, idx, () -> _fixingDate);
            return this;
        }

        @Override
        public FxFixingScheduleSimpleBuilder addFixingDate(List<ZonedDateTime> fixingDates) {
            if (fixingDates != null) {
                for (ZonedDateTime toAdd : fixingDates) {
                    this.fixingDate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixingDate")
        public FxFixingScheduleSimpleBuilder setFixingDate(List<ZonedDateTime> fixingDates) {
            this.fixingDate = fixingDates == null ? new ArrayList<ZonedDateTime>() : (List)fixingDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFixingScheduleSimpleSequence")
        @RuneAttribute(value="fxFixingScheduleSimpleSequence")
        public FxFixingScheduleSimpleBuilder setFxFixingScheduleSimpleSequence(FxFixingScheduleSimpleSequence _fxFixingScheduleSimpleSequence) {
            this.fxFixingScheduleSimpleSequence = _fxFixingScheduleSimpleSequence == null ? null : _fxFixingScheduleSimpleSequence.toBuilder();
            return this;
        }

        @Override
        public FxFixingScheduleSimple build() {
            return new FxFixingScheduleSimpleImpl(this);
        }

        @Override
        public FxFixingScheduleSimpleBuilder toBuilder() {
            return this;
        }

        @Override
        public FxFixingScheduleSimpleBuilder prune() {
            if (this.businessCentersOrReferenceModel != null && !this.businessCentersOrReferenceModel.prune().hasData()) {
                this.businessCentersOrReferenceModel = null;
            }
            if (this.fxFixingScheduleSimpleSequence != null && !this.fxFixingScheduleSimpleSequence.prune().hasData()) {
                this.fxFixingScheduleSimpleSequence = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStartDate() != null) {
                return true;
            }
            if (this.getEndDate() != null) {
                return true;
            }
            if (this.getDayType() != null) {
                return true;
            }
            if (this.getBusinessCentersOrReferenceModel() != null && this.getBusinessCentersOrReferenceModel().hasData()) {
                return true;
            }
            if (this.getFixingDate() != null && !this.getFixingDate().isEmpty()) {
                return true;
            }
            return this.getFxFixingScheduleSimpleSequence() != null && this.getFxFixingScheduleSimpleSequence().hasData();
        }

        public FxFixingScheduleSimpleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxFixingScheduleSimpleBuilder o = (FxFixingScheduleSimpleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCentersOrReferenceModel(), (RosettaModelObjectBuilder)o.getBusinessCentersOrReferenceModel(), this::setBusinessCentersOrReferenceModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFixingScheduleSimpleSequence(), (RosettaModelObjectBuilder)o.getFxFixingScheduleSimpleSequence(), this::setFxFixingScheduleSimpleSequence);
            merger.mergeBasic((Object)this.getStartDate(), (Object)o.getStartDate(), this::setStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEndDate(), (Object)o.getEndDate(), this::setEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayType(), (Object)o.getDayType(), this::setDayType, new AttributeMeta[0]);
            merger.mergeBasic(this.getFixingDate(), o.getFixingDate(), this::addFixingDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxFixingScheduleSimple _that = this.getType().cast(o);
            if (!Objects.equals(this.startDate, _that.getStartDate())) {
                return false;
            }
            if (!Objects.equals(this.endDate, _that.getEndDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayType, (Object)_that.getDayType())) {
                return false;
            }
            if (!Objects.equals(this.businessCentersOrReferenceModel, _that.getBusinessCentersOrReferenceModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            return Objects.equals(this.fxFixingScheduleSimpleSequence, _that.getFxFixingScheduleSimpleSequence());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            _result = 31 * _result + (this.dayType != null ? ((Object)((Object)this.dayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingScheduleSimpleSequence != null ? this.fxFixingScheduleSimpleSequence.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxFixingScheduleSimpleBuilder {startDate=" + this.startDate + ", endDate=" + this.endDate + ", dayType=" + (Object)((Object)this.dayType) + ", businessCentersOrReferenceModel=" + this.businessCentersOrReferenceModel + ", fixingDate=" + this.fixingDate + ", fxFixingScheduleSimpleSequence=" + this.fxFixingScheduleSimpleSequence + '}';
        }
    }

    public static interface FxFixingScheduleSimpleBuilder
    extends FxFixingScheduleSimple,
    RosettaModelObjectBuilder {
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getOrCreateBusinessCentersOrReferenceModel();

        @Override
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getBusinessCentersOrReferenceModel();

        public FxFixingScheduleSimpleSequence.FxFixingScheduleSimpleSequenceBuilder getOrCreateFxFixingScheduleSimpleSequence();

        @Override
        public FxFixingScheduleSimpleSequence.FxFixingScheduleSimpleSequenceBuilder getFxFixingScheduleSimpleSequence();

        public FxFixingScheduleSimpleBuilder setStartDate(ZonedDateTime var1);

        public FxFixingScheduleSimpleBuilder setEndDate(ZonedDateTime var1);

        public FxFixingScheduleSimpleBuilder setDayType(DayTypeEnum var1);

        public FxFixingScheduleSimpleBuilder setBusinessCentersOrReferenceModel(BusinessCentersOrReferenceModel var1);

        public FxFixingScheduleSimpleBuilder addFixingDate(ZonedDateTime var1);

        public FxFixingScheduleSimpleBuilder addFixingDate(ZonedDateTime var1, int var2);

        public FxFixingScheduleSimpleBuilder addFixingDate(List<ZonedDateTime> var1);

        public FxFixingScheduleSimpleBuilder setFixingDate(List<ZonedDateTime> var1);

        public FxFixingScheduleSimpleBuilder setFxFixingScheduleSimpleSequence(FxFixingScheduleSimpleSequence var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("startDate"), ZonedDateTime.class, (Object)this.getStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("endDate"), ZonedDateTime.class, (Object)this.getEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayType"), DayTypeEnum.class, (Object)this.getDayType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCentersOrReferenceModel"), processor, BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder.class, this.getBusinessCentersOrReferenceModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFixingScheduleSimpleSequence"), processor, FxFixingScheduleSimpleSequence.FxFixingScheduleSimpleSequenceBuilder.class, this.getFxFixingScheduleSimpleSequence(), new AttributeMeta[0]);
        }

        public FxFixingScheduleSimpleBuilder prune();
    }

    public static class FxFixingScheduleSimpleImpl
    implements FxFixingScheduleSimple {
        private final ZonedDateTime startDate;
        private final ZonedDateTime endDate;
        private final DayTypeEnum dayType;
        private final BusinessCentersOrReferenceModel businessCentersOrReferenceModel;
        private final List<ZonedDateTime> fixingDate;
        private final FxFixingScheduleSimpleSequence fxFixingScheduleSimpleSequence;

        protected FxFixingScheduleSimpleImpl(FxFixingScheduleSimpleBuilder builder) {
            this.startDate = builder.getStartDate();
            this.endDate = builder.getEndDate();
            this.dayType = builder.getDayType();
            this.businessCentersOrReferenceModel = Optional.ofNullable(builder.getBusinessCentersOrReferenceModel()).map(f -> f.build()).orElse(null);
            this.fixingDate = Optional.ofNullable(builder.getFixingDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.fxFixingScheduleSimpleSequence = Optional.ofNullable(builder.getFxFixingScheduleSimpleSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="startDate", isRequired=true)
        @RuneAttribute(value="startDate", isRequired=true)
        public ZonedDateTime getStartDate() {
            return this.startDate;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public ZonedDateTime getEndDate() {
            return this.endDate;
        }

        @Override
        @RosettaAttribute(value="dayType")
        @RuneAttribute(value="dayType")
        public DayTypeEnum getDayType() {
            return this.dayType;
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public BusinessCentersOrReferenceModel getBusinessCentersOrReferenceModel() {
            return this.businessCentersOrReferenceModel;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public List<ZonedDateTime> getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="fxFixingScheduleSimpleSequence")
        @RuneAttribute(value="fxFixingScheduleSimpleSequence")
        public FxFixingScheduleSimpleSequence getFxFixingScheduleSimpleSequence() {
            return this.fxFixingScheduleSimpleSequence;
        }

        @Override
        public FxFixingScheduleSimple build() {
            return this;
        }

        @Override
        public FxFixingScheduleSimpleBuilder toBuilder() {
            FxFixingScheduleSimpleBuilder builder = FxFixingScheduleSimple.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxFixingScheduleSimpleBuilder builder) {
            Optional.ofNullable(this.getStartDate()).ifPresent(builder::setStartDate);
            Optional.ofNullable(this.getEndDate()).ifPresent(builder::setEndDate);
            Optional.ofNullable(this.getDayType()).ifPresent(builder::setDayType);
            Optional.ofNullable(this.getBusinessCentersOrReferenceModel()).ifPresent(builder::setBusinessCentersOrReferenceModel);
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
            Optional.ofNullable(this.getFxFixingScheduleSimpleSequence()).ifPresent(builder::setFxFixingScheduleSimpleSequence);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxFixingScheduleSimple _that = this.getType().cast(o);
            if (!Objects.equals(this.startDate, _that.getStartDate())) {
                return false;
            }
            if (!Objects.equals(this.endDate, _that.getEndDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayType, (Object)_that.getDayType())) {
                return false;
            }
            if (!Objects.equals(this.businessCentersOrReferenceModel, _that.getBusinessCentersOrReferenceModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            return Objects.equals(this.fxFixingScheduleSimpleSequence, _that.getFxFixingScheduleSimpleSequence());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            _result = 31 * _result + (this.dayType != null ? ((Object)((Object)this.dayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingScheduleSimpleSequence != null ? this.fxFixingScheduleSimpleSequence.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxFixingScheduleSimple {startDate=" + this.startDate + ", endDate=" + this.endDate + ", dayType=" + (Object)((Object)this.dayType) + ", businessCentersOrReferenceModel=" + this.businessCentersOrReferenceModel + ", fixingDate=" + this.fixingDate + ", fxFixingScheduleSimpleSequence=" + this.fxFixingScheduleSimpleSequence + '}';
        }
    }
}

