/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.CrossRate;
import fpml.consolidated.fx.ExchangeRateSequence;
import fpml.consolidated.fx.meta.ExchangeRateMeta;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExchangeRate", builder=ExchangeRateBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ExchangeRate", model="fpml", builder=ExchangeRateBuilderImpl.class, version="1.1.0")
public interface ExchangeRate
extends RosettaModelObject {
    public static final ExchangeRateMeta metaData = new ExchangeRateMeta();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public BigDecimal getRate();

    public ExchangeRateSequence getExchangeRateSequence();

    public List<? extends CrossRate> getCrossRate();

    public ExchangeRate build();

    public ExchangeRateBuilder toBuilder();

    public static ExchangeRateBuilder builder() {
        return new ExchangeRateBuilderImpl();
    }

    default public RosettaMetaData<? extends ExchangeRate> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExchangeRate> getType() {
        return ExchangeRate.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeRateSequence"), processor, ExchangeRateSequence.class, this.getExchangeRateSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("crossRate"), processor, CrossRate.class, this.getCrossRate(), new AttributeMeta[0]);
    }

    public static class ExchangeRateBuilderImpl
    implements ExchangeRateBuilder {
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected BigDecimal rate;
        protected ExchangeRateSequence.ExchangeRateSequenceBuilder exchangeRateSequence;
        protected List<CrossRate.CrossRateBuilder> crossRate = new ArrayList<CrossRate.CrossRateBuilder>();

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateSequence")
        @RuneAttribute(value="exchangeRateSequence")
        public ExchangeRateSequence.ExchangeRateSequenceBuilder getExchangeRateSequence() {
            return this.exchangeRateSequence;
        }

        @Override
        public ExchangeRateSequence.ExchangeRateSequenceBuilder getOrCreateExchangeRateSequence() {
            ExchangeRateSequence.ExchangeRateSequenceBuilder result = this.exchangeRateSequence != null ? this.exchangeRateSequence : (this.exchangeRateSequence = ExchangeRateSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="crossRate")
        @RuneAttribute(value="crossRate")
        public List<? extends CrossRate.CrossRateBuilder> getCrossRate() {
            return this.crossRate;
        }

        @Override
        public CrossRate.CrossRateBuilder getOrCreateCrossRate(int index) {
            if (this.crossRate == null) {
                this.crossRate = new ArrayList<CrossRate.CrossRateBuilder>();
            }
            return (CrossRate.CrossRateBuilder)this.getIndex(this.crossRate, index, () -> {
                CrossRate.CrossRateBuilder newCrossRate = CrossRate.builder();
                return newCrossRate;
            });
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public ExchangeRateBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public ExchangeRateBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateSequence")
        @RuneAttribute(value="exchangeRateSequence")
        public ExchangeRateBuilder setExchangeRateSequence(ExchangeRateSequence _exchangeRateSequence) {
            this.exchangeRateSequence = _exchangeRateSequence == null ? null : _exchangeRateSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="crossRate")
        @RuneAttribute(value="crossRate")
        public ExchangeRateBuilder addCrossRate(CrossRate _crossRate) {
            if (_crossRate != null) {
                this.crossRate.add(_crossRate.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeRateBuilder addCrossRate(CrossRate _crossRate, int idx) {
            this.getIndex(this.crossRate, idx, () -> _crossRate.toBuilder());
            return this;
        }

        @Override
        public ExchangeRateBuilder addCrossRate(List<? extends CrossRate> crossRates) {
            if (crossRates != null) {
                for (CrossRate crossRate : crossRates) {
                    this.crossRate.add(crossRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="crossRate")
        public ExchangeRateBuilder setCrossRate(List<? extends CrossRate> crossRates) {
            this.crossRate = crossRates == null ? new ArrayList<CrossRate.CrossRateBuilder>() : (List)crossRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExchangeRate build() {
            return new ExchangeRateImpl(this);
        }

        @Override
        public ExchangeRateBuilder toBuilder() {
            return this;
        }

        @Override
        public ExchangeRateBuilder prune() {
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.exchangeRateSequence != null && !this.exchangeRateSequence.prune().hasData()) {
                this.exchangeRateSequence = null;
            }
            this.crossRate = this.crossRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getRate() != null) {
                return true;
            }
            if (this.getExchangeRateSequence() != null && this.getExchangeRateSequence().hasData()) {
                return true;
            }
            return this.getCrossRate() != null && this.getCrossRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ExchangeRateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExchangeRateBuilder o = (ExchangeRateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeRateSequence(), (RosettaModelObjectBuilder)o.getExchangeRateSequence(), this::setExchangeRateSequence);
            merger.mergeRosetta(this.getCrossRate(), o.getCrossRate(), this::getOrCreateCrossRate);
            merger.mergeBasic((Object)this.getRate(), (Object)o.getRate(), this::setRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExchangeRate _that = this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateSequence, _that.getExchangeRateSequence())) {
                return false;
            }
            return ListEquals.listEquals(this.crossRate, _that.getCrossRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateSequence != null ? this.exchangeRateSequence.hashCode() : 0);
            _result = 31 * _result + (this.crossRate != null ? this.crossRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExchangeRateBuilder {quotedCurrencyPair=" + this.quotedCurrencyPair + ", rate=" + this.rate + ", exchangeRateSequence=" + this.exchangeRateSequence + ", crossRate=" + this.crossRate + '}';
        }
    }

    public static interface ExchangeRateBuilder
    extends ExchangeRate,
    RosettaModelObjectBuilder {
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public ExchangeRateSequence.ExchangeRateSequenceBuilder getOrCreateExchangeRateSequence();

        @Override
        public ExchangeRateSequence.ExchangeRateSequenceBuilder getExchangeRateSequence();

        public CrossRate.CrossRateBuilder getOrCreateCrossRate(int var1);

        public List<? extends CrossRate.CrossRateBuilder> getCrossRate();

        public ExchangeRateBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public ExchangeRateBuilder setRate(BigDecimal var1);

        public ExchangeRateBuilder setExchangeRateSequence(ExchangeRateSequence var1);

        public ExchangeRateBuilder addCrossRate(CrossRate var1);

        public ExchangeRateBuilder addCrossRate(CrossRate var1, int var2);

        public ExchangeRateBuilder addCrossRate(List<? extends CrossRate> var1);

        public ExchangeRateBuilder setCrossRate(List<? extends CrossRate> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeRateSequence"), processor, ExchangeRateSequence.ExchangeRateSequenceBuilder.class, this.getExchangeRateSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("crossRate"), processor, CrossRate.CrossRateBuilder.class, this.getCrossRate(), new AttributeMeta[0]);
        }

        public ExchangeRateBuilder prune();
    }

    public static class ExchangeRateImpl
    implements ExchangeRate {
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final BigDecimal rate;
        private final ExchangeRateSequence exchangeRateSequence;
        private final List<? extends CrossRate> crossRate;

        protected ExchangeRateImpl(ExchangeRateBuilder builder) {
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.rate = builder.getRate();
            this.exchangeRateSequence = Optional.ofNullable(builder.getExchangeRateSequence()).map(f -> f.build()).orElse(null);
            this.crossRate = Optional.ofNullable(builder.getCrossRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateSequence")
        @RuneAttribute(value="exchangeRateSequence")
        public ExchangeRateSequence getExchangeRateSequence() {
            return this.exchangeRateSequence;
        }

        @Override
        @RosettaAttribute(value="crossRate")
        @RuneAttribute(value="crossRate")
        public List<? extends CrossRate> getCrossRate() {
            return this.crossRate;
        }

        @Override
        public ExchangeRate build() {
            return this;
        }

        @Override
        public ExchangeRateBuilder toBuilder() {
            ExchangeRateBuilder builder = ExchangeRate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExchangeRateBuilder builder) {
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getExchangeRateSequence()).ifPresent(builder::setExchangeRateSequence);
            Optional.ofNullable(this.getCrossRate()).ifPresent(builder::setCrossRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExchangeRate _that = this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateSequence, _that.getExchangeRateSequence())) {
                return false;
            }
            return ListEquals.listEquals(this.crossRate, _that.getCrossRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateSequence != null ? this.exchangeRateSequence.hashCode() : 0);
            _result = 31 * _result + (this.crossRate != null ? this.crossRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExchangeRate {quotedCurrencyPair=" + this.quotedCurrencyPair + ", rate=" + this.rate + ", exchangeRateSequence=" + this.exchangeRateSequence + ", crossRate=" + this.crossRate + '}';
        }
    }
}

