/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eqd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.EquityPremium;
import fpml.consolidated.eq.shared.EquityStrike;
import fpml.consolidated.eq.shared.ExtraordinaryEvents;
import fpml.consolidated.eq.shared.FeatureModel;
import fpml.consolidated.eq.shared.IndexAnnexFallbackModel;
import fpml.consolidated.eqd.EquityDerivativeShortFormBase;
import fpml.consolidated.eqd.EquityExerciseValuationSettlement;
import fpml.consolidated.eqd.meta.EquityOptionTransactionSupplementMeta;
import fpml.consolidated.fpmlenum.EquityOptionTypeEnum;
import fpml.consolidated.fpmlenum.MethodOfAdjustmentEnum;
import fpml.consolidated.option.shared.StrategyFeature;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.CountryCode;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.ProductModel;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityOptionTransactionSupplement", builder=EquityOptionTransactionSupplementBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EquityOptionTransactionSupplement", model="fpml", builder=EquityOptionTransactionSupplementBuilderImpl.class, version="1.1.0")
public interface EquityOptionTransactionSupplement
extends EquityDerivativeShortFormBase {
    public static final EquityOptionTransactionSupplementMeta metaData = new EquityOptionTransactionSupplementMeta();

    public Boolean getExchangeLookAlike();

    public Boolean getExchangeTradedContractNearest();

    public IndexAnnexFallbackModel getIndexAnnexFallbackModel();

    public MethodOfAdjustmentEnum getMethodOfAdjustment();

    public CountryCode getLocalJurisdiction();

    public BigDecimal getOptionEntitlement();

    public BigDecimal getMultiplier();

    public ExtraordinaryEvents getExtraordinaryEvents();

    @Override
    public EquityOptionTransactionSupplement build();

    @Override
    public EquityOptionTransactionSupplementBuilder toBuilder();

    public static EquityOptionTransactionSupplementBuilder builder() {
        return new EquityOptionTransactionSupplementBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityOptionTransactionSupplement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityOptionTransactionSupplement> getType() {
        return EquityOptionTransactionSupplement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.class, this.getEquityExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.class, this.getFeatureModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.class, this.getStrategyFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, EquityStrike.class, this.getStrike(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotPrice"), BigDecimal.class, (Object)this.getSpotPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, (Object)this.getNumberOfOptions(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityPremium"), processor, EquityPremium.class, this.getEquityPremium(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeLookAlike"), Boolean.class, (Object)this.getExchangeLookAlike(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeTradedContractNearest"), Boolean.class, (Object)this.getExchangeTradedContractNearest(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexAnnexFallbackModel"), processor, IndexAnnexFallbackModel.class, this.getIndexAnnexFallbackModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("methodOfAdjustment"), MethodOfAdjustmentEnum.class, (Object)this.getMethodOfAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("localJurisdiction"), processor, CountryCode.class, this.getLocalJurisdiction(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionEntitlement"), BigDecimal.class, (Object)this.getOptionEntitlement(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
    }

    public static class EquityOptionTransactionSupplementBuilderImpl
    extends EquityDerivativeShortFormBase.EquityDerivativeShortFormBaseBuilderImpl
    implements EquityOptionTransactionSupplementBuilder {
        protected Boolean exchangeLookAlike;
        protected Boolean exchangeTradedContractNearest;
        protected IndexAnnexFallbackModel.IndexAnnexFallbackModelBuilder indexAnnexFallbackModel;
        protected MethodOfAdjustmentEnum methodOfAdjustment;
        protected CountryCode.CountryCodeBuilder localJurisdiction;
        protected BigDecimal optionEntitlement;
        protected BigDecimal multiplier;
        protected ExtraordinaryEvents.ExtraordinaryEventsBuilder extraordinaryEvents;

        @Override
        @RosettaAttribute(value="exchangeLookAlike")
        @RuneAttribute(value="exchangeLookAlike")
        public Boolean getExchangeLookAlike() {
            return this.exchangeLookAlike;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public Boolean getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        @RosettaAttribute(value="indexAnnexFallbackModel")
        @RuneAttribute(value="indexAnnexFallbackModel")
        public IndexAnnexFallbackModel.IndexAnnexFallbackModelBuilder getIndexAnnexFallbackModel() {
            return this.indexAnnexFallbackModel;
        }

        @Override
        public IndexAnnexFallbackModel.IndexAnnexFallbackModelBuilder getOrCreateIndexAnnexFallbackModel() {
            IndexAnnexFallbackModel.IndexAnnexFallbackModelBuilder result = this.indexAnnexFallbackModel != null ? this.indexAnnexFallbackModel : (this.indexAnnexFallbackModel = IndexAnnexFallbackModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="methodOfAdjustment")
        @RuneAttribute(value="methodOfAdjustment")
        public MethodOfAdjustmentEnum getMethodOfAdjustment() {
            return this.methodOfAdjustment;
        }

        @Override
        @RosettaAttribute(value="localJurisdiction")
        @RuneAttribute(value="localJurisdiction")
        public CountryCode.CountryCodeBuilder getLocalJurisdiction() {
            return this.localJurisdiction;
        }

        @Override
        public CountryCode.CountryCodeBuilder getOrCreateLocalJurisdiction() {
            CountryCode.CountryCodeBuilder result = this.localJurisdiction != null ? this.localJurisdiction : (this.localJurisdiction = CountryCode.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public BigDecimal getOptionEntitlement() {
            return this.optionEntitlement;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getExtraordinaryEvents() {
            return this.extraordinaryEvents;
        }

        @Override
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getOrCreateExtraordinaryEvents() {
            ExtraordinaryEvents.ExtraordinaryEventsBuilder result = this.extraordinaryEvents != null ? this.extraordinaryEvents : (this.extraordinaryEvents = ExtraordinaryEvents.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public EquityOptionTransactionSupplementBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityOptionTransactionSupplementBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public EquityOptionTransactionSupplementBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public EquityOptionTransactionSupplementBuilder setOptionType(EquityOptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityEffectiveDate")
        @RuneAttribute(value="equityEffectiveDate")
        public EquityOptionTransactionSupplementBuilder setEquityEffectiveDate(ZonedDateTime _equityEffectiveDate) {
            this.equityEffectiveDate = _equityEffectiveDate == null ? null : _equityEffectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public EquityOptionTransactionSupplementBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public EquityOptionTransactionSupplementBuilder setNotional(NonNegativeMoney _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExercise", isRequired=true)
        @RuneAttribute(value="equityExercise", isRequired=true)
        public EquityOptionTransactionSupplementBuilder setEquityExercise(EquityExerciseValuationSettlement _equityExercise) {
            this.equityExercise = _equityExercise == null ? null : _equityExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="featureModel")
        @RuneAttribute(value="featureModel")
        public EquityOptionTransactionSupplementBuilder setFeatureModel(FeatureModel _featureModel) {
            this.featureModel = _featureModel == null ? null : _featureModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strategyFeature")
        @RuneAttribute(value="strategyFeature")
        public EquityOptionTransactionSupplementBuilder setStrategyFeature(StrategyFeature _strategyFeature) {
            this.strategyFeature = _strategyFeature == null ? null : _strategyFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public EquityOptionTransactionSupplementBuilder setStrike(EquityStrike _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotPrice")
        @RuneAttribute(value="spotPrice")
        public EquityOptionTransactionSupplementBuilder setSpotPrice(BigDecimal _spotPrice) {
            this.spotPrice = _spotPrice == null ? null : _spotPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfOptions")
        @RuneAttribute(value="numberOfOptions")
        public EquityOptionTransactionSupplementBuilder setNumberOfOptions(BigDecimal _numberOfOptions) {
            this.numberOfOptions = _numberOfOptions == null ? null : _numberOfOptions;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityPremium")
        @RuneAttribute(value="equityPremium")
        public EquityOptionTransactionSupplementBuilder setEquityPremium(EquityPremium _equityPremium) {
            this.equityPremium = _equityPremium == null ? null : _equityPremium.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeLookAlike")
        @RuneAttribute(value="exchangeLookAlike")
        public EquityOptionTransactionSupplementBuilder setExchangeLookAlike(Boolean _exchangeLookAlike) {
            this.exchangeLookAlike = _exchangeLookAlike == null ? null : _exchangeLookAlike;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public EquityOptionTransactionSupplementBuilder setExchangeTradedContractNearest(Boolean _exchangeTradedContractNearest) {
            this.exchangeTradedContractNearest = _exchangeTradedContractNearest == null ? null : _exchangeTradedContractNearest;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexAnnexFallbackModel")
        @RuneAttribute(value="indexAnnexFallbackModel")
        public EquityOptionTransactionSupplementBuilder setIndexAnnexFallbackModel(IndexAnnexFallbackModel _indexAnnexFallbackModel) {
            this.indexAnnexFallbackModel = _indexAnnexFallbackModel == null ? null : _indexAnnexFallbackModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="methodOfAdjustment")
        @RuneAttribute(value="methodOfAdjustment")
        public EquityOptionTransactionSupplementBuilder setMethodOfAdjustment(MethodOfAdjustmentEnum _methodOfAdjustment) {
            this.methodOfAdjustment = _methodOfAdjustment == null ? null : _methodOfAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="localJurisdiction")
        @RuneAttribute(value="localJurisdiction")
        public EquityOptionTransactionSupplementBuilder setLocalJurisdiction(CountryCode _localJurisdiction) {
            this.localJurisdiction = _localJurisdiction == null ? null : _localJurisdiction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public EquityOptionTransactionSupplementBuilder setOptionEntitlement(BigDecimal _optionEntitlement) {
            this.optionEntitlement = _optionEntitlement == null ? null : _optionEntitlement;
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public EquityOptionTransactionSupplementBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public EquityOptionTransactionSupplementBuilder setExtraordinaryEvents(ExtraordinaryEvents _extraordinaryEvents) {
            this.extraordinaryEvents = _extraordinaryEvents == null ? null : _extraordinaryEvents.toBuilder();
            return this;
        }

        @Override
        public EquityOptionTransactionSupplement build() {
            return new EquityOptionTransactionSupplementImpl(this);
        }

        @Override
        public EquityOptionTransactionSupplementBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityOptionTransactionSupplementBuilder prune() {
            super.prune();
            if (this.indexAnnexFallbackModel != null && !this.indexAnnexFallbackModel.prune().hasData()) {
                this.indexAnnexFallbackModel = null;
            }
            if (this.localJurisdiction != null && !this.localJurisdiction.prune().hasData()) {
                this.localJurisdiction = null;
            }
            if (this.extraordinaryEvents != null && !this.extraordinaryEvents.prune().hasData()) {
                this.extraordinaryEvents = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExchangeLookAlike() != null) {
                return true;
            }
            if (this.getExchangeTradedContractNearest() != null) {
                return true;
            }
            if (this.getIndexAnnexFallbackModel() != null && this.getIndexAnnexFallbackModel().hasData()) {
                return true;
            }
            if (this.getMethodOfAdjustment() != null) {
                return true;
            }
            if (this.getLocalJurisdiction() != null && this.getLocalJurisdiction().hasData()) {
                return true;
            }
            if (this.getOptionEntitlement() != null) {
                return true;
            }
            if (this.getMultiplier() != null) {
                return true;
            }
            return this.getExtraordinaryEvents() != null && this.getExtraordinaryEvents().hasData();
        }

        @Override
        public EquityOptionTransactionSupplementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityOptionTransactionSupplementBuilder o = (EquityOptionTransactionSupplementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexAnnexFallbackModel(), (RosettaModelObjectBuilder)o.getIndexAnnexFallbackModel(), this::setIndexAnnexFallbackModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLocalJurisdiction(), (RosettaModelObjectBuilder)o.getLocalJurisdiction(), this::setLocalJurisdiction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtraordinaryEvents(), (RosettaModelObjectBuilder)o.getExtraordinaryEvents(), this::setExtraordinaryEvents);
            merger.mergeBasic((Object)this.getExchangeLookAlike(), (Object)o.getExchangeLookAlike(), this::setExchangeLookAlike, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeTradedContractNearest(), (Object)o.getExchangeTradedContractNearest(), this::setExchangeTradedContractNearest, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMethodOfAdjustment(), (Object)o.getMethodOfAdjustment(), this::setMethodOfAdjustment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionEntitlement(), (Object)o.getOptionEntitlement(), this::setOptionEntitlement, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMultiplier(), (Object)o.getMultiplier(), this::setMultiplier, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityOptionTransactionSupplement _that = (EquityOptionTransactionSupplement)this.getType().cast(o);
            if (!Objects.equals(this.exchangeLookAlike, _that.getExchangeLookAlike())) {
                return false;
            }
            if (!Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest())) {
                return false;
            }
            if (!Objects.equals(this.indexAnnexFallbackModel, _that.getIndexAnnexFallbackModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.methodOfAdjustment, (Object)_that.getMethodOfAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.localJurisdiction, _that.getLocalJurisdiction())) {
                return false;
            }
            if (!Objects.equals(this.optionEntitlement, _that.getOptionEntitlement())) {
                return false;
            }
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            return Objects.equals(this.extraordinaryEvents, _that.getExtraordinaryEvents());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeLookAlike != null ? this.exchangeLookAlike.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            _result = 31 * _result + (this.indexAnnexFallbackModel != null ? this.indexAnnexFallbackModel.hashCode() : 0);
            _result = 31 * _result + (this.methodOfAdjustment != null ? ((Object)((Object)this.methodOfAdjustment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.localJurisdiction != null ? this.localJurisdiction.hashCode() : 0);
            _result = 31 * _result + (this.optionEntitlement != null ? this.optionEntitlement.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.extraordinaryEvents != null ? this.extraordinaryEvents.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityOptionTransactionSupplementBuilder {exchangeLookAlike=" + this.exchangeLookAlike + ", exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + ", indexAnnexFallbackModel=" + this.indexAnnexFallbackModel + ", methodOfAdjustment=" + (Object)((Object)this.methodOfAdjustment) + ", localJurisdiction=" + this.localJurisdiction + ", optionEntitlement=" + this.optionEntitlement + ", multiplier=" + this.multiplier + ", extraordinaryEvents=" + this.extraordinaryEvents + '}' + " " + super.toString();
        }
    }

    public static interface EquityOptionTransactionSupplementBuilder
    extends EquityOptionTransactionSupplement,
    EquityDerivativeShortFormBase.EquityDerivativeShortFormBaseBuilder {
        public IndexAnnexFallbackModel.IndexAnnexFallbackModelBuilder getOrCreateIndexAnnexFallbackModel();

        @Override
        public IndexAnnexFallbackModel.IndexAnnexFallbackModelBuilder getIndexAnnexFallbackModel();

        public CountryCode.CountryCodeBuilder getOrCreateLocalJurisdiction();

        @Override
        public CountryCode.CountryCodeBuilder getLocalJurisdiction();

        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getOrCreateExtraordinaryEvents();

        @Override
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getExtraordinaryEvents();

        @Override
        public EquityOptionTransactionSupplementBuilder setProductModel(ProductModel var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setId(String var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setOptionType(EquityOptionTypeEnum var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setEquityEffectiveDate(ZonedDateTime var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setUnderlyer(Underlyer var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setNotional(NonNegativeMoney var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setEquityExercise(EquityExerciseValuationSettlement var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setFeatureModel(FeatureModel var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setStrategyFeature(StrategyFeature var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setStrike(EquityStrike var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setSpotPrice(BigDecimal var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setNumberOfOptions(BigDecimal var1);

        @Override
        public EquityOptionTransactionSupplementBuilder setEquityPremium(EquityPremium var1);

        public EquityOptionTransactionSupplementBuilder setExchangeLookAlike(Boolean var1);

        public EquityOptionTransactionSupplementBuilder setExchangeTradedContractNearest(Boolean var1);

        public EquityOptionTransactionSupplementBuilder setIndexAnnexFallbackModel(IndexAnnexFallbackModel var1);

        public EquityOptionTransactionSupplementBuilder setMethodOfAdjustment(MethodOfAdjustmentEnum var1);

        public EquityOptionTransactionSupplementBuilder setLocalJurisdiction(CountryCode var1);

        public EquityOptionTransactionSupplementBuilder setOptionEntitlement(BigDecimal var1);

        public EquityOptionTransactionSupplementBuilder setMultiplier(BigDecimal var1);

        public EquityOptionTransactionSupplementBuilder setExtraordinaryEvents(ExtraordinaryEvents var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder.class, (RosettaModelObjectBuilder)this.getEquityExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.FeatureModelBuilder.class, (RosettaModelObjectBuilder)this.getFeatureModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.StrategyFeatureBuilder.class, (RosettaModelObjectBuilder)this.getStrategyFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, EquityStrike.EquityStrikeBuilder.class, (RosettaModelObjectBuilder)this.getStrike(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotPrice"), BigDecimal.class, (Object)this.getSpotPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, (Object)this.getNumberOfOptions(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityPremium"), processor, EquityPremium.EquityPremiumBuilder.class, (RosettaModelObjectBuilder)this.getEquityPremium(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeLookAlike"), Boolean.class, (Object)this.getExchangeLookAlike(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeTradedContractNearest"), Boolean.class, (Object)this.getExchangeTradedContractNearest(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexAnnexFallbackModel"), processor, IndexAnnexFallbackModel.IndexAnnexFallbackModelBuilder.class, this.getIndexAnnexFallbackModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("methodOfAdjustment"), MethodOfAdjustmentEnum.class, (Object)this.getMethodOfAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("localJurisdiction"), processor, CountryCode.CountryCodeBuilder.class, this.getLocalJurisdiction(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionEntitlement"), BigDecimal.class, (Object)this.getOptionEntitlement(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.ExtraordinaryEventsBuilder.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
        }

        @Override
        public EquityOptionTransactionSupplementBuilder prune();
    }

    public static class EquityOptionTransactionSupplementImpl
    extends EquityDerivativeShortFormBase.EquityDerivativeShortFormBaseImpl
    implements EquityOptionTransactionSupplement {
        private final Boolean exchangeLookAlike;
        private final Boolean exchangeTradedContractNearest;
        private final IndexAnnexFallbackModel indexAnnexFallbackModel;
        private final MethodOfAdjustmentEnum methodOfAdjustment;
        private final CountryCode localJurisdiction;
        private final BigDecimal optionEntitlement;
        private final BigDecimal multiplier;
        private final ExtraordinaryEvents extraordinaryEvents;

        protected EquityOptionTransactionSupplementImpl(EquityOptionTransactionSupplementBuilder builder) {
            super(builder);
            this.exchangeLookAlike = builder.getExchangeLookAlike();
            this.exchangeTradedContractNearest = builder.getExchangeTradedContractNearest();
            this.indexAnnexFallbackModel = Optional.ofNullable(builder.getIndexAnnexFallbackModel()).map(f -> f.build()).orElse(null);
            this.methodOfAdjustment = builder.getMethodOfAdjustment();
            this.localJurisdiction = Optional.ofNullable(builder.getLocalJurisdiction()).map(f -> f.build()).orElse(null);
            this.optionEntitlement = builder.getOptionEntitlement();
            this.multiplier = builder.getMultiplier();
            this.extraordinaryEvents = Optional.ofNullable(builder.getExtraordinaryEvents()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="exchangeLookAlike")
        @RuneAttribute(value="exchangeLookAlike")
        public Boolean getExchangeLookAlike() {
            return this.exchangeLookAlike;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedContractNearest")
        @RuneAttribute(value="exchangeTradedContractNearest")
        public Boolean getExchangeTradedContractNearest() {
            return this.exchangeTradedContractNearest;
        }

        @Override
        @RosettaAttribute(value="indexAnnexFallbackModel")
        @RuneAttribute(value="indexAnnexFallbackModel")
        public IndexAnnexFallbackModel getIndexAnnexFallbackModel() {
            return this.indexAnnexFallbackModel;
        }

        @Override
        @RosettaAttribute(value="methodOfAdjustment")
        @RuneAttribute(value="methodOfAdjustment")
        public MethodOfAdjustmentEnum getMethodOfAdjustment() {
            return this.methodOfAdjustment;
        }

        @Override
        @RosettaAttribute(value="localJurisdiction")
        @RuneAttribute(value="localJurisdiction")
        public CountryCode getLocalJurisdiction() {
            return this.localJurisdiction;
        }

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public BigDecimal getOptionEntitlement() {
            return this.optionEntitlement;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public ExtraordinaryEvents getExtraordinaryEvents() {
            return this.extraordinaryEvents;
        }

        @Override
        public EquityOptionTransactionSupplement build() {
            return this;
        }

        @Override
        public EquityOptionTransactionSupplementBuilder toBuilder() {
            EquityOptionTransactionSupplementBuilder builder = EquityOptionTransactionSupplement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityOptionTransactionSupplementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExchangeLookAlike()).ifPresent(builder::setExchangeLookAlike);
            Optional.ofNullable(this.getExchangeTradedContractNearest()).ifPresent(builder::setExchangeTradedContractNearest);
            Optional.ofNullable(this.getIndexAnnexFallbackModel()).ifPresent(builder::setIndexAnnexFallbackModel);
            Optional.ofNullable(this.getMethodOfAdjustment()).ifPresent(builder::setMethodOfAdjustment);
            Optional.ofNullable(this.getLocalJurisdiction()).ifPresent(builder::setLocalJurisdiction);
            Optional.ofNullable(this.getOptionEntitlement()).ifPresent(builder::setOptionEntitlement);
            Optional.ofNullable(this.getMultiplier()).ifPresent(builder::setMultiplier);
            Optional.ofNullable(this.getExtraordinaryEvents()).ifPresent(builder::setExtraordinaryEvents);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityOptionTransactionSupplement _that = (EquityOptionTransactionSupplement)this.getType().cast(o);
            if (!Objects.equals(this.exchangeLookAlike, _that.getExchangeLookAlike())) {
                return false;
            }
            if (!Objects.equals(this.exchangeTradedContractNearest, _that.getExchangeTradedContractNearest())) {
                return false;
            }
            if (!Objects.equals(this.indexAnnexFallbackModel, _that.getIndexAnnexFallbackModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.methodOfAdjustment, (Object)_that.getMethodOfAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.localJurisdiction, _that.getLocalJurisdiction())) {
                return false;
            }
            if (!Objects.equals(this.optionEntitlement, _that.getOptionEntitlement())) {
                return false;
            }
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            return Objects.equals(this.extraordinaryEvents, _that.getExtraordinaryEvents());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exchangeLookAlike != null ? this.exchangeLookAlike.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContractNearest != null ? this.exchangeTradedContractNearest.hashCode() : 0);
            _result = 31 * _result + (this.indexAnnexFallbackModel != null ? this.indexAnnexFallbackModel.hashCode() : 0);
            _result = 31 * _result + (this.methodOfAdjustment != null ? ((Object)((Object)this.methodOfAdjustment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.localJurisdiction != null ? this.localJurisdiction.hashCode() : 0);
            _result = 31 * _result + (this.optionEntitlement != null ? this.optionEntitlement.hashCode() : 0);
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.extraordinaryEvents != null ? this.extraordinaryEvents.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityOptionTransactionSupplement {exchangeLookAlike=" + this.exchangeLookAlike + ", exchangeTradedContractNearest=" + this.exchangeTradedContractNearest + ", indexAnnexFallbackModel=" + this.indexAnnexFallbackModel + ", methodOfAdjustment=" + (Object)((Object)this.methodOfAdjustment) + ", localJurisdiction=" + this.localJurisdiction + ", optionEntitlement=" + this.optionEntitlement + ", multiplier=" + this.multiplier + ", extraordinaryEvents=" + this.extraordinaryEvents + '}' + " " + super.toString();
        }
    }
}

