/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eqd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.DividendConditions;
import fpml.consolidated.eq.shared.EquityPremium;
import fpml.consolidated.eq.shared.EquityStrike;
import fpml.consolidated.eq.shared.ExtraordinaryEvents;
import fpml.consolidated.eq.shared.FeatureModel;
import fpml.consolidated.eqd.EquityDerivativeLongFormBase;
import fpml.consolidated.eqd.EquityExerciseValuationSettlement;
import fpml.consolidated.eqd.meta.EquityOptionMeta;
import fpml.consolidated.fpmlenum.EquityOptionTypeEnum;
import fpml.consolidated.fpmlenum.MethodOfAdjustmentEnum;
import fpml.consolidated.option.shared.StrategyFeature;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.ProductModel;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityOption", builder=EquityOptionBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EquityOption", model="fpml", builder=EquityOptionBuilderImpl.class, version="1.1.0")
public interface EquityOption
extends EquityDerivativeLongFormBase {
    public static final EquityOptionMeta metaData = new EquityOptionMeta();

    public EquityStrike getStrike();

    public BigDecimal getSpotPrice();

    public BigDecimal getNumberOfOptions();

    public BigDecimal getOptionEntitlement();

    public EquityPremium getEquityPremium();

    @Override
    public EquityOption build();

    @Override
    public EquityOptionBuilder toBuilder();

    public static EquityOptionBuilder builder() {
        return new EquityOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityOption> getType() {
        return EquityOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.class, this.getEquityExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.class, this.getFeatureModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.class, this.getStrategyFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendConditions"), processor, DividendConditions.class, this.getDividendConditions(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("methodOfAdjustment"), MethodOfAdjustmentEnum.class, (Object)this.getMethodOfAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, EquityStrike.class, this.getStrike(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotPrice"), BigDecimal.class, (Object)this.getSpotPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, (Object)this.getNumberOfOptions(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionEntitlement"), BigDecimal.class, (Object)this.getOptionEntitlement(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityPremium"), processor, EquityPremium.class, this.getEquityPremium(), new AttributeMeta[0]);
    }

    public static class EquityOptionBuilderImpl
    extends EquityDerivativeLongFormBase.EquityDerivativeLongFormBaseBuilderImpl
    implements EquityOptionBuilder {
        protected EquityStrike.EquityStrikeBuilder strike;
        protected BigDecimal spotPrice;
        protected BigDecimal numberOfOptions;
        protected BigDecimal optionEntitlement;
        protected EquityPremium.EquityPremiumBuilder equityPremium;

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public EquityStrike.EquityStrikeBuilder getStrike() {
            return this.strike;
        }

        @Override
        public EquityStrike.EquityStrikeBuilder getOrCreateStrike() {
            EquityStrike.EquityStrikeBuilder result = this.strike != null ? this.strike : (this.strike = EquityStrike.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spotPrice")
        @RuneAttribute(value="spotPrice")
        public BigDecimal getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        @RosettaAttribute(value="numberOfOptions")
        @RuneAttribute(value="numberOfOptions")
        public BigDecimal getNumberOfOptions() {
            return this.numberOfOptions;
        }

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public BigDecimal getOptionEntitlement() {
            return this.optionEntitlement;
        }

        @Override
        @RosettaAttribute(value="equityPremium")
        @RuneAttribute(value="equityPremium")
        public EquityPremium.EquityPremiumBuilder getEquityPremium() {
            return this.equityPremium;
        }

        @Override
        public EquityPremium.EquityPremiumBuilder getOrCreateEquityPremium() {
            EquityPremium.EquityPremiumBuilder result = this.equityPremium != null ? this.equityPremium : (this.equityPremium = EquityPremium.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public EquityOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public EquityOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public EquityOptionBuilder setOptionType(EquityOptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityEffectiveDate")
        @RuneAttribute(value="equityEffectiveDate")
        public EquityOptionBuilder setEquityEffectiveDate(ZonedDateTime _equityEffectiveDate) {
            this.equityEffectiveDate = _equityEffectiveDate == null ? null : _equityEffectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public EquityOptionBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public EquityOptionBuilder setNotional(NonNegativeMoney _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExercise", isRequired=true)
        @RuneAttribute(value="equityExercise", isRequired=true)
        public EquityOptionBuilder setEquityExercise(EquityExerciseValuationSettlement _equityExercise) {
            this.equityExercise = _equityExercise == null ? null : _equityExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="featureModel")
        @RuneAttribute(value="featureModel")
        public EquityOptionBuilder setFeatureModel(FeatureModel _featureModel) {
            this.featureModel = _featureModel == null ? null : _featureModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strategyFeature")
        @RuneAttribute(value="strategyFeature")
        public EquityOptionBuilder setStrategyFeature(StrategyFeature _strategyFeature) {
            this.strategyFeature = _strategyFeature == null ? null : _strategyFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendConditions")
        @RuneAttribute(value="dividendConditions")
        public EquityOptionBuilder setDividendConditions(DividendConditions _dividendConditions) {
            this.dividendConditions = _dividendConditions == null ? null : _dividendConditions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="methodOfAdjustment")
        @RuneAttribute(value="methodOfAdjustment")
        public EquityOptionBuilder setMethodOfAdjustment(MethodOfAdjustmentEnum _methodOfAdjustment) {
            this.methodOfAdjustment = _methodOfAdjustment == null ? null : _methodOfAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public EquityOptionBuilder setExtraordinaryEvents(ExtraordinaryEvents _extraordinaryEvents) {
            this.extraordinaryEvents = _extraordinaryEvents == null ? null : _extraordinaryEvents.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public EquityOptionBuilder setStrike(EquityStrike _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotPrice")
        @RuneAttribute(value="spotPrice")
        public EquityOptionBuilder setSpotPrice(BigDecimal _spotPrice) {
            this.spotPrice = _spotPrice == null ? null : _spotPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfOptions")
        @RuneAttribute(value="numberOfOptions")
        public EquityOptionBuilder setNumberOfOptions(BigDecimal _numberOfOptions) {
            this.numberOfOptions = _numberOfOptions == null ? null : _numberOfOptions;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public EquityOptionBuilder setOptionEntitlement(BigDecimal _optionEntitlement) {
            this.optionEntitlement = _optionEntitlement == null ? null : _optionEntitlement;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityPremium")
        @RuneAttribute(value="equityPremium")
        public EquityOptionBuilder setEquityPremium(EquityPremium _equityPremium) {
            this.equityPremium = _equityPremium == null ? null : _equityPremium.toBuilder();
            return this;
        }

        @Override
        public EquityOption build() {
            return new EquityOptionImpl(this);
        }

        @Override
        public EquityOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityOptionBuilder prune() {
            super.prune();
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            if (this.equityPremium != null && !this.equityPremium.prune().hasData()) {
                this.equityPremium = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getStrike() != null && this.getStrike().hasData()) {
                return true;
            }
            if (this.getSpotPrice() != null) {
                return true;
            }
            if (this.getNumberOfOptions() != null) {
                return true;
            }
            if (this.getOptionEntitlement() != null) {
                return true;
            }
            return this.getEquityPremium() != null && this.getEquityPremium().hasData();
        }

        @Override
        public EquityOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityOptionBuilder o = (EquityOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityPremium(), (RosettaModelObjectBuilder)o.getEquityPremium(), this::setEquityPremium);
            merger.mergeBasic((Object)this.getSpotPrice(), (Object)o.getSpotPrice(), this::setSpotPrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberOfOptions(), (Object)o.getNumberOfOptions(), this::setNumberOfOptions, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionEntitlement(), (Object)o.getOptionEntitlement(), this::setOptionEntitlement, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityOption _that = (EquityOption)this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.spotPrice, _that.getSpotPrice())) {
                return false;
            }
            if (!Objects.equals(this.numberOfOptions, _that.getNumberOfOptions())) {
                return false;
            }
            if (!Objects.equals(this.optionEntitlement, _that.getOptionEntitlement())) {
                return false;
            }
            return Objects.equals(this.equityPremium, _that.getEquityPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            _result = 31 * _result + (this.numberOfOptions != null ? this.numberOfOptions.hashCode() : 0);
            _result = 31 * _result + (this.optionEntitlement != null ? this.optionEntitlement.hashCode() : 0);
            _result = 31 * _result + (this.equityPremium != null ? this.equityPremium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityOptionBuilder {strike=" + this.strike + ", spotPrice=" + this.spotPrice + ", numberOfOptions=" + this.numberOfOptions + ", optionEntitlement=" + this.optionEntitlement + ", equityPremium=" + this.equityPremium + '}' + " " + super.toString();
        }
    }

    public static interface EquityOptionBuilder
    extends EquityOption,
    EquityDerivativeLongFormBase.EquityDerivativeLongFormBaseBuilder {
        public EquityStrike.EquityStrikeBuilder getOrCreateStrike();

        @Override
        public EquityStrike.EquityStrikeBuilder getStrike();

        public EquityPremium.EquityPremiumBuilder getOrCreateEquityPremium();

        @Override
        public EquityPremium.EquityPremiumBuilder getEquityPremium();

        @Override
        public EquityOptionBuilder setProductModel(ProductModel var1);

        @Override
        public EquityOptionBuilder setId(String var1);

        @Override
        public EquityOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        public EquityOptionBuilder setOptionType(EquityOptionTypeEnum var1);

        @Override
        public EquityOptionBuilder setEquityEffectiveDate(ZonedDateTime var1);

        @Override
        public EquityOptionBuilder setUnderlyer(Underlyer var1);

        @Override
        public EquityOptionBuilder setNotional(NonNegativeMoney var1);

        @Override
        public EquityOptionBuilder setEquityExercise(EquityExerciseValuationSettlement var1);

        @Override
        public EquityOptionBuilder setFeatureModel(FeatureModel var1);

        @Override
        public EquityOptionBuilder setStrategyFeature(StrategyFeature var1);

        @Override
        public EquityOptionBuilder setDividendConditions(DividendConditions var1);

        @Override
        public EquityOptionBuilder setMethodOfAdjustment(MethodOfAdjustmentEnum var1);

        @Override
        public EquityOptionBuilder setExtraordinaryEvents(ExtraordinaryEvents var1);

        public EquityOptionBuilder setStrike(EquityStrike var1);

        public EquityOptionBuilder setSpotPrice(BigDecimal var1);

        public EquityOptionBuilder setNumberOfOptions(BigDecimal var1);

        public EquityOptionBuilder setOptionEntitlement(BigDecimal var1);

        public EquityOptionBuilder setEquityPremium(EquityPremium var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder.class, (RosettaModelObjectBuilder)this.getEquityExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.FeatureModelBuilder.class, (RosettaModelObjectBuilder)this.getFeatureModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.StrategyFeatureBuilder.class, (RosettaModelObjectBuilder)this.getStrategyFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendConditions"), processor, DividendConditions.DividendConditionsBuilder.class, (RosettaModelObjectBuilder)this.getDividendConditions(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("methodOfAdjustment"), MethodOfAdjustmentEnum.class, (Object)this.getMethodOfAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.ExtraordinaryEventsBuilder.class, (RosettaModelObjectBuilder)this.getExtraordinaryEvents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, EquityStrike.EquityStrikeBuilder.class, this.getStrike(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotPrice"), BigDecimal.class, (Object)this.getSpotPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfOptions"), BigDecimal.class, (Object)this.getNumberOfOptions(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionEntitlement"), BigDecimal.class, (Object)this.getOptionEntitlement(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityPremium"), processor, EquityPremium.EquityPremiumBuilder.class, this.getEquityPremium(), new AttributeMeta[0]);
        }

        @Override
        public EquityOptionBuilder prune();
    }

    public static class EquityOptionImpl
    extends EquityDerivativeLongFormBase.EquityDerivativeLongFormBaseImpl
    implements EquityOption {
        private final EquityStrike strike;
        private final BigDecimal spotPrice;
        private final BigDecimal numberOfOptions;
        private final BigDecimal optionEntitlement;
        private final EquityPremium equityPremium;

        protected EquityOptionImpl(EquityOptionBuilder builder) {
            super(builder);
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
            this.spotPrice = builder.getSpotPrice();
            this.numberOfOptions = builder.getNumberOfOptions();
            this.optionEntitlement = builder.getOptionEntitlement();
            this.equityPremium = Optional.ofNullable(builder.getEquityPremium()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public EquityStrike getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="spotPrice")
        @RuneAttribute(value="spotPrice")
        public BigDecimal getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        @RosettaAttribute(value="numberOfOptions")
        @RuneAttribute(value="numberOfOptions")
        public BigDecimal getNumberOfOptions() {
            return this.numberOfOptions;
        }

        @Override
        @RosettaAttribute(value="optionEntitlement")
        @RuneAttribute(value="optionEntitlement")
        public BigDecimal getOptionEntitlement() {
            return this.optionEntitlement;
        }

        @Override
        @RosettaAttribute(value="equityPremium")
        @RuneAttribute(value="equityPremium")
        public EquityPremium getEquityPremium() {
            return this.equityPremium;
        }

        @Override
        public EquityOption build() {
            return this;
        }

        @Override
        public EquityOptionBuilder toBuilder() {
            EquityOptionBuilder builder = EquityOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getSpotPrice()).ifPresent(builder::setSpotPrice);
            Optional.ofNullable(this.getNumberOfOptions()).ifPresent(builder::setNumberOfOptions);
            Optional.ofNullable(this.getOptionEntitlement()).ifPresent(builder::setOptionEntitlement);
            Optional.ofNullable(this.getEquityPremium()).ifPresent(builder::setEquityPremium);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityOption _that = (EquityOption)this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.spotPrice, _that.getSpotPrice())) {
                return false;
            }
            if (!Objects.equals(this.numberOfOptions, _that.getNumberOfOptions())) {
                return false;
            }
            if (!Objects.equals(this.optionEntitlement, _that.getOptionEntitlement())) {
                return false;
            }
            return Objects.equals(this.equityPremium, _that.getEquityPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            _result = 31 * _result + (this.numberOfOptions != null ? this.numberOfOptions.hashCode() : 0);
            _result = 31 * _result + (this.optionEntitlement != null ? this.optionEntitlement.hashCode() : 0);
            _result = 31 * _result + (this.equityPremium != null ? this.equityPremium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityOption {strike=" + this.strike + ", spotPrice=" + this.spotPrice + ", numberOfOptions=" + this.numberOfOptions + ", optionEntitlement=" + this.optionEntitlement + ", equityPremium=" + this.equityPremium + '}' + " " + super.toString();
        }
    }
}

