/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eqd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.DividendConditions;
import fpml.consolidated.eq.shared.ExtraordinaryEvents;
import fpml.consolidated.eq.shared.FeatureModel;
import fpml.consolidated.eqd.EquityDerivativeLongFormBase;
import fpml.consolidated.eqd.EquityExerciseValuationSettlement;
import fpml.consolidated.eqd.meta.EquityForwardMeta;
import fpml.consolidated.fpmlenum.EquityOptionTypeEnum;
import fpml.consolidated.fpmlenum.MethodOfAdjustmentEnum;
import fpml.consolidated.option.shared.StrategyFeature;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.ProductModel;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityForward", builder=EquityForwardBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EquityForward", model="fpml", builder=EquityForwardBuilderImpl.class, version="1.1.0")
public interface EquityForward
extends EquityDerivativeLongFormBase {
    public static final EquityForwardMeta metaData = new EquityForwardMeta();

    public NonNegativeMoney getForwardPrice();

    @Override
    public EquityForward build();

    @Override
    public EquityForwardBuilder toBuilder();

    public static EquityForwardBuilder builder() {
        return new EquityForwardBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityForward> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityForward> getType() {
        return EquityForward.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.class, this.getEquityExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.class, this.getFeatureModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.class, this.getStrategyFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendConditions"), processor, DividendConditions.class, this.getDividendConditions(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("methodOfAdjustment"), MethodOfAdjustmentEnum.class, (Object)this.getMethodOfAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forwardPrice"), processor, NonNegativeMoney.class, this.getForwardPrice(), new AttributeMeta[0]);
    }

    public static class EquityForwardBuilderImpl
    extends EquityDerivativeLongFormBase.EquityDerivativeLongFormBaseBuilderImpl
    implements EquityForwardBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder forwardPrice;

        @Override
        @RosettaAttribute(value="forwardPrice")
        @RuneAttribute(value="forwardPrice")
        public NonNegativeMoney.NonNegativeMoneyBuilder getForwardPrice() {
            return this.forwardPrice;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateForwardPrice() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.forwardPrice != null ? this.forwardPrice : (this.forwardPrice = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public EquityForwardBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityForwardBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public EquityForwardBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public EquityForwardBuilder setOptionType(EquityOptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityEffectiveDate")
        @RuneAttribute(value="equityEffectiveDate")
        public EquityForwardBuilder setEquityEffectiveDate(ZonedDateTime _equityEffectiveDate) {
            this.equityEffectiveDate = _equityEffectiveDate == null ? null : _equityEffectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public EquityForwardBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public EquityForwardBuilder setNotional(NonNegativeMoney _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExercise", isRequired=true)
        @RuneAttribute(value="equityExercise", isRequired=true)
        public EquityForwardBuilder setEquityExercise(EquityExerciseValuationSettlement _equityExercise) {
            this.equityExercise = _equityExercise == null ? null : _equityExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="featureModel")
        @RuneAttribute(value="featureModel")
        public EquityForwardBuilder setFeatureModel(FeatureModel _featureModel) {
            this.featureModel = _featureModel == null ? null : _featureModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strategyFeature")
        @RuneAttribute(value="strategyFeature")
        public EquityForwardBuilder setStrategyFeature(StrategyFeature _strategyFeature) {
            this.strategyFeature = _strategyFeature == null ? null : _strategyFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendConditions")
        @RuneAttribute(value="dividendConditions")
        public EquityForwardBuilder setDividendConditions(DividendConditions _dividendConditions) {
            this.dividendConditions = _dividendConditions == null ? null : _dividendConditions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="methodOfAdjustment")
        @RuneAttribute(value="methodOfAdjustment")
        public EquityForwardBuilder setMethodOfAdjustment(MethodOfAdjustmentEnum _methodOfAdjustment) {
            this.methodOfAdjustment = _methodOfAdjustment == null ? null : _methodOfAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public EquityForwardBuilder setExtraordinaryEvents(ExtraordinaryEvents _extraordinaryEvents) {
            this.extraordinaryEvents = _extraordinaryEvents == null ? null : _extraordinaryEvents.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardPrice")
        @RuneAttribute(value="forwardPrice")
        public EquityForwardBuilder setForwardPrice(NonNegativeMoney _forwardPrice) {
            this.forwardPrice = _forwardPrice == null ? null : _forwardPrice.toBuilder();
            return this;
        }

        @Override
        public EquityForward build() {
            return new EquityForwardImpl(this);
        }

        @Override
        public EquityForwardBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityForwardBuilder prune() {
            super.prune();
            if (this.forwardPrice != null && !this.forwardPrice.prune().hasData()) {
                this.forwardPrice = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getForwardPrice() != null && this.getForwardPrice().hasData();
        }

        @Override
        public EquityForwardBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityForwardBuilder o = (EquityForwardBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForwardPrice(), (RosettaModelObjectBuilder)o.getForwardPrice(), this::setForwardPrice);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityForward _that = (EquityForward)this.getType().cast(o);
            return Objects.equals(this.forwardPrice, _that.getForwardPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.forwardPrice != null ? this.forwardPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityForwardBuilder {forwardPrice=" + this.forwardPrice + '}' + " " + super.toString();
        }
    }

    public static interface EquityForwardBuilder
    extends EquityForward,
    EquityDerivativeLongFormBase.EquityDerivativeLongFormBaseBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateForwardPrice();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getForwardPrice();

        @Override
        public EquityForwardBuilder setProductModel(ProductModel var1);

        @Override
        public EquityForwardBuilder setId(String var1);

        @Override
        public EquityForwardBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        public EquityForwardBuilder setOptionType(EquityOptionTypeEnum var1);

        @Override
        public EquityForwardBuilder setEquityEffectiveDate(ZonedDateTime var1);

        @Override
        public EquityForwardBuilder setUnderlyer(Underlyer var1);

        @Override
        public EquityForwardBuilder setNotional(NonNegativeMoney var1);

        @Override
        public EquityForwardBuilder setEquityExercise(EquityExerciseValuationSettlement var1);

        @Override
        public EquityForwardBuilder setFeatureModel(FeatureModel var1);

        @Override
        public EquityForwardBuilder setStrategyFeature(StrategyFeature var1);

        @Override
        public EquityForwardBuilder setDividendConditions(DividendConditions var1);

        @Override
        public EquityForwardBuilder setMethodOfAdjustment(MethodOfAdjustmentEnum var1);

        @Override
        public EquityForwardBuilder setExtraordinaryEvents(ExtraordinaryEvents var1);

        public EquityForwardBuilder setForwardPrice(NonNegativeMoney var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), EquityOptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("equityEffectiveDate"), ZonedDateTime.class, (Object)this.getEquityEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExercise"), processor, EquityExerciseValuationSettlement.EquityExerciseValuationSettlementBuilder.class, (RosettaModelObjectBuilder)this.getEquityExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("featureModel"), processor, FeatureModel.FeatureModelBuilder.class, (RosettaModelObjectBuilder)this.getFeatureModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.StrategyFeatureBuilder.class, (RosettaModelObjectBuilder)this.getStrategyFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendConditions"), processor, DividendConditions.DividendConditionsBuilder.class, (RosettaModelObjectBuilder)this.getDividendConditions(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("methodOfAdjustment"), MethodOfAdjustmentEnum.class, (Object)this.getMethodOfAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.ExtraordinaryEventsBuilder.class, (RosettaModelObjectBuilder)this.getExtraordinaryEvents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forwardPrice"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getForwardPrice(), new AttributeMeta[0]);
        }

        @Override
        public EquityForwardBuilder prune();
    }

    public static class EquityForwardImpl
    extends EquityDerivativeLongFormBase.EquityDerivativeLongFormBaseImpl
    implements EquityForward {
        private final NonNegativeMoney forwardPrice;

        protected EquityForwardImpl(EquityForwardBuilder builder) {
            super(builder);
            this.forwardPrice = Optional.ofNullable(builder.getForwardPrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="forwardPrice")
        @RuneAttribute(value="forwardPrice")
        public NonNegativeMoney getForwardPrice() {
            return this.forwardPrice;
        }

        @Override
        public EquityForward build() {
            return this;
        }

        @Override
        public EquityForwardBuilder toBuilder() {
            EquityForwardBuilder builder = EquityForward.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityForwardBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getForwardPrice()).ifPresent(builder::setForwardPrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityForward _that = (EquityForward)this.getType().cast(o);
            return Objects.equals(this.forwardPrice, _that.getForwardPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.forwardPrice != null ? this.forwardPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityForward {forwardPrice=" + this.forwardPrice + '}' + " " + super.toString();
        }
    }
}

