/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eqd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eqd.EquityExpirationModel;
import fpml.consolidated.eqd.EquityMultipleExercise;
import fpml.consolidated.eqd.meta.EquityAmericanExerciseMeta;
import fpml.consolidated.fpmlenum.TimeTypeEnum;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.BusinessCenterTime;
import fpml.consolidated.shared.DeterminationMethod;
import fpml.consolidated.shared.SharedAmericanExercise;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityAmericanExercise", builder=EquityAmericanExerciseBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EquityAmericanExercise", model="fpml", builder=EquityAmericanExerciseBuilderImpl.class, version="1.1.0")
public interface EquityAmericanExercise
extends SharedAmericanExercise {
    public static final EquityAmericanExerciseMeta metaData = new EquityAmericanExerciseMeta();

    public TimeTypeEnum getLatestExerciseTimeType();

    public EquityExpirationModel getEquityExpirationModel();

    public EquityMultipleExercise getEquityMultipleExercise();

    @Override
    public EquityAmericanExercise build();

    @Override
    public EquityAmericanExerciseBuilder toBuilder();

    public static EquityAmericanExerciseBuilder builder() {
        return new EquityAmericanExerciseBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityAmericanExercise> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityAmericanExercise> getType() {
        return EquityAmericanExercise.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commencementDate"), processor, AdjustableOrRelativeDate.class, this.getCommencementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("latestExerciseTime"), processor, BusinessCenterTime.class, this.getLatestExerciseTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("latestExerciseTimeDetermination"), processor, DeterminationMethod.class, this.getLatestExerciseTimeDetermination(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("latestExerciseTimeType"), TimeTypeEnum.class, (Object)this.getLatestExerciseTimeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExpirationModel"), processor, EquityExpirationModel.class, this.getEquityExpirationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityMultipleExercise"), processor, EquityMultipleExercise.class, this.getEquityMultipleExercise(), new AttributeMeta[0]);
    }

    public static class EquityAmericanExerciseBuilderImpl
    extends SharedAmericanExercise.SharedAmericanExerciseBuilderImpl
    implements EquityAmericanExerciseBuilder {
        protected TimeTypeEnum latestExerciseTimeType;
        protected EquityExpirationModel.EquityExpirationModelBuilder equityExpirationModel;
        protected EquityMultipleExercise.EquityMultipleExerciseBuilder equityMultipleExercise;

        @Override
        @RosettaAttribute(value="latestExerciseTimeType")
        @RuneAttribute(value="latestExerciseTimeType")
        public TimeTypeEnum getLatestExerciseTimeType() {
            return this.latestExerciseTimeType;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityExpirationModel.EquityExpirationModelBuilder getEquityExpirationModel() {
            return this.equityExpirationModel;
        }

        @Override
        public EquityExpirationModel.EquityExpirationModelBuilder getOrCreateEquityExpirationModel() {
            EquityExpirationModel.EquityExpirationModelBuilder result = this.equityExpirationModel != null ? this.equityExpirationModel : (this.equityExpirationModel = EquityExpirationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityMultipleExercise")
        @RuneAttribute(value="equityMultipleExercise")
        public EquityMultipleExercise.EquityMultipleExerciseBuilder getEquityMultipleExercise() {
            return this.equityMultipleExercise;
        }

        @Override
        public EquityMultipleExercise.EquityMultipleExerciseBuilder getOrCreateEquityMultipleExercise() {
            EquityMultipleExercise.EquityMultipleExerciseBuilder result = this.equityMultipleExercise != null ? this.equityMultipleExercise : (this.equityMultipleExercise = EquityMultipleExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityAmericanExerciseBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commencementDate")
        @RuneAttribute(value="commencementDate")
        public EquityAmericanExerciseBuilder setCommencementDate(AdjustableOrRelativeDate _commencementDate) {
            this.commencementDate = _commencementDate == null ? null : _commencementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public EquityAmericanExerciseBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTime")
        @RuneAttribute(value="latestExerciseTime")
        public EquityAmericanExerciseBuilder setLatestExerciseTime(BusinessCenterTime _latestExerciseTime) {
            this.latestExerciseTime = _latestExerciseTime == null ? null : _latestExerciseTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTimeDetermination")
        @RuneAttribute(value="latestExerciseTimeDetermination")
        public EquityAmericanExerciseBuilder setLatestExerciseTimeDetermination(DeterminationMethod _latestExerciseTimeDetermination) {
            this.latestExerciseTimeDetermination = _latestExerciseTimeDetermination == null ? null : _latestExerciseTimeDetermination.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="latestExerciseTimeType")
        @RuneAttribute(value="latestExerciseTimeType")
        public EquityAmericanExerciseBuilder setLatestExerciseTimeType(TimeTypeEnum _latestExerciseTimeType) {
            this.latestExerciseTimeType = _latestExerciseTimeType == null ? null : _latestExerciseTimeType;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityAmericanExerciseBuilder setEquityExpirationModel(EquityExpirationModel _equityExpirationModel) {
            this.equityExpirationModel = _equityExpirationModel == null ? null : _equityExpirationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityMultipleExercise")
        @RuneAttribute(value="equityMultipleExercise")
        public EquityAmericanExerciseBuilder setEquityMultipleExercise(EquityMultipleExercise _equityMultipleExercise) {
            this.equityMultipleExercise = _equityMultipleExercise == null ? null : _equityMultipleExercise.toBuilder();
            return this;
        }

        @Override
        public EquityAmericanExercise build() {
            return new EquityAmericanExerciseImpl(this);
        }

        @Override
        public EquityAmericanExerciseBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityAmericanExerciseBuilder prune() {
            super.prune();
            if (this.equityExpirationModel != null && !this.equityExpirationModel.prune().hasData()) {
                this.equityExpirationModel = null;
            }
            if (this.equityMultipleExercise != null && !this.equityMultipleExercise.prune().hasData()) {
                this.equityMultipleExercise = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLatestExerciseTimeType() != null) {
                return true;
            }
            if (this.getEquityExpirationModel() != null && this.getEquityExpirationModel().hasData()) {
                return true;
            }
            return this.getEquityMultipleExercise() != null && this.getEquityMultipleExercise().hasData();
        }

        @Override
        public EquityAmericanExerciseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityAmericanExerciseBuilder o = (EquityAmericanExerciseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityExpirationModel(), (RosettaModelObjectBuilder)o.getEquityExpirationModel(), this::setEquityExpirationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityMultipleExercise(), (RosettaModelObjectBuilder)o.getEquityMultipleExercise(), this::setEquityMultipleExercise);
            merger.mergeBasic((Object)this.getLatestExerciseTimeType(), (Object)o.getLatestExerciseTimeType(), this::setLatestExerciseTimeType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityAmericanExercise _that = (EquityAmericanExercise)this.getType().cast(o);
            if (!Objects.equals((Object)this.latestExerciseTimeType, (Object)_that.getLatestExerciseTimeType())) {
                return false;
            }
            if (!Objects.equals(this.equityExpirationModel, _that.getEquityExpirationModel())) {
                return false;
            }
            return Objects.equals(this.equityMultipleExercise, _that.getEquityMultipleExercise());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.latestExerciseTimeType != null ? ((Object)((Object)this.latestExerciseTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.equityExpirationModel != null ? this.equityExpirationModel.hashCode() : 0);
            _result = 31 * _result + (this.equityMultipleExercise != null ? this.equityMultipleExercise.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityAmericanExerciseBuilder {latestExerciseTimeType=" + (Object)((Object)this.latestExerciseTimeType) + ", equityExpirationModel=" + this.equityExpirationModel + ", equityMultipleExercise=" + this.equityMultipleExercise + '}' + " " + super.toString();
        }
    }

    public static interface EquityAmericanExerciseBuilder
    extends EquityAmericanExercise,
    SharedAmericanExercise.SharedAmericanExerciseBuilder {
        public EquityExpirationModel.EquityExpirationModelBuilder getOrCreateEquityExpirationModel();

        @Override
        public EquityExpirationModel.EquityExpirationModelBuilder getEquityExpirationModel();

        public EquityMultipleExercise.EquityMultipleExerciseBuilder getOrCreateEquityMultipleExercise();

        @Override
        public EquityMultipleExercise.EquityMultipleExerciseBuilder getEquityMultipleExercise();

        @Override
        public EquityAmericanExerciseBuilder setId(String var1);

        @Override
        public EquityAmericanExerciseBuilder setCommencementDate(AdjustableOrRelativeDate var1);

        @Override
        public EquityAmericanExerciseBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        @Override
        public EquityAmericanExerciseBuilder setLatestExerciseTime(BusinessCenterTime var1);

        @Override
        public EquityAmericanExerciseBuilder setLatestExerciseTimeDetermination(DeterminationMethod var1);

        public EquityAmericanExerciseBuilder setLatestExerciseTimeType(TimeTypeEnum var1);

        public EquityAmericanExerciseBuilder setEquityExpirationModel(EquityExpirationModel var1);

        public EquityAmericanExerciseBuilder setEquityMultipleExercise(EquityMultipleExercise var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commencementDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getCommencementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("latestExerciseTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, (RosettaModelObjectBuilder)this.getLatestExerciseTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("latestExerciseTimeDetermination"), processor, DeterminationMethod.DeterminationMethodBuilder.class, (RosettaModelObjectBuilder)this.getLatestExerciseTimeDetermination(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("latestExerciseTimeType"), TimeTypeEnum.class, (Object)this.getLatestExerciseTimeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExpirationModel"), processor, EquityExpirationModel.EquityExpirationModelBuilder.class, this.getEquityExpirationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityMultipleExercise"), processor, EquityMultipleExercise.EquityMultipleExerciseBuilder.class, this.getEquityMultipleExercise(), new AttributeMeta[0]);
        }

        @Override
        public EquityAmericanExerciseBuilder prune();
    }

    public static class EquityAmericanExerciseImpl
    extends SharedAmericanExercise.SharedAmericanExerciseImpl
    implements EquityAmericanExercise {
        private final TimeTypeEnum latestExerciseTimeType;
        private final EquityExpirationModel equityExpirationModel;
        private final EquityMultipleExercise equityMultipleExercise;

        protected EquityAmericanExerciseImpl(EquityAmericanExerciseBuilder builder) {
            super(builder);
            this.latestExerciseTimeType = builder.getLatestExerciseTimeType();
            this.equityExpirationModel = Optional.ofNullable(builder.getEquityExpirationModel()).map(f -> f.build()).orElse(null);
            this.equityMultipleExercise = Optional.ofNullable(builder.getEquityMultipleExercise()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="latestExerciseTimeType")
        @RuneAttribute(value="latestExerciseTimeType")
        public TimeTypeEnum getLatestExerciseTimeType() {
            return this.latestExerciseTimeType;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityExpirationModel getEquityExpirationModel() {
            return this.equityExpirationModel;
        }

        @Override
        @RosettaAttribute(value="equityMultipleExercise")
        @RuneAttribute(value="equityMultipleExercise")
        public EquityMultipleExercise getEquityMultipleExercise() {
            return this.equityMultipleExercise;
        }

        @Override
        public EquityAmericanExercise build() {
            return this;
        }

        @Override
        public EquityAmericanExerciseBuilder toBuilder() {
            EquityAmericanExerciseBuilder builder = EquityAmericanExercise.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityAmericanExerciseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLatestExerciseTimeType()).ifPresent(builder::setLatestExerciseTimeType);
            Optional.ofNullable(this.getEquityExpirationModel()).ifPresent(builder::setEquityExpirationModel);
            Optional.ofNullable(this.getEquityMultipleExercise()).ifPresent(builder::setEquityMultipleExercise);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityAmericanExercise _that = (EquityAmericanExercise)this.getType().cast(o);
            if (!Objects.equals((Object)this.latestExerciseTimeType, (Object)_that.getLatestExerciseTimeType())) {
                return false;
            }
            if (!Objects.equals(this.equityExpirationModel, _that.getEquityExpirationModel())) {
                return false;
            }
            return Objects.equals(this.equityMultipleExercise, _that.getEquityMultipleExercise());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.latestExerciseTimeType != null ? ((Object)((Object)this.latestExerciseTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.equityExpirationModel != null ? this.equityExpirationModel.hashCode() : 0);
            _result = 31 * _result + (this.equityMultipleExercise != null ? this.equityMultipleExercise.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityAmericanExercise {latestExerciseTimeType=" + (Object)((Object)this.latestExerciseTimeType) + ", equityExpirationModel=" + this.equityExpirationModel + ", equityMultipleExercise=" + this.equityMultipleExercise + '}' + " " + super.toString();
        }
    }
}

