/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Commission;
import fpml.consolidated.asset.EquityPriceModel;
import fpml.consolidated.asset.Price;
import fpml.consolidated.asset.PriceSequence;
import fpml.consolidated.asset.QuotationCharacteristics;
import fpml.consolidated.eq.shared.EquityValuation;
import fpml.consolidated.eq.shared.meta.ReturnLegValuationPriceMeta;
import fpml.consolidated.shared.AmountReference;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ReturnLegValuationPrice", builder=ReturnLegValuationPriceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ReturnLegValuationPrice", model="fpml", builder=ReturnLegValuationPriceBuilderImpl.class, version="1.1.0")
public interface ReturnLegValuationPrice
extends Price {
    public static final ReturnLegValuationPriceMeta metaData = new ReturnLegValuationPriceMeta();

    public EquityValuation getValuationRules();

    @Override
    public ReturnLegValuationPrice build();

    @Override
    public ReturnLegValuationPriceBuilder toBuilder();

    public static ReturnLegValuationPriceBuilder builder() {
        return new ReturnLegValuationPriceBuilderImpl();
    }

    default public RosettaMetaData<? extends ReturnLegValuationPrice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReturnLegValuationPrice> getType() {
        return ReturnLegValuationPrice.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("commission"), processor, Commission.class, this.getCommission(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSequence"), processor, PriceSequence.class, this.getPriceSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amountRelativeTo"), processor, AmountReference.class, this.getAmountRelativeTo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityPriceModel"), processor, EquityPriceModel.class, this.getEquityPriceModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleanNetPrice"), BigDecimal.class, (Object)this.getCleanNetPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotationCharacteristics"), processor, QuotationCharacteristics.class, this.getQuotationCharacteristics(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationRules"), processor, EquityValuation.class, this.getValuationRules(), new AttributeMeta[0]);
    }

    public static class ReturnLegValuationPriceBuilderImpl
    extends Price.PriceBuilderImpl
    implements ReturnLegValuationPriceBuilder {
        protected EquityValuation.EquityValuationBuilder valuationRules;

        @Override
        @RosettaAttribute(value="valuationRules")
        @RuneAttribute(value="valuationRules")
        public EquityValuation.EquityValuationBuilder getValuationRules() {
            return this.valuationRules;
        }

        @Override
        public EquityValuation.EquityValuationBuilder getOrCreateValuationRules() {
            EquityValuation.EquityValuationBuilder result = this.valuationRules != null ? this.valuationRules : (this.valuationRules = EquityValuation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commission")
        @RuneAttribute(value="commission")
        public ReturnLegValuationPriceBuilder setCommission(Commission _commission) {
            this.commission = _commission == null ? null : _commission.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSequence")
        @RuneAttribute(value="priceSequence")
        public ReturnLegValuationPriceBuilder setPriceSequence(PriceSequence _priceSequence) {
            this.priceSequence = _priceSequence == null ? null : _priceSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amountRelativeTo")
        @RuneAttribute(value="amountRelativeTo")
        public ReturnLegValuationPriceBuilder setAmountRelativeTo(AmountReference _amountRelativeTo) {
            this.amountRelativeTo = _amountRelativeTo == null ? null : _amountRelativeTo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityPriceModel")
        @RuneAttribute(value="equityPriceModel")
        public ReturnLegValuationPriceBuilder setEquityPriceModel(EquityPriceModel _equityPriceModel) {
            this.equityPriceModel = _equityPriceModel == null ? null : _equityPriceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cleanNetPrice")
        @RuneAttribute(value="cleanNetPrice")
        public ReturnLegValuationPriceBuilder setCleanNetPrice(BigDecimal _cleanNetPrice) {
            this.cleanNetPrice = _cleanNetPrice == null ? null : _cleanNetPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristics")
        @RuneAttribute(value="quotationCharacteristics")
        public ReturnLegValuationPriceBuilder setQuotationCharacteristics(QuotationCharacteristics _quotationCharacteristics) {
            this.quotationCharacteristics = _quotationCharacteristics == null ? null : _quotationCharacteristics.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationRules")
        @RuneAttribute(value="valuationRules")
        public ReturnLegValuationPriceBuilder setValuationRules(EquityValuation _valuationRules) {
            this.valuationRules = _valuationRules == null ? null : _valuationRules.toBuilder();
            return this;
        }

        @Override
        public ReturnLegValuationPrice build() {
            return new ReturnLegValuationPriceImpl(this);
        }

        @Override
        public ReturnLegValuationPriceBuilder toBuilder() {
            return this;
        }

        @Override
        public ReturnLegValuationPriceBuilder prune() {
            super.prune();
            if (this.valuationRules != null && !this.valuationRules.prune().hasData()) {
                this.valuationRules = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getValuationRules() != null && this.getValuationRules().hasData();
        }

        @Override
        public ReturnLegValuationPriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ReturnLegValuationPriceBuilder o = (ReturnLegValuationPriceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationRules(), (RosettaModelObjectBuilder)o.getValuationRules(), this::setValuationRules);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReturnLegValuationPrice _that = (ReturnLegValuationPrice)this.getType().cast(o);
            return Objects.equals(this.valuationRules, _that.getValuationRules());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.valuationRules != null ? this.valuationRules.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ReturnLegValuationPriceBuilder {valuationRules=" + this.valuationRules + '}' + " " + super.toString();
        }
    }

    public static interface ReturnLegValuationPriceBuilder
    extends ReturnLegValuationPrice,
    Price.PriceBuilder {
        public EquityValuation.EquityValuationBuilder getOrCreateValuationRules();

        @Override
        public EquityValuation.EquityValuationBuilder getValuationRules();

        @Override
        public ReturnLegValuationPriceBuilder setCommission(Commission var1);

        @Override
        public ReturnLegValuationPriceBuilder setPriceSequence(PriceSequence var1);

        @Override
        public ReturnLegValuationPriceBuilder setAmountRelativeTo(AmountReference var1);

        @Override
        public ReturnLegValuationPriceBuilder setEquityPriceModel(EquityPriceModel var1);

        @Override
        public ReturnLegValuationPriceBuilder setCleanNetPrice(BigDecimal var1);

        @Override
        public ReturnLegValuationPriceBuilder setQuotationCharacteristics(QuotationCharacteristics var1);

        public ReturnLegValuationPriceBuilder setValuationRules(EquityValuation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("commission"), processor, Commission.CommissionBuilder.class, (RosettaModelObjectBuilder)this.getCommission(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSequence"), processor, PriceSequence.PriceSequenceBuilder.class, (RosettaModelObjectBuilder)this.getPriceSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amountRelativeTo"), processor, AmountReference.AmountReferenceBuilder.class, (RosettaModelObjectBuilder)this.getAmountRelativeTo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityPriceModel"), processor, EquityPriceModel.EquityPriceModelBuilder.class, (RosettaModelObjectBuilder)this.getEquityPriceModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleanNetPrice"), BigDecimal.class, (Object)this.getCleanNetPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotationCharacteristics"), processor, QuotationCharacteristics.QuotationCharacteristicsBuilder.class, (RosettaModelObjectBuilder)this.getQuotationCharacteristics(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationRules"), processor, EquityValuation.EquityValuationBuilder.class, this.getValuationRules(), new AttributeMeta[0]);
        }

        @Override
        public ReturnLegValuationPriceBuilder prune();
    }

    public static class ReturnLegValuationPriceImpl
    extends Price.PriceImpl
    implements ReturnLegValuationPrice {
        private final EquityValuation valuationRules;

        protected ReturnLegValuationPriceImpl(ReturnLegValuationPriceBuilder builder) {
            super(builder);
            this.valuationRules = Optional.ofNullable(builder.getValuationRules()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="valuationRules")
        @RuneAttribute(value="valuationRules")
        public EquityValuation getValuationRules() {
            return this.valuationRules;
        }

        @Override
        public ReturnLegValuationPrice build() {
            return this;
        }

        @Override
        public ReturnLegValuationPriceBuilder toBuilder() {
            ReturnLegValuationPriceBuilder builder = ReturnLegValuationPrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReturnLegValuationPriceBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getValuationRules()).ifPresent(builder::setValuationRules);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReturnLegValuationPrice _that = (ReturnLegValuationPrice)this.getType().cast(o);
            return Objects.equals(this.valuationRules, _that.getValuationRules());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.valuationRules != null ? this.valuationRules.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ReturnLegValuationPrice {valuationRules=" + this.valuationRules + '}' + " " + super.toString();
        }
    }
}

