/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.TradeTimestamp;
import fpml.consolidated.doc.meta.TradeProcessingTimestampsMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeProcessingTimestamps", builder=TradeProcessingTimestampsBuilderImpl.class, version="1.1.0")
@RuneDataType(value="TradeProcessingTimestamps", model="fpml", builder=TradeProcessingTimestampsBuilderImpl.class, version="1.1.0")
public interface TradeProcessingTimestamps
extends RosettaModelObject {
    public static final TradeProcessingTimestampsMeta metaData = new TradeProcessingTimestampsMeta();

    public ZonedDateTime getOrderEntered();

    public ZonedDateTime getOrderSubmitted();

    public ZonedDateTime getPubliclyReported();

    public ZonedDateTime getPublicReportAccepted();

    public ZonedDateTime getPublicReportUpdated();

    public ZonedDateTime getNonpubliclyReported();

    public ZonedDateTime getNonpublicReportAccepted();

    public ZonedDateTime getNonpublicReportUpdated();

    public ZonedDateTime getSubmittedForConfirmation();

    public ZonedDateTime getUpdatedForConfirmation();

    public ZonedDateTime getConfirmed();

    public ZonedDateTime getSubmittedForClearing();

    public ZonedDateTime getUpdatedForClearing();

    public ZonedDateTime getCleared();

    public ZonedDateTime getAllocationsSubmitted();

    public ZonedDateTime getAllocationsUpdated();

    public ZonedDateTime getAllocationsCompleted();

    public List<? extends TradeTimestamp> getTimestamp();

    public TradeProcessingTimestamps build();

    public TradeProcessingTimestampsBuilder toBuilder();

    public static TradeProcessingTimestampsBuilder builder() {
        return new TradeProcessingTimestampsBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeProcessingTimestamps> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeProcessingTimestamps> getType() {
        return TradeProcessingTimestamps.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("orderEntered"), ZonedDateTime.class, (Object)this.getOrderEntered(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("orderSubmitted"), ZonedDateTime.class, (Object)this.getOrderSubmitted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("publiclyReported"), ZonedDateTime.class, (Object)this.getPubliclyReported(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("publicReportAccepted"), ZonedDateTime.class, (Object)this.getPublicReportAccepted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("publicReportUpdated"), ZonedDateTime.class, (Object)this.getPublicReportUpdated(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonpubliclyReported"), ZonedDateTime.class, (Object)this.getNonpubliclyReported(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonpublicReportAccepted"), ZonedDateTime.class, (Object)this.getNonpublicReportAccepted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonpublicReportUpdated"), ZonedDateTime.class, (Object)this.getNonpublicReportUpdated(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittedForConfirmation"), ZonedDateTime.class, (Object)this.getSubmittedForConfirmation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("updatedForConfirmation"), ZonedDateTime.class, (Object)this.getUpdatedForConfirmation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ZonedDateTime.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittedForClearing"), ZonedDateTime.class, (Object)this.getSubmittedForClearing(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("updatedForClearing"), ZonedDateTime.class, (Object)this.getUpdatedForClearing(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ZonedDateTime.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("allocationsSubmitted"), ZonedDateTime.class, (Object)this.getAllocationsSubmitted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("allocationsUpdated"), ZonedDateTime.class, (Object)this.getAllocationsUpdated(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("allocationsCompleted"), ZonedDateTime.class, (Object)this.getAllocationsCompleted(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("timestamp"), processor, TradeTimestamp.class, this.getTimestamp(), new AttributeMeta[0]);
    }

    public static class TradeProcessingTimestampsBuilderImpl
    implements TradeProcessingTimestampsBuilder {
        protected ZonedDateTime orderEntered;
        protected ZonedDateTime orderSubmitted;
        protected ZonedDateTime publiclyReported;
        protected ZonedDateTime publicReportAccepted;
        protected ZonedDateTime publicReportUpdated;
        protected ZonedDateTime nonpubliclyReported;
        protected ZonedDateTime nonpublicReportAccepted;
        protected ZonedDateTime nonpublicReportUpdated;
        protected ZonedDateTime submittedForConfirmation;
        protected ZonedDateTime updatedForConfirmation;
        protected ZonedDateTime confirmed;
        protected ZonedDateTime submittedForClearing;
        protected ZonedDateTime updatedForClearing;
        protected ZonedDateTime cleared;
        protected ZonedDateTime allocationsSubmitted;
        protected ZonedDateTime allocationsUpdated;
        protected ZonedDateTime allocationsCompleted;
        protected List<TradeTimestamp.TradeTimestampBuilder> timestamp = new ArrayList<TradeTimestamp.TradeTimestampBuilder>();

        @Override
        @RosettaAttribute(value="orderEntered")
        @RuneAttribute(value="orderEntered")
        public ZonedDateTime getOrderEntered() {
            return this.orderEntered;
        }

        @Override
        @RosettaAttribute(value="orderSubmitted")
        @RuneAttribute(value="orderSubmitted")
        public ZonedDateTime getOrderSubmitted() {
            return this.orderSubmitted;
        }

        @Override
        @RosettaAttribute(value="publiclyReported")
        @RuneAttribute(value="publiclyReported")
        public ZonedDateTime getPubliclyReported() {
            return this.publiclyReported;
        }

        @Override
        @RosettaAttribute(value="publicReportAccepted")
        @RuneAttribute(value="publicReportAccepted")
        public ZonedDateTime getPublicReportAccepted() {
            return this.publicReportAccepted;
        }

        @Override
        @RosettaAttribute(value="publicReportUpdated")
        @RuneAttribute(value="publicReportUpdated")
        public ZonedDateTime getPublicReportUpdated() {
            return this.publicReportUpdated;
        }

        @Override
        @RosettaAttribute(value="nonpubliclyReported")
        @RuneAttribute(value="nonpubliclyReported")
        public ZonedDateTime getNonpubliclyReported() {
            return this.nonpubliclyReported;
        }

        @Override
        @RosettaAttribute(value="nonpublicReportAccepted")
        @RuneAttribute(value="nonpublicReportAccepted")
        public ZonedDateTime getNonpublicReportAccepted() {
            return this.nonpublicReportAccepted;
        }

        @Override
        @RosettaAttribute(value="nonpublicReportUpdated")
        @RuneAttribute(value="nonpublicReportUpdated")
        public ZonedDateTime getNonpublicReportUpdated() {
            return this.nonpublicReportUpdated;
        }

        @Override
        @RosettaAttribute(value="submittedForConfirmation")
        @RuneAttribute(value="submittedForConfirmation")
        public ZonedDateTime getSubmittedForConfirmation() {
            return this.submittedForConfirmation;
        }

        @Override
        @RosettaAttribute(value="updatedForConfirmation")
        @RuneAttribute(value="updatedForConfirmation")
        public ZonedDateTime getUpdatedForConfirmation() {
            return this.updatedForConfirmation;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public ZonedDateTime getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="submittedForClearing")
        @RuneAttribute(value="submittedForClearing")
        public ZonedDateTime getSubmittedForClearing() {
            return this.submittedForClearing;
        }

        @Override
        @RosettaAttribute(value="updatedForClearing")
        @RuneAttribute(value="updatedForClearing")
        public ZonedDateTime getUpdatedForClearing() {
            return this.updatedForClearing;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public ZonedDateTime getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="allocationsSubmitted")
        @RuneAttribute(value="allocationsSubmitted")
        public ZonedDateTime getAllocationsSubmitted() {
            return this.allocationsSubmitted;
        }

        @Override
        @RosettaAttribute(value="allocationsUpdated")
        @RuneAttribute(value="allocationsUpdated")
        public ZonedDateTime getAllocationsUpdated() {
            return this.allocationsUpdated;
        }

        @Override
        @RosettaAttribute(value="allocationsCompleted")
        @RuneAttribute(value="allocationsCompleted")
        public ZonedDateTime getAllocationsCompleted() {
            return this.allocationsCompleted;
        }

        @Override
        @RosettaAttribute(value="timestamp")
        @RuneAttribute(value="timestamp")
        public List<? extends TradeTimestamp.TradeTimestampBuilder> getTimestamp() {
            return this.timestamp;
        }

        @Override
        public TradeTimestamp.TradeTimestampBuilder getOrCreateTimestamp(int index) {
            if (this.timestamp == null) {
                this.timestamp = new ArrayList<TradeTimestamp.TradeTimestampBuilder>();
            }
            return (TradeTimestamp.TradeTimestampBuilder)this.getIndex(this.timestamp, index, () -> {
                TradeTimestamp.TradeTimestampBuilder newTimestamp = TradeTimestamp.builder();
                return newTimestamp;
            });
        }

        @Override
        @RosettaAttribute(value="orderEntered")
        @RuneAttribute(value="orderEntered")
        public TradeProcessingTimestampsBuilder setOrderEntered(ZonedDateTime _orderEntered) {
            this.orderEntered = _orderEntered == null ? null : _orderEntered;
            return this;
        }

        @Override
        @RosettaAttribute(value="orderSubmitted")
        @RuneAttribute(value="orderSubmitted")
        public TradeProcessingTimestampsBuilder setOrderSubmitted(ZonedDateTime _orderSubmitted) {
            this.orderSubmitted = _orderSubmitted == null ? null : _orderSubmitted;
            return this;
        }

        @Override
        @RosettaAttribute(value="publiclyReported")
        @RuneAttribute(value="publiclyReported")
        public TradeProcessingTimestampsBuilder setPubliclyReported(ZonedDateTime _publiclyReported) {
            this.publiclyReported = _publiclyReported == null ? null : _publiclyReported;
            return this;
        }

        @Override
        @RosettaAttribute(value="publicReportAccepted")
        @RuneAttribute(value="publicReportAccepted")
        public TradeProcessingTimestampsBuilder setPublicReportAccepted(ZonedDateTime _publicReportAccepted) {
            this.publicReportAccepted = _publicReportAccepted == null ? null : _publicReportAccepted;
            return this;
        }

        @Override
        @RosettaAttribute(value="publicReportUpdated")
        @RuneAttribute(value="publicReportUpdated")
        public TradeProcessingTimestampsBuilder setPublicReportUpdated(ZonedDateTime _publicReportUpdated) {
            this.publicReportUpdated = _publicReportUpdated == null ? null : _publicReportUpdated;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonpubliclyReported")
        @RuneAttribute(value="nonpubliclyReported")
        public TradeProcessingTimestampsBuilder setNonpubliclyReported(ZonedDateTime _nonpubliclyReported) {
            this.nonpubliclyReported = _nonpubliclyReported == null ? null : _nonpubliclyReported;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonpublicReportAccepted")
        @RuneAttribute(value="nonpublicReportAccepted")
        public TradeProcessingTimestampsBuilder setNonpublicReportAccepted(ZonedDateTime _nonpublicReportAccepted) {
            this.nonpublicReportAccepted = _nonpublicReportAccepted == null ? null : _nonpublicReportAccepted;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonpublicReportUpdated")
        @RuneAttribute(value="nonpublicReportUpdated")
        public TradeProcessingTimestampsBuilder setNonpublicReportUpdated(ZonedDateTime _nonpublicReportUpdated) {
            this.nonpublicReportUpdated = _nonpublicReportUpdated == null ? null : _nonpublicReportUpdated;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittedForConfirmation")
        @RuneAttribute(value="submittedForConfirmation")
        public TradeProcessingTimestampsBuilder setSubmittedForConfirmation(ZonedDateTime _submittedForConfirmation) {
            this.submittedForConfirmation = _submittedForConfirmation == null ? null : _submittedForConfirmation;
            return this;
        }

        @Override
        @RosettaAttribute(value="updatedForConfirmation")
        @RuneAttribute(value="updatedForConfirmation")
        public TradeProcessingTimestampsBuilder setUpdatedForConfirmation(ZonedDateTime _updatedForConfirmation) {
            this.updatedForConfirmation = _updatedForConfirmation == null ? null : _updatedForConfirmation;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public TradeProcessingTimestampsBuilder setConfirmed(ZonedDateTime _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittedForClearing")
        @RuneAttribute(value="submittedForClearing")
        public TradeProcessingTimestampsBuilder setSubmittedForClearing(ZonedDateTime _submittedForClearing) {
            this.submittedForClearing = _submittedForClearing == null ? null : _submittedForClearing;
            return this;
        }

        @Override
        @RosettaAttribute(value="updatedForClearing")
        @RuneAttribute(value="updatedForClearing")
        public TradeProcessingTimestampsBuilder setUpdatedForClearing(ZonedDateTime _updatedForClearing) {
            this.updatedForClearing = _updatedForClearing == null ? null : _updatedForClearing;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public TradeProcessingTimestampsBuilder setCleared(ZonedDateTime _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationsSubmitted")
        @RuneAttribute(value="allocationsSubmitted")
        public TradeProcessingTimestampsBuilder setAllocationsSubmitted(ZonedDateTime _allocationsSubmitted) {
            this.allocationsSubmitted = _allocationsSubmitted == null ? null : _allocationsSubmitted;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationsUpdated")
        @RuneAttribute(value="allocationsUpdated")
        public TradeProcessingTimestampsBuilder setAllocationsUpdated(ZonedDateTime _allocationsUpdated) {
            this.allocationsUpdated = _allocationsUpdated == null ? null : _allocationsUpdated;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationsCompleted")
        @RuneAttribute(value="allocationsCompleted")
        public TradeProcessingTimestampsBuilder setAllocationsCompleted(ZonedDateTime _allocationsCompleted) {
            this.allocationsCompleted = _allocationsCompleted == null ? null : _allocationsCompleted;
            return this;
        }

        @Override
        @RosettaAttribute(value="timestamp")
        @RuneAttribute(value="timestamp")
        public TradeProcessingTimestampsBuilder addTimestamp(TradeTimestamp _timestamp) {
            if (_timestamp != null) {
                this.timestamp.add(_timestamp.toBuilder());
            }
            return this;
        }

        @Override
        public TradeProcessingTimestampsBuilder addTimestamp(TradeTimestamp _timestamp, int idx) {
            this.getIndex(this.timestamp, idx, () -> _timestamp.toBuilder());
            return this;
        }

        @Override
        public TradeProcessingTimestampsBuilder addTimestamp(List<? extends TradeTimestamp> timestamps) {
            if (timestamps != null) {
                for (TradeTimestamp tradeTimestamp : timestamps) {
                    this.timestamp.add(tradeTimestamp.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="timestamp")
        public TradeProcessingTimestampsBuilder setTimestamp(List<? extends TradeTimestamp> timestamps) {
            this.timestamp = timestamps == null ? new ArrayList<TradeTimestamp.TradeTimestampBuilder>() : (List)timestamps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeProcessingTimestamps build() {
            return new TradeProcessingTimestampsImpl(this);
        }

        @Override
        public TradeProcessingTimestampsBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeProcessingTimestampsBuilder prune() {
            this.timestamp = this.timestamp.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getOrderEntered() != null) {
                return true;
            }
            if (this.getOrderSubmitted() != null) {
                return true;
            }
            if (this.getPubliclyReported() != null) {
                return true;
            }
            if (this.getPublicReportAccepted() != null) {
                return true;
            }
            if (this.getPublicReportUpdated() != null) {
                return true;
            }
            if (this.getNonpubliclyReported() != null) {
                return true;
            }
            if (this.getNonpublicReportAccepted() != null) {
                return true;
            }
            if (this.getNonpublicReportUpdated() != null) {
                return true;
            }
            if (this.getSubmittedForConfirmation() != null) {
                return true;
            }
            if (this.getUpdatedForConfirmation() != null) {
                return true;
            }
            if (this.getConfirmed() != null) {
                return true;
            }
            if (this.getSubmittedForClearing() != null) {
                return true;
            }
            if (this.getUpdatedForClearing() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getAllocationsSubmitted() != null) {
                return true;
            }
            if (this.getAllocationsUpdated() != null) {
                return true;
            }
            if (this.getAllocationsCompleted() != null) {
                return true;
            }
            return this.getTimestamp() != null && this.getTimestamp().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TradeProcessingTimestampsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeProcessingTimestampsBuilder o = (TradeProcessingTimestampsBuilder)other;
            merger.mergeRosetta(this.getTimestamp(), o.getTimestamp(), this::getOrCreateTimestamp);
            merger.mergeBasic((Object)this.getOrderEntered(), (Object)o.getOrderEntered(), this::setOrderEntered, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOrderSubmitted(), (Object)o.getOrderSubmitted(), this::setOrderSubmitted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPubliclyReported(), (Object)o.getPubliclyReported(), this::setPubliclyReported, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPublicReportAccepted(), (Object)o.getPublicReportAccepted(), this::setPublicReportAccepted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPublicReportUpdated(), (Object)o.getPublicReportUpdated(), this::setPublicReportUpdated, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonpubliclyReported(), (Object)o.getNonpubliclyReported(), this::setNonpubliclyReported, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonpublicReportAccepted(), (Object)o.getNonpublicReportAccepted(), this::setNonpublicReportAccepted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonpublicReportUpdated(), (Object)o.getNonpublicReportUpdated(), this::setNonpublicReportUpdated, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittedForConfirmation(), (Object)o.getSubmittedForConfirmation(), this::setSubmittedForConfirmation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUpdatedForConfirmation(), (Object)o.getUpdatedForConfirmation(), this::setUpdatedForConfirmation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmed(), (Object)o.getConfirmed(), this::setConfirmed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittedForClearing(), (Object)o.getSubmittedForClearing(), this::setSubmittedForClearing, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUpdatedForClearing(), (Object)o.getUpdatedForClearing(), this::setUpdatedForClearing, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setCleared, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAllocationsSubmitted(), (Object)o.getAllocationsSubmitted(), this::setAllocationsSubmitted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAllocationsUpdated(), (Object)o.getAllocationsUpdated(), this::setAllocationsUpdated, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAllocationsCompleted(), (Object)o.getAllocationsCompleted(), this::setAllocationsCompleted, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeProcessingTimestamps _that = this.getType().cast(o);
            if (!Objects.equals(this.orderEntered, _that.getOrderEntered())) {
                return false;
            }
            if (!Objects.equals(this.orderSubmitted, _that.getOrderSubmitted())) {
                return false;
            }
            if (!Objects.equals(this.publiclyReported, _that.getPubliclyReported())) {
                return false;
            }
            if (!Objects.equals(this.publicReportAccepted, _that.getPublicReportAccepted())) {
                return false;
            }
            if (!Objects.equals(this.publicReportUpdated, _that.getPublicReportUpdated())) {
                return false;
            }
            if (!Objects.equals(this.nonpubliclyReported, _that.getNonpubliclyReported())) {
                return false;
            }
            if (!Objects.equals(this.nonpublicReportAccepted, _that.getNonpublicReportAccepted())) {
                return false;
            }
            if (!Objects.equals(this.nonpublicReportUpdated, _that.getNonpublicReportUpdated())) {
                return false;
            }
            if (!Objects.equals(this.submittedForConfirmation, _that.getSubmittedForConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.updatedForConfirmation, _that.getUpdatedForConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.confirmed, _that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.submittedForClearing, _that.getSubmittedForClearing())) {
                return false;
            }
            if (!Objects.equals(this.updatedForClearing, _that.getUpdatedForClearing())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.allocationsSubmitted, _that.getAllocationsSubmitted())) {
                return false;
            }
            if (!Objects.equals(this.allocationsUpdated, _that.getAllocationsUpdated())) {
                return false;
            }
            if (!Objects.equals(this.allocationsCompleted, _that.getAllocationsCompleted())) {
                return false;
            }
            return ListEquals.listEquals(this.timestamp, _that.getTimestamp());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.orderEntered != null ? this.orderEntered.hashCode() : 0);
            _result = 31 * _result + (this.orderSubmitted != null ? this.orderSubmitted.hashCode() : 0);
            _result = 31 * _result + (this.publiclyReported != null ? this.publiclyReported.hashCode() : 0);
            _result = 31 * _result + (this.publicReportAccepted != null ? this.publicReportAccepted.hashCode() : 0);
            _result = 31 * _result + (this.publicReportUpdated != null ? this.publicReportUpdated.hashCode() : 0);
            _result = 31 * _result + (this.nonpubliclyReported != null ? this.nonpubliclyReported.hashCode() : 0);
            _result = 31 * _result + (this.nonpublicReportAccepted != null ? this.nonpublicReportAccepted.hashCode() : 0);
            _result = 31 * _result + (this.nonpublicReportUpdated != null ? this.nonpublicReportUpdated.hashCode() : 0);
            _result = 31 * _result + (this.submittedForConfirmation != null ? this.submittedForConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.updatedForConfirmation != null ? this.updatedForConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? this.confirmed.hashCode() : 0);
            _result = 31 * _result + (this.submittedForClearing != null ? this.submittedForClearing.hashCode() : 0);
            _result = 31 * _result + (this.updatedForClearing != null ? this.updatedForClearing.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.allocationsSubmitted != null ? this.allocationsSubmitted.hashCode() : 0);
            _result = 31 * _result + (this.allocationsUpdated != null ? this.allocationsUpdated.hashCode() : 0);
            _result = 31 * _result + (this.allocationsCompleted != null ? this.allocationsCompleted.hashCode() : 0);
            _result = 31 * _result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeProcessingTimestampsBuilder {orderEntered=" + this.orderEntered + ", orderSubmitted=" + this.orderSubmitted + ", publiclyReported=" + this.publiclyReported + ", publicReportAccepted=" + this.publicReportAccepted + ", publicReportUpdated=" + this.publicReportUpdated + ", nonpubliclyReported=" + this.nonpubliclyReported + ", nonpublicReportAccepted=" + this.nonpublicReportAccepted + ", nonpublicReportUpdated=" + this.nonpublicReportUpdated + ", submittedForConfirmation=" + this.submittedForConfirmation + ", updatedForConfirmation=" + this.updatedForConfirmation + ", confirmed=" + this.confirmed + ", submittedForClearing=" + this.submittedForClearing + ", updatedForClearing=" + this.updatedForClearing + ", cleared=" + this.cleared + ", allocationsSubmitted=" + this.allocationsSubmitted + ", allocationsUpdated=" + this.allocationsUpdated + ", allocationsCompleted=" + this.allocationsCompleted + ", timestamp=" + this.timestamp + '}';
        }
    }

    public static interface TradeProcessingTimestampsBuilder
    extends TradeProcessingTimestamps,
    RosettaModelObjectBuilder {
        public TradeTimestamp.TradeTimestampBuilder getOrCreateTimestamp(int var1);

        public List<? extends TradeTimestamp.TradeTimestampBuilder> getTimestamp();

        public TradeProcessingTimestampsBuilder setOrderEntered(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setOrderSubmitted(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setPubliclyReported(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setPublicReportAccepted(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setPublicReportUpdated(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setNonpubliclyReported(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setNonpublicReportAccepted(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setNonpublicReportUpdated(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setSubmittedForConfirmation(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setUpdatedForConfirmation(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setConfirmed(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setSubmittedForClearing(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setUpdatedForClearing(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setCleared(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setAllocationsSubmitted(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setAllocationsUpdated(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder setAllocationsCompleted(ZonedDateTime var1);

        public TradeProcessingTimestampsBuilder addTimestamp(TradeTimestamp var1);

        public TradeProcessingTimestampsBuilder addTimestamp(TradeTimestamp var1, int var2);

        public TradeProcessingTimestampsBuilder addTimestamp(List<? extends TradeTimestamp> var1);

        public TradeProcessingTimestampsBuilder setTimestamp(List<? extends TradeTimestamp> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("orderEntered"), ZonedDateTime.class, (Object)this.getOrderEntered(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("orderSubmitted"), ZonedDateTime.class, (Object)this.getOrderSubmitted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("publiclyReported"), ZonedDateTime.class, (Object)this.getPubliclyReported(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("publicReportAccepted"), ZonedDateTime.class, (Object)this.getPublicReportAccepted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("publicReportUpdated"), ZonedDateTime.class, (Object)this.getPublicReportUpdated(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonpubliclyReported"), ZonedDateTime.class, (Object)this.getNonpubliclyReported(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonpublicReportAccepted"), ZonedDateTime.class, (Object)this.getNonpublicReportAccepted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonpublicReportUpdated"), ZonedDateTime.class, (Object)this.getNonpublicReportUpdated(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittedForConfirmation"), ZonedDateTime.class, (Object)this.getSubmittedForConfirmation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("updatedForConfirmation"), ZonedDateTime.class, (Object)this.getUpdatedForConfirmation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ZonedDateTime.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittedForClearing"), ZonedDateTime.class, (Object)this.getSubmittedForClearing(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("updatedForClearing"), ZonedDateTime.class, (Object)this.getUpdatedForClearing(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ZonedDateTime.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("allocationsSubmitted"), ZonedDateTime.class, (Object)this.getAllocationsSubmitted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("allocationsUpdated"), ZonedDateTime.class, (Object)this.getAllocationsUpdated(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("allocationsCompleted"), ZonedDateTime.class, (Object)this.getAllocationsCompleted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("timestamp"), processor, TradeTimestamp.TradeTimestampBuilder.class, this.getTimestamp(), new AttributeMeta[0]);
        }

        public TradeProcessingTimestampsBuilder prune();
    }

    public static class TradeProcessingTimestampsImpl
    implements TradeProcessingTimestamps {
        private final ZonedDateTime orderEntered;
        private final ZonedDateTime orderSubmitted;
        private final ZonedDateTime publiclyReported;
        private final ZonedDateTime publicReportAccepted;
        private final ZonedDateTime publicReportUpdated;
        private final ZonedDateTime nonpubliclyReported;
        private final ZonedDateTime nonpublicReportAccepted;
        private final ZonedDateTime nonpublicReportUpdated;
        private final ZonedDateTime submittedForConfirmation;
        private final ZonedDateTime updatedForConfirmation;
        private final ZonedDateTime confirmed;
        private final ZonedDateTime submittedForClearing;
        private final ZonedDateTime updatedForClearing;
        private final ZonedDateTime cleared;
        private final ZonedDateTime allocationsSubmitted;
        private final ZonedDateTime allocationsUpdated;
        private final ZonedDateTime allocationsCompleted;
        private final List<? extends TradeTimestamp> timestamp;

        protected TradeProcessingTimestampsImpl(TradeProcessingTimestampsBuilder builder) {
            this.orderEntered = builder.getOrderEntered();
            this.orderSubmitted = builder.getOrderSubmitted();
            this.publiclyReported = builder.getPubliclyReported();
            this.publicReportAccepted = builder.getPublicReportAccepted();
            this.publicReportUpdated = builder.getPublicReportUpdated();
            this.nonpubliclyReported = builder.getNonpubliclyReported();
            this.nonpublicReportAccepted = builder.getNonpublicReportAccepted();
            this.nonpublicReportUpdated = builder.getNonpublicReportUpdated();
            this.submittedForConfirmation = builder.getSubmittedForConfirmation();
            this.updatedForConfirmation = builder.getUpdatedForConfirmation();
            this.confirmed = builder.getConfirmed();
            this.submittedForClearing = builder.getSubmittedForClearing();
            this.updatedForClearing = builder.getUpdatedForClearing();
            this.cleared = builder.getCleared();
            this.allocationsSubmitted = builder.getAllocationsSubmitted();
            this.allocationsUpdated = builder.getAllocationsUpdated();
            this.allocationsCompleted = builder.getAllocationsCompleted();
            this.timestamp = Optional.ofNullable(builder.getTimestamp()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="orderEntered")
        @RuneAttribute(value="orderEntered")
        public ZonedDateTime getOrderEntered() {
            return this.orderEntered;
        }

        @Override
        @RosettaAttribute(value="orderSubmitted")
        @RuneAttribute(value="orderSubmitted")
        public ZonedDateTime getOrderSubmitted() {
            return this.orderSubmitted;
        }

        @Override
        @RosettaAttribute(value="publiclyReported")
        @RuneAttribute(value="publiclyReported")
        public ZonedDateTime getPubliclyReported() {
            return this.publiclyReported;
        }

        @Override
        @RosettaAttribute(value="publicReportAccepted")
        @RuneAttribute(value="publicReportAccepted")
        public ZonedDateTime getPublicReportAccepted() {
            return this.publicReportAccepted;
        }

        @Override
        @RosettaAttribute(value="publicReportUpdated")
        @RuneAttribute(value="publicReportUpdated")
        public ZonedDateTime getPublicReportUpdated() {
            return this.publicReportUpdated;
        }

        @Override
        @RosettaAttribute(value="nonpubliclyReported")
        @RuneAttribute(value="nonpubliclyReported")
        public ZonedDateTime getNonpubliclyReported() {
            return this.nonpubliclyReported;
        }

        @Override
        @RosettaAttribute(value="nonpublicReportAccepted")
        @RuneAttribute(value="nonpublicReportAccepted")
        public ZonedDateTime getNonpublicReportAccepted() {
            return this.nonpublicReportAccepted;
        }

        @Override
        @RosettaAttribute(value="nonpublicReportUpdated")
        @RuneAttribute(value="nonpublicReportUpdated")
        public ZonedDateTime getNonpublicReportUpdated() {
            return this.nonpublicReportUpdated;
        }

        @Override
        @RosettaAttribute(value="submittedForConfirmation")
        @RuneAttribute(value="submittedForConfirmation")
        public ZonedDateTime getSubmittedForConfirmation() {
            return this.submittedForConfirmation;
        }

        @Override
        @RosettaAttribute(value="updatedForConfirmation")
        @RuneAttribute(value="updatedForConfirmation")
        public ZonedDateTime getUpdatedForConfirmation() {
            return this.updatedForConfirmation;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public ZonedDateTime getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="submittedForClearing")
        @RuneAttribute(value="submittedForClearing")
        public ZonedDateTime getSubmittedForClearing() {
            return this.submittedForClearing;
        }

        @Override
        @RosettaAttribute(value="updatedForClearing")
        @RuneAttribute(value="updatedForClearing")
        public ZonedDateTime getUpdatedForClearing() {
            return this.updatedForClearing;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public ZonedDateTime getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="allocationsSubmitted")
        @RuneAttribute(value="allocationsSubmitted")
        public ZonedDateTime getAllocationsSubmitted() {
            return this.allocationsSubmitted;
        }

        @Override
        @RosettaAttribute(value="allocationsUpdated")
        @RuneAttribute(value="allocationsUpdated")
        public ZonedDateTime getAllocationsUpdated() {
            return this.allocationsUpdated;
        }

        @Override
        @RosettaAttribute(value="allocationsCompleted")
        @RuneAttribute(value="allocationsCompleted")
        public ZonedDateTime getAllocationsCompleted() {
            return this.allocationsCompleted;
        }

        @Override
        @RosettaAttribute(value="timestamp")
        @RuneAttribute(value="timestamp")
        public List<? extends TradeTimestamp> getTimestamp() {
            return this.timestamp;
        }

        @Override
        public TradeProcessingTimestamps build() {
            return this;
        }

        @Override
        public TradeProcessingTimestampsBuilder toBuilder() {
            TradeProcessingTimestampsBuilder builder = TradeProcessingTimestamps.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeProcessingTimestampsBuilder builder) {
            Optional.ofNullable(this.getOrderEntered()).ifPresent(builder::setOrderEntered);
            Optional.ofNullable(this.getOrderSubmitted()).ifPresent(builder::setOrderSubmitted);
            Optional.ofNullable(this.getPubliclyReported()).ifPresent(builder::setPubliclyReported);
            Optional.ofNullable(this.getPublicReportAccepted()).ifPresent(builder::setPublicReportAccepted);
            Optional.ofNullable(this.getPublicReportUpdated()).ifPresent(builder::setPublicReportUpdated);
            Optional.ofNullable(this.getNonpubliclyReported()).ifPresent(builder::setNonpubliclyReported);
            Optional.ofNullable(this.getNonpublicReportAccepted()).ifPresent(builder::setNonpublicReportAccepted);
            Optional.ofNullable(this.getNonpublicReportUpdated()).ifPresent(builder::setNonpublicReportUpdated);
            Optional.ofNullable(this.getSubmittedForConfirmation()).ifPresent(builder::setSubmittedForConfirmation);
            Optional.ofNullable(this.getUpdatedForConfirmation()).ifPresent(builder::setUpdatedForConfirmation);
            Optional.ofNullable(this.getConfirmed()).ifPresent(builder::setConfirmed);
            Optional.ofNullable(this.getSubmittedForClearing()).ifPresent(builder::setSubmittedForClearing);
            Optional.ofNullable(this.getUpdatedForClearing()).ifPresent(builder::setUpdatedForClearing);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setCleared);
            Optional.ofNullable(this.getAllocationsSubmitted()).ifPresent(builder::setAllocationsSubmitted);
            Optional.ofNullable(this.getAllocationsUpdated()).ifPresent(builder::setAllocationsUpdated);
            Optional.ofNullable(this.getAllocationsCompleted()).ifPresent(builder::setAllocationsCompleted);
            Optional.ofNullable(this.getTimestamp()).ifPresent(builder::setTimestamp);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeProcessingTimestamps _that = this.getType().cast(o);
            if (!Objects.equals(this.orderEntered, _that.getOrderEntered())) {
                return false;
            }
            if (!Objects.equals(this.orderSubmitted, _that.getOrderSubmitted())) {
                return false;
            }
            if (!Objects.equals(this.publiclyReported, _that.getPubliclyReported())) {
                return false;
            }
            if (!Objects.equals(this.publicReportAccepted, _that.getPublicReportAccepted())) {
                return false;
            }
            if (!Objects.equals(this.publicReportUpdated, _that.getPublicReportUpdated())) {
                return false;
            }
            if (!Objects.equals(this.nonpubliclyReported, _that.getNonpubliclyReported())) {
                return false;
            }
            if (!Objects.equals(this.nonpublicReportAccepted, _that.getNonpublicReportAccepted())) {
                return false;
            }
            if (!Objects.equals(this.nonpublicReportUpdated, _that.getNonpublicReportUpdated())) {
                return false;
            }
            if (!Objects.equals(this.submittedForConfirmation, _that.getSubmittedForConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.updatedForConfirmation, _that.getUpdatedForConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.confirmed, _that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.submittedForClearing, _that.getSubmittedForClearing())) {
                return false;
            }
            if (!Objects.equals(this.updatedForClearing, _that.getUpdatedForClearing())) {
                return false;
            }
            if (!Objects.equals(this.cleared, _that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.allocationsSubmitted, _that.getAllocationsSubmitted())) {
                return false;
            }
            if (!Objects.equals(this.allocationsUpdated, _that.getAllocationsUpdated())) {
                return false;
            }
            if (!Objects.equals(this.allocationsCompleted, _that.getAllocationsCompleted())) {
                return false;
            }
            return ListEquals.listEquals(this.timestamp, _that.getTimestamp());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.orderEntered != null ? this.orderEntered.hashCode() : 0);
            _result = 31 * _result + (this.orderSubmitted != null ? this.orderSubmitted.hashCode() : 0);
            _result = 31 * _result + (this.publiclyReported != null ? this.publiclyReported.hashCode() : 0);
            _result = 31 * _result + (this.publicReportAccepted != null ? this.publicReportAccepted.hashCode() : 0);
            _result = 31 * _result + (this.publicReportUpdated != null ? this.publicReportUpdated.hashCode() : 0);
            _result = 31 * _result + (this.nonpubliclyReported != null ? this.nonpubliclyReported.hashCode() : 0);
            _result = 31 * _result + (this.nonpublicReportAccepted != null ? this.nonpublicReportAccepted.hashCode() : 0);
            _result = 31 * _result + (this.nonpublicReportUpdated != null ? this.nonpublicReportUpdated.hashCode() : 0);
            _result = 31 * _result + (this.submittedForConfirmation != null ? this.submittedForConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.updatedForConfirmation != null ? this.updatedForConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? this.confirmed.hashCode() : 0);
            _result = 31 * _result + (this.submittedForClearing != null ? this.submittedForClearing.hashCode() : 0);
            _result = 31 * _result + (this.updatedForClearing != null ? this.updatedForClearing.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? this.cleared.hashCode() : 0);
            _result = 31 * _result + (this.allocationsSubmitted != null ? this.allocationsSubmitted.hashCode() : 0);
            _result = 31 * _result + (this.allocationsUpdated != null ? this.allocationsUpdated.hashCode() : 0);
            _result = 31 * _result + (this.allocationsCompleted != null ? this.allocationsCompleted.hashCode() : 0);
            _result = 31 * _result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeProcessingTimestamps {orderEntered=" + this.orderEntered + ", orderSubmitted=" + this.orderSubmitted + ", publiclyReported=" + this.publiclyReported + ", publicReportAccepted=" + this.publicReportAccepted + ", publicReportUpdated=" + this.publicReportUpdated + ", nonpubliclyReported=" + this.nonpubliclyReported + ", nonpublicReportAccepted=" + this.nonpublicReportAccepted + ", nonpublicReportUpdated=" + this.nonpublicReportUpdated + ", submittedForConfirmation=" + this.submittedForConfirmation + ", updatedForConfirmation=" + this.updatedForConfirmation + ", confirmed=" + this.confirmed + ", submittedForClearing=" + this.submittedForClearing + ", updatedForClearing=" + this.updatedForClearing + ", cleared=" + this.cleared + ", allocationsSubmitted=" + this.allocationsSubmitted + ", allocationsUpdated=" + this.allocationsUpdated + ", allocationsCompleted=" + this.allocationsCompleted + ", timestamp=" + this.timestamp + '}';
        }
    }
}

