/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.StrategyComponentIdentification;
import fpml.consolidated.doc.meta.StrategyMeta;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.shared.ProductReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Strategy", builder=StrategyBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Strategy", model="fpml", builder=StrategyBuilderImpl.class, version="1.1.0")
public interface Strategy
extends Product {
    public static final StrategyMeta metaData = new StrategyMeta();

    public List<? extends StrategyComponentIdentification> getStrategyComponentIdentifier();

    public ProductReference getPremiumProductReference();

    public List<? extends Product> getProduct();

    @Override
    public Strategy build();

    @Override
    public StrategyBuilder toBuilder();

    public static StrategyBuilder builder() {
        return new StrategyBuilderImpl();
    }

    default public RosettaMetaData<? extends Strategy> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Strategy> getType() {
        return Strategy.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strategyComponentIdentifier"), processor, StrategyComponentIdentification.class, this.getStrategyComponentIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premiumProductReference"), processor, ProductReference.class, this.getPremiumProductReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
    }

    public static class StrategyBuilderImpl
    extends Product.ProductBuilderImpl
    implements StrategyBuilder {
        protected List<StrategyComponentIdentification.StrategyComponentIdentificationBuilder> strategyComponentIdentifier = new ArrayList<StrategyComponentIdentification.StrategyComponentIdentificationBuilder>();
        protected ProductReference.ProductReferenceBuilder premiumProductReference;
        protected List<Product.ProductBuilder> product = new ArrayList<Product.ProductBuilder>();

        @Override
        @RosettaAttribute(value="strategyComponentIdentifier")
        @RuneAttribute(value="strategyComponentIdentifier")
        public List<? extends StrategyComponentIdentification.StrategyComponentIdentificationBuilder> getStrategyComponentIdentifier() {
            return this.strategyComponentIdentifier;
        }

        @Override
        public StrategyComponentIdentification.StrategyComponentIdentificationBuilder getOrCreateStrategyComponentIdentifier(int index) {
            if (this.strategyComponentIdentifier == null) {
                this.strategyComponentIdentifier = new ArrayList<StrategyComponentIdentification.StrategyComponentIdentificationBuilder>();
            }
            return (StrategyComponentIdentification.StrategyComponentIdentificationBuilder)this.getIndex(this.strategyComponentIdentifier, index, () -> {
                StrategyComponentIdentification.StrategyComponentIdentificationBuilder newStrategyComponentIdentifier = StrategyComponentIdentification.builder();
                return newStrategyComponentIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="premiumProductReference")
        @RuneAttribute(value="premiumProductReference")
        public ProductReference.ProductReferenceBuilder getPremiumProductReference() {
            return this.premiumProductReference;
        }

        @Override
        public ProductReference.ProductReferenceBuilder getOrCreatePremiumProductReference() {
            ProductReference.ProductReferenceBuilder result = this.premiumProductReference != null ? this.premiumProductReference : (this.premiumProductReference = ProductReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public List<? extends Product.ProductBuilder> getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct(int index) {
            if (this.product == null) {
                this.product = new ArrayList<Product.ProductBuilder>();
            }
            return (Product.ProductBuilder)this.getIndex(this.product, index, () -> {
                Product.ProductBuilder newProduct = Product.builder();
                return newProduct;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public StrategyBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public StrategyBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="strategyComponentIdentifier")
        @RuneAttribute(value="strategyComponentIdentifier")
        public StrategyBuilder addStrategyComponentIdentifier(StrategyComponentIdentification _strategyComponentIdentifier) {
            if (_strategyComponentIdentifier != null) {
                this.strategyComponentIdentifier.add(_strategyComponentIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public StrategyBuilder addStrategyComponentIdentifier(StrategyComponentIdentification _strategyComponentIdentifier, int idx) {
            this.getIndex(this.strategyComponentIdentifier, idx, () -> _strategyComponentIdentifier.toBuilder());
            return this;
        }

        @Override
        public StrategyBuilder addStrategyComponentIdentifier(List<? extends StrategyComponentIdentification> strategyComponentIdentifiers) {
            if (strategyComponentIdentifiers != null) {
                for (StrategyComponentIdentification strategyComponentIdentification : strategyComponentIdentifiers) {
                    this.strategyComponentIdentifier.add(strategyComponentIdentification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strategyComponentIdentifier")
        public StrategyBuilder setStrategyComponentIdentifier(List<? extends StrategyComponentIdentification> strategyComponentIdentifiers) {
            this.strategyComponentIdentifier = strategyComponentIdentifiers == null ? new ArrayList<StrategyComponentIdentification.StrategyComponentIdentificationBuilder>() : (List)strategyComponentIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="premiumProductReference")
        @RuneAttribute(value="premiumProductReference")
        public StrategyBuilder setPremiumProductReference(ProductReference _premiumProductReference) {
            this.premiumProductReference = _premiumProductReference == null ? null : _premiumProductReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public StrategyBuilder addProduct(Product _product) {
            if (_product != null) {
                this.product.add(_product.toBuilder());
            }
            return this;
        }

        @Override
        public StrategyBuilder addProduct(Product _product, int idx) {
            this.getIndex(this.product, idx, () -> _product.toBuilder());
            return this;
        }

        @Override
        public StrategyBuilder addProduct(List<? extends Product> products) {
            if (products != null) {
                for (Product product : products) {
                    this.product.add(product.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="product")
        public StrategyBuilder setProduct(List<? extends Product> products) {
            this.product = products == null ? new ArrayList<Product.ProductBuilder>() : (List)products.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Strategy build() {
            return new StrategyImpl(this);
        }

        @Override
        public StrategyBuilder toBuilder() {
            return this;
        }

        @Override
        public StrategyBuilder prune() {
            super.prune();
            this.strategyComponentIdentifier = this.strategyComponentIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.premiumProductReference != null && !this.premiumProductReference.prune().hasData()) {
                this.premiumProductReference = null;
            }
            this.product = this.product.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getStrategyComponentIdentifier() != null && this.getStrategyComponentIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPremiumProductReference() != null && this.getPremiumProductReference().hasData()) {
                return true;
            }
            return this.getProduct() != null && this.getProduct().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public StrategyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            StrategyBuilder o = (StrategyBuilder)other;
            merger.mergeRosetta(this.getStrategyComponentIdentifier(), o.getStrategyComponentIdentifier(), this::getOrCreateStrategyComponentIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremiumProductReference(), (RosettaModelObjectBuilder)o.getPremiumProductReference(), this::setPremiumProductReference);
            merger.mergeRosetta(this.getProduct(), o.getProduct(), this::getOrCreateProduct);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Strategy _that = (Strategy)this.getType().cast(o);
            if (!ListEquals.listEquals(this.strategyComponentIdentifier, _that.getStrategyComponentIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.premiumProductReference, _that.getPremiumProductReference())) {
                return false;
            }
            return ListEquals.listEquals(this.product, _that.getProduct());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.strategyComponentIdentifier != null ? this.strategyComponentIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.premiumProductReference != null ? this.premiumProductReference.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "StrategyBuilder {strategyComponentIdentifier=" + this.strategyComponentIdentifier + ", premiumProductReference=" + this.premiumProductReference + ", product=" + this.product + '}' + " " + super.toString();
        }
    }

    public static interface StrategyBuilder
    extends Strategy,
    Product.ProductBuilder {
        public StrategyComponentIdentification.StrategyComponentIdentificationBuilder getOrCreateStrategyComponentIdentifier(int var1);

        public List<? extends StrategyComponentIdentification.StrategyComponentIdentificationBuilder> getStrategyComponentIdentifier();

        public ProductReference.ProductReferenceBuilder getOrCreatePremiumProductReference();

        @Override
        public ProductReference.ProductReferenceBuilder getPremiumProductReference();

        public Product.ProductBuilder getOrCreateProduct(int var1);

        public List<? extends Product.ProductBuilder> getProduct();

        @Override
        public StrategyBuilder setProductModel(ProductModel var1);

        @Override
        public StrategyBuilder setId(String var1);

        public StrategyBuilder addStrategyComponentIdentifier(StrategyComponentIdentification var1);

        public StrategyBuilder addStrategyComponentIdentifier(StrategyComponentIdentification var1, int var2);

        public StrategyBuilder addStrategyComponentIdentifier(List<? extends StrategyComponentIdentification> var1);

        public StrategyBuilder setStrategyComponentIdentifier(List<? extends StrategyComponentIdentification> var1);

        public StrategyBuilder setPremiumProductReference(ProductReference var1);

        public StrategyBuilder addProduct(Product var1);

        public StrategyBuilder addProduct(Product var1, int var2);

        public StrategyBuilder addProduct(List<? extends Product> var1);

        public StrategyBuilder setProduct(List<? extends Product> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strategyComponentIdentifier"), processor, StrategyComponentIdentification.StrategyComponentIdentificationBuilder.class, this.getStrategyComponentIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premiumProductReference"), processor, ProductReference.ProductReferenceBuilder.class, this.getPremiumProductReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
        }

        @Override
        public StrategyBuilder prune();
    }

    public static class StrategyImpl
    extends Product.ProductImpl
    implements Strategy {
        private final List<? extends StrategyComponentIdentification> strategyComponentIdentifier;
        private final ProductReference premiumProductReference;
        private final List<? extends Product> product;

        protected StrategyImpl(StrategyBuilder builder) {
            super(builder);
            this.strategyComponentIdentifier = Optional.ofNullable(builder.getStrategyComponentIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.premiumProductReference = Optional.ofNullable(builder.getPremiumProductReference()).map(f -> f.build()).orElse(null);
            this.product = Optional.ofNullable(builder.getProduct()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strategyComponentIdentifier")
        @RuneAttribute(value="strategyComponentIdentifier")
        public List<? extends StrategyComponentIdentification> getStrategyComponentIdentifier() {
            return this.strategyComponentIdentifier;
        }

        @Override
        @RosettaAttribute(value="premiumProductReference")
        @RuneAttribute(value="premiumProductReference")
        public ProductReference getPremiumProductReference() {
            return this.premiumProductReference;
        }

        @Override
        @RosettaAttribute(value="product")
        @RuneAttribute(value="product")
        public List<? extends Product> getProduct() {
            return this.product;
        }

        @Override
        public Strategy build() {
            return this;
        }

        @Override
        public StrategyBuilder toBuilder() {
            StrategyBuilder builder = Strategy.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StrategyBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStrategyComponentIdentifier()).ifPresent(builder::setStrategyComponentIdentifier);
            Optional.ofNullable(this.getPremiumProductReference()).ifPresent(builder::setPremiumProductReference);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Strategy _that = (Strategy)this.getType().cast(o);
            if (!ListEquals.listEquals(this.strategyComponentIdentifier, _that.getStrategyComponentIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.premiumProductReference, _that.getPremiumProductReference())) {
                return false;
            }
            return ListEquals.listEquals(this.product, _that.getProduct());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.strategyComponentIdentifier != null ? this.strategyComponentIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.premiumProductReference != null ? this.premiumProductReference.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Strategy {strategyComponentIdentifier=" + this.strategyComponentIdentifier + ", premiumProductReference=" + this.premiumProductReference + ", product=" + this.product + '}' + " " + super.toString();
        }
    }
}

