/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.OrderIdentifier;
import fpml.consolidated.doc.PackageType;
import fpml.consolidated.doc.meta.PackageSummaryMeta;
import fpml.consolidated.shared.IssuerTradeId;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PackageSummary", builder=PackageSummaryBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PackageSummary", model="fpml", builder=PackageSummaryBuilderImpl.class, version="1.1.0")
public interface PackageSummary
extends RosettaModelObject {
    public static final PackageSummaryMeta metaData = new PackageSummaryMeta();

    public IssuerTradeId getPackageIdentifier();

    public OrderIdentifier getOrderIdentifier();

    public List<? extends PackageType> getPackageType();

    public BigDecimal getSize();

    public BigDecimal getSequenceNumber();

    public PackageSummary build();

    public PackageSummaryBuilder toBuilder();

    public static PackageSummaryBuilder builder() {
        return new PackageSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends PackageSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PackageSummary> getType() {
        return PackageSummary.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("packageIdentifier"), processor, IssuerTradeId.class, this.getPackageIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("orderIdentifier"), processor, OrderIdentifier.class, this.getOrderIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageType"), processor, PackageType.class, this.getPackageType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("size"), BigDecimal.class, (Object)this.getSize(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sequenceNumber"), BigDecimal.class, (Object)this.getSequenceNumber(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PackageSummaryBuilderImpl
    implements PackageSummaryBuilder {
        protected IssuerTradeId.IssuerTradeIdBuilder packageIdentifier;
        protected OrderIdentifier.OrderIdentifierBuilder orderIdentifier;
        protected List<PackageType.PackageTypeBuilder> packageType = new ArrayList<PackageType.PackageTypeBuilder>();
        protected BigDecimal size;
        protected BigDecimal sequenceNumber;

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public IssuerTradeId.IssuerTradeIdBuilder getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        public IssuerTradeId.IssuerTradeIdBuilder getOrCreatePackageIdentifier() {
            IssuerTradeId.IssuerTradeIdBuilder result = this.packageIdentifier != null ? this.packageIdentifier : (this.packageIdentifier = IssuerTradeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="orderIdentifier")
        @RuneAttribute(value="orderIdentifier")
        public OrderIdentifier.OrderIdentifierBuilder getOrderIdentifier() {
            return this.orderIdentifier;
        }

        @Override
        public OrderIdentifier.OrderIdentifierBuilder getOrCreateOrderIdentifier() {
            OrderIdentifier.OrderIdentifierBuilder result = this.orderIdentifier != null ? this.orderIdentifier : (this.orderIdentifier = OrderIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageType")
        @RuneAttribute(value="packageType")
        public List<? extends PackageType.PackageTypeBuilder> getPackageType() {
            return this.packageType;
        }

        @Override
        public PackageType.PackageTypeBuilder getOrCreatePackageType(int index) {
            if (this.packageType == null) {
                this.packageType = new ArrayList<PackageType.PackageTypeBuilder>();
            }
            return (PackageType.PackageTypeBuilder)this.getIndex(this.packageType, index, () -> {
                PackageType.PackageTypeBuilder newPackageType = PackageType.builder();
                return newPackageType;
            });
        }

        @Override
        @RosettaAttribute(value="size")
        @RuneAttribute(value="size")
        public BigDecimal getSize() {
            return this.size;
        }

        @Override
        @RosettaAttribute(value="sequenceNumber")
        @RuneAttribute(value="sequenceNumber")
        public BigDecimal getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public PackageSummaryBuilder setPackageIdentifier(IssuerTradeId _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="orderIdentifier")
        @RuneAttribute(value="orderIdentifier")
        public PackageSummaryBuilder setOrderIdentifier(OrderIdentifier _orderIdentifier) {
            this.orderIdentifier = _orderIdentifier == null ? null : _orderIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageType")
        @RuneAttribute(value="packageType")
        public PackageSummaryBuilder addPackageType(PackageType _packageType) {
            if (_packageType != null) {
                this.packageType.add(_packageType.toBuilder());
            }
            return this;
        }

        @Override
        public PackageSummaryBuilder addPackageType(PackageType _packageType, int idx) {
            this.getIndex(this.packageType, idx, () -> _packageType.toBuilder());
            return this;
        }

        @Override
        public PackageSummaryBuilder addPackageType(List<? extends PackageType> packageTypes) {
            if (packageTypes != null) {
                for (PackageType packageType : packageTypes) {
                    this.packageType.add(packageType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="packageType")
        public PackageSummaryBuilder setPackageType(List<? extends PackageType> packageTypes) {
            this.packageType = packageTypes == null ? new ArrayList<PackageType.PackageTypeBuilder>() : (List)packageTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="size")
        @RuneAttribute(value="size")
        public PackageSummaryBuilder setSize(BigDecimal _size) {
            this.size = _size == null ? null : _size;
            return this;
        }

        @Override
        @RosettaAttribute(value="sequenceNumber")
        @RuneAttribute(value="sequenceNumber")
        public PackageSummaryBuilder setSequenceNumber(BigDecimal _sequenceNumber) {
            this.sequenceNumber = _sequenceNumber == null ? null : _sequenceNumber;
            return this;
        }

        @Override
        public PackageSummary build() {
            return new PackageSummaryImpl(this);
        }

        @Override
        public PackageSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public PackageSummaryBuilder prune() {
            if (this.packageIdentifier != null && !this.packageIdentifier.prune().hasData()) {
                this.packageIdentifier = null;
            }
            if (this.orderIdentifier != null && !this.orderIdentifier.prune().hasData()) {
                this.orderIdentifier = null;
            }
            this.packageType = this.packageType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPackageIdentifier() != null && this.getPackageIdentifier().hasData()) {
                return true;
            }
            if (this.getOrderIdentifier() != null && this.getOrderIdentifier().hasData()) {
                return true;
            }
            if (this.getPackageType() != null && this.getPackageType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSize() != null) {
                return true;
            }
            return this.getSequenceNumber() != null;
        }

        public PackageSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PackageSummaryBuilder o = (PackageSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageIdentifier(), (RosettaModelObjectBuilder)o.getPackageIdentifier(), this::setPackageIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOrderIdentifier(), (RosettaModelObjectBuilder)o.getOrderIdentifier(), this::setOrderIdentifier);
            merger.mergeRosetta(this.getPackageType(), o.getPackageType(), this::getOrCreatePackageType);
            merger.mergeBasic((Object)this.getSize(), (Object)o.getSize(), this::setSize, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSequenceNumber(), (Object)o.getSequenceNumber(), this::setSequenceNumber, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PackageSummary _that = this.getType().cast(o);
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.orderIdentifier, _that.getOrderIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.packageType, _that.getPackageType())) {
                return false;
            }
            if (!Objects.equals(this.size, _that.getSize())) {
                return false;
            }
            return Objects.equals(this.sequenceNumber, _that.getSequenceNumber());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.orderIdentifier != null ? this.orderIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.packageType != null ? this.packageType.hashCode() : 0);
            _result = 31 * _result + (this.size != null ? this.size.hashCode() : 0);
            _result = 31 * _result + (this.sequenceNumber != null ? this.sequenceNumber.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PackageSummaryBuilder {packageIdentifier=" + this.packageIdentifier + ", orderIdentifier=" + this.orderIdentifier + ", packageType=" + this.packageType + ", size=" + this.size + ", sequenceNumber=" + this.sequenceNumber + '}';
        }
    }

    public static interface PackageSummaryBuilder
    extends PackageSummary,
    RosettaModelObjectBuilder {
        public IssuerTradeId.IssuerTradeIdBuilder getOrCreatePackageIdentifier();

        @Override
        public IssuerTradeId.IssuerTradeIdBuilder getPackageIdentifier();

        public OrderIdentifier.OrderIdentifierBuilder getOrCreateOrderIdentifier();

        @Override
        public OrderIdentifier.OrderIdentifierBuilder getOrderIdentifier();

        public PackageType.PackageTypeBuilder getOrCreatePackageType(int var1);

        public List<? extends PackageType.PackageTypeBuilder> getPackageType();

        public PackageSummaryBuilder setPackageIdentifier(IssuerTradeId var1);

        public PackageSummaryBuilder setOrderIdentifier(OrderIdentifier var1);

        public PackageSummaryBuilder addPackageType(PackageType var1);

        public PackageSummaryBuilder addPackageType(PackageType var1, int var2);

        public PackageSummaryBuilder addPackageType(List<? extends PackageType> var1);

        public PackageSummaryBuilder setPackageType(List<? extends PackageType> var1);

        public PackageSummaryBuilder setSize(BigDecimal var1);

        public PackageSummaryBuilder setSequenceNumber(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("packageIdentifier"), processor, IssuerTradeId.IssuerTradeIdBuilder.class, this.getPackageIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("orderIdentifier"), processor, OrderIdentifier.OrderIdentifierBuilder.class, this.getOrderIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageType"), processor, PackageType.PackageTypeBuilder.class, this.getPackageType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("size"), BigDecimal.class, (Object)this.getSize(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sequenceNumber"), BigDecimal.class, (Object)this.getSequenceNumber(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PackageSummaryBuilder prune();
    }

    public static class PackageSummaryImpl
    implements PackageSummary {
        private final IssuerTradeId packageIdentifier;
        private final OrderIdentifier orderIdentifier;
        private final List<? extends PackageType> packageType;
        private final BigDecimal size;
        private final BigDecimal sequenceNumber;

        protected PackageSummaryImpl(PackageSummaryBuilder builder) {
            this.packageIdentifier = Optional.ofNullable(builder.getPackageIdentifier()).map(f -> f.build()).orElse(null);
            this.orderIdentifier = Optional.ofNullable(builder.getOrderIdentifier()).map(f -> f.build()).orElse(null);
            this.packageType = Optional.ofNullable(builder.getPackageType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.size = builder.getSize();
            this.sequenceNumber = builder.getSequenceNumber();
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public IssuerTradeId getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="orderIdentifier")
        @RuneAttribute(value="orderIdentifier")
        public OrderIdentifier getOrderIdentifier() {
            return this.orderIdentifier;
        }

        @Override
        @RosettaAttribute(value="packageType")
        @RuneAttribute(value="packageType")
        public List<? extends PackageType> getPackageType() {
            return this.packageType;
        }

        @Override
        @RosettaAttribute(value="size")
        @RuneAttribute(value="size")
        public BigDecimal getSize() {
            return this.size;
        }

        @Override
        @RosettaAttribute(value="sequenceNumber")
        @RuneAttribute(value="sequenceNumber")
        public BigDecimal getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public PackageSummary build() {
            return this;
        }

        @Override
        public PackageSummaryBuilder toBuilder() {
            PackageSummaryBuilder builder = PackageSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PackageSummaryBuilder builder) {
            Optional.ofNullable(this.getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
            Optional.ofNullable(this.getOrderIdentifier()).ifPresent(builder::setOrderIdentifier);
            Optional.ofNullable(this.getPackageType()).ifPresent(builder::setPackageType);
            Optional.ofNullable(this.getSize()).ifPresent(builder::setSize);
            Optional.ofNullable(this.getSequenceNumber()).ifPresent(builder::setSequenceNumber);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PackageSummary _that = this.getType().cast(o);
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.orderIdentifier, _that.getOrderIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.packageType, _that.getPackageType())) {
                return false;
            }
            if (!Objects.equals(this.size, _that.getSize())) {
                return false;
            }
            return Objects.equals(this.sequenceNumber, _that.getSequenceNumber());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.orderIdentifier != null ? this.orderIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.packageType != null ? this.packageType.hashCode() : 0);
            _result = 31 * _result + (this.size != null ? this.size.hashCode() : 0);
            _result = 31 * _result + (this.sequenceNumber != null ? this.sequenceNumber.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PackageSummary {packageIdentifier=" + this.packageIdentifier + ", orderIdentifier=" + this.orderIdentifier + ", packageType=" + this.packageType + ", size=" + this.size + ", sequenceNumber=" + this.sequenceNumber + '}';
        }
    }
}

