/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.AllocationReportingStatus;
import fpml.consolidated.doc.ClearingStatusValue;
import fpml.consolidated.doc.ExecutionDateTime;
import fpml.consolidated.doc.ExecutionVenueType;
import fpml.consolidated.doc.TradeCategory;
import fpml.consolidated.doc.TradeProcessingTimestamps;
import fpml.consolidated.doc.meta.PackageInformationMeta;
import fpml.consolidated.shared.RelatedParty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PackageInformation", builder=PackageInformationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PackageInformation", model="fpml", builder=PackageInformationBuilderImpl.class, version="1.1.0")
public interface PackageInformation
extends RosettaModelObject {
    public static final PackageInformationMeta metaData = new PackageInformationMeta();

    public List<? extends RelatedParty> getRelatedParty();

    public List<? extends TradeCategory> getCategory();

    public ExecutionDateTime getExecutionDateTime();

    public TradeProcessingTimestamps getTimestamps();

    public Boolean getIntentToAllocate();

    public AllocationReportingStatus getAllocationStatus();

    public Boolean getIntentToClear();

    public ClearingStatusValue getClearingStatus();

    public ExecutionVenueType getExecutionVenueType();

    public PackageInformation build();

    public PackageInformationBuilder toBuilder();

    public static PackageInformationBuilder builder() {
        return new PackageInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends PackageInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PackageInformation> getType() {
        return PackageInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("category"), processor, TradeCategory.class, this.getCategory(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDateTime"), processor, ExecutionDateTime.class, this.getExecutionDateTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("timestamps"), processor, TradeProcessingTimestamps.class, this.getTimestamps(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intentToAllocate"), Boolean.class, (Object)this.getIntentToAllocate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationStatus"), processor, AllocationReportingStatus.class, this.getAllocationStatus(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intentToClear"), Boolean.class, (Object)this.getIntentToClear(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingStatus"), processor, ClearingStatusValue.class, this.getClearingStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionVenueType"), processor, ExecutionVenueType.class, this.getExecutionVenueType(), new AttributeMeta[0]);
    }

    public static class PackageInformationBuilderImpl
    implements PackageInformationBuilder {
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
        protected List<TradeCategory.TradeCategoryBuilder> category = new ArrayList<TradeCategory.TradeCategoryBuilder>();
        protected ExecutionDateTime.ExecutionDateTimeBuilder executionDateTime;
        protected TradeProcessingTimestamps.TradeProcessingTimestampsBuilder timestamps;
        protected Boolean intentToAllocate;
        protected AllocationReportingStatus.AllocationReportingStatusBuilder allocationStatus;
        protected Boolean intentToClear;
        protected ClearingStatusValue.ClearingStatusValueBuilder clearingStatus;
        protected ExecutionVenueType.ExecutionVenueTypeBuilder executionVenueType;

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public List<? extends TradeCategory.TradeCategoryBuilder> getCategory() {
            return this.category;
        }

        @Override
        public TradeCategory.TradeCategoryBuilder getOrCreateCategory(int index) {
            if (this.category == null) {
                this.category = new ArrayList<TradeCategory.TradeCategoryBuilder>();
            }
            return (TradeCategory.TradeCategoryBuilder)this.getIndex(this.category, index, () -> {
                TradeCategory.TradeCategoryBuilder newCategory = TradeCategory.builder();
                return newCategory;
            });
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public ExecutionDateTime.ExecutionDateTimeBuilder getExecutionDateTime() {
            return this.executionDateTime;
        }

        @Override
        public ExecutionDateTime.ExecutionDateTimeBuilder getOrCreateExecutionDateTime() {
            ExecutionDateTime.ExecutionDateTimeBuilder result = this.executionDateTime != null ? this.executionDateTime : (this.executionDateTime = ExecutionDateTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="timestamps")
        @RuneAttribute(value="timestamps")
        public TradeProcessingTimestamps.TradeProcessingTimestampsBuilder getTimestamps() {
            return this.timestamps;
        }

        @Override
        public TradeProcessingTimestamps.TradeProcessingTimestampsBuilder getOrCreateTimestamps() {
            TradeProcessingTimestamps.TradeProcessingTimestampsBuilder result = this.timestamps != null ? this.timestamps : (this.timestamps = TradeProcessingTimestamps.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="intentToAllocate")
        @RuneAttribute(value="intentToAllocate")
        public Boolean getIntentToAllocate() {
            return this.intentToAllocate;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public AllocationReportingStatus.AllocationReportingStatusBuilder getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        public AllocationReportingStatus.AllocationReportingStatusBuilder getOrCreateAllocationStatus() {
            AllocationReportingStatus.AllocationReportingStatusBuilder result = this.allocationStatus != null ? this.allocationStatus : (this.allocationStatus = AllocationReportingStatus.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="intentToClear")
        @RuneAttribute(value="intentToClear")
        public Boolean getIntentToClear() {
            return this.intentToClear;
        }

        @Override
        @RosettaAttribute(value="clearingStatus")
        @RuneAttribute(value="clearingStatus")
        public ClearingStatusValue.ClearingStatusValueBuilder getClearingStatus() {
            return this.clearingStatus;
        }

        @Override
        public ClearingStatusValue.ClearingStatusValueBuilder getOrCreateClearingStatus() {
            ClearingStatusValue.ClearingStatusValueBuilder result = this.clearingStatus != null ? this.clearingStatus : (this.clearingStatus = ClearingStatusValue.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public ExecutionVenueType.ExecutionVenueTypeBuilder getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        public ExecutionVenueType.ExecutionVenueTypeBuilder getOrCreateExecutionVenueType() {
            ExecutionVenueType.ExecutionVenueTypeBuilder result = this.executionVenueType != null ? this.executionVenueType : (this.executionVenueType = ExecutionVenueType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public PackageInformationBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public PackageInformationBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public PackageInformationBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public PackageInformationBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public PackageInformationBuilder addCategory(TradeCategory _category) {
            if (_category != null) {
                this.category.add(_category.toBuilder());
            }
            return this;
        }

        @Override
        public PackageInformationBuilder addCategory(TradeCategory _category, int idx) {
            this.getIndex(this.category, idx, () -> _category.toBuilder());
            return this;
        }

        @Override
        public PackageInformationBuilder addCategory(List<? extends TradeCategory> categorys) {
            if (categorys != null) {
                for (TradeCategory tradeCategory : categorys) {
                    this.category.add(tradeCategory.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="category")
        public PackageInformationBuilder setCategory(List<? extends TradeCategory> categorys) {
            this.category = categorys == null ? new ArrayList<TradeCategory.TradeCategoryBuilder>() : (List)categorys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public PackageInformationBuilder setExecutionDateTime(ExecutionDateTime _executionDateTime) {
            this.executionDateTime = _executionDateTime == null ? null : _executionDateTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="timestamps")
        @RuneAttribute(value="timestamps")
        public PackageInformationBuilder setTimestamps(TradeProcessingTimestamps _timestamps) {
            this.timestamps = _timestamps == null ? null : _timestamps.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="intentToAllocate")
        @RuneAttribute(value="intentToAllocate")
        public PackageInformationBuilder setIntentToAllocate(Boolean _intentToAllocate) {
            this.intentToAllocate = _intentToAllocate == null ? null : _intentToAllocate;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public PackageInformationBuilder setAllocationStatus(AllocationReportingStatus _allocationStatus) {
            this.allocationStatus = _allocationStatus == null ? null : _allocationStatus.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="intentToClear")
        @RuneAttribute(value="intentToClear")
        public PackageInformationBuilder setIntentToClear(Boolean _intentToClear) {
            this.intentToClear = _intentToClear == null ? null : _intentToClear;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingStatus")
        @RuneAttribute(value="clearingStatus")
        public PackageInformationBuilder setClearingStatus(ClearingStatusValue _clearingStatus) {
            this.clearingStatus = _clearingStatus == null ? null : _clearingStatus.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public PackageInformationBuilder setExecutionVenueType(ExecutionVenueType _executionVenueType) {
            this.executionVenueType = _executionVenueType == null ? null : _executionVenueType.toBuilder();
            return this;
        }

        @Override
        public PackageInformation build() {
            return new PackageInformationImpl(this);
        }

        @Override
        public PackageInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public PackageInformationBuilder prune() {
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.category = this.category.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.executionDateTime != null && !this.executionDateTime.prune().hasData()) {
                this.executionDateTime = null;
            }
            if (this.timestamps != null && !this.timestamps.prune().hasData()) {
                this.timestamps = null;
            }
            if (this.allocationStatus != null && !this.allocationStatus.prune().hasData()) {
                this.allocationStatus = null;
            }
            if (this.clearingStatus != null && !this.clearingStatus.prune().hasData()) {
                this.clearingStatus = null;
            }
            if (this.executionVenueType != null && !this.executionVenueType.prune().hasData()) {
                this.executionVenueType = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCategory() != null && this.getCategory().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExecutionDateTime() != null && this.getExecutionDateTime().hasData()) {
                return true;
            }
            if (this.getTimestamps() != null && this.getTimestamps().hasData()) {
                return true;
            }
            if (this.getIntentToAllocate() != null) {
                return true;
            }
            if (this.getAllocationStatus() != null && this.getAllocationStatus().hasData()) {
                return true;
            }
            if (this.getIntentToClear() != null) {
                return true;
            }
            if (this.getClearingStatus() != null && this.getClearingStatus().hasData()) {
                return true;
            }
            return this.getExecutionVenueType() != null && this.getExecutionVenueType().hasData();
        }

        public PackageInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PackageInformationBuilder o = (PackageInformationBuilder)other;
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            merger.mergeRosetta(this.getCategory(), o.getCategory(), this::getOrCreateCategory);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionDateTime(), (RosettaModelObjectBuilder)o.getExecutionDateTime(), this::setExecutionDateTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTimestamps(), (RosettaModelObjectBuilder)o.getTimestamps(), this::setTimestamps);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocationStatus(), (RosettaModelObjectBuilder)o.getAllocationStatus(), this::setAllocationStatus);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingStatus(), (RosettaModelObjectBuilder)o.getClearingStatus(), this::setClearingStatus);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionVenueType(), (RosettaModelObjectBuilder)o.getExecutionVenueType(), this::setExecutionVenueType);
            merger.mergeBasic((Object)this.getIntentToAllocate(), (Object)o.getIntentToAllocate(), this::setIntentToAllocate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIntentToClear(), (Object)o.getIntentToClear(), this::setIntentToClear, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PackageInformation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.category, _that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.executionDateTime, _that.getExecutionDateTime())) {
                return false;
            }
            if (!Objects.equals(this.timestamps, _that.getTimestamps())) {
                return false;
            }
            if (!Objects.equals(this.intentToAllocate, _that.getIntentToAllocate())) {
                return false;
            }
            if (!Objects.equals(this.allocationStatus, _that.getAllocationStatus())) {
                return false;
            }
            if (!Objects.equals(this.intentToClear, _that.getIntentToClear())) {
                return false;
            }
            if (!Objects.equals(this.clearingStatus, _that.getClearingStatus())) {
                return false;
            }
            return Objects.equals(this.executionVenueType, _that.getExecutionVenueType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? this.category.hashCode() : 0);
            _result = 31 * _result + (this.executionDateTime != null ? this.executionDateTime.hashCode() : 0);
            _result = 31 * _result + (this.timestamps != null ? this.timestamps.hashCode() : 0);
            _result = 31 * _result + (this.intentToAllocate != null ? this.intentToAllocate.hashCode() : 0);
            _result = 31 * _result + (this.allocationStatus != null ? this.allocationStatus.hashCode() : 0);
            _result = 31 * _result + (this.intentToClear != null ? this.intentToClear.hashCode() : 0);
            _result = 31 * _result + (this.clearingStatus != null ? this.clearingStatus.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? this.executionVenueType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PackageInformationBuilder {relatedParty=" + this.relatedParty + ", category=" + this.category + ", executionDateTime=" + this.executionDateTime + ", timestamps=" + this.timestamps + ", intentToAllocate=" + this.intentToAllocate + ", allocationStatus=" + this.allocationStatus + ", intentToClear=" + this.intentToClear + ", clearingStatus=" + this.clearingStatus + ", executionVenueType=" + this.executionVenueType + '}';
        }
    }

    public static interface PackageInformationBuilder
    extends PackageInformation,
    RosettaModelObjectBuilder {
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public TradeCategory.TradeCategoryBuilder getOrCreateCategory(int var1);

        public List<? extends TradeCategory.TradeCategoryBuilder> getCategory();

        public ExecutionDateTime.ExecutionDateTimeBuilder getOrCreateExecutionDateTime();

        @Override
        public ExecutionDateTime.ExecutionDateTimeBuilder getExecutionDateTime();

        public TradeProcessingTimestamps.TradeProcessingTimestampsBuilder getOrCreateTimestamps();

        @Override
        public TradeProcessingTimestamps.TradeProcessingTimestampsBuilder getTimestamps();

        public AllocationReportingStatus.AllocationReportingStatusBuilder getOrCreateAllocationStatus();

        @Override
        public AllocationReportingStatus.AllocationReportingStatusBuilder getAllocationStatus();

        public ClearingStatusValue.ClearingStatusValueBuilder getOrCreateClearingStatus();

        @Override
        public ClearingStatusValue.ClearingStatusValueBuilder getClearingStatus();

        public ExecutionVenueType.ExecutionVenueTypeBuilder getOrCreateExecutionVenueType();

        @Override
        public ExecutionVenueType.ExecutionVenueTypeBuilder getExecutionVenueType();

        public PackageInformationBuilder addRelatedParty(RelatedParty var1);

        public PackageInformationBuilder addRelatedParty(RelatedParty var1, int var2);

        public PackageInformationBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public PackageInformationBuilder setRelatedParty(List<? extends RelatedParty> var1);

        public PackageInformationBuilder addCategory(TradeCategory var1);

        public PackageInformationBuilder addCategory(TradeCategory var1, int var2);

        public PackageInformationBuilder addCategory(List<? extends TradeCategory> var1);

        public PackageInformationBuilder setCategory(List<? extends TradeCategory> var1);

        public PackageInformationBuilder setExecutionDateTime(ExecutionDateTime var1);

        public PackageInformationBuilder setTimestamps(TradeProcessingTimestamps var1);

        public PackageInformationBuilder setIntentToAllocate(Boolean var1);

        public PackageInformationBuilder setAllocationStatus(AllocationReportingStatus var1);

        public PackageInformationBuilder setIntentToClear(Boolean var1);

        public PackageInformationBuilder setClearingStatus(ClearingStatusValue var1);

        public PackageInformationBuilder setExecutionVenueType(ExecutionVenueType var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("category"), processor, TradeCategory.TradeCategoryBuilder.class, this.getCategory(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDateTime"), processor, ExecutionDateTime.ExecutionDateTimeBuilder.class, this.getExecutionDateTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("timestamps"), processor, TradeProcessingTimestamps.TradeProcessingTimestampsBuilder.class, this.getTimestamps(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intentToAllocate"), Boolean.class, (Object)this.getIntentToAllocate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationStatus"), processor, AllocationReportingStatus.AllocationReportingStatusBuilder.class, this.getAllocationStatus(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intentToClear"), Boolean.class, (Object)this.getIntentToClear(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingStatus"), processor, ClearingStatusValue.ClearingStatusValueBuilder.class, this.getClearingStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionVenueType"), processor, ExecutionVenueType.ExecutionVenueTypeBuilder.class, this.getExecutionVenueType(), new AttributeMeta[0]);
        }

        public PackageInformationBuilder prune();
    }

    public static class PackageInformationImpl
    implements PackageInformation {
        private final List<? extends RelatedParty> relatedParty;
        private final List<? extends TradeCategory> category;
        private final ExecutionDateTime executionDateTime;
        private final TradeProcessingTimestamps timestamps;
        private final Boolean intentToAllocate;
        private final AllocationReportingStatus allocationStatus;
        private final Boolean intentToClear;
        private final ClearingStatusValue clearingStatus;
        private final ExecutionVenueType executionVenueType;

        protected PackageInformationImpl(PackageInformationBuilder builder) {
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.category = Optional.ofNullable(builder.getCategory()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.executionDateTime = Optional.ofNullable(builder.getExecutionDateTime()).map(f -> f.build()).orElse(null);
            this.timestamps = Optional.ofNullable(builder.getTimestamps()).map(f -> f.build()).orElse(null);
            this.intentToAllocate = builder.getIntentToAllocate();
            this.allocationStatus = Optional.ofNullable(builder.getAllocationStatus()).map(f -> f.build()).orElse(null);
            this.intentToClear = builder.getIntentToClear();
            this.clearingStatus = Optional.ofNullable(builder.getClearingStatus()).map(f -> f.build()).orElse(null);
            this.executionVenueType = Optional.ofNullable(builder.getExecutionVenueType()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public List<? extends TradeCategory> getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="executionDateTime")
        @RuneAttribute(value="executionDateTime")
        public ExecutionDateTime getExecutionDateTime() {
            return this.executionDateTime;
        }

        @Override
        @RosettaAttribute(value="timestamps")
        @RuneAttribute(value="timestamps")
        public TradeProcessingTimestamps getTimestamps() {
            return this.timestamps;
        }

        @Override
        @RosettaAttribute(value="intentToAllocate")
        @RuneAttribute(value="intentToAllocate")
        public Boolean getIntentToAllocate() {
            return this.intentToAllocate;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public AllocationReportingStatus getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        @RosettaAttribute(value="intentToClear")
        @RuneAttribute(value="intentToClear")
        public Boolean getIntentToClear() {
            return this.intentToClear;
        }

        @Override
        @RosettaAttribute(value="clearingStatus")
        @RuneAttribute(value="clearingStatus")
        public ClearingStatusValue getClearingStatus() {
            return this.clearingStatus;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public ExecutionVenueType getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        public PackageInformation build() {
            return this;
        }

        @Override
        public PackageInformationBuilder toBuilder() {
            PackageInformationBuilder builder = PackageInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PackageInformationBuilder builder) {
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
            Optional.ofNullable(this.getCategory()).ifPresent(builder::setCategory);
            Optional.ofNullable(this.getExecutionDateTime()).ifPresent(builder::setExecutionDateTime);
            Optional.ofNullable(this.getTimestamps()).ifPresent(builder::setTimestamps);
            Optional.ofNullable(this.getIntentToAllocate()).ifPresent(builder::setIntentToAllocate);
            Optional.ofNullable(this.getAllocationStatus()).ifPresent(builder::setAllocationStatus);
            Optional.ofNullable(this.getIntentToClear()).ifPresent(builder::setIntentToClear);
            Optional.ofNullable(this.getClearingStatus()).ifPresent(builder::setClearingStatus);
            Optional.ofNullable(this.getExecutionVenueType()).ifPresent(builder::setExecutionVenueType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PackageInformation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.relatedParty, _that.getRelatedParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.category, _that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.executionDateTime, _that.getExecutionDateTime())) {
                return false;
            }
            if (!Objects.equals(this.timestamps, _that.getTimestamps())) {
                return false;
            }
            if (!Objects.equals(this.intentToAllocate, _that.getIntentToAllocate())) {
                return false;
            }
            if (!Objects.equals(this.allocationStatus, _that.getAllocationStatus())) {
                return false;
            }
            if (!Objects.equals(this.intentToClear, _that.getIntentToClear())) {
                return false;
            }
            if (!Objects.equals(this.clearingStatus, _that.getClearingStatus())) {
                return false;
            }
            return Objects.equals(this.executionVenueType, _that.getExecutionVenueType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? this.category.hashCode() : 0);
            _result = 31 * _result + (this.executionDateTime != null ? this.executionDateTime.hashCode() : 0);
            _result = 31 * _result + (this.timestamps != null ? this.timestamps.hashCode() : 0);
            _result = 31 * _result + (this.intentToAllocate != null ? this.intentToAllocate.hashCode() : 0);
            _result = 31 * _result + (this.allocationStatus != null ? this.allocationStatus.hashCode() : 0);
            _result = 31 * _result + (this.intentToClear != null ? this.intentToClear.hashCode() : 0);
            _result = 31 * _result + (this.clearingStatus != null ? this.clearingStatus.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? this.executionVenueType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PackageInformation {relatedParty=" + this.relatedParty + ", category=" + this.category + ", executionDateTime=" + this.executionDateTime + ", timestamps=" + this.timestamps + ", intentToAllocate=" + this.intentToAllocate + ", allocationStatus=" + this.allocationStatus + ", intentToClear=" + this.intentToClear + ", clearingStatus=" + this.clearingStatus + ", executionVenueType=" + this.executionVenueType + '}';
        }
    }
}

