/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.meta.DocumentMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Document", builder=DocumentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Document", model="fpml", builder=DocumentBuilderImpl.class, version="1.1.0")
public interface Document
extends RosettaModelObject {
    public static final DocumentMeta metaData = new DocumentMeta();

    public String getFpmlVersion();

    public Integer getExpectedBuild();

    public Integer getActualBuild();

    public Document build();

    public DocumentBuilder toBuilder();

    public static DocumentBuilder builder() {
        return new DocumentBuilderImpl();
    }

    default public RosettaMetaData<? extends Document> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Document> getType() {
        return Document.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DocumentBuilderImpl
    implements DocumentBuilder {
        protected String fpmlVersion;
        protected Integer expectedBuild;
        protected Integer actualBuild;

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public String getFpmlVersion() {
            return this.fpmlVersion;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public Integer getExpectedBuild() {
            return this.expectedBuild;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public Integer getActualBuild() {
            return this.actualBuild;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public DocumentBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public DocumentBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public DocumentBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        public Document build() {
            return new DocumentImpl(this);
        }

        @Override
        public DocumentBuilder toBuilder() {
            return this;
        }

        @Override
        public DocumentBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getFpmlVersion() != null) {
                return true;
            }
            if (this.getExpectedBuild() != null) {
                return true;
            }
            return this.getActualBuild() != null;
        }

        public DocumentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DocumentBuilder o = (DocumentBuilder)other;
            merger.mergeBasic((Object)this.getFpmlVersion(), (Object)o.getFpmlVersion(), this::setFpmlVersion, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpectedBuild(), (Object)o.getExpectedBuild(), this::setExpectedBuild, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActualBuild(), (Object)o.getActualBuild(), this::setActualBuild, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Document _that = this.getType().cast(o);
            if (!Objects.equals(this.fpmlVersion, _that.getFpmlVersion())) {
                return false;
            }
            if (!Objects.equals(this.expectedBuild, _that.getExpectedBuild())) {
                return false;
            }
            return Objects.equals(this.actualBuild, _that.getActualBuild());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fpmlVersion != null ? this.fpmlVersion.hashCode() : 0);
            _result = 31 * _result + (this.expectedBuild != null ? this.expectedBuild.hashCode() : 0);
            _result = 31 * _result + (this.actualBuild != null ? this.actualBuild.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DocumentBuilder {fpmlVersion=" + this.fpmlVersion + ", expectedBuild=" + this.expectedBuild + ", actualBuild=" + this.actualBuild + '}';
        }
    }

    public static interface DocumentBuilder
    extends Document,
    RosettaModelObjectBuilder {
        public DocumentBuilder setFpmlVersion(String var1);

        public DocumentBuilder setExpectedBuild(Integer var1);

        public DocumentBuilder setActualBuild(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DocumentBuilder prune();
    }

    public static class DocumentImpl
    implements Document {
        private final String fpmlVersion;
        private final Integer expectedBuild;
        private final Integer actualBuild;

        protected DocumentImpl(DocumentBuilder builder) {
            this.fpmlVersion = builder.getFpmlVersion();
            this.expectedBuild = builder.getExpectedBuild();
            this.actualBuild = builder.getActualBuild();
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public String getFpmlVersion() {
            return this.fpmlVersion;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public Integer getExpectedBuild() {
            return this.expectedBuild;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public Integer getActualBuild() {
            return this.actualBuild;
        }

        @Override
        public Document build() {
            return this;
        }

        @Override
        public DocumentBuilder toBuilder() {
            DocumentBuilder builder = Document.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DocumentBuilder builder) {
            Optional.ofNullable(this.getFpmlVersion()).ifPresent(builder::setFpmlVersion);
            Optional.ofNullable(this.getExpectedBuild()).ifPresent(builder::setExpectedBuild);
            Optional.ofNullable(this.getActualBuild()).ifPresent(builder::setActualBuild);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Document _that = this.getType().cast(o);
            if (!Objects.equals(this.fpmlVersion, _that.getFpmlVersion())) {
                return false;
            }
            if (!Objects.equals(this.expectedBuild, _that.getExpectedBuild())) {
                return false;
            }
            return Objects.equals(this.actualBuild, _that.getActualBuild());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fpmlVersion != null ? this.fpmlVersion.hashCode() : 0);
            _result = 31 * _result + (this.expectedBuild != null ? this.expectedBuild.hashCode() : 0);
            _result = 31 * _result + (this.actualBuild != null ? this.actualBuild.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Document {fpmlVersion=" + this.fpmlVersion + ", expectedBuild=" + this.expectedBuild + ", actualBuild=" + this.actualBuild + '}';
        }
    }
}

