/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.AllocationContentModel;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.doc.meta.AllocationMeta;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.PartyAndAccountReferencesModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Allocation", builder=AllocationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Allocation", model="fpml", builder=AllocationBuilderImpl.class, version="1.1.0")
public interface Allocation
extends RosettaModelObject {
    public static final AllocationMeta metaData = new AllocationMeta();

    public List<? extends TradeIdentifier> getAllocationTradeId();

    public PartyAndAccountReferencesModel getPartyAndAccountReferencesModel();

    public BigDecimal getAllocatedFraction();

    public List<? extends Money> getAllocatedNotional();

    public AllocationContentModel getAllocationContentModel();

    public Allocation build();

    public AllocationBuilder toBuilder();

    public static AllocationBuilder builder() {
        return new AllocationBuilderImpl();
    }

    default public RosettaMetaData<? extends Allocation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Allocation> getType() {
        return Allocation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("allocationTradeId"), processor, TradeIdentifier.class, this.getAllocationTradeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyAndAccountReferencesModel"), processor, PartyAndAccountReferencesModel.class, this.getPartyAndAccountReferencesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("allocatedFraction"), BigDecimal.class, (Object)this.getAllocatedFraction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocatedNotional"), processor, Money.class, this.getAllocatedNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationContentModel"), processor, AllocationContentModel.class, this.getAllocationContentModel(), new AttributeMeta[0]);
    }

    public static class AllocationBuilderImpl
    implements AllocationBuilder {
        protected List<TradeIdentifier.TradeIdentifierBuilder> allocationTradeId = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
        protected PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder partyAndAccountReferencesModel;
        protected BigDecimal allocatedFraction;
        protected List<Money.MoneyBuilder> allocatedNotional = new ArrayList<Money.MoneyBuilder>();
        protected AllocationContentModel.AllocationContentModelBuilder allocationContentModel;

        @Override
        @RosettaAttribute(value="allocationTradeId")
        @RuneAttribute(value="allocationTradeId")
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getAllocationTradeId() {
            return this.allocationTradeId;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateAllocationTradeId(int index) {
            if (this.allocationTradeId == null) {
                this.allocationTradeId = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.allocationTradeId, index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newAllocationTradeId = TradeIdentifier.builder();
                return newAllocationTradeId;
            });
        }

        @Override
        @RosettaAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        @RuneAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        public PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder getPartyAndAccountReferencesModel() {
            return this.partyAndAccountReferencesModel;
        }

        @Override
        public PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder getOrCreatePartyAndAccountReferencesModel() {
            PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder result = this.partyAndAccountReferencesModel != null ? this.partyAndAccountReferencesModel : (this.partyAndAccountReferencesModel = PartyAndAccountReferencesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="allocatedFraction")
        @RuneAttribute(value="allocatedFraction")
        public BigDecimal getAllocatedFraction() {
            return this.allocatedFraction;
        }

        @Override
        @RosettaAttribute(value="allocatedNotional")
        @RuneAttribute(value="allocatedNotional")
        public List<? extends Money.MoneyBuilder> getAllocatedNotional() {
            return this.allocatedNotional;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAllocatedNotional(int index) {
            if (this.allocatedNotional == null) {
                this.allocatedNotional = new ArrayList<Money.MoneyBuilder>();
            }
            return (Money.MoneyBuilder)this.getIndex(this.allocatedNotional, index, () -> {
                Money.MoneyBuilder newAllocatedNotional = Money.builder();
                return newAllocatedNotional;
            });
        }

        @Override
        @RosettaAttribute(value="allocationContentModel", isRequired=true)
        @RuneAttribute(value="allocationContentModel", isRequired=true)
        public AllocationContentModel.AllocationContentModelBuilder getAllocationContentModel() {
            return this.allocationContentModel;
        }

        @Override
        public AllocationContentModel.AllocationContentModelBuilder getOrCreateAllocationContentModel() {
            AllocationContentModel.AllocationContentModelBuilder result = this.allocationContentModel != null ? this.allocationContentModel : (this.allocationContentModel = AllocationContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="allocationTradeId")
        @RuneAttribute(value="allocationTradeId")
        public AllocationBuilder addAllocationTradeId(TradeIdentifier _allocationTradeId) {
            if (_allocationTradeId != null) {
                this.allocationTradeId.add(_allocationTradeId.toBuilder());
            }
            return this;
        }

        @Override
        public AllocationBuilder addAllocationTradeId(TradeIdentifier _allocationTradeId, int idx) {
            this.getIndex(this.allocationTradeId, idx, () -> _allocationTradeId.toBuilder());
            return this;
        }

        @Override
        public AllocationBuilder addAllocationTradeId(List<? extends TradeIdentifier> allocationTradeIds) {
            if (allocationTradeIds != null) {
                for (TradeIdentifier tradeIdentifier : allocationTradeIds) {
                    this.allocationTradeId.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="allocationTradeId")
        public AllocationBuilder setAllocationTradeId(List<? extends TradeIdentifier> allocationTradeIds) {
            this.allocationTradeId = allocationTradeIds == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)allocationTradeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        @RuneAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        public AllocationBuilder setPartyAndAccountReferencesModel(PartyAndAccountReferencesModel _partyAndAccountReferencesModel) {
            this.partyAndAccountReferencesModel = _partyAndAccountReferencesModel == null ? null : _partyAndAccountReferencesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="allocatedFraction")
        @RuneAttribute(value="allocatedFraction")
        public AllocationBuilder setAllocatedFraction(BigDecimal _allocatedFraction) {
            this.allocatedFraction = _allocatedFraction == null ? null : _allocatedFraction;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocatedNotional")
        @RuneAttribute(value="allocatedNotional")
        public AllocationBuilder addAllocatedNotional(Money _allocatedNotional) {
            if (_allocatedNotional != null) {
                this.allocatedNotional.add(_allocatedNotional.toBuilder());
            }
            return this;
        }

        @Override
        public AllocationBuilder addAllocatedNotional(Money _allocatedNotional, int idx) {
            this.getIndex(this.allocatedNotional, idx, () -> _allocatedNotional.toBuilder());
            return this;
        }

        @Override
        public AllocationBuilder addAllocatedNotional(List<? extends Money> allocatedNotionals) {
            if (allocatedNotionals != null) {
                for (Money money : allocatedNotionals) {
                    this.allocatedNotional.add(money.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="allocatedNotional")
        public AllocationBuilder setAllocatedNotional(List<? extends Money> allocatedNotionals) {
            this.allocatedNotional = allocatedNotionals == null ? new ArrayList<Money.MoneyBuilder>() : (List)allocatedNotionals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationContentModel", isRequired=true)
        @RuneAttribute(value="allocationContentModel", isRequired=true)
        public AllocationBuilder setAllocationContentModel(AllocationContentModel _allocationContentModel) {
            this.allocationContentModel = _allocationContentModel == null ? null : _allocationContentModel.toBuilder();
            return this;
        }

        @Override
        public Allocation build() {
            return new AllocationImpl(this);
        }

        @Override
        public AllocationBuilder toBuilder() {
            return this;
        }

        @Override
        public AllocationBuilder prune() {
            this.allocationTradeId = this.allocationTradeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partyAndAccountReferencesModel != null && !this.partyAndAccountReferencesModel.prune().hasData()) {
                this.partyAndAccountReferencesModel = null;
            }
            this.allocatedNotional = this.allocatedNotional.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.allocationContentModel != null && !this.allocationContentModel.prune().hasData()) {
                this.allocationContentModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAllocationTradeId() != null && this.getAllocationTradeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyAndAccountReferencesModel() != null && this.getPartyAndAccountReferencesModel().hasData()) {
                return true;
            }
            if (this.getAllocatedFraction() != null) {
                return true;
            }
            if (this.getAllocatedNotional() != null && this.getAllocatedNotional().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAllocationContentModel() != null && this.getAllocationContentModel().hasData();
        }

        public AllocationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AllocationBuilder o = (AllocationBuilder)other;
            merger.mergeRosetta(this.getAllocationTradeId(), o.getAllocationTradeId(), this::getOrCreateAllocationTradeId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyAndAccountReferencesModel(), (RosettaModelObjectBuilder)o.getPartyAndAccountReferencesModel(), this::setPartyAndAccountReferencesModel);
            merger.mergeRosetta(this.getAllocatedNotional(), o.getAllocatedNotional(), this::getOrCreateAllocatedNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocationContentModel(), (RosettaModelObjectBuilder)o.getAllocationContentModel(), this::setAllocationContentModel);
            merger.mergeBasic((Object)this.getAllocatedFraction(), (Object)o.getAllocatedFraction(), this::setAllocatedFraction, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Allocation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.allocationTradeId, _that.getAllocationTradeId())) {
                return false;
            }
            if (!Objects.equals(this.partyAndAccountReferencesModel, _that.getPartyAndAccountReferencesModel())) {
                return false;
            }
            if (!Objects.equals(this.allocatedFraction, _that.getAllocatedFraction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.allocatedNotional, _that.getAllocatedNotional())) {
                return false;
            }
            return Objects.equals(this.allocationContentModel, _that.getAllocationContentModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.allocationTradeId != null ? this.allocationTradeId.hashCode() : 0);
            _result = 31 * _result + (this.partyAndAccountReferencesModel != null ? this.partyAndAccountReferencesModel.hashCode() : 0);
            _result = 31 * _result + (this.allocatedFraction != null ? this.allocatedFraction.hashCode() : 0);
            _result = 31 * _result + (this.allocatedNotional != null ? this.allocatedNotional.hashCode() : 0);
            _result = 31 * _result + (this.allocationContentModel != null ? this.allocationContentModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AllocationBuilder {allocationTradeId=" + this.allocationTradeId + ", partyAndAccountReferencesModel=" + this.partyAndAccountReferencesModel + ", allocatedFraction=" + this.allocatedFraction + ", allocatedNotional=" + this.allocatedNotional + ", allocationContentModel=" + this.allocationContentModel + '}';
        }
    }

    public static interface AllocationBuilder
    extends Allocation,
    RosettaModelObjectBuilder {
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateAllocationTradeId(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getAllocationTradeId();

        public PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder getOrCreatePartyAndAccountReferencesModel();

        @Override
        public PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder getPartyAndAccountReferencesModel();

        public Money.MoneyBuilder getOrCreateAllocatedNotional(int var1);

        public List<? extends Money.MoneyBuilder> getAllocatedNotional();

        public AllocationContentModel.AllocationContentModelBuilder getOrCreateAllocationContentModel();

        @Override
        public AllocationContentModel.AllocationContentModelBuilder getAllocationContentModel();

        public AllocationBuilder addAllocationTradeId(TradeIdentifier var1);

        public AllocationBuilder addAllocationTradeId(TradeIdentifier var1, int var2);

        public AllocationBuilder addAllocationTradeId(List<? extends TradeIdentifier> var1);

        public AllocationBuilder setAllocationTradeId(List<? extends TradeIdentifier> var1);

        public AllocationBuilder setPartyAndAccountReferencesModel(PartyAndAccountReferencesModel var1);

        public AllocationBuilder setAllocatedFraction(BigDecimal var1);

        public AllocationBuilder addAllocatedNotional(Money var1);

        public AllocationBuilder addAllocatedNotional(Money var1, int var2);

        public AllocationBuilder addAllocatedNotional(List<? extends Money> var1);

        public AllocationBuilder setAllocatedNotional(List<? extends Money> var1);

        public AllocationBuilder setAllocationContentModel(AllocationContentModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("allocationTradeId"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getAllocationTradeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyAndAccountReferencesModel"), processor, PartyAndAccountReferencesModel.PartyAndAccountReferencesModelBuilder.class, this.getPartyAndAccountReferencesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("allocatedFraction"), BigDecimal.class, (Object)this.getAllocatedFraction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocatedNotional"), processor, Money.MoneyBuilder.class, this.getAllocatedNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationContentModel"), processor, AllocationContentModel.AllocationContentModelBuilder.class, this.getAllocationContentModel(), new AttributeMeta[0]);
        }

        public AllocationBuilder prune();
    }

    public static class AllocationImpl
    implements Allocation {
        private final List<? extends TradeIdentifier> allocationTradeId;
        private final PartyAndAccountReferencesModel partyAndAccountReferencesModel;
        private final BigDecimal allocatedFraction;
        private final List<? extends Money> allocatedNotional;
        private final AllocationContentModel allocationContentModel;

        protected AllocationImpl(AllocationBuilder builder) {
            this.allocationTradeId = Optional.ofNullable(builder.getAllocationTradeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyAndAccountReferencesModel = Optional.ofNullable(builder.getPartyAndAccountReferencesModel()).map(f -> f.build()).orElse(null);
            this.allocatedFraction = builder.getAllocatedFraction();
            this.allocatedNotional = Optional.ofNullable(builder.getAllocatedNotional()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.allocationContentModel = Optional.ofNullable(builder.getAllocationContentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="allocationTradeId")
        @RuneAttribute(value="allocationTradeId")
        public List<? extends TradeIdentifier> getAllocationTradeId() {
            return this.allocationTradeId;
        }

        @Override
        @RosettaAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        @RuneAttribute(value="partyAndAccountReferencesModel", isRequired=true)
        public PartyAndAccountReferencesModel getPartyAndAccountReferencesModel() {
            return this.partyAndAccountReferencesModel;
        }

        @Override
        @RosettaAttribute(value="allocatedFraction")
        @RuneAttribute(value="allocatedFraction")
        public BigDecimal getAllocatedFraction() {
            return this.allocatedFraction;
        }

        @Override
        @RosettaAttribute(value="allocatedNotional")
        @RuneAttribute(value="allocatedNotional")
        public List<? extends Money> getAllocatedNotional() {
            return this.allocatedNotional;
        }

        @Override
        @RosettaAttribute(value="allocationContentModel", isRequired=true)
        @RuneAttribute(value="allocationContentModel", isRequired=true)
        public AllocationContentModel getAllocationContentModel() {
            return this.allocationContentModel;
        }

        @Override
        public Allocation build() {
            return this;
        }

        @Override
        public AllocationBuilder toBuilder() {
            AllocationBuilder builder = Allocation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AllocationBuilder builder) {
            Optional.ofNullable(this.getAllocationTradeId()).ifPresent(builder::setAllocationTradeId);
            Optional.ofNullable(this.getPartyAndAccountReferencesModel()).ifPresent(builder::setPartyAndAccountReferencesModel);
            Optional.ofNullable(this.getAllocatedFraction()).ifPresent(builder::setAllocatedFraction);
            Optional.ofNullable(this.getAllocatedNotional()).ifPresent(builder::setAllocatedNotional);
            Optional.ofNullable(this.getAllocationContentModel()).ifPresent(builder::setAllocationContentModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Allocation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.allocationTradeId, _that.getAllocationTradeId())) {
                return false;
            }
            if (!Objects.equals(this.partyAndAccountReferencesModel, _that.getPartyAndAccountReferencesModel())) {
                return false;
            }
            if (!Objects.equals(this.allocatedFraction, _that.getAllocatedFraction())) {
                return false;
            }
            if (!ListEquals.listEquals(this.allocatedNotional, _that.getAllocatedNotional())) {
                return false;
            }
            return Objects.equals(this.allocationContentModel, _that.getAllocationContentModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.allocationTradeId != null ? this.allocationTradeId.hashCode() : 0);
            _result = 31 * _result + (this.partyAndAccountReferencesModel != null ? this.partyAndAccountReferencesModel.hashCode() : 0);
            _result = 31 * _result + (this.allocatedFraction != null ? this.allocatedFraction.hashCode() : 0);
            _result = 31 * _result + (this.allocatedNotional != null ? this.allocatedNotional.hashCode() : 0);
            _result = 31 * _result + (this.allocationContentModel != null ? this.allocationContentModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Allocation {allocationTradeId=" + this.allocationTradeId + ", partyAndAccountReferencesModel=" + this.partyAndAccountReferencesModel + ", allocatedFraction=" + this.allocatedFraction + ", allocatedNotional=" + this.allocatedNotional + ", allocationContentModel=" + this.allocationContentModel + '}';
        }
    }
}

