/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.credit.event.notification;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.credit.event.notification.CreditEventNoticeDocument;
import fpml.consolidated.credit.event.notification.meta.CreditEventNotificationRetractedMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.NonCorrectableRequestMessage;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditEventNotificationRetracted", builder=CreditEventNotificationRetractedBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CreditEventNotificationRetracted", model="fpml", builder=CreditEventNotificationRetractedBuilderImpl.class, version="1.1.0")
public interface CreditEventNotificationRetracted
extends NonCorrectableRequestMessage {
    public static final CreditEventNotificationRetractedMeta metaData = new CreditEventNotificationRetractedMeta();

    public CreditEventNoticeDocument getCreditEventNotice();

    public List<? extends Party> getParty();

    @Override
    public CreditEventNotificationRetracted build();

    @Override
    public CreditEventNotificationRetractedBuilder toBuilder();

    public static CreditEventNotificationRetractedBuilder builder() {
        return new CreditEventNotificationRetractedBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditEventNotificationRetracted> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditEventNotificationRetracted> getType() {
        return CreditEventNotificationRetracted.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEventNotice"), processor, CreditEventNoticeDocument.class, this.getCreditEventNotice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class CreditEventNotificationRetractedBuilderImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilderImpl
    implements CreditEventNotificationRetractedBuilder {
        protected CreditEventNoticeDocument.CreditEventNoticeDocumentBuilder creditEventNotice;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="creditEventNotice")
        @RuneAttribute(value="creditEventNotice")
        public CreditEventNoticeDocument.CreditEventNoticeDocumentBuilder getCreditEventNotice() {
            return this.creditEventNotice;
        }

        @Override
        public CreditEventNoticeDocument.CreditEventNoticeDocumentBuilder getOrCreateCreditEventNotice() {
            CreditEventNoticeDocument.CreditEventNoticeDocumentBuilder result = this.creditEventNotice != null ? this.creditEventNotice : (this.creditEventNotice = CreditEventNoticeDocument.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public CreditEventNotificationRetractedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public CreditEventNotificationRetractedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public CreditEventNotificationRetractedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public CreditEventNotificationRetractedBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public CreditEventNotificationRetractedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public CreditEventNotificationRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public CreditEventNotificationRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEventNotice")
        @RuneAttribute(value="creditEventNotice")
        public CreditEventNotificationRetractedBuilder setCreditEventNotice(CreditEventNoticeDocument _creditEventNotice) {
            this.creditEventNotice = _creditEventNotice == null ? null : _creditEventNotice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public CreditEventNotificationRetractedBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public CreditEventNotificationRetractedBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public CreditEventNotificationRetractedBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public CreditEventNotificationRetractedBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CreditEventNotificationRetracted build() {
            return new CreditEventNotificationRetractedImpl(this);
        }

        @Override
        public CreditEventNotificationRetractedBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditEventNotificationRetractedBuilder prune() {
            super.prune();
            if (this.creditEventNotice != null && !this.creditEventNotice.prune().hasData()) {
                this.creditEventNotice = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCreditEventNotice() != null && this.getCreditEventNotice().hasData()) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public CreditEventNotificationRetractedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CreditEventNotificationRetractedBuilder o = (CreditEventNotificationRetractedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEventNotice(), (RosettaModelObjectBuilder)o.getCreditEventNotice(), this::setCreditEventNotice);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditEventNotificationRetracted _that = (CreditEventNotificationRetracted)this.getType().cast(o);
            if (!Objects.equals(this.creditEventNotice, _that.getCreditEventNotice())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.creditEventNotice != null ? this.creditEventNotice.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditEventNotificationRetractedBuilder {creditEventNotice=" + this.creditEventNotice + ", party=" + this.party + '}' + " " + super.toString();
        }
    }

    public static interface CreditEventNotificationRetractedBuilder
    extends CreditEventNotificationRetracted,
    NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilder {
        public CreditEventNoticeDocument.CreditEventNoticeDocumentBuilder getOrCreateCreditEventNotice();

        @Override
        public CreditEventNoticeDocument.CreditEventNoticeDocumentBuilder getCreditEventNotice();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public CreditEventNotificationRetractedBuilder setFpmlVersion(String var1);

        @Override
        public CreditEventNotificationRetractedBuilder setExpectedBuild(Integer var1);

        @Override
        public CreditEventNotificationRetractedBuilder setActualBuild(Integer var1);

        @Override
        public CreditEventNotificationRetractedBuilder setHeader(RequestMessageHeader var1);

        @Override
        public CreditEventNotificationRetractedBuilder setValidationModel(ValidationModel var1);

        @Override
        public CreditEventNotificationRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public CreditEventNotificationRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public CreditEventNotificationRetractedBuilder setCreditEventNotice(CreditEventNoticeDocument var1);

        public CreditEventNotificationRetractedBuilder addParty(Party var1);

        public CreditEventNotificationRetractedBuilder addParty(Party var1, int var2);

        public CreditEventNotificationRetractedBuilder addParty(List<? extends Party> var1);

        public CreditEventNotificationRetractedBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEventNotice"), processor, CreditEventNoticeDocument.CreditEventNoticeDocumentBuilder.class, this.getCreditEventNotice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public CreditEventNotificationRetractedBuilder prune();
    }

    public static class CreditEventNotificationRetractedImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageImpl
    implements CreditEventNotificationRetracted {
        private final CreditEventNoticeDocument creditEventNotice;
        private final List<? extends Party> party;

        protected CreditEventNotificationRetractedImpl(CreditEventNotificationRetractedBuilder builder) {
            super(builder);
            this.creditEventNotice = Optional.ofNullable(builder.getCreditEventNotice()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="creditEventNotice")
        @RuneAttribute(value="creditEventNotice")
        public CreditEventNoticeDocument getCreditEventNotice() {
            return this.creditEventNotice;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public CreditEventNotificationRetracted build() {
            return this;
        }

        @Override
        public CreditEventNotificationRetractedBuilder toBuilder() {
            CreditEventNotificationRetractedBuilder builder = CreditEventNotificationRetracted.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditEventNotificationRetractedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCreditEventNotice()).ifPresent(builder::setCreditEventNotice);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditEventNotificationRetracted _that = (CreditEventNotificationRetracted)this.getType().cast(o);
            if (!Objects.equals(this.creditEventNotice, _that.getCreditEventNotice())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.creditEventNotice != null ? this.creditEventNotice.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditEventNotificationRetracted {creditEventNotice=" + this.creditEventNotice + ", party=" + this.party + '}' + " " + super.toString();
        }
    }
}

