/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.confirmation.processes.meta.ApprovalStatusNotificationMeta;
import fpml.consolidated.doc.Approvals;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.doc.TradeIdentifier;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.NotificationMessage;
import fpml.consolidated.msg.NotificationMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ApprovalStatusNotification", builder=ApprovalStatusNotificationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ApprovalStatusNotification", model="fpml", builder=ApprovalStatusNotificationBuilderImpl.class, version="1.1.0")
public interface ApprovalStatusNotification
extends NotificationMessage {
    public static final ApprovalStatusNotificationMeta metaData = new ApprovalStatusNotificationMeta();

    public Trade getTrade();

    public TradeIdentifier getTradeIdentifier();

    public Approvals getApprovals();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public ApprovalStatusNotification build();

    @Override
    public ApprovalStatusNotificationBuilder toBuilder();

    public static ApprovalStatusNotificationBuilder builder() {
        return new ApprovalStatusNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends ApprovalStatusNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ApprovalStatusNotification> getType() {
        return ApprovalStatusNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approvals"), processor, Approvals.class, this.getApprovals(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class ApprovalStatusNotificationBuilderImpl
    extends NotificationMessage.NotificationMessageBuilderImpl
    implements ApprovalStatusNotificationBuilder {
        protected Trade.TradeBuilder trade;
        protected TradeIdentifier.TradeIdentifierBuilder tradeIdentifier;
        protected Approvals.ApprovalsBuilder approvals;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public Trade.TradeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade() {
            Trade.TradeBuilder result = this.trade != null ? this.trade : (this.trade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public TradeIdentifier.TradeIdentifierBuilder getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier() {
            TradeIdentifier.TradeIdentifierBuilder result = this.tradeIdentifier != null ? this.tradeIdentifier : (this.tradeIdentifier = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="approvals", isRequired=true)
        @RuneAttribute(value="approvals", isRequired=true)
        public Approvals.ApprovalsBuilder getApprovals() {
            return this.approvals;
        }

        @Override
        public Approvals.ApprovalsBuilder getOrCreateApprovals() {
            Approvals.ApprovalsBuilder result = this.approvals != null ? this.approvals : (this.approvals = Approvals.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ApprovalStatusNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ApprovalStatusNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ApprovalStatusNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ApprovalStatusNotificationBuilder setHeader(NotificationMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ApprovalStatusNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel")
        @RuneAttribute(value="correlationAndOptionalSequenceModel")
        public ApprovalStatusNotificationBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ApprovalStatusNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public ApprovalStatusNotificationBuilder setTrade(Trade _trade) {
            this.trade = _trade == null ? null : _trade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public ApprovalStatusNotificationBuilder setTradeIdentifier(TradeIdentifier _tradeIdentifier) {
            this.tradeIdentifier = _tradeIdentifier == null ? null : _tradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="approvals", isRequired=true)
        @RuneAttribute(value="approvals", isRequired=true)
        public ApprovalStatusNotificationBuilder setApprovals(Approvals _approvals) {
            this.approvals = _approvals == null ? null : _approvals.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ApprovalStatusNotificationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public ApprovalStatusNotification build() {
            return new ApprovalStatusNotificationImpl(this);
        }

        @Override
        public ApprovalStatusNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public ApprovalStatusNotificationBuilder prune() {
            super.prune();
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            if (this.tradeIdentifier != null && !this.tradeIdentifier.prune().hasData()) {
                this.tradeIdentifier = null;
            }
            if (this.approvals != null && !this.approvals.prune().hasData()) {
                this.approvals = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTrade() != null && this.getTrade().hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getApprovals() != null && this.getApprovals().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public ApprovalStatusNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ApprovalStatusNotificationBuilder o = (ApprovalStatusNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeIdentifier(), (RosettaModelObjectBuilder)o.getTradeIdentifier(), this::setTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprovals(), (RosettaModelObjectBuilder)o.getApprovals(), this::setApprovals);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ApprovalStatusNotification _that = (ApprovalStatusNotification)this.getType().cast(o);
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.approvals, _that.getApprovals())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.approvals != null ? this.approvals.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ApprovalStatusNotificationBuilder {trade=" + this.trade + ", tradeIdentifier=" + this.tradeIdentifier + ", approvals=" + this.approvals + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface ApprovalStatusNotificationBuilder
    extends ApprovalStatusNotification,
    NotificationMessage.NotificationMessageBuilder {
        public Trade.TradeBuilder getOrCreateTrade();

        @Override
        public Trade.TradeBuilder getTrade();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateTradeIdentifier();

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getTradeIdentifier();

        public Approvals.ApprovalsBuilder getOrCreateApprovals();

        @Override
        public Approvals.ApprovalsBuilder getApprovals();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public ApprovalStatusNotificationBuilder setFpmlVersion(String var1);

        @Override
        public ApprovalStatusNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public ApprovalStatusNotificationBuilder setActualBuild(Integer var1);

        @Override
        public ApprovalStatusNotificationBuilder setHeader(NotificationMessageHeader var1);

        @Override
        public ApprovalStatusNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public ApprovalStatusNotificationBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ApprovalStatusNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ApprovalStatusNotificationBuilder setTrade(Trade var1);

        public ApprovalStatusNotificationBuilder setTradeIdentifier(TradeIdentifier var1);

        public ApprovalStatusNotificationBuilder setApprovals(Approvals var1);

        public ApprovalStatusNotificationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.NotificationMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approvals"), processor, Approvals.ApprovalsBuilder.class, this.getApprovals(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public ApprovalStatusNotificationBuilder prune();
    }

    public static class ApprovalStatusNotificationImpl
    extends NotificationMessage.NotificationMessageImpl
    implements ApprovalStatusNotification {
        private final Trade trade;
        private final TradeIdentifier tradeIdentifier;
        private final Approvals approvals;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected ApprovalStatusNotificationImpl(ApprovalStatusNotificationBuilder builder) {
            super(builder);
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.approvals = Optional.ofNullable(builder.getApprovals()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="trade")
        @RuneAttribute(value="trade")
        public Trade getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public TradeIdentifier getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="approvals", isRequired=true)
        @RuneAttribute(value="approvals", isRequired=true)
        public Approvals getApprovals() {
            return this.approvals;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public ApprovalStatusNotification build() {
            return this;
        }

        @Override
        public ApprovalStatusNotificationBuilder toBuilder() {
            ApprovalStatusNotificationBuilder builder = ApprovalStatusNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ApprovalStatusNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getApprovals()).ifPresent(builder::setApprovals);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ApprovalStatusNotification _that = (ApprovalStatusNotification)this.getType().cast(o);
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.approvals, _that.getApprovals())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.approvals != null ? this.approvals.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ApprovalStatusNotification {trade=" + this.trade + ", tradeIdentifier=" + this.tradeIdentifier + ", approvals=" + this.approvals + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

