/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.CommodityRelativePaymentDates;
import fpml.consolidated.com.FinancialSwapLeg;
import fpml.consolidated.com.WeatherCalculationPeriodModel;
import fpml.consolidated.com.WeatherIndex;
import fpml.consolidated.com.WeatherIndexData;
import fpml.consolidated.com.WeatherLegCalculation;
import fpml.consolidated.com.meta.WeatherLegMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="WeatherLeg", builder=WeatherLegBuilderImpl.class, version="1.1.0")
@RuneDataType(value="WeatherLeg", model="fpml", builder=WeatherLegBuilderImpl.class, version="1.1.0")
public interface WeatherLeg
extends FinancialSwapLeg {
    public static final WeatherLegMeta metaData = new WeatherLegMeta();

    public WeatherIndex getWeatherIndexLevel();

    public WeatherCalculationPeriodModel getWeatherCalculationPeriodModel();

    public NonNegativeMoney getWeatherNotionalAmount();

    public WeatherLegCalculation getCalculation();

    public CommodityRelativePaymentDates getPaymentDates();

    public WeatherIndexData getWeatherIndexData();

    @Override
    public WeatherLeg build();

    @Override
    public WeatherLegBuilder toBuilder();

    public static WeatherLegBuilder builder() {
        return new WeatherLegBuilderImpl();
    }

    default public RosettaMetaData<? extends WeatherLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends WeatherLeg> getType() {
        return WeatherLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("weatherIndexLevel"), processor, WeatherIndex.class, this.getWeatherIndexLevel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("weatherCalculationPeriodModel"), processor, WeatherCalculationPeriodModel.class, this.getWeatherCalculationPeriodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("weatherNotionalAmount"), processor, NonNegativeMoney.class, this.getWeatherNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculation"), processor, WeatherLegCalculation.class, this.getCalculation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, CommodityRelativePaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("weatherIndexData"), processor, WeatherIndexData.class, this.getWeatherIndexData(), new AttributeMeta[0]);
    }

    public static class WeatherLegBuilderImpl
    extends FinancialSwapLeg.FinancialSwapLegBuilderImpl
    implements WeatherLegBuilder {
        protected WeatherIndex.WeatherIndexBuilder weatherIndexLevel;
        protected WeatherCalculationPeriodModel.WeatherCalculationPeriodModelBuilder weatherCalculationPeriodModel;
        protected NonNegativeMoney.NonNegativeMoneyBuilder weatherNotionalAmount;
        protected WeatherLegCalculation.WeatherLegCalculationBuilder calculation;
        protected CommodityRelativePaymentDates.CommodityRelativePaymentDatesBuilder paymentDates;
        protected WeatherIndexData.WeatherIndexDataBuilder weatherIndexData;

        @Override
        @RosettaAttribute(value="weatherIndexLevel", isRequired=true)
        @RuneAttribute(value="weatherIndexLevel", isRequired=true)
        public WeatherIndex.WeatherIndexBuilder getWeatherIndexLevel() {
            return this.weatherIndexLevel;
        }

        @Override
        public WeatherIndex.WeatherIndexBuilder getOrCreateWeatherIndexLevel() {
            WeatherIndex.WeatherIndexBuilder result = this.weatherIndexLevel != null ? this.weatherIndexLevel : (this.weatherIndexLevel = WeatherIndex.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="weatherCalculationPeriodModel", isRequired=true)
        @RuneAttribute(value="weatherCalculationPeriodModel", isRequired=true)
        public WeatherCalculationPeriodModel.WeatherCalculationPeriodModelBuilder getWeatherCalculationPeriodModel() {
            return this.weatherCalculationPeriodModel;
        }

        @Override
        public WeatherCalculationPeriodModel.WeatherCalculationPeriodModelBuilder getOrCreateWeatherCalculationPeriodModel() {
            WeatherCalculationPeriodModel.WeatherCalculationPeriodModelBuilder result = this.weatherCalculationPeriodModel != null ? this.weatherCalculationPeriodModel : (this.weatherCalculationPeriodModel = WeatherCalculationPeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="weatherNotionalAmount", isRequired=true)
        @RuneAttribute(value="weatherNotionalAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getWeatherNotionalAmount() {
            return this.weatherNotionalAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateWeatherNotionalAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.weatherNotionalAmount != null ? this.weatherNotionalAmount : (this.weatherNotionalAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculation", isRequired=true)
        @RuneAttribute(value="calculation", isRequired=true)
        public WeatherLegCalculation.WeatherLegCalculationBuilder getCalculation() {
            return this.calculation;
        }

        @Override
        public WeatherLegCalculation.WeatherLegCalculationBuilder getOrCreateCalculation() {
            WeatherLegCalculation.WeatherLegCalculationBuilder result = this.calculation != null ? this.calculation : (this.calculation = WeatherLegCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public CommodityRelativePaymentDates.CommodityRelativePaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public CommodityRelativePaymentDates.CommodityRelativePaymentDatesBuilder getOrCreatePaymentDates() {
            CommodityRelativePaymentDates.CommodityRelativePaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = CommodityRelativePaymentDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="weatherIndexData")
        @RuneAttribute(value="weatherIndexData")
        public WeatherIndexData.WeatherIndexDataBuilder getWeatherIndexData() {
            return this.weatherIndexData;
        }

        @Override
        public WeatherIndexData.WeatherIndexDataBuilder getOrCreateWeatherIndexData() {
            WeatherIndexData.WeatherIndexDataBuilder result = this.weatherIndexData != null ? this.weatherIndexData : (this.weatherIndexData = WeatherIndexData.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public WeatherLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public WeatherLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="weatherIndexLevel", isRequired=true)
        @RuneAttribute(value="weatherIndexLevel", isRequired=true)
        public WeatherLegBuilder setWeatherIndexLevel(WeatherIndex _weatherIndexLevel) {
            this.weatherIndexLevel = _weatherIndexLevel == null ? null : _weatherIndexLevel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="weatherCalculationPeriodModel", isRequired=true)
        @RuneAttribute(value="weatherCalculationPeriodModel", isRequired=true)
        public WeatherLegBuilder setWeatherCalculationPeriodModel(WeatherCalculationPeriodModel _weatherCalculationPeriodModel) {
            this.weatherCalculationPeriodModel = _weatherCalculationPeriodModel == null ? null : _weatherCalculationPeriodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="weatherNotionalAmount", isRequired=true)
        @RuneAttribute(value="weatherNotionalAmount", isRequired=true)
        public WeatherLegBuilder setWeatherNotionalAmount(NonNegativeMoney _weatherNotionalAmount) {
            this.weatherNotionalAmount = _weatherNotionalAmount == null ? null : _weatherNotionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculation", isRequired=true)
        @RuneAttribute(value="calculation", isRequired=true)
        public WeatherLegBuilder setCalculation(WeatherLegCalculation _calculation) {
            this.calculation = _calculation == null ? null : _calculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public WeatherLegBuilder setPaymentDates(CommodityRelativePaymentDates _paymentDates) {
            this.paymentDates = _paymentDates == null ? null : _paymentDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="weatherIndexData")
        @RuneAttribute(value="weatherIndexData")
        public WeatherLegBuilder setWeatherIndexData(WeatherIndexData _weatherIndexData) {
            this.weatherIndexData = _weatherIndexData == null ? null : _weatherIndexData.toBuilder();
            return this;
        }

        @Override
        public WeatherLeg build() {
            return new WeatherLegImpl(this);
        }

        @Override
        public WeatherLegBuilder toBuilder() {
            return this;
        }

        @Override
        public WeatherLegBuilder prune() {
            super.prune();
            if (this.weatherIndexLevel != null && !this.weatherIndexLevel.prune().hasData()) {
                this.weatherIndexLevel = null;
            }
            if (this.weatherCalculationPeriodModel != null && !this.weatherCalculationPeriodModel.prune().hasData()) {
                this.weatherCalculationPeriodModel = null;
            }
            if (this.weatherNotionalAmount != null && !this.weatherNotionalAmount.prune().hasData()) {
                this.weatherNotionalAmount = null;
            }
            if (this.calculation != null && !this.calculation.prune().hasData()) {
                this.calculation = null;
            }
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.weatherIndexData != null && !this.weatherIndexData.prune().hasData()) {
                this.weatherIndexData = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getWeatherIndexLevel() != null && this.getWeatherIndexLevel().hasData()) {
                return true;
            }
            if (this.getWeatherCalculationPeriodModel() != null && this.getWeatherCalculationPeriodModel().hasData()) {
                return true;
            }
            if (this.getWeatherNotionalAmount() != null && this.getWeatherNotionalAmount().hasData()) {
                return true;
            }
            if (this.getCalculation() != null && this.getCalculation().hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            return this.getWeatherIndexData() != null && this.getWeatherIndexData().hasData();
        }

        @Override
        public WeatherLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            WeatherLegBuilder o = (WeatherLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWeatherIndexLevel(), (RosettaModelObjectBuilder)o.getWeatherIndexLevel(), this::setWeatherIndexLevel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWeatherCalculationPeriodModel(), (RosettaModelObjectBuilder)o.getWeatherCalculationPeriodModel(), this::setWeatherCalculationPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWeatherNotionalAmount(), (RosettaModelObjectBuilder)o.getWeatherNotionalAmount(), this::setWeatherNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculation(), (RosettaModelObjectBuilder)o.getCalculation(), this::setCalculation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWeatherIndexData(), (RosettaModelObjectBuilder)o.getWeatherIndexData(), this::setWeatherIndexData);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            WeatherLeg _that = (WeatherLeg)this.getType().cast(o);
            if (!Objects.equals(this.weatherIndexLevel, _that.getWeatherIndexLevel())) {
                return false;
            }
            if (!Objects.equals(this.weatherCalculationPeriodModel, _that.getWeatherCalculationPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.weatherNotionalAmount, _that.getWeatherNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.calculation, _that.getCalculation())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            return Objects.equals(this.weatherIndexData, _that.getWeatherIndexData());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.weatherIndexLevel != null ? this.weatherIndexLevel.hashCode() : 0);
            _result = 31 * _result + (this.weatherCalculationPeriodModel != null ? this.weatherCalculationPeriodModel.hashCode() : 0);
            _result = 31 * _result + (this.weatherNotionalAmount != null ? this.weatherNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.calculation != null ? this.calculation.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.weatherIndexData != null ? this.weatherIndexData.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "WeatherLegBuilder {weatherIndexLevel=" + this.weatherIndexLevel + ", weatherCalculationPeriodModel=" + this.weatherCalculationPeriodModel + ", weatherNotionalAmount=" + this.weatherNotionalAmount + ", calculation=" + this.calculation + ", paymentDates=" + this.paymentDates + ", weatherIndexData=" + this.weatherIndexData + '}' + " " + super.toString();
        }
    }

    public static interface WeatherLegBuilder
    extends WeatherLeg,
    FinancialSwapLeg.FinancialSwapLegBuilder {
        public WeatherIndex.WeatherIndexBuilder getOrCreateWeatherIndexLevel();

        @Override
        public WeatherIndex.WeatherIndexBuilder getWeatherIndexLevel();

        public WeatherCalculationPeriodModel.WeatherCalculationPeriodModelBuilder getOrCreateWeatherCalculationPeriodModel();

        @Override
        public WeatherCalculationPeriodModel.WeatherCalculationPeriodModelBuilder getWeatherCalculationPeriodModel();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateWeatherNotionalAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getWeatherNotionalAmount();

        public WeatherLegCalculation.WeatherLegCalculationBuilder getOrCreateCalculation();

        @Override
        public WeatherLegCalculation.WeatherLegCalculationBuilder getCalculation();

        public CommodityRelativePaymentDates.CommodityRelativePaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public CommodityRelativePaymentDates.CommodityRelativePaymentDatesBuilder getPaymentDates();

        public WeatherIndexData.WeatherIndexDataBuilder getOrCreateWeatherIndexData();

        @Override
        public WeatherIndexData.WeatherIndexDataBuilder getWeatherIndexData();

        @Override
        public WeatherLegBuilder setId(String var1);

        @Override
        public WeatherLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public WeatherLegBuilder setWeatherIndexLevel(WeatherIndex var1);

        public WeatherLegBuilder setWeatherCalculationPeriodModel(WeatherCalculationPeriodModel var1);

        public WeatherLegBuilder setWeatherNotionalAmount(NonNegativeMoney var1);

        public WeatherLegBuilder setCalculation(WeatherLegCalculation var1);

        public WeatherLegBuilder setPaymentDates(CommodityRelativePaymentDates var1);

        public WeatherLegBuilder setWeatherIndexData(WeatherIndexData var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("weatherIndexLevel"), processor, WeatherIndex.WeatherIndexBuilder.class, this.getWeatherIndexLevel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("weatherCalculationPeriodModel"), processor, WeatherCalculationPeriodModel.WeatherCalculationPeriodModelBuilder.class, this.getWeatherCalculationPeriodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("weatherNotionalAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getWeatherNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculation"), processor, WeatherLegCalculation.WeatherLegCalculationBuilder.class, this.getCalculation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, CommodityRelativePaymentDates.CommodityRelativePaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("weatherIndexData"), processor, WeatherIndexData.WeatherIndexDataBuilder.class, this.getWeatherIndexData(), new AttributeMeta[0]);
        }

        @Override
        public WeatherLegBuilder prune();
    }

    public static class WeatherLegImpl
    extends FinancialSwapLeg.FinancialSwapLegImpl
    implements WeatherLeg {
        private final WeatherIndex weatherIndexLevel;
        private final WeatherCalculationPeriodModel weatherCalculationPeriodModel;
        private final NonNegativeMoney weatherNotionalAmount;
        private final WeatherLegCalculation calculation;
        private final CommodityRelativePaymentDates paymentDates;
        private final WeatherIndexData weatherIndexData;

        protected WeatherLegImpl(WeatherLegBuilder builder) {
            super(builder);
            this.weatherIndexLevel = Optional.ofNullable(builder.getWeatherIndexLevel()).map(f -> f.build()).orElse(null);
            this.weatherCalculationPeriodModel = Optional.ofNullable(builder.getWeatherCalculationPeriodModel()).map(f -> f.build()).orElse(null);
            this.weatherNotionalAmount = Optional.ofNullable(builder.getWeatherNotionalAmount()).map(f -> f.build()).orElse(null);
            this.calculation = Optional.ofNullable(builder.getCalculation()).map(f -> f.build()).orElse(null);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.weatherIndexData = Optional.ofNullable(builder.getWeatherIndexData()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="weatherIndexLevel", isRequired=true)
        @RuneAttribute(value="weatherIndexLevel", isRequired=true)
        public WeatherIndex getWeatherIndexLevel() {
            return this.weatherIndexLevel;
        }

        @Override
        @RosettaAttribute(value="weatherCalculationPeriodModel", isRequired=true)
        @RuneAttribute(value="weatherCalculationPeriodModel", isRequired=true)
        public WeatherCalculationPeriodModel getWeatherCalculationPeriodModel() {
            return this.weatherCalculationPeriodModel;
        }

        @Override
        @RosettaAttribute(value="weatherNotionalAmount", isRequired=true)
        @RuneAttribute(value="weatherNotionalAmount", isRequired=true)
        public NonNegativeMoney getWeatherNotionalAmount() {
            return this.weatherNotionalAmount;
        }

        @Override
        @RosettaAttribute(value="calculation", isRequired=true)
        @RuneAttribute(value="calculation", isRequired=true)
        public WeatherLegCalculation getCalculation() {
            return this.calculation;
        }

        @Override
        @RosettaAttribute(value="paymentDates")
        @RuneAttribute(value="paymentDates")
        public CommodityRelativePaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        @RosettaAttribute(value="weatherIndexData")
        @RuneAttribute(value="weatherIndexData")
        public WeatherIndexData getWeatherIndexData() {
            return this.weatherIndexData;
        }

        @Override
        public WeatherLeg build() {
            return this;
        }

        @Override
        public WeatherLegBuilder toBuilder() {
            WeatherLegBuilder builder = WeatherLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(WeatherLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getWeatherIndexLevel()).ifPresent(builder::setWeatherIndexLevel);
            Optional.ofNullable(this.getWeatherCalculationPeriodModel()).ifPresent(builder::setWeatherCalculationPeriodModel);
            Optional.ofNullable(this.getWeatherNotionalAmount()).ifPresent(builder::setWeatherNotionalAmount);
            Optional.ofNullable(this.getCalculation()).ifPresent(builder::setCalculation);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getWeatherIndexData()).ifPresent(builder::setWeatherIndexData);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            WeatherLeg _that = (WeatherLeg)this.getType().cast(o);
            if (!Objects.equals(this.weatherIndexLevel, _that.getWeatherIndexLevel())) {
                return false;
            }
            if (!Objects.equals(this.weatherCalculationPeriodModel, _that.getWeatherCalculationPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.weatherNotionalAmount, _that.getWeatherNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.calculation, _that.getCalculation())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            return Objects.equals(this.weatherIndexData, _that.getWeatherIndexData());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.weatherIndexLevel != null ? this.weatherIndexLevel.hashCode() : 0);
            _result = 31 * _result + (this.weatherCalculationPeriodModel != null ? this.weatherCalculationPeriodModel.hashCode() : 0);
            _result = 31 * _result + (this.weatherNotionalAmount != null ? this.weatherNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.calculation != null ? this.calculation.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.weatherIndexData != null ? this.weatherIndexData.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "WeatherLeg {weatherIndexLevel=" + this.weatherIndexLevel + ", weatherCalculationPeriodModel=" + this.weatherCalculationPeriodModel + ", weatherNotionalAmount=" + this.weatherNotionalAmount + ", calculation=" + this.calculation + ", paymentDates=" + this.paymentDates + ", weatherIndexData=" + this.weatherIndexData + '}' + " " + super.toString();
        }
    }
}

