/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CommodityClassification;
import fpml.consolidated.com.CommodityDeliveryPeriods;
import fpml.consolidated.com.CommodityFixedPhysicalQuantityModel;
import fpml.consolidated.com.Metal;
import fpml.consolidated.com.MetalDelivery;
import fpml.consolidated.com.PhysicalForwardLeg;
import fpml.consolidated.com.meta.MetalPhysicalLegMeta;
import fpml.consolidated.shared.PayerReceiverModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MetalPhysicalLeg", builder=MetalPhysicalLegBuilderImpl.class, version="1.1.0")
@RuneDataType(value="MetalPhysicalLeg", model="fpml", builder=MetalPhysicalLegBuilderImpl.class, version="1.1.0")
public interface MetalPhysicalLeg
extends PhysicalForwardLeg {
    public static final MetalPhysicalLegMeta metaData = new MetalPhysicalLegMeta();

    public Metal getMetal();

    public CommodityDeliveryPeriods getDeliveryPeriods();

    public MetalDelivery getDeliveryConditions();

    public CommodityFixedPhysicalQuantityModel getCommodityFixedPhysicalQuantityModel();

    public BigDecimal getConversionFactor();

    @Override
    public MetalPhysicalLeg build();

    @Override
    public MetalPhysicalLegBuilder toBuilder();

    public static MetalPhysicalLegBuilder builder() {
        return new MetalPhysicalLegBuilderImpl();
    }

    default public RosettaMetaData<? extends MetalPhysicalLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MetalPhysicalLeg> getType() {
        return MetalPhysicalLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("metal"), processor, Metal.class, this.getMetal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryPeriods"), processor, CommodityDeliveryPeriods.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryConditions"), processor, MetalDelivery.class, this.getDeliveryConditions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityFixedPhysicalQuantityModel"), processor, CommodityFixedPhysicalQuantityModel.class, this.getCommodityFixedPhysicalQuantityModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MetalPhysicalLegBuilderImpl
    extends PhysicalForwardLeg.PhysicalForwardLegBuilderImpl
    implements MetalPhysicalLegBuilder {
        protected Metal.MetalBuilder metal;
        protected CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder deliveryPeriods;
        protected MetalDelivery.MetalDeliveryBuilder deliveryConditions;
        protected CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder commodityFixedPhysicalQuantityModel;
        protected BigDecimal conversionFactor;

        @Override
        @RosettaAttribute(value="metal")
        @RuneAttribute(value="metal")
        public Metal.MetalBuilder getMetal() {
            return this.metal;
        }

        @Override
        public Metal.MetalBuilder getOrCreateMetal() {
            Metal.MetalBuilder result = this.metal != null ? this.metal : (this.metal = Metal.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods")
        @RuneAttribute(value="deliveryPeriods")
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getOrCreateDeliveryPeriods() {
            CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder result = this.deliveryPeriods != null ? this.deliveryPeriods : (this.deliveryPeriods = CommodityDeliveryPeriods.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public MetalDelivery.MetalDeliveryBuilder getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        public MetalDelivery.MetalDeliveryBuilder getOrCreateDeliveryConditions() {
            MetalDelivery.MetalDeliveryBuilder result = this.deliveryConditions != null ? this.deliveryConditions : (this.deliveryConditions = MetalDelivery.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        @RuneAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        public CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder getCommodityFixedPhysicalQuantityModel() {
            return this.commodityFixedPhysicalQuantityModel;
        }

        @Override
        public CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder getOrCreateCommodityFixedPhysicalQuantityModel() {
            CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder result = this.commodityFixedPhysicalQuantityModel != null ? this.commodityFixedPhysicalQuantityModel : (this.commodityFixedPhysicalQuantityModel = CommodityFixedPhysicalQuantityModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public MetalPhysicalLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public MetalPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public MetalPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public MetalPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public MetalPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public MetalPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="metal")
        @RuneAttribute(value="metal")
        public MetalPhysicalLegBuilder setMetal(Metal _metal) {
            this.metal = _metal == null ? null : _metal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods")
        @RuneAttribute(value="deliveryPeriods")
        public MetalPhysicalLegBuilder setDeliveryPeriods(CommodityDeliveryPeriods _deliveryPeriods) {
            this.deliveryPeriods = _deliveryPeriods == null ? null : _deliveryPeriods.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public MetalPhysicalLegBuilder setDeliveryConditions(MetalDelivery _deliveryConditions) {
            this.deliveryConditions = _deliveryConditions == null ? null : _deliveryConditions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        @RuneAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        public MetalPhysicalLegBuilder setCommodityFixedPhysicalQuantityModel(CommodityFixedPhysicalQuantityModel _commodityFixedPhysicalQuantityModel) {
            this.commodityFixedPhysicalQuantityModel = _commodityFixedPhysicalQuantityModel == null ? null : _commodityFixedPhysicalQuantityModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public MetalPhysicalLegBuilder setConversionFactor(BigDecimal _conversionFactor) {
            this.conversionFactor = _conversionFactor == null ? null : _conversionFactor;
            return this;
        }

        @Override
        public MetalPhysicalLeg build() {
            return new MetalPhysicalLegImpl(this);
        }

        @Override
        public MetalPhysicalLegBuilder toBuilder() {
            return this;
        }

        @Override
        public MetalPhysicalLegBuilder prune() {
            super.prune();
            if (this.metal != null && !this.metal.prune().hasData()) {
                this.metal = null;
            }
            if (this.deliveryPeriods != null && !this.deliveryPeriods.prune().hasData()) {
                this.deliveryPeriods = null;
            }
            if (this.deliveryConditions != null && !this.deliveryConditions.prune().hasData()) {
                this.deliveryConditions = null;
            }
            if (this.commodityFixedPhysicalQuantityModel != null && !this.commodityFixedPhysicalQuantityModel.prune().hasData()) {
                this.commodityFixedPhysicalQuantityModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getMetal() != null && this.getMetal().hasData()) {
                return true;
            }
            if (this.getDeliveryPeriods() != null && this.getDeliveryPeriods().hasData()) {
                return true;
            }
            if (this.getDeliveryConditions() != null && this.getDeliveryConditions().hasData()) {
                return true;
            }
            if (this.getCommodityFixedPhysicalQuantityModel() != null && this.getCommodityFixedPhysicalQuantityModel().hasData()) {
                return true;
            }
            return this.getConversionFactor() != null;
        }

        @Override
        public MetalPhysicalLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MetalPhysicalLegBuilder o = (MetalPhysicalLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMetal(), (RosettaModelObjectBuilder)o.getMetal(), this::setMetal);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryPeriods(), (RosettaModelObjectBuilder)o.getDeliveryPeriods(), this::setDeliveryPeriods);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryConditions(), (RosettaModelObjectBuilder)o.getDeliveryConditions(), this::setDeliveryConditions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityFixedPhysicalQuantityModel(), (RosettaModelObjectBuilder)o.getCommodityFixedPhysicalQuantityModel(), this::setCommodityFixedPhysicalQuantityModel);
            merger.mergeBasic((Object)this.getConversionFactor(), (Object)o.getConversionFactor(), this::setConversionFactor, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MetalPhysicalLeg _that = (MetalPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.metal, _that.getMetal())) {
                return false;
            }
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            if (!Objects.equals(this.commodityFixedPhysicalQuantityModel, _that.getCommodityFixedPhysicalQuantityModel())) {
                return false;
            }
            return Objects.equals(this.conversionFactor, _that.getConversionFactor());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.metal != null ? this.metal.hashCode() : 0);
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.commodityFixedPhysicalQuantityModel != null ? this.commodityFixedPhysicalQuantityModel.hashCode() : 0);
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MetalPhysicalLegBuilder {metal=" + this.metal + ", deliveryPeriods=" + this.deliveryPeriods + ", deliveryConditions=" + this.deliveryConditions + ", commodityFixedPhysicalQuantityModel=" + this.commodityFixedPhysicalQuantityModel + ", conversionFactor=" + this.conversionFactor + '}' + " " + super.toString();
        }
    }

    public static interface MetalPhysicalLegBuilder
    extends MetalPhysicalLeg,
    PhysicalForwardLeg.PhysicalForwardLegBuilder {
        public Metal.MetalBuilder getOrCreateMetal();

        @Override
        public Metal.MetalBuilder getMetal();

        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getOrCreateDeliveryPeriods();

        @Override
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getDeliveryPeriods();

        public MetalDelivery.MetalDeliveryBuilder getOrCreateDeliveryConditions();

        @Override
        public MetalDelivery.MetalDeliveryBuilder getDeliveryConditions();

        public CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder getOrCreateCommodityFixedPhysicalQuantityModel();

        @Override
        public CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder getCommodityFixedPhysicalQuantityModel();

        @Override
        public MetalPhysicalLegBuilder setId(String var1);

        @Override
        public MetalPhysicalLegBuilder addCommodityClassification(CommodityClassification var1);

        @Override
        public MetalPhysicalLegBuilder addCommodityClassification(CommodityClassification var1, int var2);

        @Override
        public MetalPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public MetalPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public MetalPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public MetalPhysicalLegBuilder setMetal(Metal var1);

        public MetalPhysicalLegBuilder setDeliveryPeriods(CommodityDeliveryPeriods var1);

        public MetalPhysicalLegBuilder setDeliveryConditions(MetalDelivery var1);

        public MetalPhysicalLegBuilder setCommodityFixedPhysicalQuantityModel(CommodityFixedPhysicalQuantityModel var1);

        public MetalPhysicalLegBuilder setConversionFactor(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("metal"), processor, Metal.MetalBuilder.class, this.getMetal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryPeriods"), processor, CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryConditions"), processor, MetalDelivery.MetalDeliveryBuilder.class, this.getDeliveryConditions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityFixedPhysicalQuantityModel"), processor, CommodityFixedPhysicalQuantityModel.CommodityFixedPhysicalQuantityModelBuilder.class, this.getCommodityFixedPhysicalQuantityModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public MetalPhysicalLegBuilder prune();
    }

    public static class MetalPhysicalLegImpl
    extends PhysicalForwardLeg.PhysicalForwardLegImpl
    implements MetalPhysicalLeg {
        private final Metal metal;
        private final CommodityDeliveryPeriods deliveryPeriods;
        private final MetalDelivery deliveryConditions;
        private final CommodityFixedPhysicalQuantityModel commodityFixedPhysicalQuantityModel;
        private final BigDecimal conversionFactor;

        protected MetalPhysicalLegImpl(MetalPhysicalLegBuilder builder) {
            super(builder);
            this.metal = Optional.ofNullable(builder.getMetal()).map(f -> f.build()).orElse(null);
            this.deliveryPeriods = Optional.ofNullable(builder.getDeliveryPeriods()).map(f -> f.build()).orElse(null);
            this.deliveryConditions = Optional.ofNullable(builder.getDeliveryConditions()).map(f -> f.build()).orElse(null);
            this.commodityFixedPhysicalQuantityModel = Optional.ofNullable(builder.getCommodityFixedPhysicalQuantityModel()).map(f -> f.build()).orElse(null);
            this.conversionFactor = builder.getConversionFactor();
        }

        @Override
        @RosettaAttribute(value="metal")
        @RuneAttribute(value="metal")
        public Metal getMetal() {
            return this.metal;
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods")
        @RuneAttribute(value="deliveryPeriods")
        public CommodityDeliveryPeriods getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions")
        @RuneAttribute(value="deliveryConditions")
        public MetalDelivery getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        @RosettaAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        @RuneAttribute(value="commodityFixedPhysicalQuantityModel", isRequired=true)
        public CommodityFixedPhysicalQuantityModel getCommodityFixedPhysicalQuantityModel() {
            return this.commodityFixedPhysicalQuantityModel;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        public MetalPhysicalLeg build() {
            return this;
        }

        @Override
        public MetalPhysicalLegBuilder toBuilder() {
            MetalPhysicalLegBuilder builder = MetalPhysicalLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MetalPhysicalLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getMetal()).ifPresent(builder::setMetal);
            Optional.ofNullable(this.getDeliveryPeriods()).ifPresent(builder::setDeliveryPeriods);
            Optional.ofNullable(this.getDeliveryConditions()).ifPresent(builder::setDeliveryConditions);
            Optional.ofNullable(this.getCommodityFixedPhysicalQuantityModel()).ifPresent(builder::setCommodityFixedPhysicalQuantityModel);
            Optional.ofNullable(this.getConversionFactor()).ifPresent(builder::setConversionFactor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MetalPhysicalLeg _that = (MetalPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.metal, _that.getMetal())) {
                return false;
            }
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            if (!Objects.equals(this.commodityFixedPhysicalQuantityModel, _that.getCommodityFixedPhysicalQuantityModel())) {
                return false;
            }
            return Objects.equals(this.conversionFactor, _that.getConversionFactor());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.metal != null ? this.metal.hashCode() : 0);
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.commodityFixedPhysicalQuantityModel != null ? this.commodityFixedPhysicalQuantityModel.hashCode() : 0);
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MetalPhysicalLeg {metal=" + this.metal + ", deliveryPeriods=" + this.deliveryPeriods + ", deliveryConditions=" + this.deliveryConditions + ", commodityFixedPhysicalQuantityModel=" + this.commodityFixedPhysicalQuantityModel + ", conversionFactor=" + this.conversionFactor + '}' + " " + super.toString();
        }
    }
}

