/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.com.CommodityFx;
import fpml.consolidated.com.CommodityPricingDates;
import fpml.consolidated.com.CommoditySpread;
import fpml.consolidated.com.CommoditySpreadSchedule;
import fpml.consolidated.com.meta.FloatingLegCalculationMeta;
import fpml.consolidated.fpmlenum.AveragingMethodEnum;
import fpml.consolidated.shared.Rounding;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FloatingLegCalculation", builder=FloatingLegCalculationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FloatingLegCalculation", model="fpml", builder=FloatingLegCalculationBuilderImpl.class, version="1.1.0")
public interface FloatingLegCalculation
extends RosettaModelObject {
    public static final FloatingLegCalculationMeta metaData = new FloatingLegCalculationMeta();

    public CommodityPricingDates getPricingDates();

    public AveragingMethodEnum getAveragingMethod();

    public BigDecimal getConversionFactor();

    public Rounding getRounding();

    public CommoditySpread getSpread();

    public List<? extends CommoditySpreadSchedule> getSpreadSchedule();

    public BigDecimal getSpreadPercentage();

    public CommodityFx getFx();

    public FloatingLegCalculation build();

    public FloatingLegCalculationBuilder toBuilder();

    public static FloatingLegCalculationBuilder builder() {
        return new FloatingLegCalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingLegCalculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingLegCalculation> getType() {
        return FloatingLegCalculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.class, this.getPricingDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, CommoditySpread.class, this.getSpread(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadSchedule"), processor, CommoditySpreadSchedule.class, this.getSpreadSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadPercentage"), BigDecimal.class, (Object)this.getSpreadPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fx"), processor, CommodityFx.class, this.getFx(), new AttributeMeta[0]);
    }

    public static class FloatingLegCalculationBuilderImpl
    implements FloatingLegCalculationBuilder {
        protected CommodityPricingDates.CommodityPricingDatesBuilder pricingDates;
        protected AveragingMethodEnum averagingMethod;
        protected BigDecimal conversionFactor;
        protected Rounding.RoundingBuilder rounding;
        protected CommoditySpread.CommoditySpreadBuilder spread;
        protected List<CommoditySpreadSchedule.CommoditySpreadScheduleBuilder> spreadSchedule = new ArrayList<CommoditySpreadSchedule.CommoditySpreadScheduleBuilder>();
        protected BigDecimal spreadPercentage;
        protected CommodityFx.CommodityFxBuilder fx;

        @Override
        @RosettaAttribute(value="pricingDates", isRequired=true)
        @RuneAttribute(value="pricingDates", isRequired=true)
        public CommodityPricingDates.CommodityPricingDatesBuilder getPricingDates() {
            return this.pricingDates;
        }

        @Override
        public CommodityPricingDates.CommodityPricingDatesBuilder getOrCreatePricingDates() {
            CommodityPricingDates.CommodityPricingDatesBuilder result = this.pricingDates != null ? this.pricingDates : (this.pricingDates = CommodityPricingDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public CommoditySpread.CommoditySpreadBuilder getSpread() {
            return this.spread;
        }

        @Override
        public CommoditySpread.CommoditySpreadBuilder getOrCreateSpread() {
            CommoditySpread.CommoditySpreadBuilder result = this.spread != null ? this.spread : (this.spread = CommoditySpread.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public List<? extends CommoditySpreadSchedule.CommoditySpreadScheduleBuilder> getSpreadSchedule() {
            return this.spreadSchedule;
        }

        @Override
        public CommoditySpreadSchedule.CommoditySpreadScheduleBuilder getOrCreateSpreadSchedule(int index) {
            if (this.spreadSchedule == null) {
                this.spreadSchedule = new ArrayList<CommoditySpreadSchedule.CommoditySpreadScheduleBuilder>();
            }
            return (CommoditySpreadSchedule.CommoditySpreadScheduleBuilder)this.getIndex(this.spreadSchedule, index, () -> {
                CommoditySpreadSchedule.CommoditySpreadScheduleBuilder newSpreadSchedule = CommoditySpreadSchedule.builder();
                return newSpreadSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="spreadPercentage")
        @RuneAttribute(value="spreadPercentage")
        public BigDecimal getSpreadPercentage() {
            return this.spreadPercentage;
        }

        @Override
        @RosettaAttribute(value="fx")
        @RuneAttribute(value="fx")
        public CommodityFx.CommodityFxBuilder getFx() {
            return this.fx;
        }

        @Override
        public CommodityFx.CommodityFxBuilder getOrCreateFx() {
            CommodityFx.CommodityFxBuilder result = this.fx != null ? this.fx : (this.fx = CommodityFx.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingDates", isRequired=true)
        @RuneAttribute(value="pricingDates", isRequired=true)
        public FloatingLegCalculationBuilder setPricingDates(CommodityPricingDates _pricingDates) {
            this.pricingDates = _pricingDates == null ? null : _pricingDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public FloatingLegCalculationBuilder setAveragingMethod(AveragingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public FloatingLegCalculationBuilder setConversionFactor(BigDecimal _conversionFactor) {
            this.conversionFactor = _conversionFactor == null ? null : _conversionFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public FloatingLegCalculationBuilder setRounding(Rounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public FloatingLegCalculationBuilder setSpread(CommoditySpread _spread) {
            this.spread = _spread == null ? null : _spread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public FloatingLegCalculationBuilder addSpreadSchedule(CommoditySpreadSchedule _spreadSchedule) {
            if (_spreadSchedule != null) {
                this.spreadSchedule.add(_spreadSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingLegCalculationBuilder addSpreadSchedule(CommoditySpreadSchedule _spreadSchedule, int idx) {
            this.getIndex(this.spreadSchedule, idx, () -> _spreadSchedule.toBuilder());
            return this;
        }

        @Override
        public FloatingLegCalculationBuilder addSpreadSchedule(List<? extends CommoditySpreadSchedule> spreadSchedules) {
            if (spreadSchedules != null) {
                for (CommoditySpreadSchedule commoditySpreadSchedule : spreadSchedules) {
                    this.spreadSchedule.add(commoditySpreadSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="spreadSchedule")
        public FloatingLegCalculationBuilder setSpreadSchedule(List<? extends CommoditySpreadSchedule> spreadSchedules) {
            this.spreadSchedule = spreadSchedules == null ? new ArrayList<CommoditySpreadSchedule.CommoditySpreadScheduleBuilder>() : (List)spreadSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadPercentage")
        @RuneAttribute(value="spreadPercentage")
        public FloatingLegCalculationBuilder setSpreadPercentage(BigDecimal _spreadPercentage) {
            this.spreadPercentage = _spreadPercentage == null ? null : _spreadPercentage;
            return this;
        }

        @Override
        @RosettaAttribute(value="fx")
        @RuneAttribute(value="fx")
        public FloatingLegCalculationBuilder setFx(CommodityFx _fx) {
            this.fx = _fx == null ? null : _fx.toBuilder();
            return this;
        }

        @Override
        public FloatingLegCalculation build() {
            return new FloatingLegCalculationImpl(this);
        }

        @Override
        public FloatingLegCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingLegCalculationBuilder prune() {
            if (this.pricingDates != null && !this.pricingDates.prune().hasData()) {
                this.pricingDates = null;
            }
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            if (this.spread != null && !this.spread.prune().hasData()) {
                this.spread = null;
            }
            this.spreadSchedule = this.spreadSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fx != null && !this.fx.prune().hasData()) {
                this.fx = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPricingDates() != null && this.getPricingDates().hasData()) {
                return true;
            }
            if (this.getAveragingMethod() != null) {
                return true;
            }
            if (this.getConversionFactor() != null) {
                return true;
            }
            if (this.getRounding() != null && this.getRounding().hasData()) {
                return true;
            }
            if (this.getSpread() != null && this.getSpread().hasData()) {
                return true;
            }
            if (this.getSpreadSchedule() != null && this.getSpreadSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSpreadPercentage() != null) {
                return true;
            }
            return this.getFx() != null && this.getFx().hasData();
        }

        public FloatingLegCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingLegCalculationBuilder o = (FloatingLegCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingDates(), (RosettaModelObjectBuilder)o.getPricingDates(), this::setPricingDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpread(), (RosettaModelObjectBuilder)o.getSpread(), this::setSpread);
            merger.mergeRosetta(this.getSpreadSchedule(), o.getSpreadSchedule(), this::getOrCreateSpreadSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFx(), (RosettaModelObjectBuilder)o.getFx(), this::setFx);
            merger.mergeBasic((Object)this.getAveragingMethod(), (Object)o.getAveragingMethod(), this::setAveragingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConversionFactor(), (Object)o.getConversionFactor(), this::setConversionFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadPercentage(), (Object)o.getSpreadPercentage(), this::setSpreadPercentage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingLegCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            if (!Objects.equals(this.conversionFactor, _that.getConversionFactor())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadSchedule, _that.getSpreadSchedule())) {
                return false;
            }
            if (!Objects.equals(this.spreadPercentage, _that.getSpreadPercentage())) {
                return false;
            }
            return Objects.equals(this.fx, _that.getFx());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.spreadSchedule != null ? this.spreadSchedule.hashCode() : 0);
            _result = 31 * _result + (this.spreadPercentage != null ? this.spreadPercentage.hashCode() : 0);
            _result = 31 * _result + (this.fx != null ? this.fx.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingLegCalculationBuilder {pricingDates=" + this.pricingDates + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", conversionFactor=" + this.conversionFactor + ", rounding=" + this.rounding + ", spread=" + this.spread + ", spreadSchedule=" + this.spreadSchedule + ", spreadPercentage=" + this.spreadPercentage + ", fx=" + this.fx + '}';
        }
    }

    public static interface FloatingLegCalculationBuilder
    extends FloatingLegCalculation,
    RosettaModelObjectBuilder {
        public CommodityPricingDates.CommodityPricingDatesBuilder getOrCreatePricingDates();

        @Override
        public CommodityPricingDates.CommodityPricingDatesBuilder getPricingDates();

        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public CommoditySpread.CommoditySpreadBuilder getOrCreateSpread();

        @Override
        public CommoditySpread.CommoditySpreadBuilder getSpread();

        public CommoditySpreadSchedule.CommoditySpreadScheduleBuilder getOrCreateSpreadSchedule(int var1);

        public List<? extends CommoditySpreadSchedule.CommoditySpreadScheduleBuilder> getSpreadSchedule();

        public CommodityFx.CommodityFxBuilder getOrCreateFx();

        @Override
        public CommodityFx.CommodityFxBuilder getFx();

        public FloatingLegCalculationBuilder setPricingDates(CommodityPricingDates var1);

        public FloatingLegCalculationBuilder setAveragingMethod(AveragingMethodEnum var1);

        public FloatingLegCalculationBuilder setConversionFactor(BigDecimal var1);

        public FloatingLegCalculationBuilder setRounding(Rounding var1);

        public FloatingLegCalculationBuilder setSpread(CommoditySpread var1);

        public FloatingLegCalculationBuilder addSpreadSchedule(CommoditySpreadSchedule var1);

        public FloatingLegCalculationBuilder addSpreadSchedule(CommoditySpreadSchedule var1, int var2);

        public FloatingLegCalculationBuilder addSpreadSchedule(List<? extends CommoditySpreadSchedule> var1);

        public FloatingLegCalculationBuilder setSpreadSchedule(List<? extends CommoditySpreadSchedule> var1);

        public FloatingLegCalculationBuilder setSpreadPercentage(BigDecimal var1);

        public FloatingLegCalculationBuilder setFx(CommodityFx var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.CommodityPricingDatesBuilder.class, this.getPricingDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, CommoditySpread.CommoditySpreadBuilder.class, this.getSpread(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadSchedule"), processor, CommoditySpreadSchedule.CommoditySpreadScheduleBuilder.class, this.getSpreadSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadPercentage"), BigDecimal.class, (Object)this.getSpreadPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fx"), processor, CommodityFx.CommodityFxBuilder.class, this.getFx(), new AttributeMeta[0]);
        }

        public FloatingLegCalculationBuilder prune();
    }

    public static class FloatingLegCalculationImpl
    implements FloatingLegCalculation {
        private final CommodityPricingDates pricingDates;
        private final AveragingMethodEnum averagingMethod;
        private final BigDecimal conversionFactor;
        private final Rounding rounding;
        private final CommoditySpread spread;
        private final List<? extends CommoditySpreadSchedule> spreadSchedule;
        private final BigDecimal spreadPercentage;
        private final CommodityFx fx;

        protected FloatingLegCalculationImpl(FloatingLegCalculationBuilder builder) {
            this.pricingDates = Optional.ofNullable(builder.getPricingDates()).map(f -> f.build()).orElse(null);
            this.averagingMethod = builder.getAveragingMethod();
            this.conversionFactor = builder.getConversionFactor();
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
            this.spread = Optional.ofNullable(builder.getSpread()).map(f -> f.build()).orElse(null);
            this.spreadSchedule = Optional.ofNullable(builder.getSpreadSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.spreadPercentage = builder.getSpreadPercentage();
            this.fx = Optional.ofNullable(builder.getFx()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="pricingDates", isRequired=true)
        @RuneAttribute(value="pricingDates", isRequired=true)
        public CommodityPricingDates getPricingDates() {
            return this.pricingDates;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public CommoditySpread getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="spreadSchedule")
        @RuneAttribute(value="spreadSchedule")
        public List<? extends CommoditySpreadSchedule> getSpreadSchedule() {
            return this.spreadSchedule;
        }

        @Override
        @RosettaAttribute(value="spreadPercentage")
        @RuneAttribute(value="spreadPercentage")
        public BigDecimal getSpreadPercentage() {
            return this.spreadPercentage;
        }

        @Override
        @RosettaAttribute(value="fx")
        @RuneAttribute(value="fx")
        public CommodityFx getFx() {
            return this.fx;
        }

        @Override
        public FloatingLegCalculation build() {
            return this;
        }

        @Override
        public FloatingLegCalculationBuilder toBuilder() {
            FloatingLegCalculationBuilder builder = FloatingLegCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingLegCalculationBuilder builder) {
            Optional.ofNullable(this.getPricingDates()).ifPresent(builder::setPricingDates);
            Optional.ofNullable(this.getAveragingMethod()).ifPresent(builder::setAveragingMethod);
            Optional.ofNullable(this.getConversionFactor()).ifPresent(builder::setConversionFactor);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getSpreadSchedule()).ifPresent(builder::setSpreadSchedule);
            Optional.ofNullable(this.getSpreadPercentage()).ifPresent(builder::setSpreadPercentage);
            Optional.ofNullable(this.getFx()).ifPresent(builder::setFx);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingLegCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            if (!Objects.equals(this.conversionFactor, _that.getConversionFactor())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadSchedule, _that.getSpreadSchedule())) {
                return false;
            }
            if (!Objects.equals(this.spreadPercentage, _that.getSpreadPercentage())) {
                return false;
            }
            return Objects.equals(this.fx, _that.getFx());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.spreadSchedule != null ? this.spreadSchedule.hashCode() : 0);
            _result = 31 * _result + (this.spreadPercentage != null ? this.spreadPercentage.hashCode() : 0);
            _result = 31 * _result + (this.fx != null ? this.fx.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingLegCalculation {pricingDates=" + this.pricingDates + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", conversionFactor=" + this.conversionFactor + ", rounding=" + this.rounding + ", spread=" + this.spread + ", spreadSchedule=" + this.spreadSchedule + ", spreadPercentage=" + this.spreadPercentage + ", fx=" + this.fx + '}';
        }
    }
}

