/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.QuantityUnit;
import fpml.consolidated.com.meta.CommodityTriggerSequenceMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityTriggerSequence", builder=CommodityTriggerSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityTriggerSequence", model="fpml", builder=CommodityTriggerSequenceBuilderImpl.class, version="1.1.0")
public interface CommodityTriggerSequence
extends RosettaModelObject {
    public static final CommodityTriggerSequenceMeta metaData = new CommodityTriggerSequenceMeta();

    public BigDecimal getLevelQuantity();

    public QuantityUnit getLevelUnit();

    public CommodityTriggerSequence build();

    public CommodityTriggerSequenceBuilder toBuilder();

    public static CommodityTriggerSequenceBuilder builder() {
        return new CommodityTriggerSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityTriggerSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityTriggerSequence> getType() {
        return CommodityTriggerSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("levelQuantity"), BigDecimal.class, (Object)this.getLevelQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("levelUnit"), processor, QuantityUnit.class, this.getLevelUnit(), new AttributeMeta[0]);
    }

    public static class CommodityTriggerSequenceBuilderImpl
    implements CommodityTriggerSequenceBuilder {
        protected BigDecimal levelQuantity;
        protected QuantityUnit.QuantityUnitBuilder levelUnit;

        @Override
        @RosettaAttribute(value="levelQuantity", isRequired=true)
        @RuneAttribute(value="levelQuantity", isRequired=true)
        public BigDecimal getLevelQuantity() {
            return this.levelQuantity;
        }

        @Override
        @RosettaAttribute(value="levelUnit", isRequired=true)
        @RuneAttribute(value="levelUnit", isRequired=true)
        public QuantityUnit.QuantityUnitBuilder getLevelUnit() {
            return this.levelUnit;
        }

        @Override
        public QuantityUnit.QuantityUnitBuilder getOrCreateLevelUnit() {
            QuantityUnit.QuantityUnitBuilder result = this.levelUnit != null ? this.levelUnit : (this.levelUnit = QuantityUnit.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="levelQuantity", isRequired=true)
        @RuneAttribute(value="levelQuantity", isRequired=true)
        public CommodityTriggerSequenceBuilder setLevelQuantity(BigDecimal _levelQuantity) {
            this.levelQuantity = _levelQuantity == null ? null : _levelQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="levelUnit", isRequired=true)
        @RuneAttribute(value="levelUnit", isRequired=true)
        public CommodityTriggerSequenceBuilder setLevelUnit(QuantityUnit _levelUnit) {
            this.levelUnit = _levelUnit == null ? null : _levelUnit.toBuilder();
            return this;
        }

        @Override
        public CommodityTriggerSequence build() {
            return new CommodityTriggerSequenceImpl(this);
        }

        @Override
        public CommodityTriggerSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityTriggerSequenceBuilder prune() {
            if (this.levelUnit != null && !this.levelUnit.prune().hasData()) {
                this.levelUnit = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getLevelQuantity() != null) {
                return true;
            }
            return this.getLevelUnit() != null && this.getLevelUnit().hasData();
        }

        public CommodityTriggerSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityTriggerSequenceBuilder o = (CommodityTriggerSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLevelUnit(), (RosettaModelObjectBuilder)o.getLevelUnit(), this::setLevelUnit);
            merger.mergeBasic((Object)this.getLevelQuantity(), (Object)o.getLevelQuantity(), this::setLevelQuantity, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityTriggerSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.levelQuantity, _that.getLevelQuantity())) {
                return false;
            }
            return Objects.equals(this.levelUnit, _that.getLevelUnit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.levelQuantity != null ? this.levelQuantity.hashCode() : 0);
            _result = 31 * _result + (this.levelUnit != null ? this.levelUnit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityTriggerSequenceBuilder {levelQuantity=" + this.levelQuantity + ", levelUnit=" + this.levelUnit + '}';
        }
    }

    public static interface CommodityTriggerSequenceBuilder
    extends CommodityTriggerSequence,
    RosettaModelObjectBuilder {
        public QuantityUnit.QuantityUnitBuilder getOrCreateLevelUnit();

        @Override
        public QuantityUnit.QuantityUnitBuilder getLevelUnit();

        public CommodityTriggerSequenceBuilder setLevelQuantity(BigDecimal var1);

        public CommodityTriggerSequenceBuilder setLevelUnit(QuantityUnit var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("levelQuantity"), BigDecimal.class, (Object)this.getLevelQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("levelUnit"), processor, QuantityUnit.QuantityUnitBuilder.class, this.getLevelUnit(), new AttributeMeta[0]);
        }

        public CommodityTriggerSequenceBuilder prune();
    }

    public static class CommodityTriggerSequenceImpl
    implements CommodityTriggerSequence {
        private final BigDecimal levelQuantity;
        private final QuantityUnit levelUnit;

        protected CommodityTriggerSequenceImpl(CommodityTriggerSequenceBuilder builder) {
            this.levelQuantity = builder.getLevelQuantity();
            this.levelUnit = Optional.ofNullable(builder.getLevelUnit()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="levelQuantity", isRequired=true)
        @RuneAttribute(value="levelQuantity", isRequired=true)
        public BigDecimal getLevelQuantity() {
            return this.levelQuantity;
        }

        @Override
        @RosettaAttribute(value="levelUnit", isRequired=true)
        @RuneAttribute(value="levelUnit", isRequired=true)
        public QuantityUnit getLevelUnit() {
            return this.levelUnit;
        }

        @Override
        public CommodityTriggerSequence build() {
            return this;
        }

        @Override
        public CommodityTriggerSequenceBuilder toBuilder() {
            CommodityTriggerSequenceBuilder builder = CommodityTriggerSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityTriggerSequenceBuilder builder) {
            Optional.ofNullable(this.getLevelQuantity()).ifPresent(builder::setLevelQuantity);
            Optional.ofNullable(this.getLevelUnit()).ifPresent(builder::setLevelUnit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityTriggerSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.levelQuantity, _that.getLevelQuantity())) {
                return false;
            }
            return Objects.equals(this.levelUnit, _that.getLevelUnit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.levelQuantity != null ? this.levelQuantity.hashCode() : 0);
            _result = 31 * _result + (this.levelUnit != null ? this.levelUnit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityTriggerSequence {levelQuantity=" + this.levelQuantity + ", levelUnit=" + this.levelUnit + '}';
        }
    }
}

