/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.CommodityPricingDates;
import fpml.consolidated.com.CommodityValuationDates;
import fpml.consolidated.com.meta.CommodityReturnCalculationMeta;
import fpml.consolidated.fpmlenum.CommodityReturnCalculationFormulaEnum;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityReturnCalculation", builder=CommodityReturnCalculationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityReturnCalculation", model="fpml", builder=CommodityReturnCalculationBuilderImpl.class, version="1.1.0")
public interface CommodityReturnCalculation
extends RosettaModelObject {
    public static final CommodityReturnCalculationMeta metaData = new CommodityReturnCalculationMeta();

    public CommodityReturnCalculationFormulaEnum getFormula();

    public CommodityPricingDates getPricingDates();

    public CommodityValuationDates getValuationDates();

    public BigDecimal getInitialPrice();

    public CommodityReturnCalculation build();

    public CommodityReturnCalculationBuilder toBuilder();

    public static CommodityReturnCalculationBuilder builder() {
        return new CommodityReturnCalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityReturnCalculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityReturnCalculation> getType() {
        return CommodityReturnCalculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("formula"), CommodityReturnCalculationFormulaEnum.class, (Object)this.getFormula(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.class, this.getPricingDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationDates"), processor, CommodityValuationDates.class, this.getValuationDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialPrice"), BigDecimal.class, (Object)this.getInitialPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommodityReturnCalculationBuilderImpl
    implements CommodityReturnCalculationBuilder {
        protected CommodityReturnCalculationFormulaEnum formula;
        protected CommodityPricingDates.CommodityPricingDatesBuilder pricingDates;
        protected CommodityValuationDates.CommodityValuationDatesBuilder valuationDates;
        protected BigDecimal initialPrice;

        @Override
        @RosettaAttribute(value="formula")
        @RuneAttribute(value="formula")
        public CommodityReturnCalculationFormulaEnum getFormula() {
            return this.formula;
        }

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityPricingDates.CommodityPricingDatesBuilder getPricingDates() {
            return this.pricingDates;
        }

        @Override
        public CommodityPricingDates.CommodityPricingDatesBuilder getOrCreatePricingDates() {
            CommodityPricingDates.CommodityPricingDatesBuilder result = this.pricingDates != null ? this.pricingDates : (this.pricingDates = CommodityPricingDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationDates")
        @RuneAttribute(value="valuationDates")
        public CommodityValuationDates.CommodityValuationDatesBuilder getValuationDates() {
            return this.valuationDates;
        }

        @Override
        public CommodityValuationDates.CommodityValuationDatesBuilder getOrCreateValuationDates() {
            CommodityValuationDates.CommodityValuationDatesBuilder result = this.valuationDates != null ? this.valuationDates : (this.valuationDates = CommodityValuationDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialPrice")
        @RuneAttribute(value="initialPrice")
        public BigDecimal getInitialPrice() {
            return this.initialPrice;
        }

        @Override
        @RosettaAttribute(value="formula")
        @RuneAttribute(value="formula")
        public CommodityReturnCalculationBuilder setFormula(CommodityReturnCalculationFormulaEnum _formula) {
            this.formula = _formula == null ? null : _formula;
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityReturnCalculationBuilder setPricingDates(CommodityPricingDates _pricingDates) {
            this.pricingDates = _pricingDates == null ? null : _pricingDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDates")
        @RuneAttribute(value="valuationDates")
        public CommodityReturnCalculationBuilder setValuationDates(CommodityValuationDates _valuationDates) {
            this.valuationDates = _valuationDates == null ? null : _valuationDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initialPrice")
        @RuneAttribute(value="initialPrice")
        public CommodityReturnCalculationBuilder setInitialPrice(BigDecimal _initialPrice) {
            this.initialPrice = _initialPrice == null ? null : _initialPrice;
            return this;
        }

        @Override
        public CommodityReturnCalculation build() {
            return new CommodityReturnCalculationImpl(this);
        }

        @Override
        public CommodityReturnCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityReturnCalculationBuilder prune() {
            if (this.pricingDates != null && !this.pricingDates.prune().hasData()) {
                this.pricingDates = null;
            }
            if (this.valuationDates != null && !this.valuationDates.prune().hasData()) {
                this.valuationDates = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFormula() != null) {
                return true;
            }
            if (this.getPricingDates() != null && this.getPricingDates().hasData()) {
                return true;
            }
            if (this.getValuationDates() != null && this.getValuationDates().hasData()) {
                return true;
            }
            return this.getInitialPrice() != null;
        }

        public CommodityReturnCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityReturnCalculationBuilder o = (CommodityReturnCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingDates(), (RosettaModelObjectBuilder)o.getPricingDates(), this::setPricingDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDates(), (RosettaModelObjectBuilder)o.getValuationDates(), this::setValuationDates);
            merger.mergeBasic((Object)this.getFormula(), (Object)o.getFormula(), this::setFormula, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialPrice(), (Object)o.getInitialPrice(), this::setInitialPrice, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityReturnCalculation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.formula, (Object)_that.getFormula())) {
                return false;
            }
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals(this.valuationDates, _that.getValuationDates())) {
                return false;
            }
            return Objects.equals(this.initialPrice, _that.getInitialPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.formula != null ? ((Object)((Object)this.formula)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.valuationDates != null ? this.valuationDates.hashCode() : 0);
            _result = 31 * _result + (this.initialPrice != null ? this.initialPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityReturnCalculationBuilder {formula=" + (Object)((Object)this.formula) + ", pricingDates=" + this.pricingDates + ", valuationDates=" + this.valuationDates + ", initialPrice=" + this.initialPrice + '}';
        }
    }

    public static interface CommodityReturnCalculationBuilder
    extends CommodityReturnCalculation,
    RosettaModelObjectBuilder {
        public CommodityPricingDates.CommodityPricingDatesBuilder getOrCreatePricingDates();

        @Override
        public CommodityPricingDates.CommodityPricingDatesBuilder getPricingDates();

        public CommodityValuationDates.CommodityValuationDatesBuilder getOrCreateValuationDates();

        @Override
        public CommodityValuationDates.CommodityValuationDatesBuilder getValuationDates();

        public CommodityReturnCalculationBuilder setFormula(CommodityReturnCalculationFormulaEnum var1);

        public CommodityReturnCalculationBuilder setPricingDates(CommodityPricingDates var1);

        public CommodityReturnCalculationBuilder setValuationDates(CommodityValuationDates var1);

        public CommodityReturnCalculationBuilder setInitialPrice(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("formula"), CommodityReturnCalculationFormulaEnum.class, (Object)this.getFormula(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.CommodityPricingDatesBuilder.class, this.getPricingDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationDates"), processor, CommodityValuationDates.CommodityValuationDatesBuilder.class, this.getValuationDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialPrice"), BigDecimal.class, (Object)this.getInitialPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CommodityReturnCalculationBuilder prune();
    }

    public static class CommodityReturnCalculationImpl
    implements CommodityReturnCalculation {
        private final CommodityReturnCalculationFormulaEnum formula;
        private final CommodityPricingDates pricingDates;
        private final CommodityValuationDates valuationDates;
        private final BigDecimal initialPrice;

        protected CommodityReturnCalculationImpl(CommodityReturnCalculationBuilder builder) {
            this.formula = builder.getFormula();
            this.pricingDates = Optional.ofNullable(builder.getPricingDates()).map(f -> f.build()).orElse(null);
            this.valuationDates = Optional.ofNullable(builder.getValuationDates()).map(f -> f.build()).orElse(null);
            this.initialPrice = builder.getInitialPrice();
        }

        @Override
        @RosettaAttribute(value="formula")
        @RuneAttribute(value="formula")
        public CommodityReturnCalculationFormulaEnum getFormula() {
            return this.formula;
        }

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityPricingDates getPricingDates() {
            return this.pricingDates;
        }

        @Override
        @RosettaAttribute(value="valuationDates")
        @RuneAttribute(value="valuationDates")
        public CommodityValuationDates getValuationDates() {
            return this.valuationDates;
        }

        @Override
        @RosettaAttribute(value="initialPrice")
        @RuneAttribute(value="initialPrice")
        public BigDecimal getInitialPrice() {
            return this.initialPrice;
        }

        @Override
        public CommodityReturnCalculation build() {
            return this;
        }

        @Override
        public CommodityReturnCalculationBuilder toBuilder() {
            CommodityReturnCalculationBuilder builder = CommodityReturnCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityReturnCalculationBuilder builder) {
            Optional.ofNullable(this.getFormula()).ifPresent(builder::setFormula);
            Optional.ofNullable(this.getPricingDates()).ifPresent(builder::setPricingDates);
            Optional.ofNullable(this.getValuationDates()).ifPresent(builder::setValuationDates);
            Optional.ofNullable(this.getInitialPrice()).ifPresent(builder::setInitialPrice);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityReturnCalculation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.formula, (Object)_that.getFormula())) {
                return false;
            }
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals(this.valuationDates, _that.getValuationDates())) {
                return false;
            }
            return Objects.equals(this.initialPrice, _that.getInitialPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.formula != null ? ((Object)((Object)this.formula)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.valuationDates != null ? this.valuationDates.hashCode() : 0);
            _result = 31 * _result + (this.initialPrice != null ? this.initialPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityReturnCalculation {formula=" + (Object)((Object)this.formula) + ", pricingDates=" + this.pricingDates + ", valuationDates=" + this.valuationDates + ", initialPrice=" + this.initialPrice + '}';
        }
    }
}

