/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.Commodity;
import fpml.consolidated.com.CommodityContentModel;
import fpml.consolidated.com.CommodityDigitalExercise;
import fpml.consolidated.com.CommodityDigitalOptionFeaturesModel;
import fpml.consolidated.com.CommodityDigitalOptionSequence;
import fpml.consolidated.com.CommodityPremium;
import fpml.consolidated.com.meta.CommodityDigitalOptionMeta;
import fpml.consolidated.fpmlenum.PutCallEnum;
import fpml.consolidated.option.shared.Option;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.NotionalAmount;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityDigitalOption", builder=CommodityDigitalOptionBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityDigitalOption", model="fpml", builder=CommodityDigitalOptionBuilderImpl.class, version="1.1.0")
public interface CommodityDigitalOption
extends Option {
    public static final CommodityDigitalOptionMeta metaData = new CommodityDigitalOptionMeta();

    public PutCallEnum getOptionType();

    public Commodity getCommodity();

    public CommodityDigitalOptionFeaturesModel getCommodityDigitalOptionFeaturesModel();

    public NotionalAmount getNotionalAmount();

    public CommodityDigitalOptionSequence getCommodityDigitalOptionSequence();

    public CommodityDigitalExercise getExercise();

    public List<? extends CommodityPremium> getPremium();

    public CommodityContentModel getCommodityContentModel();

    @Override
    public CommodityDigitalOption build();

    @Override
    public CommodityDigitalOptionBuilder toBuilder();

    public static CommodityDigitalOptionBuilder builder() {
        return new CommodityDigitalOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityDigitalOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityDigitalOption> getType() {
        return CommodityDigitalOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodity"), processor, Commodity.class, this.getCommodity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityDigitalOptionFeaturesModel"), processor, CommodityDigitalOptionFeaturesModel.class, this.getCommodityDigitalOptionFeaturesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NotionalAmount.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityDigitalOptionSequence"), processor, CommodityDigitalOptionSequence.class, this.getCommodityDigitalOptionSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exercise"), processor, CommodityDigitalExercise.class, this.getExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, CommodityPremium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.class, this.getCommodityContentModel(), new AttributeMeta[0]);
    }

    public static class CommodityDigitalOptionBuilderImpl
    extends Option.OptionBuilderImpl
    implements CommodityDigitalOptionBuilder {
        protected PutCallEnum optionType;
        protected Commodity.CommodityBuilder commodity;
        protected CommodityDigitalOptionFeaturesModel.CommodityDigitalOptionFeaturesModelBuilder commodityDigitalOptionFeaturesModel;
        protected NotionalAmount.NotionalAmountBuilder notionalAmount;
        protected CommodityDigitalOptionSequence.CommodityDigitalOptionSequenceBuilder commodityDigitalOptionSequence;
        protected CommodityDigitalExercise.CommodityDigitalExerciseBuilder exercise;
        protected List<CommodityPremium.CommodityPremiumBuilder> premium = new ArrayList<CommodityPremium.CommodityPremiumBuilder>();
        protected CommodityContentModel.CommodityContentModelBuilder commodityContentModel;

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commodity", isRequired=true)
        @RuneAttribute(value="commodity", isRequired=true)
        public Commodity.CommodityBuilder getCommodity() {
            return this.commodity;
        }

        @Override
        public Commodity.CommodityBuilder getOrCreateCommodity() {
            Commodity.CommodityBuilder result = this.commodity != null ? this.commodity : (this.commodity = Commodity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityDigitalOptionFeaturesModel", isRequired=true)
        @RuneAttribute(value="commodityDigitalOptionFeaturesModel", isRequired=true)
        public CommodityDigitalOptionFeaturesModel.CommodityDigitalOptionFeaturesModelBuilder getCommodityDigitalOptionFeaturesModel() {
            return this.commodityDigitalOptionFeaturesModel;
        }

        @Override
        public CommodityDigitalOptionFeaturesModel.CommodityDigitalOptionFeaturesModelBuilder getOrCreateCommodityDigitalOptionFeaturesModel() {
            CommodityDigitalOptionFeaturesModel.CommodityDigitalOptionFeaturesModelBuilder result = this.commodityDigitalOptionFeaturesModel != null ? this.commodityDigitalOptionFeaturesModel : (this.commodityDigitalOptionFeaturesModel = CommodityDigitalOptionFeaturesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public NotionalAmount.NotionalAmountBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NotionalAmount.NotionalAmountBuilder getOrCreateNotionalAmount() {
            NotionalAmount.NotionalAmountBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NotionalAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityDigitalOptionSequence")
        @RuneAttribute(value="commodityDigitalOptionSequence")
        public CommodityDigitalOptionSequence.CommodityDigitalOptionSequenceBuilder getCommodityDigitalOptionSequence() {
            return this.commodityDigitalOptionSequence;
        }

        @Override
        public CommodityDigitalOptionSequence.CommodityDigitalOptionSequenceBuilder getOrCreateCommodityDigitalOptionSequence() {
            CommodityDigitalOptionSequence.CommodityDigitalOptionSequenceBuilder result = this.commodityDigitalOptionSequence != null ? this.commodityDigitalOptionSequence : (this.commodityDigitalOptionSequence = CommodityDigitalOptionSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exercise")
        @RuneAttribute(value="exercise")
        public CommodityDigitalExercise.CommodityDigitalExerciseBuilder getExercise() {
            return this.exercise;
        }

        @Override
        public CommodityDigitalExercise.CommodityDigitalExerciseBuilder getOrCreateExercise() {
            CommodityDigitalExercise.CommodityDigitalExerciseBuilder result = this.exercise != null ? this.exercise : (this.exercise = CommodityDigitalExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends CommodityPremium.CommodityPremiumBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public CommodityPremium.CommodityPremiumBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<CommodityPremium.CommodityPremiumBuilder>();
            }
            return (CommodityPremium.CommodityPremiumBuilder)this.getIndex(this.premium, index, () -> {
                CommodityPremium.CommodityPremiumBuilder newPremium = CommodityPremium.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel() {
            CommodityContentModel.CommodityContentModelBuilder result = this.commodityContentModel != null ? this.commodityContentModel : (this.commodityContentModel = CommodityContentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public CommodityDigitalOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommodityDigitalOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public CommodityDigitalOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public CommodityDigitalOptionBuilder setOptionType(PutCallEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodity", isRequired=true)
        @RuneAttribute(value="commodity", isRequired=true)
        public CommodityDigitalOptionBuilder setCommodity(Commodity _commodity) {
            this.commodity = _commodity == null ? null : _commodity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityDigitalOptionFeaturesModel", isRequired=true)
        @RuneAttribute(value="commodityDigitalOptionFeaturesModel", isRequired=true)
        public CommodityDigitalOptionBuilder setCommodityDigitalOptionFeaturesModel(CommodityDigitalOptionFeaturesModel _commodityDigitalOptionFeaturesModel) {
            this.commodityDigitalOptionFeaturesModel = _commodityDigitalOptionFeaturesModel == null ? null : _commodityDigitalOptionFeaturesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public CommodityDigitalOptionBuilder setNotionalAmount(NotionalAmount _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityDigitalOptionSequence")
        @RuneAttribute(value="commodityDigitalOptionSequence")
        public CommodityDigitalOptionBuilder setCommodityDigitalOptionSequence(CommodityDigitalOptionSequence _commodityDigitalOptionSequence) {
            this.commodityDigitalOptionSequence = _commodityDigitalOptionSequence == null ? null : _commodityDigitalOptionSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exercise")
        @RuneAttribute(value="exercise")
        public CommodityDigitalOptionBuilder setExercise(CommodityDigitalExercise _exercise) {
            this.exercise = _exercise == null ? null : _exercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public CommodityDigitalOptionBuilder addPremium(CommodityPremium _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityDigitalOptionBuilder addPremium(CommodityPremium _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public CommodityDigitalOptionBuilder addPremium(List<? extends CommodityPremium> premiums) {
            if (premiums != null) {
                for (CommodityPremium commodityPremium : premiums) {
                    this.premium.add(commodityPremium.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public CommodityDigitalOptionBuilder setPremium(List<? extends CommodityPremium> premiums) {
            this.premium = premiums == null ? new ArrayList<CommodityPremium.CommodityPremiumBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityDigitalOptionBuilder setCommodityContentModel(CommodityContentModel _commodityContentModel) {
            this.commodityContentModel = _commodityContentModel == null ? null : _commodityContentModel.toBuilder();
            return this;
        }

        @Override
        public CommodityDigitalOption build() {
            return new CommodityDigitalOptionImpl(this);
        }

        @Override
        public CommodityDigitalOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityDigitalOptionBuilder prune() {
            super.prune();
            if (this.commodity != null && !this.commodity.prune().hasData()) {
                this.commodity = null;
            }
            if (this.commodityDigitalOptionFeaturesModel != null && !this.commodityDigitalOptionFeaturesModel.prune().hasData()) {
                this.commodityDigitalOptionFeaturesModel = null;
            }
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            if (this.commodityDigitalOptionSequence != null && !this.commodityDigitalOptionSequence.prune().hasData()) {
                this.commodityDigitalOptionSequence = null;
            }
            if (this.exercise != null && !this.exercise.prune().hasData()) {
                this.exercise = null;
            }
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.commodityContentModel != null && !this.commodityContentModel.prune().hasData()) {
                this.commodityContentModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getCommodity() != null && this.getCommodity().hasData()) {
                return true;
            }
            if (this.getCommodityDigitalOptionFeaturesModel() != null && this.getCommodityDigitalOptionFeaturesModel().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getCommodityDigitalOptionSequence() != null && this.getCommodityDigitalOptionSequence().hasData()) {
                return true;
            }
            if (this.getExercise() != null && this.getExercise().hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCommodityContentModel() != null && this.getCommodityContentModel().hasData();
        }

        @Override
        public CommodityDigitalOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommodityDigitalOptionBuilder o = (CommodityDigitalOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodity(), (RosettaModelObjectBuilder)o.getCommodity(), this::setCommodity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityDigitalOptionFeaturesModel(), (RosettaModelObjectBuilder)o.getCommodityDigitalOptionFeaturesModel(), this::setCommodityDigitalOptionFeaturesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityDigitalOptionSequence(), (RosettaModelObjectBuilder)o.getCommodityDigitalOptionSequence(), this::setCommodityDigitalOptionSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExercise(), (RosettaModelObjectBuilder)o.getExercise(), this::setExercise);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityContentModel(), (RosettaModelObjectBuilder)o.getCommodityContentModel(), this::setCommodityContentModel);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityDigitalOption _that = (CommodityDigitalOption)this.getType().cast(o);
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.commodityDigitalOptionFeaturesModel, _that.getCommodityDigitalOptionFeaturesModel())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.commodityDigitalOptionSequence, _that.getCommodityDigitalOptionSequence())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.commodityDigitalOptionFeaturesModel != null ? this.commodityDigitalOptionFeaturesModel.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.commodityDigitalOptionSequence != null ? this.commodityDigitalOptionSequence.hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityDigitalOptionBuilder {optionType=" + (Object)((Object)this.optionType) + ", commodity=" + this.commodity + ", commodityDigitalOptionFeaturesModel=" + this.commodityDigitalOptionFeaturesModel + ", notionalAmount=" + this.notionalAmount + ", commodityDigitalOptionSequence=" + this.commodityDigitalOptionSequence + ", exercise=" + this.exercise + ", premium=" + this.premium + ", commodityContentModel=" + this.commodityContentModel + '}' + " " + super.toString();
        }
    }

    public static interface CommodityDigitalOptionBuilder
    extends CommodityDigitalOption,
    Option.OptionBuilder {
        public Commodity.CommodityBuilder getOrCreateCommodity();

        @Override
        public Commodity.CommodityBuilder getCommodity();

        public CommodityDigitalOptionFeaturesModel.CommodityDigitalOptionFeaturesModelBuilder getOrCreateCommodityDigitalOptionFeaturesModel();

        @Override
        public CommodityDigitalOptionFeaturesModel.CommodityDigitalOptionFeaturesModelBuilder getCommodityDigitalOptionFeaturesModel();

        public NotionalAmount.NotionalAmountBuilder getOrCreateNotionalAmount();

        @Override
        public NotionalAmount.NotionalAmountBuilder getNotionalAmount();

        public CommodityDigitalOptionSequence.CommodityDigitalOptionSequenceBuilder getOrCreateCommodityDigitalOptionSequence();

        @Override
        public CommodityDigitalOptionSequence.CommodityDigitalOptionSequenceBuilder getCommodityDigitalOptionSequence();

        public CommodityDigitalExercise.CommodityDigitalExerciseBuilder getOrCreateExercise();

        @Override
        public CommodityDigitalExercise.CommodityDigitalExerciseBuilder getExercise();

        public CommodityPremium.CommodityPremiumBuilder getOrCreatePremium(int var1);

        public List<? extends CommodityPremium.CommodityPremiumBuilder> getPremium();

        public CommodityContentModel.CommodityContentModelBuilder getOrCreateCommodityContentModel();

        @Override
        public CommodityContentModel.CommodityContentModelBuilder getCommodityContentModel();

        @Override
        public CommodityDigitalOptionBuilder setProductModel(ProductModel var1);

        @Override
        public CommodityDigitalOptionBuilder setId(String var1);

        @Override
        public CommodityDigitalOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public CommodityDigitalOptionBuilder setOptionType(PutCallEnum var1);

        public CommodityDigitalOptionBuilder setCommodity(Commodity var1);

        public CommodityDigitalOptionBuilder setCommodityDigitalOptionFeaturesModel(CommodityDigitalOptionFeaturesModel var1);

        public CommodityDigitalOptionBuilder setNotionalAmount(NotionalAmount var1);

        public CommodityDigitalOptionBuilder setCommodityDigitalOptionSequence(CommodityDigitalOptionSequence var1);

        public CommodityDigitalOptionBuilder setExercise(CommodityDigitalExercise var1);

        public CommodityDigitalOptionBuilder addPremium(CommodityPremium var1);

        public CommodityDigitalOptionBuilder addPremium(CommodityPremium var1, int var2);

        public CommodityDigitalOptionBuilder addPremium(List<? extends CommodityPremium> var1);

        public CommodityDigitalOptionBuilder setPremium(List<? extends CommodityPremium> var1);

        public CommodityDigitalOptionBuilder setCommodityContentModel(CommodityContentModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodity"), processor, Commodity.CommodityBuilder.class, this.getCommodity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityDigitalOptionFeaturesModel"), processor, CommodityDigitalOptionFeaturesModel.CommodityDigitalOptionFeaturesModelBuilder.class, this.getCommodityDigitalOptionFeaturesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NotionalAmount.NotionalAmountBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityDigitalOptionSequence"), processor, CommodityDigitalOptionSequence.CommodityDigitalOptionSequenceBuilder.class, this.getCommodityDigitalOptionSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exercise"), processor, CommodityDigitalExercise.CommodityDigitalExerciseBuilder.class, this.getExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, CommodityPremium.CommodityPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityContentModel"), processor, CommodityContentModel.CommodityContentModelBuilder.class, this.getCommodityContentModel(), new AttributeMeta[0]);
        }

        @Override
        public CommodityDigitalOptionBuilder prune();
    }

    public static class CommodityDigitalOptionImpl
    extends Option.OptionImpl
    implements CommodityDigitalOption {
        private final PutCallEnum optionType;
        private final Commodity commodity;
        private final CommodityDigitalOptionFeaturesModel commodityDigitalOptionFeaturesModel;
        private final NotionalAmount notionalAmount;
        private final CommodityDigitalOptionSequence commodityDigitalOptionSequence;
        private final CommodityDigitalExercise exercise;
        private final List<? extends CommodityPremium> premium;
        private final CommodityContentModel commodityContentModel;

        protected CommodityDigitalOptionImpl(CommodityDigitalOptionBuilder builder) {
            super(builder);
            this.optionType = builder.getOptionType();
            this.commodity = Optional.ofNullable(builder.getCommodity()).map(f -> f.build()).orElse(null);
            this.commodityDigitalOptionFeaturesModel = Optional.ofNullable(builder.getCommodityDigitalOptionFeaturesModel()).map(f -> f.build()).orElse(null);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.commodityDigitalOptionSequence = Optional.ofNullable(builder.getCommodityDigitalOptionSequence()).map(f -> f.build()).orElse(null);
            this.exercise = Optional.ofNullable(builder.getExercise()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.commodityContentModel = Optional.ofNullable(builder.getCommodityContentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public PutCallEnum getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commodity", isRequired=true)
        @RuneAttribute(value="commodity", isRequired=true)
        public Commodity getCommodity() {
            return this.commodity;
        }

        @Override
        @RosettaAttribute(value="commodityDigitalOptionFeaturesModel", isRequired=true)
        @RuneAttribute(value="commodityDigitalOptionFeaturesModel", isRequired=true)
        public CommodityDigitalOptionFeaturesModel getCommodityDigitalOptionFeaturesModel() {
            return this.commodityDigitalOptionFeaturesModel;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public NotionalAmount getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="commodityDigitalOptionSequence")
        @RuneAttribute(value="commodityDigitalOptionSequence")
        public CommodityDigitalOptionSequence getCommodityDigitalOptionSequence() {
            return this.commodityDigitalOptionSequence;
        }

        @Override
        @RosettaAttribute(value="exercise")
        @RuneAttribute(value="exercise")
        public CommodityDigitalExercise getExercise() {
            return this.exercise;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends CommodityPremium> getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="commodityContentModel")
        @RuneAttribute(value="commodityContentModel")
        public CommodityContentModel getCommodityContentModel() {
            return this.commodityContentModel;
        }

        @Override
        public CommodityDigitalOption build() {
            return this;
        }

        @Override
        public CommodityDigitalOptionBuilder toBuilder() {
            CommodityDigitalOptionBuilder builder = CommodityDigitalOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityDigitalOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getCommodity()).ifPresent(builder::setCommodity);
            Optional.ofNullable(this.getCommodityDigitalOptionFeaturesModel()).ifPresent(builder::setCommodityDigitalOptionFeaturesModel);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getCommodityDigitalOptionSequence()).ifPresent(builder::setCommodityDigitalOptionSequence);
            Optional.ofNullable(this.getExercise()).ifPresent(builder::setExercise);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getCommodityContentModel()).ifPresent(builder::setCommodityContentModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommodityDigitalOption _that = (CommodityDigitalOption)this.getType().cast(o);
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.commodityDigitalOptionFeaturesModel, _that.getCommodityDigitalOptionFeaturesModel())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.commodityDigitalOptionSequence, _that.getCommodityDigitalOptionSequence())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.commodityContentModel, _that.getCommodityContentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.commodityDigitalOptionFeaturesModel != null ? this.commodityDigitalOptionFeaturesModel.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.commodityDigitalOptionSequence != null ? this.commodityDigitalOptionSequence.hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.commodityContentModel != null ? this.commodityContentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommodityDigitalOption {optionType=" + (Object)((Object)this.optionType) + ", commodity=" + this.commodity + ", commodityDigitalOptionFeaturesModel=" + this.commodityDigitalOptionFeaturesModel + ", notionalAmount=" + this.notionalAmount + ", commodityDigitalOptionSequence=" + this.commodityDigitalOptionSequence + ", exercise=" + this.exercise + ", premium=" + this.premium + ", commodityContentModel=" + this.commodityContentModel + '}' + " " + super.toString();
        }
    }
}

