/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Commodity;
import fpml.consolidated.com.CommodityPricingDates;
import fpml.consolidated.com.meta.CommodityBasketUnderlyingBaseMeta;
import fpml.consolidated.fpmlenum.AveragingMethodEnum;
import fpml.consolidated.fpmlenum.PayerReceiverEnum;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityBasketUnderlyingBase", builder=CommodityBasketUnderlyingBaseBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityBasketUnderlyingBase", model="fpml", builder=CommodityBasketUnderlyingBaseBuilderImpl.class, version="1.1.0")
public interface CommodityBasketUnderlyingBase
extends RosettaModelObject {
    public static final CommodityBasketUnderlyingBaseMeta metaData = new CommodityBasketUnderlyingBaseMeta();

    public PayerReceiverEnum getDirection();

    public Commodity getCommodity();

    public CommodityPricingDates getPricingDates();

    public AveragingMethodEnum getAveragingMethod();

    public String getId();

    public CommodityBasketUnderlyingBase build();

    public CommodityBasketUnderlyingBaseBuilder toBuilder();

    public static CommodityBasketUnderlyingBaseBuilder builder() {
        return new CommodityBasketUnderlyingBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityBasketUnderlyingBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityBasketUnderlyingBase> getType() {
        return CommodityBasketUnderlyingBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("direction"), PayerReceiverEnum.class, (Object)this.getDirection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodity"), processor, Commodity.class, this.getCommodity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.class, this.getPricingDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommodityBasketUnderlyingBaseBuilderImpl
    implements CommodityBasketUnderlyingBaseBuilder {
        protected PayerReceiverEnum direction;
        protected Commodity.CommodityBuilder commodity;
        protected CommodityPricingDates.CommodityPricingDatesBuilder pricingDates;
        protected AveragingMethodEnum averagingMethod;
        protected String id;

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public PayerReceiverEnum getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        public Commodity.CommodityBuilder getCommodity() {
            return this.commodity;
        }

        @Override
        public Commodity.CommodityBuilder getOrCreateCommodity() {
            Commodity.CommodityBuilder result = this.commodity != null ? this.commodity : (this.commodity = Commodity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityPricingDates.CommodityPricingDatesBuilder getPricingDates() {
            return this.pricingDates;
        }

        @Override
        public CommodityPricingDates.CommodityPricingDatesBuilder getOrCreatePricingDates() {
            CommodityPricingDates.CommodityPricingDatesBuilder result = this.pricingDates != null ? this.pricingDates : (this.pricingDates = CommodityPricingDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public CommodityBasketUnderlyingBaseBuilder setDirection(PayerReceiverEnum _direction) {
            this.direction = _direction == null ? null : _direction;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        public CommodityBasketUnderlyingBaseBuilder setCommodity(Commodity _commodity) {
            this.commodity = _commodity == null ? null : _commodity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityBasketUnderlyingBaseBuilder setPricingDates(CommodityPricingDates _pricingDates) {
            this.pricingDates = _pricingDates == null ? null : _pricingDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public CommodityBasketUnderlyingBaseBuilder setAveragingMethod(AveragingMethodEnum _averagingMethod) {
            this.averagingMethod = _averagingMethod == null ? null : _averagingMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommodityBasketUnderlyingBaseBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public CommodityBasketUnderlyingBase build() {
            return new CommodityBasketUnderlyingBaseImpl(this);
        }

        @Override
        public CommodityBasketUnderlyingBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityBasketUnderlyingBaseBuilder prune() {
            if (this.commodity != null && !this.commodity.prune().hasData()) {
                this.commodity = null;
            }
            if (this.pricingDates != null && !this.pricingDates.prune().hasData()) {
                this.pricingDates = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDirection() != null) {
                return true;
            }
            if (this.getCommodity() != null && this.getCommodity().hasData()) {
                return true;
            }
            if (this.getPricingDates() != null && this.getPricingDates().hasData()) {
                return true;
            }
            if (this.getAveragingMethod() != null) {
                return true;
            }
            return this.getId() != null;
        }

        public CommodityBasketUnderlyingBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityBasketUnderlyingBaseBuilder o = (CommodityBasketUnderlyingBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodity(), (RosettaModelObjectBuilder)o.getCommodity(), this::setCommodity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingDates(), (RosettaModelObjectBuilder)o.getPricingDates(), this::setPricingDates);
            merger.mergeBasic((Object)this.getDirection(), (Object)o.getDirection(), this::setDirection, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAveragingMethod(), (Object)o.getAveragingMethod(), this::setAveragingMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityBasketUnderlyingBase _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.direction, (Object)_that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.direction != null ? ((Object)((Object)this.direction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityBasketUnderlyingBaseBuilder {direction=" + (Object)((Object)this.direction) + ", commodity=" + this.commodity + ", pricingDates=" + this.pricingDates + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", id=" + this.id + '}';
        }
    }

    public static interface CommodityBasketUnderlyingBaseBuilder
    extends CommodityBasketUnderlyingBase,
    RosettaModelObjectBuilder {
        public Commodity.CommodityBuilder getOrCreateCommodity();

        @Override
        public Commodity.CommodityBuilder getCommodity();

        public CommodityPricingDates.CommodityPricingDatesBuilder getOrCreatePricingDates();

        @Override
        public CommodityPricingDates.CommodityPricingDatesBuilder getPricingDates();

        public CommodityBasketUnderlyingBaseBuilder setDirection(PayerReceiverEnum var1);

        public CommodityBasketUnderlyingBaseBuilder setCommodity(Commodity var1);

        public CommodityBasketUnderlyingBaseBuilder setPricingDates(CommodityPricingDates var1);

        public CommodityBasketUnderlyingBaseBuilder setAveragingMethod(AveragingMethodEnum var1);

        public CommodityBasketUnderlyingBaseBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("direction"), PayerReceiverEnum.class, (Object)this.getDirection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodity"), processor, Commodity.CommodityBuilder.class, this.getCommodity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingDates"), processor, CommodityPricingDates.CommodityPricingDatesBuilder.class, this.getPricingDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("averagingMethod"), AveragingMethodEnum.class, (Object)this.getAveragingMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CommodityBasketUnderlyingBaseBuilder prune();
    }

    public static class CommodityBasketUnderlyingBaseImpl
    implements CommodityBasketUnderlyingBase {
        private final PayerReceiverEnum direction;
        private final Commodity commodity;
        private final CommodityPricingDates pricingDates;
        private final AveragingMethodEnum averagingMethod;
        private final String id;

        protected CommodityBasketUnderlyingBaseImpl(CommodityBasketUnderlyingBaseBuilder builder) {
            this.direction = builder.getDirection();
            this.commodity = Optional.ofNullable(builder.getCommodity()).map(f -> f.build()).orElse(null);
            this.pricingDates = Optional.ofNullable(builder.getPricingDates()).map(f -> f.build()).orElse(null);
            this.averagingMethod = builder.getAveragingMethod();
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="direction")
        @RuneAttribute(value="direction")
        public PayerReceiverEnum getDirection() {
            return this.direction;
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        public Commodity getCommodity() {
            return this.commodity;
        }

        @Override
        @RosettaAttribute(value="pricingDates")
        @RuneAttribute(value="pricingDates")
        public CommodityPricingDates getPricingDates() {
            return this.pricingDates;
        }

        @Override
        @RosettaAttribute(value="averagingMethod")
        @RuneAttribute(value="averagingMethod")
        public AveragingMethodEnum getAveragingMethod() {
            return this.averagingMethod;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public CommodityBasketUnderlyingBase build() {
            return this;
        }

        @Override
        public CommodityBasketUnderlyingBaseBuilder toBuilder() {
            CommodityBasketUnderlyingBaseBuilder builder = CommodityBasketUnderlyingBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityBasketUnderlyingBaseBuilder builder) {
            Optional.ofNullable(this.getDirection()).ifPresent(builder::setDirection);
            Optional.ofNullable(this.getCommodity()).ifPresent(builder::setCommodity);
            Optional.ofNullable(this.getPricingDates()).ifPresent(builder::setPricingDates);
            Optional.ofNullable(this.getAveragingMethod()).ifPresent(builder::setAveragingMethod);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityBasketUnderlyingBase _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.direction, (Object)_that.getDirection())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.pricingDates, _that.getPricingDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.averagingMethod, (Object)_that.getAveragingMethod())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.direction != null ? ((Object)((Object)this.direction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.pricingDates != null ? this.pricingDates.hashCode() : 0);
            _result = 31 * _result + (this.averagingMethod != null ? ((Object)((Object)this.averagingMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityBasketUnderlyingBase {direction=" + (Object)((Object)this.direction) + ", commodity=" + this.commodity + ", pricingDates=" + this.pricingDates + ", averagingMethod=" + (Object)((Object)this.averagingMethod) + ", id=" + this.id + '}';
        }
    }
}

