/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.cd.ReferencePair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ReferencePairChoice")
@ImplementedBy(value=Default.class)
public interface ReferencePairChoice
extends Validator<ReferencePair> {
    public static final String NAME = "ReferencePairChoice";
    public static final String DEFINITION = "optional choice referenceObligation, noReferenceObligation";

    public static class NoOp
    implements ReferencePairChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReferencePair referencePair) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ReferencePairChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReferencePair referencePair) {
            ComparisonResult result = this.executeDataRule(referencePair);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ReferencePairChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferencePair", (RosettaPath)path, (String)ReferencePairChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ReferencePairChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferencePair", (RosettaPath)path, (String)ReferencePairChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ReferencePair referencePair) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)referencePair), Arrays.asList("referenceObligation", "noReferenceObligation"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

