/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.cd.ReferenceInformation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ReferenceInformationChoice")
@ImplementedBy(value=Default.class)
public interface ReferenceInformationChoice
extends Validator<ReferenceInformation> {
    public static final String NAME = "ReferenceInformationChoice";
    public static final String DEFINITION = "optional choice referenceObligation, noReferenceObligation , unknownReferenceObligation";

    public static class NoOp
    implements ReferenceInformationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReferenceInformation referenceInformation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ReferenceInformationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReferenceInformation referenceInformation) {
            ComparisonResult result = this.executeDataRule(referenceInformation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ReferenceInformationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferenceInformation", (RosettaPath)path, (String)ReferenceInformationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ReferenceInformationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReferenceInformation", (RosettaPath)path, (String)ReferenceInformationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ReferenceInformation referenceInformation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)referenceInformation), Arrays.asList("referenceObligation", "noReferenceObligation", "unknownReferenceObligation"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

