/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.cd.CreditOptionStrike;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CreditOptionStrikeChoice")
@ImplementedBy(value=Default.class)
public interface CreditOptionStrikeChoice
extends Validator<CreditOptionStrike> {
    public static final String NAME = "CreditOptionStrikeChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements CreditOptionStrikeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditOptionStrike creditOptionStrike) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CreditOptionStrikeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditOptionStrike creditOptionStrike) {
            ComparisonResult result = this.executeDataRule(creditOptionStrike);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CreditOptionStrikeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditOptionStrike", (RosettaPath)path, (String)CreditOptionStrikeChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CreditOptionStrikeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditOptionStrike", (RosettaPath)path, (String)CreditOptionStrikeChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CreditOptionStrike creditOptionStrike) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)creditOptionStrike), Arrays.asList("spread", "price", "strikeReference"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

