/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.cd.CalculationAmount;
import fpml.consolidated.cd.meta.FloatingAmountCalculationMeta;
import fpml.consolidated.ird.FloatingRateCalculation;
import fpml.consolidated.shared.AdjustableDate;
import fpml.consolidated.shared.DayCountFraction;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FloatingAmountCalculation", builder=FloatingAmountCalculationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FloatingAmountCalculation", model="fpml", builder=FloatingAmountCalculationBuilderImpl.class, version="1.1.0")
public interface FloatingAmountCalculation
extends RosettaModelObject {
    public static final FloatingAmountCalculationMeta metaData = new FloatingAmountCalculationMeta();

    public CalculationAmount getCalculationAmount();

    public FloatingRateCalculation getFloatingRate();

    public DayCountFraction getDayCountFraction();

    public ZonedDateTime getInitialFixingDate();

    public AdjustableDate getFinalFixingDate();

    public FloatingAmountCalculation build();

    public FloatingAmountCalculationBuilder toBuilder();

    public static FloatingAmountCalculationBuilder builder() {
        return new FloatingAmountCalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingAmountCalculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingAmountCalculation> getType() {
        return FloatingAmountCalculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("calculationAmount"), processor, CalculationAmount.class, this.getCalculationAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRate"), processor, FloatingRateCalculation.class, this.getFloatingRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialFixingDate"), ZonedDateTime.class, (Object)this.getInitialFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalFixingDate"), processor, AdjustableDate.class, this.getFinalFixingDate(), new AttributeMeta[0]);
    }

    public static class FloatingAmountCalculationBuilderImpl
    implements FloatingAmountCalculationBuilder {
        protected CalculationAmount.CalculationAmountBuilder calculationAmount;
        protected FloatingRateCalculation.FloatingRateCalculationBuilder floatingRate;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected ZonedDateTime initialFixingDate;
        protected AdjustableDate.AdjustableDateBuilder finalFixingDate;

        @Override
        @RosettaAttribute(value="calculationAmount")
        @RuneAttribute(value="calculationAmount")
        public CalculationAmount.CalculationAmountBuilder getCalculationAmount() {
            return this.calculationAmount;
        }

        @Override
        public CalculationAmount.CalculationAmountBuilder getOrCreateCalculationAmount() {
            CalculationAmount.CalculationAmountBuilder result = this.calculationAmount != null ? this.calculationAmount : (this.calculationAmount = CalculationAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRate", isRequired=true)
        @RuneAttribute(value="floatingRate", isRequired=true)
        public FloatingRateCalculation.FloatingRateCalculationBuilder getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        public FloatingRateCalculation.FloatingRateCalculationBuilder getOrCreateFloatingRate() {
            FloatingRateCalculation.FloatingRateCalculationBuilder result = this.floatingRate != null ? this.floatingRate : (this.floatingRate = FloatingRateCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialFixingDate")
        @RuneAttribute(value="initialFixingDate")
        public ZonedDateTime getInitialFixingDate() {
            return this.initialFixingDate;
        }

        @Override
        @RosettaAttribute(value="finalFixingDate")
        @RuneAttribute(value="finalFixingDate")
        public AdjustableDate.AdjustableDateBuilder getFinalFixingDate() {
            return this.finalFixingDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreateFinalFixingDate() {
            AdjustableDate.AdjustableDateBuilder result = this.finalFixingDate != null ? this.finalFixingDate : (this.finalFixingDate = AdjustableDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationAmount")
        @RuneAttribute(value="calculationAmount")
        public FloatingAmountCalculationBuilder setCalculationAmount(CalculationAmount _calculationAmount) {
            this.calculationAmount = _calculationAmount == null ? null : _calculationAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRate", isRequired=true)
        @RuneAttribute(value="floatingRate", isRequired=true)
        public FloatingAmountCalculationBuilder setFloatingRate(FloatingRateCalculation _floatingRate) {
            this.floatingRate = _floatingRate == null ? null : _floatingRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public FloatingAmountCalculationBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initialFixingDate")
        @RuneAttribute(value="initialFixingDate")
        public FloatingAmountCalculationBuilder setInitialFixingDate(ZonedDateTime _initialFixingDate) {
            this.initialFixingDate = _initialFixingDate == null ? null : _initialFixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalFixingDate")
        @RuneAttribute(value="finalFixingDate")
        public FloatingAmountCalculationBuilder setFinalFixingDate(AdjustableDate _finalFixingDate) {
            this.finalFixingDate = _finalFixingDate == null ? null : _finalFixingDate.toBuilder();
            return this;
        }

        @Override
        public FloatingAmountCalculation build() {
            return new FloatingAmountCalculationImpl(this);
        }

        @Override
        public FloatingAmountCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingAmountCalculationBuilder prune() {
            if (this.calculationAmount != null && !this.calculationAmount.prune().hasData()) {
                this.calculationAmount = null;
            }
            if (this.floatingRate != null && !this.floatingRate.prune().hasData()) {
                this.floatingRate = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.finalFixingDate != null && !this.finalFixingDate.prune().hasData()) {
                this.finalFixingDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCalculationAmount() != null && this.getCalculationAmount().hasData()) {
                return true;
            }
            if (this.getFloatingRate() != null && this.getFloatingRate().hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            if (this.getInitialFixingDate() != null) {
                return true;
            }
            return this.getFinalFixingDate() != null && this.getFinalFixingDate().hasData();
        }

        public FloatingAmountCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingAmountCalculationBuilder o = (FloatingAmountCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationAmount(), (RosettaModelObjectBuilder)o.getCalculationAmount(), this::setCalculationAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRate(), (RosettaModelObjectBuilder)o.getFloatingRate(), this::setFloatingRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalFixingDate(), (RosettaModelObjectBuilder)o.getFinalFixingDate(), this::setFinalFixingDate);
            merger.mergeBasic((Object)this.getInitialFixingDate(), (Object)o.getInitialFixingDate(), this::setInitialFixingDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingAmountCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.calculationAmount, _that.getCalculationAmount())) {
                return false;
            }
            if (!Objects.equals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.initialFixingDate, _that.getInitialFixingDate())) {
                return false;
            }
            return Objects.equals(this.finalFixingDate, _that.getFinalFixingDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationAmount != null ? this.calculationAmount.hashCode() : 0);
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.initialFixingDate != null ? this.initialFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.finalFixingDate != null ? this.finalFixingDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingAmountCalculationBuilder {calculationAmount=" + this.calculationAmount + ", floatingRate=" + this.floatingRate + ", dayCountFraction=" + this.dayCountFraction + ", initialFixingDate=" + this.initialFixingDate + ", finalFixingDate=" + this.finalFixingDate + '}';
        }
    }

    public static interface FloatingAmountCalculationBuilder
    extends FloatingAmountCalculation,
    RosettaModelObjectBuilder {
        public CalculationAmount.CalculationAmountBuilder getOrCreateCalculationAmount();

        @Override
        public CalculationAmount.CalculationAmountBuilder getCalculationAmount();

        public FloatingRateCalculation.FloatingRateCalculationBuilder getOrCreateFloatingRate();

        @Override
        public FloatingRateCalculation.FloatingRateCalculationBuilder getFloatingRate();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public AdjustableDate.AdjustableDateBuilder getOrCreateFinalFixingDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getFinalFixingDate();

        public FloatingAmountCalculationBuilder setCalculationAmount(CalculationAmount var1);

        public FloatingAmountCalculationBuilder setFloatingRate(FloatingRateCalculation var1);

        public FloatingAmountCalculationBuilder setDayCountFraction(DayCountFraction var1);

        public FloatingAmountCalculationBuilder setInitialFixingDate(ZonedDateTime var1);

        public FloatingAmountCalculationBuilder setFinalFixingDate(AdjustableDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("calculationAmount"), processor, CalculationAmount.CalculationAmountBuilder.class, this.getCalculationAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRate"), processor, FloatingRateCalculation.FloatingRateCalculationBuilder.class, this.getFloatingRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialFixingDate"), ZonedDateTime.class, (Object)this.getInitialFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalFixingDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getFinalFixingDate(), new AttributeMeta[0]);
        }

        public FloatingAmountCalculationBuilder prune();
    }

    public static class FloatingAmountCalculationImpl
    implements FloatingAmountCalculation {
        private final CalculationAmount calculationAmount;
        private final FloatingRateCalculation floatingRate;
        private final DayCountFraction dayCountFraction;
        private final ZonedDateTime initialFixingDate;
        private final AdjustableDate finalFixingDate;

        protected FloatingAmountCalculationImpl(FloatingAmountCalculationBuilder builder) {
            this.calculationAmount = Optional.ofNullable(builder.getCalculationAmount()).map(f -> f.build()).orElse(null);
            this.floatingRate = Optional.ofNullable(builder.getFloatingRate()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.initialFixingDate = builder.getInitialFixingDate();
            this.finalFixingDate = Optional.ofNullable(builder.getFinalFixingDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="calculationAmount")
        @RuneAttribute(value="calculationAmount")
        public CalculationAmount getCalculationAmount() {
            return this.calculationAmount;
        }

        @Override
        @RosettaAttribute(value="floatingRate", isRequired=true)
        @RuneAttribute(value="floatingRate", isRequired=true)
        public FloatingRateCalculation getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="initialFixingDate")
        @RuneAttribute(value="initialFixingDate")
        public ZonedDateTime getInitialFixingDate() {
            return this.initialFixingDate;
        }

        @Override
        @RosettaAttribute(value="finalFixingDate")
        @RuneAttribute(value="finalFixingDate")
        public AdjustableDate getFinalFixingDate() {
            return this.finalFixingDate;
        }

        @Override
        public FloatingAmountCalculation build() {
            return this;
        }

        @Override
        public FloatingAmountCalculationBuilder toBuilder() {
            FloatingAmountCalculationBuilder builder = FloatingAmountCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingAmountCalculationBuilder builder) {
            Optional.ofNullable(this.getCalculationAmount()).ifPresent(builder::setCalculationAmount);
            Optional.ofNullable(this.getFloatingRate()).ifPresent(builder::setFloatingRate);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getInitialFixingDate()).ifPresent(builder::setInitialFixingDate);
            Optional.ofNullable(this.getFinalFixingDate()).ifPresent(builder::setFinalFixingDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingAmountCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.calculationAmount, _that.getCalculationAmount())) {
                return false;
            }
            if (!Objects.equals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.initialFixingDate, _that.getInitialFixingDate())) {
                return false;
            }
            return Objects.equals(this.finalFixingDate, _that.getFinalFixingDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationAmount != null ? this.calculationAmount.hashCode() : 0);
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.initialFixingDate != null ? this.initialFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.finalFixingDate != null ? this.finalFixingDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingAmountCalculation {calculationAmount=" + this.calculationAmount + ", floatingRate=" + this.floatingRate + ", dayCountFraction=" + this.dayCountFraction + ", initialFixingDate=" + this.initialFixingDate + ", finalFixingDate=" + this.finalFixingDate + '}';
        }
    }
}

