/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.cd.LoanParticipation;
import fpml.consolidated.cd.NotDomesticCurrency;
import fpml.consolidated.cd.PCDeliverableObligationCharac;
import fpml.consolidated.cd.SpecifiedCurrency;
import fpml.consolidated.cd.meta.DeliverableObligationsMeta;
import fpml.consolidated.fpmlenum.ObligationCategoryEnum;
import fpml.consolidated.shared.Period;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="DeliverableObligations", builder=DeliverableObligationsBuilderImpl.class, version="1.1.0")
@RuneDataType(value="DeliverableObligations", model="fpml", builder=DeliverableObligationsBuilderImpl.class, version="1.1.0")
public interface DeliverableObligations
extends RosettaModelObject {
    public static final DeliverableObligationsMeta metaData = new DeliverableObligationsMeta();

    public Boolean getAccruedInterest();

    public ObligationCategoryEnum getCategory();

    public Boolean getNotSubordinated();

    public SpecifiedCurrency getSpecifiedCurrency();

    public Boolean getNotSovereignLender();

    public NotDomesticCurrency getNotDomesticCurrency();

    public Boolean getNotDomesticLaw();

    public Boolean getListed();

    public Boolean getNotContingent();

    public Boolean getNotDomesticIssuance();

    public PCDeliverableObligationCharac getAssignableLoan();

    public PCDeliverableObligationCharac getConsentRequiredLoan();

    public LoanParticipation getDirectLoanParticipation();

    public Boolean getTransferable();

    public Period getMaximumMaturity();

    public Boolean getAcceleratedOrMatured();

    public Boolean getNotBearer();

    public Boolean getFullFaithAndCreditObLiability();

    public Boolean getGeneralFundObligationLiability();

    public Boolean getRevenueObligationLiability();

    public LoanParticipation getIndirectLoanParticipation();

    public String getExcluded();

    public String getOthReferenceEntityObligations();

    public DeliverableObligations build();

    public DeliverableObligationsBuilder toBuilder();

    public static DeliverableObligationsBuilder builder() {
        return new DeliverableObligationsBuilderImpl();
    }

    default public RosettaMetaData<? extends DeliverableObligations> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DeliverableObligations> getType() {
        return DeliverableObligations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("accruedInterest"), Boolean.class, (Object)this.getAccruedInterest(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("category"), ObligationCategoryEnum.class, (Object)this.getCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notSubordinated"), Boolean.class, (Object)this.getNotSubordinated(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("specifiedCurrency"), processor, SpecifiedCurrency.class, this.getSpecifiedCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notSovereignLender"), Boolean.class, (Object)this.getNotSovereignLender(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notDomesticCurrency"), processor, NotDomesticCurrency.class, this.getNotDomesticCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notDomesticLaw"), Boolean.class, (Object)this.getNotDomesticLaw(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("listed"), Boolean.class, (Object)this.getListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notContingent"), Boolean.class, (Object)this.getNotContingent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notDomesticIssuance"), Boolean.class, (Object)this.getNotDomesticIssuance(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assignableLoan"), processor, PCDeliverableObligationCharac.class, this.getAssignableLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("consentRequiredLoan"), processor, PCDeliverableObligationCharac.class, this.getConsentRequiredLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("directLoanParticipation"), processor, LoanParticipation.class, this.getDirectLoanParticipation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("transferable"), Boolean.class, (Object)this.getTransferable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("maximumMaturity"), processor, Period.class, this.getMaximumMaturity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("acceleratedOrMatured"), Boolean.class, (Object)this.getAcceleratedOrMatured(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notBearer"), Boolean.class, (Object)this.getNotBearer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fullFaithAndCreditObLiability"), Boolean.class, (Object)this.getFullFaithAndCreditObLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("generalFundObligationLiability"), Boolean.class, (Object)this.getGeneralFundObligationLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("revenueObligationLiability"), Boolean.class, (Object)this.getRevenueObligationLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indirectLoanParticipation"), processor, LoanParticipation.class, this.getIndirectLoanParticipation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excluded"), String.class, (Object)this.getExcluded(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("othReferenceEntityObligations"), String.class, (Object)this.getOthReferenceEntityObligations(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DeliverableObligationsBuilderImpl
    implements DeliverableObligationsBuilder {
        protected Boolean accruedInterest;
        protected ObligationCategoryEnum category;
        protected Boolean notSubordinated;
        protected SpecifiedCurrency.SpecifiedCurrencyBuilder specifiedCurrency;
        protected Boolean notSovereignLender;
        protected NotDomesticCurrency.NotDomesticCurrencyBuilder notDomesticCurrency;
        protected Boolean notDomesticLaw;
        protected Boolean listed;
        protected Boolean notContingent;
        protected Boolean notDomesticIssuance;
        protected PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder assignableLoan;
        protected PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder consentRequiredLoan;
        protected LoanParticipation.LoanParticipationBuilder directLoanParticipation;
        protected Boolean transferable;
        protected Period.PeriodBuilder maximumMaturity;
        protected Boolean acceleratedOrMatured;
        protected Boolean notBearer;
        protected Boolean fullFaithAndCreditObLiability;
        protected Boolean generalFundObligationLiability;
        protected Boolean revenueObligationLiability;
        protected LoanParticipation.LoanParticipationBuilder indirectLoanParticipation;
        protected String excluded;
        protected String othReferenceEntityObligations;

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public Boolean getAccruedInterest() {
            return this.accruedInterest;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public ObligationCategoryEnum getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="notSubordinated")
        @RuneAttribute(value="notSubordinated")
        public Boolean getNotSubordinated() {
            return this.notSubordinated;
        }

        @Override
        @RosettaAttribute(value="specifiedCurrency")
        @RuneAttribute(value="specifiedCurrency")
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getSpecifiedCurrency() {
            return this.specifiedCurrency;
        }

        @Override
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getOrCreateSpecifiedCurrency() {
            SpecifiedCurrency.SpecifiedCurrencyBuilder result = this.specifiedCurrency != null ? this.specifiedCurrency : (this.specifiedCurrency = SpecifiedCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notSovereignLender")
        @RuneAttribute(value="notSovereignLender")
        public Boolean getNotSovereignLender() {
            return this.notSovereignLender;
        }

        @Override
        @RosettaAttribute(value="notDomesticCurrency")
        @RuneAttribute(value="notDomesticCurrency")
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getNotDomesticCurrency() {
            return this.notDomesticCurrency;
        }

        @Override
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getOrCreateNotDomesticCurrency() {
            NotDomesticCurrency.NotDomesticCurrencyBuilder result = this.notDomesticCurrency != null ? this.notDomesticCurrency : (this.notDomesticCurrency = NotDomesticCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notDomesticLaw")
        @RuneAttribute(value="notDomesticLaw")
        public Boolean getNotDomesticLaw() {
            return this.notDomesticLaw;
        }

        @Override
        @RosettaAttribute(value="listed")
        @RuneAttribute(value="listed")
        public Boolean getListed() {
            return this.listed;
        }

        @Override
        @RosettaAttribute(value="notContingent")
        @RuneAttribute(value="notContingent")
        public Boolean getNotContingent() {
            return this.notContingent;
        }

        @Override
        @RosettaAttribute(value="notDomesticIssuance")
        @RuneAttribute(value="notDomesticIssuance")
        public Boolean getNotDomesticIssuance() {
            return this.notDomesticIssuance;
        }

        @Override
        @RosettaAttribute(value="assignableLoan")
        @RuneAttribute(value="assignableLoan")
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getAssignableLoan() {
            return this.assignableLoan;
        }

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getOrCreateAssignableLoan() {
            PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder result = this.assignableLoan != null ? this.assignableLoan : (this.assignableLoan = PCDeliverableObligationCharac.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="consentRequiredLoan")
        @RuneAttribute(value="consentRequiredLoan")
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getConsentRequiredLoan() {
            return this.consentRequiredLoan;
        }

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getOrCreateConsentRequiredLoan() {
            PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder result = this.consentRequiredLoan != null ? this.consentRequiredLoan : (this.consentRequiredLoan = PCDeliverableObligationCharac.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="directLoanParticipation")
        @RuneAttribute(value="directLoanParticipation")
        public LoanParticipation.LoanParticipationBuilder getDirectLoanParticipation() {
            return this.directLoanParticipation;
        }

        @Override
        public LoanParticipation.LoanParticipationBuilder getOrCreateDirectLoanParticipation() {
            LoanParticipation.LoanParticipationBuilder result = this.directLoanParticipation != null ? this.directLoanParticipation : (this.directLoanParticipation = LoanParticipation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="transferable")
        @RuneAttribute(value="transferable")
        public Boolean getTransferable() {
            return this.transferable;
        }

        @Override
        @RosettaAttribute(value="maximumMaturity")
        @RuneAttribute(value="maximumMaturity")
        public Period.PeriodBuilder getMaximumMaturity() {
            return this.maximumMaturity;
        }

        @Override
        public Period.PeriodBuilder getOrCreateMaximumMaturity() {
            Period.PeriodBuilder result = this.maximumMaturity != null ? this.maximumMaturity : (this.maximumMaturity = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="acceleratedOrMatured")
        @RuneAttribute(value="acceleratedOrMatured")
        public Boolean getAcceleratedOrMatured() {
            return this.acceleratedOrMatured;
        }

        @Override
        @RosettaAttribute(value="notBearer")
        @RuneAttribute(value="notBearer")
        public Boolean getNotBearer() {
            return this.notBearer;
        }

        @Override
        @RosettaAttribute(value="fullFaithAndCreditObLiability")
        @RuneAttribute(value="fullFaithAndCreditObLiability")
        public Boolean getFullFaithAndCreditObLiability() {
            return this.fullFaithAndCreditObLiability;
        }

        @Override
        @RosettaAttribute(value="generalFundObligationLiability")
        @RuneAttribute(value="generalFundObligationLiability")
        public Boolean getGeneralFundObligationLiability() {
            return this.generalFundObligationLiability;
        }

        @Override
        @RosettaAttribute(value="revenueObligationLiability")
        @RuneAttribute(value="revenueObligationLiability")
        public Boolean getRevenueObligationLiability() {
            return this.revenueObligationLiability;
        }

        @Override
        @RosettaAttribute(value="indirectLoanParticipation")
        @RuneAttribute(value="indirectLoanParticipation")
        public LoanParticipation.LoanParticipationBuilder getIndirectLoanParticipation() {
            return this.indirectLoanParticipation;
        }

        @Override
        public LoanParticipation.LoanParticipationBuilder getOrCreateIndirectLoanParticipation() {
            LoanParticipation.LoanParticipationBuilder result = this.indirectLoanParticipation != null ? this.indirectLoanParticipation : (this.indirectLoanParticipation = LoanParticipation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="excluded")
        @RuneAttribute(value="excluded")
        public String getExcluded() {
            return this.excluded;
        }

        @Override
        @RosettaAttribute(value="othReferenceEntityObligations")
        @RuneAttribute(value="othReferenceEntityObligations")
        public String getOthReferenceEntityObligations() {
            return this.othReferenceEntityObligations;
        }

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public DeliverableObligationsBuilder setAccruedInterest(Boolean _accruedInterest) {
            this.accruedInterest = _accruedInterest == null ? null : _accruedInterest;
            return this;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public DeliverableObligationsBuilder setCategory(ObligationCategoryEnum _category) {
            this.category = _category == null ? null : _category;
            return this;
        }

        @Override
        @RosettaAttribute(value="notSubordinated")
        @RuneAttribute(value="notSubordinated")
        public DeliverableObligationsBuilder setNotSubordinated(Boolean _notSubordinated) {
            this.notSubordinated = _notSubordinated == null ? null : _notSubordinated;
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedCurrency")
        @RuneAttribute(value="specifiedCurrency")
        public DeliverableObligationsBuilder setSpecifiedCurrency(SpecifiedCurrency _specifiedCurrency) {
            this.specifiedCurrency = _specifiedCurrency == null ? null : _specifiedCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notSovereignLender")
        @RuneAttribute(value="notSovereignLender")
        public DeliverableObligationsBuilder setNotSovereignLender(Boolean _notSovereignLender) {
            this.notSovereignLender = _notSovereignLender == null ? null : _notSovereignLender;
            return this;
        }

        @Override
        @RosettaAttribute(value="notDomesticCurrency")
        @RuneAttribute(value="notDomesticCurrency")
        public DeliverableObligationsBuilder setNotDomesticCurrency(NotDomesticCurrency _notDomesticCurrency) {
            this.notDomesticCurrency = _notDomesticCurrency == null ? null : _notDomesticCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notDomesticLaw")
        @RuneAttribute(value="notDomesticLaw")
        public DeliverableObligationsBuilder setNotDomesticLaw(Boolean _notDomesticLaw) {
            this.notDomesticLaw = _notDomesticLaw == null ? null : _notDomesticLaw;
            return this;
        }

        @Override
        @RosettaAttribute(value="listed")
        @RuneAttribute(value="listed")
        public DeliverableObligationsBuilder setListed(Boolean _listed) {
            this.listed = _listed == null ? null : _listed;
            return this;
        }

        @Override
        @RosettaAttribute(value="notContingent")
        @RuneAttribute(value="notContingent")
        public DeliverableObligationsBuilder setNotContingent(Boolean _notContingent) {
            this.notContingent = _notContingent == null ? null : _notContingent;
            return this;
        }

        @Override
        @RosettaAttribute(value="notDomesticIssuance")
        @RuneAttribute(value="notDomesticIssuance")
        public DeliverableObligationsBuilder setNotDomesticIssuance(Boolean _notDomesticIssuance) {
            this.notDomesticIssuance = _notDomesticIssuance == null ? null : _notDomesticIssuance;
            return this;
        }

        @Override
        @RosettaAttribute(value="assignableLoan")
        @RuneAttribute(value="assignableLoan")
        public DeliverableObligationsBuilder setAssignableLoan(PCDeliverableObligationCharac _assignableLoan) {
            this.assignableLoan = _assignableLoan == null ? null : _assignableLoan.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="consentRequiredLoan")
        @RuneAttribute(value="consentRequiredLoan")
        public DeliverableObligationsBuilder setConsentRequiredLoan(PCDeliverableObligationCharac _consentRequiredLoan) {
            this.consentRequiredLoan = _consentRequiredLoan == null ? null : _consentRequiredLoan.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="directLoanParticipation")
        @RuneAttribute(value="directLoanParticipation")
        public DeliverableObligationsBuilder setDirectLoanParticipation(LoanParticipation _directLoanParticipation) {
            this.directLoanParticipation = _directLoanParticipation == null ? null : _directLoanParticipation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="transferable")
        @RuneAttribute(value="transferable")
        public DeliverableObligationsBuilder setTransferable(Boolean _transferable) {
            this.transferable = _transferable == null ? null : _transferable;
            return this;
        }

        @Override
        @RosettaAttribute(value="maximumMaturity")
        @RuneAttribute(value="maximumMaturity")
        public DeliverableObligationsBuilder setMaximumMaturity(Period _maximumMaturity) {
            this.maximumMaturity = _maximumMaturity == null ? null : _maximumMaturity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="acceleratedOrMatured")
        @RuneAttribute(value="acceleratedOrMatured")
        public DeliverableObligationsBuilder setAcceleratedOrMatured(Boolean _acceleratedOrMatured) {
            this.acceleratedOrMatured = _acceleratedOrMatured == null ? null : _acceleratedOrMatured;
            return this;
        }

        @Override
        @RosettaAttribute(value="notBearer")
        @RuneAttribute(value="notBearer")
        public DeliverableObligationsBuilder setNotBearer(Boolean _notBearer) {
            this.notBearer = _notBearer == null ? null : _notBearer;
            return this;
        }

        @Override
        @RosettaAttribute(value="fullFaithAndCreditObLiability")
        @RuneAttribute(value="fullFaithAndCreditObLiability")
        public DeliverableObligationsBuilder setFullFaithAndCreditObLiability(Boolean _fullFaithAndCreditObLiability) {
            this.fullFaithAndCreditObLiability = _fullFaithAndCreditObLiability == null ? null : _fullFaithAndCreditObLiability;
            return this;
        }

        @Override
        @RosettaAttribute(value="generalFundObligationLiability")
        @RuneAttribute(value="generalFundObligationLiability")
        public DeliverableObligationsBuilder setGeneralFundObligationLiability(Boolean _generalFundObligationLiability) {
            this.generalFundObligationLiability = _generalFundObligationLiability == null ? null : _generalFundObligationLiability;
            return this;
        }

        @Override
        @RosettaAttribute(value="revenueObligationLiability")
        @RuneAttribute(value="revenueObligationLiability")
        public DeliverableObligationsBuilder setRevenueObligationLiability(Boolean _revenueObligationLiability) {
            this.revenueObligationLiability = _revenueObligationLiability == null ? null : _revenueObligationLiability;
            return this;
        }

        @Override
        @RosettaAttribute(value="indirectLoanParticipation")
        @RuneAttribute(value="indirectLoanParticipation")
        public DeliverableObligationsBuilder setIndirectLoanParticipation(LoanParticipation _indirectLoanParticipation) {
            this.indirectLoanParticipation = _indirectLoanParticipation == null ? null : _indirectLoanParticipation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="excluded")
        @RuneAttribute(value="excluded")
        public DeliverableObligationsBuilder setExcluded(String _excluded) {
            this.excluded = _excluded == null ? null : _excluded;
            return this;
        }

        @Override
        @RosettaAttribute(value="othReferenceEntityObligations")
        @RuneAttribute(value="othReferenceEntityObligations")
        public DeliverableObligationsBuilder setOthReferenceEntityObligations(String _othReferenceEntityObligations) {
            this.othReferenceEntityObligations = _othReferenceEntityObligations == null ? null : _othReferenceEntityObligations;
            return this;
        }

        @Override
        public DeliverableObligations build() {
            return new DeliverableObligationsImpl(this);
        }

        @Override
        public DeliverableObligationsBuilder toBuilder() {
            return this;
        }

        @Override
        public DeliverableObligationsBuilder prune() {
            if (this.specifiedCurrency != null && !this.specifiedCurrency.prune().hasData()) {
                this.specifiedCurrency = null;
            }
            if (this.notDomesticCurrency != null && !this.notDomesticCurrency.prune().hasData()) {
                this.notDomesticCurrency = null;
            }
            if (this.assignableLoan != null && !this.assignableLoan.prune().hasData()) {
                this.assignableLoan = null;
            }
            if (this.consentRequiredLoan != null && !this.consentRequiredLoan.prune().hasData()) {
                this.consentRequiredLoan = null;
            }
            if (this.directLoanParticipation != null && !this.directLoanParticipation.prune().hasData()) {
                this.directLoanParticipation = null;
            }
            if (this.maximumMaturity != null && !this.maximumMaturity.prune().hasData()) {
                this.maximumMaturity = null;
            }
            if (this.indirectLoanParticipation != null && !this.indirectLoanParticipation.prune().hasData()) {
                this.indirectLoanParticipation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccruedInterest() != null) {
                return true;
            }
            if (this.getCategory() != null) {
                return true;
            }
            if (this.getNotSubordinated() != null) {
                return true;
            }
            if (this.getSpecifiedCurrency() != null && this.getSpecifiedCurrency().hasData()) {
                return true;
            }
            if (this.getNotSovereignLender() != null) {
                return true;
            }
            if (this.getNotDomesticCurrency() != null && this.getNotDomesticCurrency().hasData()) {
                return true;
            }
            if (this.getNotDomesticLaw() != null) {
                return true;
            }
            if (this.getListed() != null) {
                return true;
            }
            if (this.getNotContingent() != null) {
                return true;
            }
            if (this.getNotDomesticIssuance() != null) {
                return true;
            }
            if (this.getAssignableLoan() != null && this.getAssignableLoan().hasData()) {
                return true;
            }
            if (this.getConsentRequiredLoan() != null && this.getConsentRequiredLoan().hasData()) {
                return true;
            }
            if (this.getDirectLoanParticipation() != null && this.getDirectLoanParticipation().hasData()) {
                return true;
            }
            if (this.getTransferable() != null) {
                return true;
            }
            if (this.getMaximumMaturity() != null && this.getMaximumMaturity().hasData()) {
                return true;
            }
            if (this.getAcceleratedOrMatured() != null) {
                return true;
            }
            if (this.getNotBearer() != null) {
                return true;
            }
            if (this.getFullFaithAndCreditObLiability() != null) {
                return true;
            }
            if (this.getGeneralFundObligationLiability() != null) {
                return true;
            }
            if (this.getRevenueObligationLiability() != null) {
                return true;
            }
            if (this.getIndirectLoanParticipation() != null && this.getIndirectLoanParticipation().hasData()) {
                return true;
            }
            if (this.getExcluded() != null) {
                return true;
            }
            return this.getOthReferenceEntityObligations() != null;
        }

        public DeliverableObligationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DeliverableObligationsBuilder o = (DeliverableObligationsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpecifiedCurrency(), (RosettaModelObjectBuilder)o.getSpecifiedCurrency(), this::setSpecifiedCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotDomesticCurrency(), (RosettaModelObjectBuilder)o.getNotDomesticCurrency(), this::setNotDomesticCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAssignableLoan(), (RosettaModelObjectBuilder)o.getAssignableLoan(), this::setAssignableLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConsentRequiredLoan(), (RosettaModelObjectBuilder)o.getConsentRequiredLoan(), this::setConsentRequiredLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDirectLoanParticipation(), (RosettaModelObjectBuilder)o.getDirectLoanParticipation(), this::setDirectLoanParticipation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMaximumMaturity(), (RosettaModelObjectBuilder)o.getMaximumMaturity(), this::setMaximumMaturity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndirectLoanParticipation(), (RosettaModelObjectBuilder)o.getIndirectLoanParticipation(), this::setIndirectLoanParticipation);
            merger.mergeBasic((Object)this.getAccruedInterest(), (Object)o.getAccruedInterest(), this::setAccruedInterest, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCategory(), (Object)o.getCategory(), this::setCategory, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotSubordinated(), (Object)o.getNotSubordinated(), this::setNotSubordinated, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotSovereignLender(), (Object)o.getNotSovereignLender(), this::setNotSovereignLender, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotDomesticLaw(), (Object)o.getNotDomesticLaw(), this::setNotDomesticLaw, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getListed(), (Object)o.getListed(), this::setListed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotContingent(), (Object)o.getNotContingent(), this::setNotContingent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotDomesticIssuance(), (Object)o.getNotDomesticIssuance(), this::setNotDomesticIssuance, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTransferable(), (Object)o.getTransferable(), this::setTransferable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAcceleratedOrMatured(), (Object)o.getAcceleratedOrMatured(), this::setAcceleratedOrMatured, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotBearer(), (Object)o.getNotBearer(), this::setNotBearer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFullFaithAndCreditObLiability(), (Object)o.getFullFaithAndCreditObLiability(), this::setFullFaithAndCreditObLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGeneralFundObligationLiability(), (Object)o.getGeneralFundObligationLiability(), this::setGeneralFundObligationLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRevenueObligationLiability(), (Object)o.getRevenueObligationLiability(), this::setRevenueObligationLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExcluded(), (Object)o.getExcluded(), this::setExcluded, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOthReferenceEntityObligations(), (Object)o.getOthReferenceEntityObligations(), this::setOthReferenceEntityObligations, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DeliverableObligations _that = this.getType().cast(o);
            if (!Objects.equals(this.accruedInterest, _that.getAccruedInterest())) {
                return false;
            }
            if (!Objects.equals((Object)this.category, (Object)_that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.notSubordinated, _that.getNotSubordinated())) {
                return false;
            }
            if (!Objects.equals(this.specifiedCurrency, _that.getSpecifiedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notSovereignLender, _that.getNotSovereignLender())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticCurrency, _that.getNotDomesticCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticLaw, _that.getNotDomesticLaw())) {
                return false;
            }
            if (!Objects.equals(this.listed, _that.getListed())) {
                return false;
            }
            if (!Objects.equals(this.notContingent, _that.getNotContingent())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticIssuance, _that.getNotDomesticIssuance())) {
                return false;
            }
            if (!Objects.equals(this.assignableLoan, _that.getAssignableLoan())) {
                return false;
            }
            if (!Objects.equals(this.consentRequiredLoan, _that.getConsentRequiredLoan())) {
                return false;
            }
            if (!Objects.equals(this.directLoanParticipation, _that.getDirectLoanParticipation())) {
                return false;
            }
            if (!Objects.equals(this.transferable, _that.getTransferable())) {
                return false;
            }
            if (!Objects.equals(this.maximumMaturity, _that.getMaximumMaturity())) {
                return false;
            }
            if (!Objects.equals(this.acceleratedOrMatured, _that.getAcceleratedOrMatured())) {
                return false;
            }
            if (!Objects.equals(this.notBearer, _that.getNotBearer())) {
                return false;
            }
            if (!Objects.equals(this.fullFaithAndCreditObLiability, _that.getFullFaithAndCreditObLiability())) {
                return false;
            }
            if (!Objects.equals(this.generalFundObligationLiability, _that.getGeneralFundObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.revenueObligationLiability, _that.getRevenueObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.indirectLoanParticipation, _that.getIndirectLoanParticipation())) {
                return false;
            }
            if (!Objects.equals(this.excluded, _that.getExcluded())) {
                return false;
            }
            return Objects.equals(this.othReferenceEntityObligations, _that.getOthReferenceEntityObligations());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accruedInterest != null ? this.accruedInterest.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? ((Object)((Object)this.category)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notSubordinated != null ? this.notSubordinated.hashCode() : 0);
            _result = 31 * _result + (this.specifiedCurrency != null ? this.specifiedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notSovereignLender != null ? this.notSovereignLender.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticCurrency != null ? this.notDomesticCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticLaw != null ? this.notDomesticLaw.hashCode() : 0);
            _result = 31 * _result + (this.listed != null ? this.listed.hashCode() : 0);
            _result = 31 * _result + (this.notContingent != null ? this.notContingent.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticIssuance != null ? this.notDomesticIssuance.hashCode() : 0);
            _result = 31 * _result + (this.assignableLoan != null ? this.assignableLoan.hashCode() : 0);
            _result = 31 * _result + (this.consentRequiredLoan != null ? this.consentRequiredLoan.hashCode() : 0);
            _result = 31 * _result + (this.directLoanParticipation != null ? this.directLoanParticipation.hashCode() : 0);
            _result = 31 * _result + (this.transferable != null ? this.transferable.hashCode() : 0);
            _result = 31 * _result + (this.maximumMaturity != null ? this.maximumMaturity.hashCode() : 0);
            _result = 31 * _result + (this.acceleratedOrMatured != null ? this.acceleratedOrMatured.hashCode() : 0);
            _result = 31 * _result + (this.notBearer != null ? this.notBearer.hashCode() : 0);
            _result = 31 * _result + (this.fullFaithAndCreditObLiability != null ? this.fullFaithAndCreditObLiability.hashCode() : 0);
            _result = 31 * _result + (this.generalFundObligationLiability != null ? this.generalFundObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.revenueObligationLiability != null ? this.revenueObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.indirectLoanParticipation != null ? this.indirectLoanParticipation.hashCode() : 0);
            _result = 31 * _result + (this.excluded != null ? this.excluded.hashCode() : 0);
            _result = 31 * _result + (this.othReferenceEntityObligations != null ? this.othReferenceEntityObligations.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DeliverableObligationsBuilder {accruedInterest=" + this.accruedInterest + ", category=" + (Object)((Object)this.category) + ", notSubordinated=" + this.notSubordinated + ", specifiedCurrency=" + this.specifiedCurrency + ", notSovereignLender=" + this.notSovereignLender + ", notDomesticCurrency=" + this.notDomesticCurrency + ", notDomesticLaw=" + this.notDomesticLaw + ", listed=" + this.listed + ", notContingent=" + this.notContingent + ", notDomesticIssuance=" + this.notDomesticIssuance + ", assignableLoan=" + this.assignableLoan + ", consentRequiredLoan=" + this.consentRequiredLoan + ", directLoanParticipation=" + this.directLoanParticipation + ", transferable=" + this.transferable + ", maximumMaturity=" + this.maximumMaturity + ", acceleratedOrMatured=" + this.acceleratedOrMatured + ", notBearer=" + this.notBearer + ", fullFaithAndCreditObLiability=" + this.fullFaithAndCreditObLiability + ", generalFundObligationLiability=" + this.generalFundObligationLiability + ", revenueObligationLiability=" + this.revenueObligationLiability + ", indirectLoanParticipation=" + this.indirectLoanParticipation + ", excluded=" + this.excluded + ", othReferenceEntityObligations=" + this.othReferenceEntityObligations + '}';
        }
    }

    public static interface DeliverableObligationsBuilder
    extends DeliverableObligations,
    RosettaModelObjectBuilder {
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getOrCreateSpecifiedCurrency();

        @Override
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getSpecifiedCurrency();

        public NotDomesticCurrency.NotDomesticCurrencyBuilder getOrCreateNotDomesticCurrency();

        @Override
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getNotDomesticCurrency();

        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getOrCreateAssignableLoan();

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getAssignableLoan();

        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getOrCreateConsentRequiredLoan();

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getConsentRequiredLoan();

        public LoanParticipation.LoanParticipationBuilder getOrCreateDirectLoanParticipation();

        @Override
        public LoanParticipation.LoanParticipationBuilder getDirectLoanParticipation();

        public Period.PeriodBuilder getOrCreateMaximumMaturity();

        @Override
        public Period.PeriodBuilder getMaximumMaturity();

        public LoanParticipation.LoanParticipationBuilder getOrCreateIndirectLoanParticipation();

        @Override
        public LoanParticipation.LoanParticipationBuilder getIndirectLoanParticipation();

        public DeliverableObligationsBuilder setAccruedInterest(Boolean var1);

        public DeliverableObligationsBuilder setCategory(ObligationCategoryEnum var1);

        public DeliverableObligationsBuilder setNotSubordinated(Boolean var1);

        public DeliverableObligationsBuilder setSpecifiedCurrency(SpecifiedCurrency var1);

        public DeliverableObligationsBuilder setNotSovereignLender(Boolean var1);

        public DeliverableObligationsBuilder setNotDomesticCurrency(NotDomesticCurrency var1);

        public DeliverableObligationsBuilder setNotDomesticLaw(Boolean var1);

        public DeliverableObligationsBuilder setListed(Boolean var1);

        public DeliverableObligationsBuilder setNotContingent(Boolean var1);

        public DeliverableObligationsBuilder setNotDomesticIssuance(Boolean var1);

        public DeliverableObligationsBuilder setAssignableLoan(PCDeliverableObligationCharac var1);

        public DeliverableObligationsBuilder setConsentRequiredLoan(PCDeliverableObligationCharac var1);

        public DeliverableObligationsBuilder setDirectLoanParticipation(LoanParticipation var1);

        public DeliverableObligationsBuilder setTransferable(Boolean var1);

        public DeliverableObligationsBuilder setMaximumMaturity(Period var1);

        public DeliverableObligationsBuilder setAcceleratedOrMatured(Boolean var1);

        public DeliverableObligationsBuilder setNotBearer(Boolean var1);

        public DeliverableObligationsBuilder setFullFaithAndCreditObLiability(Boolean var1);

        public DeliverableObligationsBuilder setGeneralFundObligationLiability(Boolean var1);

        public DeliverableObligationsBuilder setRevenueObligationLiability(Boolean var1);

        public DeliverableObligationsBuilder setIndirectLoanParticipation(LoanParticipation var1);

        public DeliverableObligationsBuilder setExcluded(String var1);

        public DeliverableObligationsBuilder setOthReferenceEntityObligations(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("accruedInterest"), Boolean.class, (Object)this.getAccruedInterest(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("category"), ObligationCategoryEnum.class, (Object)this.getCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notSubordinated"), Boolean.class, (Object)this.getNotSubordinated(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("specifiedCurrency"), processor, SpecifiedCurrency.SpecifiedCurrencyBuilder.class, this.getSpecifiedCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notSovereignLender"), Boolean.class, (Object)this.getNotSovereignLender(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notDomesticCurrency"), processor, NotDomesticCurrency.NotDomesticCurrencyBuilder.class, this.getNotDomesticCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notDomesticLaw"), Boolean.class, (Object)this.getNotDomesticLaw(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("listed"), Boolean.class, (Object)this.getListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notContingent"), Boolean.class, (Object)this.getNotContingent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notDomesticIssuance"), Boolean.class, (Object)this.getNotDomesticIssuance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assignableLoan"), processor, PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder.class, this.getAssignableLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("consentRequiredLoan"), processor, PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder.class, this.getConsentRequiredLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("directLoanParticipation"), processor, LoanParticipation.LoanParticipationBuilder.class, this.getDirectLoanParticipation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("transferable"), Boolean.class, (Object)this.getTransferable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("maximumMaturity"), processor, Period.PeriodBuilder.class, this.getMaximumMaturity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("acceleratedOrMatured"), Boolean.class, (Object)this.getAcceleratedOrMatured(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notBearer"), Boolean.class, (Object)this.getNotBearer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fullFaithAndCreditObLiability"), Boolean.class, (Object)this.getFullFaithAndCreditObLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("generalFundObligationLiability"), Boolean.class, (Object)this.getGeneralFundObligationLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("revenueObligationLiability"), Boolean.class, (Object)this.getRevenueObligationLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indirectLoanParticipation"), processor, LoanParticipation.LoanParticipationBuilder.class, this.getIndirectLoanParticipation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excluded"), String.class, (Object)this.getExcluded(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("othReferenceEntityObligations"), String.class, (Object)this.getOthReferenceEntityObligations(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DeliverableObligationsBuilder prune();
    }

    public static class DeliverableObligationsImpl
    implements DeliverableObligations {
        private final Boolean accruedInterest;
        private final ObligationCategoryEnum category;
        private final Boolean notSubordinated;
        private final SpecifiedCurrency specifiedCurrency;
        private final Boolean notSovereignLender;
        private final NotDomesticCurrency notDomesticCurrency;
        private final Boolean notDomesticLaw;
        private final Boolean listed;
        private final Boolean notContingent;
        private final Boolean notDomesticIssuance;
        private final PCDeliverableObligationCharac assignableLoan;
        private final PCDeliverableObligationCharac consentRequiredLoan;
        private final LoanParticipation directLoanParticipation;
        private final Boolean transferable;
        private final Period maximumMaturity;
        private final Boolean acceleratedOrMatured;
        private final Boolean notBearer;
        private final Boolean fullFaithAndCreditObLiability;
        private final Boolean generalFundObligationLiability;
        private final Boolean revenueObligationLiability;
        private final LoanParticipation indirectLoanParticipation;
        private final String excluded;
        private final String othReferenceEntityObligations;

        protected DeliverableObligationsImpl(DeliverableObligationsBuilder builder) {
            this.accruedInterest = builder.getAccruedInterest();
            this.category = builder.getCategory();
            this.notSubordinated = builder.getNotSubordinated();
            this.specifiedCurrency = Optional.ofNullable(builder.getSpecifiedCurrency()).map(f -> f.build()).orElse(null);
            this.notSovereignLender = builder.getNotSovereignLender();
            this.notDomesticCurrency = Optional.ofNullable(builder.getNotDomesticCurrency()).map(f -> f.build()).orElse(null);
            this.notDomesticLaw = builder.getNotDomesticLaw();
            this.listed = builder.getListed();
            this.notContingent = builder.getNotContingent();
            this.notDomesticIssuance = builder.getNotDomesticIssuance();
            this.assignableLoan = Optional.ofNullable(builder.getAssignableLoan()).map(f -> f.build()).orElse(null);
            this.consentRequiredLoan = Optional.ofNullable(builder.getConsentRequiredLoan()).map(f -> f.build()).orElse(null);
            this.directLoanParticipation = Optional.ofNullable(builder.getDirectLoanParticipation()).map(f -> f.build()).orElse(null);
            this.transferable = builder.getTransferable();
            this.maximumMaturity = Optional.ofNullable(builder.getMaximumMaturity()).map(f -> f.build()).orElse(null);
            this.acceleratedOrMatured = builder.getAcceleratedOrMatured();
            this.notBearer = builder.getNotBearer();
            this.fullFaithAndCreditObLiability = builder.getFullFaithAndCreditObLiability();
            this.generalFundObligationLiability = builder.getGeneralFundObligationLiability();
            this.revenueObligationLiability = builder.getRevenueObligationLiability();
            this.indirectLoanParticipation = Optional.ofNullable(builder.getIndirectLoanParticipation()).map(f -> f.build()).orElse(null);
            this.excluded = builder.getExcluded();
            this.othReferenceEntityObligations = builder.getOthReferenceEntityObligations();
        }

        @Override
        @RosettaAttribute(value="accruedInterest")
        @RuneAttribute(value="accruedInterest")
        public Boolean getAccruedInterest() {
            return this.accruedInterest;
        }

        @Override
        @RosettaAttribute(value="category")
        @RuneAttribute(value="category")
        public ObligationCategoryEnum getCategory() {
            return this.category;
        }

        @Override
        @RosettaAttribute(value="notSubordinated")
        @RuneAttribute(value="notSubordinated")
        public Boolean getNotSubordinated() {
            return this.notSubordinated;
        }

        @Override
        @RosettaAttribute(value="specifiedCurrency")
        @RuneAttribute(value="specifiedCurrency")
        public SpecifiedCurrency getSpecifiedCurrency() {
            return this.specifiedCurrency;
        }

        @Override
        @RosettaAttribute(value="notSovereignLender")
        @RuneAttribute(value="notSovereignLender")
        public Boolean getNotSovereignLender() {
            return this.notSovereignLender;
        }

        @Override
        @RosettaAttribute(value="notDomesticCurrency")
        @RuneAttribute(value="notDomesticCurrency")
        public NotDomesticCurrency getNotDomesticCurrency() {
            return this.notDomesticCurrency;
        }

        @Override
        @RosettaAttribute(value="notDomesticLaw")
        @RuneAttribute(value="notDomesticLaw")
        public Boolean getNotDomesticLaw() {
            return this.notDomesticLaw;
        }

        @Override
        @RosettaAttribute(value="listed")
        @RuneAttribute(value="listed")
        public Boolean getListed() {
            return this.listed;
        }

        @Override
        @RosettaAttribute(value="notContingent")
        @RuneAttribute(value="notContingent")
        public Boolean getNotContingent() {
            return this.notContingent;
        }

        @Override
        @RosettaAttribute(value="notDomesticIssuance")
        @RuneAttribute(value="notDomesticIssuance")
        public Boolean getNotDomesticIssuance() {
            return this.notDomesticIssuance;
        }

        @Override
        @RosettaAttribute(value="assignableLoan")
        @RuneAttribute(value="assignableLoan")
        public PCDeliverableObligationCharac getAssignableLoan() {
            return this.assignableLoan;
        }

        @Override
        @RosettaAttribute(value="consentRequiredLoan")
        @RuneAttribute(value="consentRequiredLoan")
        public PCDeliverableObligationCharac getConsentRequiredLoan() {
            return this.consentRequiredLoan;
        }

        @Override
        @RosettaAttribute(value="directLoanParticipation")
        @RuneAttribute(value="directLoanParticipation")
        public LoanParticipation getDirectLoanParticipation() {
            return this.directLoanParticipation;
        }

        @Override
        @RosettaAttribute(value="transferable")
        @RuneAttribute(value="transferable")
        public Boolean getTransferable() {
            return this.transferable;
        }

        @Override
        @RosettaAttribute(value="maximumMaturity")
        @RuneAttribute(value="maximumMaturity")
        public Period getMaximumMaturity() {
            return this.maximumMaturity;
        }

        @Override
        @RosettaAttribute(value="acceleratedOrMatured")
        @RuneAttribute(value="acceleratedOrMatured")
        public Boolean getAcceleratedOrMatured() {
            return this.acceleratedOrMatured;
        }

        @Override
        @RosettaAttribute(value="notBearer")
        @RuneAttribute(value="notBearer")
        public Boolean getNotBearer() {
            return this.notBearer;
        }

        @Override
        @RosettaAttribute(value="fullFaithAndCreditObLiability")
        @RuneAttribute(value="fullFaithAndCreditObLiability")
        public Boolean getFullFaithAndCreditObLiability() {
            return this.fullFaithAndCreditObLiability;
        }

        @Override
        @RosettaAttribute(value="generalFundObligationLiability")
        @RuneAttribute(value="generalFundObligationLiability")
        public Boolean getGeneralFundObligationLiability() {
            return this.generalFundObligationLiability;
        }

        @Override
        @RosettaAttribute(value="revenueObligationLiability")
        @RuneAttribute(value="revenueObligationLiability")
        public Boolean getRevenueObligationLiability() {
            return this.revenueObligationLiability;
        }

        @Override
        @RosettaAttribute(value="indirectLoanParticipation")
        @RuneAttribute(value="indirectLoanParticipation")
        public LoanParticipation getIndirectLoanParticipation() {
            return this.indirectLoanParticipation;
        }

        @Override
        @RosettaAttribute(value="excluded")
        @RuneAttribute(value="excluded")
        public String getExcluded() {
            return this.excluded;
        }

        @Override
        @RosettaAttribute(value="othReferenceEntityObligations")
        @RuneAttribute(value="othReferenceEntityObligations")
        public String getOthReferenceEntityObligations() {
            return this.othReferenceEntityObligations;
        }

        @Override
        public DeliverableObligations build() {
            return this;
        }

        @Override
        public DeliverableObligationsBuilder toBuilder() {
            DeliverableObligationsBuilder builder = DeliverableObligations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DeliverableObligationsBuilder builder) {
            Optional.ofNullable(this.getAccruedInterest()).ifPresent(builder::setAccruedInterest);
            Optional.ofNullable(this.getCategory()).ifPresent(builder::setCategory);
            Optional.ofNullable(this.getNotSubordinated()).ifPresent(builder::setNotSubordinated);
            Optional.ofNullable(this.getSpecifiedCurrency()).ifPresent(builder::setSpecifiedCurrency);
            Optional.ofNullable(this.getNotSovereignLender()).ifPresent(builder::setNotSovereignLender);
            Optional.ofNullable(this.getNotDomesticCurrency()).ifPresent(builder::setNotDomesticCurrency);
            Optional.ofNullable(this.getNotDomesticLaw()).ifPresent(builder::setNotDomesticLaw);
            Optional.ofNullable(this.getListed()).ifPresent(builder::setListed);
            Optional.ofNullable(this.getNotContingent()).ifPresent(builder::setNotContingent);
            Optional.ofNullable(this.getNotDomesticIssuance()).ifPresent(builder::setNotDomesticIssuance);
            Optional.ofNullable(this.getAssignableLoan()).ifPresent(builder::setAssignableLoan);
            Optional.ofNullable(this.getConsentRequiredLoan()).ifPresent(builder::setConsentRequiredLoan);
            Optional.ofNullable(this.getDirectLoanParticipation()).ifPresent(builder::setDirectLoanParticipation);
            Optional.ofNullable(this.getTransferable()).ifPresent(builder::setTransferable);
            Optional.ofNullable(this.getMaximumMaturity()).ifPresent(builder::setMaximumMaturity);
            Optional.ofNullable(this.getAcceleratedOrMatured()).ifPresent(builder::setAcceleratedOrMatured);
            Optional.ofNullable(this.getNotBearer()).ifPresent(builder::setNotBearer);
            Optional.ofNullable(this.getFullFaithAndCreditObLiability()).ifPresent(builder::setFullFaithAndCreditObLiability);
            Optional.ofNullable(this.getGeneralFundObligationLiability()).ifPresent(builder::setGeneralFundObligationLiability);
            Optional.ofNullable(this.getRevenueObligationLiability()).ifPresent(builder::setRevenueObligationLiability);
            Optional.ofNullable(this.getIndirectLoanParticipation()).ifPresent(builder::setIndirectLoanParticipation);
            Optional.ofNullable(this.getExcluded()).ifPresent(builder::setExcluded);
            Optional.ofNullable(this.getOthReferenceEntityObligations()).ifPresent(builder::setOthReferenceEntityObligations);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DeliverableObligations _that = this.getType().cast(o);
            if (!Objects.equals(this.accruedInterest, _that.getAccruedInterest())) {
                return false;
            }
            if (!Objects.equals((Object)this.category, (Object)_that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.notSubordinated, _that.getNotSubordinated())) {
                return false;
            }
            if (!Objects.equals(this.specifiedCurrency, _that.getSpecifiedCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notSovereignLender, _that.getNotSovereignLender())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticCurrency, _that.getNotDomesticCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticLaw, _that.getNotDomesticLaw())) {
                return false;
            }
            if (!Objects.equals(this.listed, _that.getListed())) {
                return false;
            }
            if (!Objects.equals(this.notContingent, _that.getNotContingent())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticIssuance, _that.getNotDomesticIssuance())) {
                return false;
            }
            if (!Objects.equals(this.assignableLoan, _that.getAssignableLoan())) {
                return false;
            }
            if (!Objects.equals(this.consentRequiredLoan, _that.getConsentRequiredLoan())) {
                return false;
            }
            if (!Objects.equals(this.directLoanParticipation, _that.getDirectLoanParticipation())) {
                return false;
            }
            if (!Objects.equals(this.transferable, _that.getTransferable())) {
                return false;
            }
            if (!Objects.equals(this.maximumMaturity, _that.getMaximumMaturity())) {
                return false;
            }
            if (!Objects.equals(this.acceleratedOrMatured, _that.getAcceleratedOrMatured())) {
                return false;
            }
            if (!Objects.equals(this.notBearer, _that.getNotBearer())) {
                return false;
            }
            if (!Objects.equals(this.fullFaithAndCreditObLiability, _that.getFullFaithAndCreditObLiability())) {
                return false;
            }
            if (!Objects.equals(this.generalFundObligationLiability, _that.getGeneralFundObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.revenueObligationLiability, _that.getRevenueObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.indirectLoanParticipation, _that.getIndirectLoanParticipation())) {
                return false;
            }
            if (!Objects.equals(this.excluded, _that.getExcluded())) {
                return false;
            }
            return Objects.equals(this.othReferenceEntityObligations, _that.getOthReferenceEntityObligations());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accruedInterest != null ? this.accruedInterest.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? ((Object)((Object)this.category)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notSubordinated != null ? this.notSubordinated.hashCode() : 0);
            _result = 31 * _result + (this.specifiedCurrency != null ? this.specifiedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notSovereignLender != null ? this.notSovereignLender.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticCurrency != null ? this.notDomesticCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticLaw != null ? this.notDomesticLaw.hashCode() : 0);
            _result = 31 * _result + (this.listed != null ? this.listed.hashCode() : 0);
            _result = 31 * _result + (this.notContingent != null ? this.notContingent.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticIssuance != null ? this.notDomesticIssuance.hashCode() : 0);
            _result = 31 * _result + (this.assignableLoan != null ? this.assignableLoan.hashCode() : 0);
            _result = 31 * _result + (this.consentRequiredLoan != null ? this.consentRequiredLoan.hashCode() : 0);
            _result = 31 * _result + (this.directLoanParticipation != null ? this.directLoanParticipation.hashCode() : 0);
            _result = 31 * _result + (this.transferable != null ? this.transferable.hashCode() : 0);
            _result = 31 * _result + (this.maximumMaturity != null ? this.maximumMaturity.hashCode() : 0);
            _result = 31 * _result + (this.acceleratedOrMatured != null ? this.acceleratedOrMatured.hashCode() : 0);
            _result = 31 * _result + (this.notBearer != null ? this.notBearer.hashCode() : 0);
            _result = 31 * _result + (this.fullFaithAndCreditObLiability != null ? this.fullFaithAndCreditObLiability.hashCode() : 0);
            _result = 31 * _result + (this.generalFundObligationLiability != null ? this.generalFundObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.revenueObligationLiability != null ? this.revenueObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.indirectLoanParticipation != null ? this.indirectLoanParticipation.hashCode() : 0);
            _result = 31 * _result + (this.excluded != null ? this.excluded.hashCode() : 0);
            _result = 31 * _result + (this.othReferenceEntityObligations != null ? this.othReferenceEntityObligations.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DeliverableObligations {accruedInterest=" + this.accruedInterest + ", category=" + (Object)((Object)this.category) + ", notSubordinated=" + this.notSubordinated + ", specifiedCurrency=" + this.specifiedCurrency + ", notSovereignLender=" + this.notSovereignLender + ", notDomesticCurrency=" + this.notDomesticCurrency + ", notDomesticLaw=" + this.notDomesticLaw + ", listed=" + this.listed + ", notContingent=" + this.notContingent + ", notDomesticIssuance=" + this.notDomesticIssuance + ", assignableLoan=" + this.assignableLoan + ", consentRequiredLoan=" + this.consentRequiredLoan + ", directLoanParticipation=" + this.directLoanParticipation + ", transferable=" + this.transferable + ", maximumMaturity=" + this.maximumMaturity + ", acceleratedOrMatured=" + this.acceleratedOrMatured + ", notBearer=" + this.notBearer + ", fullFaithAndCreditObLiability=" + this.fullFaithAndCreditObLiability + ", generalFundObligationLiability=" + this.generalFundObligationLiability + ", revenueObligationLiability=" + this.revenueObligationLiability + ", indirectLoanParticipation=" + this.indirectLoanParticipation + ", excluded=" + this.excluded + ", othReferenceEntityObligations=" + this.othReferenceEntityObligations + '}';
        }
    }
}

