/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.business.events.TradeChangeContent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradeChangeContentChoice")
@ImplementedBy(value=Default.class)
public interface TradeChangeContentChoice
extends Validator<TradeChangeContent> {
    public static final String NAME = "TradeChangeContentChoice";
    public static final String DEFINITION = "optional choice oldTradeIdentifier, oldTrade";

    public static class NoOp
    implements TradeChangeContentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeChangeContent tradeChangeContent) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeChangeContentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeChangeContent tradeChangeContent) {
            ComparisonResult result = this.executeDataRule(tradeChangeContent);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeChangeContentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradeChangeContent", (RosettaPath)path, (String)TradeChangeContentChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeChangeContentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradeChangeContent", (RosettaPath)path, (String)TradeChangeContentChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TradeChangeContent tradeChangeContent) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)tradeChangeContent), Arrays.asList("oldTradeIdentifier", "oldTrade"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

