/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.business.events.OptionExpiry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="OptionExpiryChoice")
@ImplementedBy(value=Default.class)
public interface OptionExpiryChoice
extends Validator<OptionExpiry> {
    public static final String NAME = "OptionExpiryChoice";
    public static final String DEFINITION = "optional choice originalTrade, tradeIdentifier";

    public static class NoOp
    implements OptionExpiryChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionExpiry optionExpiry) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements OptionExpiryChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionExpiry optionExpiry) {
            ComparisonResult result = this.executeDataRule(optionExpiry);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)OptionExpiryChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionExpiry", (RosettaPath)path, (String)OptionExpiryChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)OptionExpiryChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionExpiry", (RosettaPath)path, (String)OptionExpiryChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(OptionExpiry optionExpiry) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)optionExpiry), Arrays.asList("originalTrade", "tradeIdentifier"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

