/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AbstractEvent;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.business.events.ResetCalculationDetails;
import fpml.consolidated.business.events.meta.ResetEventMeta;
import fpml.consolidated.doc.PartyTradeIdentifiers;
import fpml.consolidated.shared.IdentifiedRate;
import fpml.consolidated.shared.LegIdentifier;
import fpml.consolidated.shared.RequiredIdentifierDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ResetEvent", builder=ResetEventBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ResetEvent", model="fpml", builder=ResetEventBuilderImpl.class, version="1.1.0")
public interface ResetEvent
extends AbstractEvent {
    public static final ResetEventMeta metaData = new ResetEventMeta();

    public PartyTradeIdentifiers getTradeReference();

    public List<? extends LegIdentifier> getLegIdentifier();

    public RequiredIdentifierDate getDate();

    public IdentifiedRate getResetValue();

    public ResetCalculationDetails getCalculationDetails();

    @Override
    public ResetEvent build();

    @Override
    public ResetEventBuilder toBuilder();

    public static ResetEventBuilder builder() {
        return new ResetEventBuilderImpl();
    }

    default public RosettaMetaData<? extends ResetEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ResetEvent> getType() {
        return ResetEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, PartyTradeIdentifiers.class, this.getTradeReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("date"), processor, RequiredIdentifierDate.class, this.getDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resetValue"), processor, IdentifiedRate.class, this.getResetValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationDetails"), processor, ResetCalculationDetails.class, this.getCalculationDetails(), new AttributeMeta[0]);
    }

    public static class ResetEventBuilderImpl
    extends AbstractEvent.AbstractEventBuilderImpl
    implements ResetEventBuilder {
        protected PartyTradeIdentifiers.PartyTradeIdentifiersBuilder tradeReference;
        protected List<LegIdentifier.LegIdentifierBuilder> legIdentifier = new ArrayList<LegIdentifier.LegIdentifierBuilder>();
        protected RequiredIdentifierDate.RequiredIdentifierDateBuilder date;
        protected IdentifiedRate.IdentifiedRateBuilder resetValue;
        protected ResetCalculationDetails.ResetCalculationDetailsBuilder calculationDetails;

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public PartyTradeIdentifiers.PartyTradeIdentifiersBuilder getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public PartyTradeIdentifiers.PartyTradeIdentifiersBuilder getOrCreateTradeReference() {
            PartyTradeIdentifiers.PartyTradeIdentifiersBuilder result = this.tradeReference != null ? this.tradeReference : (this.tradeReference = PartyTradeIdentifiers.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public List<? extends LegIdentifier.LegIdentifierBuilder> getLegIdentifier() {
            return this.legIdentifier;
        }

        @Override
        public LegIdentifier.LegIdentifierBuilder getOrCreateLegIdentifier(int index) {
            if (this.legIdentifier == null) {
                this.legIdentifier = new ArrayList<LegIdentifier.LegIdentifierBuilder>();
            }
            return (LegIdentifier.LegIdentifierBuilder)this.getIndex(this.legIdentifier, index, () -> {
                LegIdentifier.LegIdentifierBuilder newLegIdentifier = LegIdentifier.builder();
                return newLegIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public RequiredIdentifierDate.RequiredIdentifierDateBuilder getDate() {
            return this.date;
        }

        @Override
        public RequiredIdentifierDate.RequiredIdentifierDateBuilder getOrCreateDate() {
            RequiredIdentifierDate.RequiredIdentifierDateBuilder result = this.date != null ? this.date : (this.date = RequiredIdentifierDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="resetValue")
        @RuneAttribute(value="resetValue")
        public IdentifiedRate.IdentifiedRateBuilder getResetValue() {
            return this.resetValue;
        }

        @Override
        public IdentifiedRate.IdentifiedRateBuilder getOrCreateResetValue() {
            IdentifiedRate.IdentifiedRateBuilder result = this.resetValue != null ? this.resetValue : (this.resetValue = IdentifiedRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationDetails")
        @RuneAttribute(value="calculationDetails")
        public ResetCalculationDetails.ResetCalculationDetailsBuilder getCalculationDetails() {
            return this.calculationDetails;
        }

        @Override
        public ResetCalculationDetails.ResetCalculationDetailsBuilder getOrCreateCalculationDetails() {
            ResetCalculationDetails.ResetCalculationDetailsBuilder result = this.calculationDetails != null ? this.calculationDetails : (this.calculationDetails = ResetCalculationDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public ResetEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ResetEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public ResetEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public ResetEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public ResetEventBuilder setTradeReference(PartyTradeIdentifiers _tradeReference) {
            this.tradeReference = _tradeReference == null ? null : _tradeReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public ResetEventBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ResetEventBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public ResetEventBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public ResetEventBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList<LegIdentifier.LegIdentifierBuilder>() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ResetEventBuilder setDate(RequiredIdentifierDate _date) {
            this.date = _date == null ? null : _date.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="resetValue")
        @RuneAttribute(value="resetValue")
        public ResetEventBuilder setResetValue(IdentifiedRate _resetValue) {
            this.resetValue = _resetValue == null ? null : _resetValue.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationDetails")
        @RuneAttribute(value="calculationDetails")
        public ResetEventBuilder setCalculationDetails(ResetCalculationDetails _calculationDetails) {
            this.calculationDetails = _calculationDetails == null ? null : _calculationDetails.toBuilder();
            return this;
        }

        @Override
        public ResetEvent build() {
            return new ResetEventImpl(this);
        }

        @Override
        public ResetEventBuilder toBuilder() {
            return this;
        }

        @Override
        public ResetEventBuilder prune() {
            super.prune();
            if (this.tradeReference != null && !this.tradeReference.prune().hasData()) {
                this.tradeReference = null;
            }
            this.legIdentifier = this.legIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.date != null && !this.date.prune().hasData()) {
                this.date = null;
            }
            if (this.resetValue != null && !this.resetValue.prune().hasData()) {
                this.resetValue = null;
            }
            if (this.calculationDetails != null && !this.calculationDetails.prune().hasData()) {
                this.calculationDetails = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradeReference() != null && this.getTradeReference().hasData()) {
                return true;
            }
            if (this.getLegIdentifier() != null && this.getLegIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDate() != null && this.getDate().hasData()) {
                return true;
            }
            if (this.getResetValue() != null && this.getResetValue().hasData()) {
                return true;
            }
            return this.getCalculationDetails() != null && this.getCalculationDetails().hasData();
        }

        @Override
        public ResetEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ResetEventBuilder o = (ResetEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeReference(), (RosettaModelObjectBuilder)o.getTradeReference(), this::setTradeReference);
            merger.mergeRosetta(this.getLegIdentifier(), o.getLegIdentifier(), this::getOrCreateLegIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDate(), (RosettaModelObjectBuilder)o.getDate(), this::setDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getResetValue(), (RosettaModelObjectBuilder)o.getResetValue(), this::setResetValue);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationDetails(), (RosettaModelObjectBuilder)o.getCalculationDetails(), this::setCalculationDetails);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ResetEvent _that = (ResetEvent)this.getType().cast(o);
            if (!Objects.equals(this.tradeReference, _that.getTradeReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.legIdentifier, _that.getLegIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.resetValue, _that.getResetValue())) {
                return false;
            }
            return Objects.equals(this.calculationDetails, _that.getCalculationDetails());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            _result = 31 * _result + (this.legIdentifier != null ? this.legIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.resetValue != null ? this.resetValue.hashCode() : 0);
            _result = 31 * _result + (this.calculationDetails != null ? this.calculationDetails.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ResetEventBuilder {tradeReference=" + this.tradeReference + ", legIdentifier=" + this.legIdentifier + ", date=" + this.date + ", resetValue=" + this.resetValue + ", calculationDetails=" + this.calculationDetails + '}' + " " + super.toString();
        }
    }

    public static interface ResetEventBuilder
    extends ResetEvent,
    AbstractEvent.AbstractEventBuilder {
        public PartyTradeIdentifiers.PartyTradeIdentifiersBuilder getOrCreateTradeReference();

        @Override
        public PartyTradeIdentifiers.PartyTradeIdentifiersBuilder getTradeReference();

        public LegIdentifier.LegIdentifierBuilder getOrCreateLegIdentifier(int var1);

        public List<? extends LegIdentifier.LegIdentifierBuilder> getLegIdentifier();

        public RequiredIdentifierDate.RequiredIdentifierDateBuilder getOrCreateDate();

        @Override
        public RequiredIdentifierDate.RequiredIdentifierDateBuilder getDate();

        public IdentifiedRate.IdentifiedRateBuilder getOrCreateResetValue();

        @Override
        public IdentifiedRate.IdentifiedRateBuilder getResetValue();

        public ResetCalculationDetails.ResetCalculationDetailsBuilder getOrCreateCalculationDetails();

        @Override
        public ResetCalculationDetails.ResetCalculationDetailsBuilder getCalculationDetails();

        @Override
        public ResetEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public ResetEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public ResetEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public ResetEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public ResetEventBuilder setTradeReference(PartyTradeIdentifiers var1);

        public ResetEventBuilder addLegIdentifier(LegIdentifier var1);

        public ResetEventBuilder addLegIdentifier(LegIdentifier var1, int var2);

        public ResetEventBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        public ResetEventBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        public ResetEventBuilder setDate(RequiredIdentifierDate var1);

        public ResetEventBuilder setResetValue(IdentifiedRate var1);

        public ResetEventBuilder setCalculationDetails(ResetCalculationDetails var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, PartyTradeIdentifiers.PartyTradeIdentifiersBuilder.class, this.getTradeReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("date"), processor, RequiredIdentifierDate.RequiredIdentifierDateBuilder.class, this.getDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resetValue"), processor, IdentifiedRate.IdentifiedRateBuilder.class, this.getResetValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationDetails"), processor, ResetCalculationDetails.ResetCalculationDetailsBuilder.class, this.getCalculationDetails(), new AttributeMeta[0]);
        }

        @Override
        public ResetEventBuilder prune();
    }

    public static class ResetEventImpl
    extends AbstractEvent.AbstractEventImpl
    implements ResetEvent {
        private final PartyTradeIdentifiers tradeReference;
        private final List<? extends LegIdentifier> legIdentifier;
        private final RequiredIdentifierDate date;
        private final IdentifiedRate resetValue;
        private final ResetCalculationDetails calculationDetails;

        protected ResetEventImpl(ResetEventBuilder builder) {
            super(builder);
            this.tradeReference = Optional.ofNullable(builder.getTradeReference()).map(f -> f.build()).orElse(null);
            this.legIdentifier = Optional.ofNullable(builder.getLegIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.date = Optional.ofNullable(builder.getDate()).map(f -> f.build()).orElse(null);
            this.resetValue = Optional.ofNullable(builder.getResetValue()).map(f -> f.build()).orElse(null);
            this.calculationDetails = Optional.ofNullable(builder.getCalculationDetails()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public PartyTradeIdentifiers getTradeReference() {
            return this.tradeReference;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public List<? extends LegIdentifier> getLegIdentifier() {
            return this.legIdentifier;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public RequiredIdentifierDate getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="resetValue")
        @RuneAttribute(value="resetValue")
        public IdentifiedRate getResetValue() {
            return this.resetValue;
        }

        @Override
        @RosettaAttribute(value="calculationDetails")
        @RuneAttribute(value="calculationDetails")
        public ResetCalculationDetails getCalculationDetails() {
            return this.calculationDetails;
        }

        @Override
        public ResetEvent build() {
            return this;
        }

        @Override
        public ResetEventBuilder toBuilder() {
            ResetEventBuilder builder = ResetEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ResetEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradeReference()).ifPresent(builder::setTradeReference);
            Optional.ofNullable(this.getLegIdentifier()).ifPresent(builder::setLegIdentifier);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
            Optional.ofNullable(this.getResetValue()).ifPresent(builder::setResetValue);
            Optional.ofNullable(this.getCalculationDetails()).ifPresent(builder::setCalculationDetails);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ResetEvent _that = (ResetEvent)this.getType().cast(o);
            if (!Objects.equals(this.tradeReference, _that.getTradeReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.legIdentifier, _that.getLegIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.resetValue, _that.getResetValue())) {
                return false;
            }
            return Objects.equals(this.calculationDetails, _that.getCalculationDetails());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            _result = 31 * _result + (this.legIdentifier != null ? this.legIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.resetValue != null ? this.resetValue.hashCode() : 0);
            _result = 31 * _result + (this.calculationDetails != null ? this.calculationDetails.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ResetEvent {tradeReference=" + this.tradeReference + ", legIdentifier=" + this.legIdentifier + ", date=" + this.date + ", resetValue=" + this.resetValue + ", calculationDetails=" + this.calculationDetails + '}' + " " + super.toString();
        }
    }
}

