/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.meta.OptionExpiryBaseMeta;
import fpml.consolidated.doc.PartyTradeIdentifier;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OptionExpiryBase", builder=OptionExpiryBaseBuilderImpl.class, version="1.1.0")
@RuneDataType(value="OptionExpiryBase", model="fpml", builder=OptionExpiryBaseBuilderImpl.class, version="1.1.0")
public interface OptionExpiryBase
extends RosettaModelObject {
    public static final OptionExpiryBaseMeta metaData = new OptionExpiryBaseMeta();

    public List<? extends PartyTradeIdentifier> getTradeIdentifier();

    public ZonedDateTime getDate();

    public LocalTime getTime();

    public OptionExpiryBase build();

    public OptionExpiryBaseBuilder toBuilder();

    public static OptionExpiryBaseBuilder builder() {
        return new OptionExpiryBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionExpiryBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionExpiryBase> getType() {
        return OptionExpiryBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class OptionExpiryBaseBuilderImpl
    implements OptionExpiryBaseBuilder {
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected ZonedDateTime date;
        protected LocalTime time;

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newTradeIdentifier = PartyTradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="time", isRequired=true)
        @RuneAttribute(value="time", isRequired=true)
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public OptionExpiryBaseBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public OptionExpiryBaseBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public OptionExpiryBaseBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public OptionExpiryBaseBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public OptionExpiryBaseBuilder setDate(ZonedDateTime _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        @RosettaAttribute(value="time", isRequired=true)
        @RuneAttribute(value="time", isRequired=true)
        public OptionExpiryBaseBuilder setTime(LocalTime _time) {
            this.time = _time == null ? null : _time;
            return this;
        }

        @Override
        public OptionExpiryBase build() {
            return new OptionExpiryBaseImpl(this);
        }

        @Override
        public OptionExpiryBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionExpiryBaseBuilder prune() {
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDate() != null) {
                return true;
            }
            return this.getTime() != null;
        }

        public OptionExpiryBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OptionExpiryBaseBuilder o = (OptionExpiryBaseBuilder)other;
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTime(), (Object)o.getTime(), this::setTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionExpiryBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            return Objects.equals(this.time, _that.getTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionExpiryBaseBuilder {tradeIdentifier=" + this.tradeIdentifier + ", date=" + this.date + ", time=" + this.time + '}';
        }
    }

    public static interface OptionExpiryBaseBuilder
    extends OptionExpiryBase,
    RosettaModelObjectBuilder {
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier();

        public OptionExpiryBaseBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        public OptionExpiryBaseBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public OptionExpiryBaseBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OptionExpiryBaseBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OptionExpiryBaseBuilder setDate(ZonedDateTime var1);

        public OptionExpiryBaseBuilder setTime(LocalTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public OptionExpiryBaseBuilder prune();
    }

    public static class OptionExpiryBaseImpl
    implements OptionExpiryBase {
        private final List<? extends PartyTradeIdentifier> tradeIdentifier;
        private final ZonedDateTime date;
        private final LocalTime time;

        protected OptionExpiryBaseImpl(OptionExpiryBaseBuilder builder) {
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.date = builder.getDate();
            this.time = builder.getTime();
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="time", isRequired=true)
        @RuneAttribute(value="time", isRequired=true)
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        public OptionExpiryBase build() {
            return this;
        }

        @Override
        public OptionExpiryBaseBuilder toBuilder() {
            OptionExpiryBaseBuilder builder = OptionExpiryBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionExpiryBaseBuilder builder) {
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionExpiryBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            return Objects.equals(this.time, _that.getTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionExpiryBase {tradeIdentifier=" + this.tradeIdentifier + ", date=" + this.date + ", time=" + this.time + '}';
        }
    }
}

