/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.meta.OldTradeModelMeta;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.Trade;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OldTradeModel", builder=OldTradeModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="OldTradeModel", model="fpml", builder=OldTradeModelBuilderImpl.class, version="1.1.0")
public interface OldTradeModel
extends RosettaModelObject {
    public static final OldTradeModelMeta metaData = new OldTradeModelMeta();

    public List<? extends PartyTradeIdentifier> getOldTradeIdentifier();

    public Trade getOldTrade();

    public OldTradeModel build();

    public OldTradeModelBuilder toBuilder();

    public static OldTradeModelBuilder builder() {
        return new OldTradeModelBuilderImpl();
    }

    default public RosettaMetaData<? extends OldTradeModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OldTradeModel> getType() {
        return OldTradeModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("oldTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getOldTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("oldTrade"), processor, Trade.class, this.getOldTrade(), new AttributeMeta[0]);
    }

    public static class OldTradeModelBuilderImpl
    implements OldTradeModelBuilder {
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> oldTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected Trade.TradeBuilder oldTrade;

        @Override
        @RosettaAttribute(value="oldTradeIdentifier")
        @RuneAttribute(value="oldTradeIdentifier")
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getOldTradeIdentifier() {
            return this.oldTradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateOldTradeIdentifier(int index) {
            if (this.oldTradeIdentifier == null) {
                this.oldTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.oldTradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newOldTradeIdentifier = PartyTradeIdentifier.builder();
                return newOldTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="oldTrade")
        @RuneAttribute(value="oldTrade")
        public Trade.TradeBuilder getOldTrade() {
            return this.oldTrade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateOldTrade() {
            Trade.TradeBuilder result = this.oldTrade != null ? this.oldTrade : (this.oldTrade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="oldTradeIdentifier")
        @RuneAttribute(value="oldTradeIdentifier")
        public OldTradeModelBuilder addOldTradeIdentifier(PartyTradeIdentifier _oldTradeIdentifier) {
            if (_oldTradeIdentifier != null) {
                this.oldTradeIdentifier.add(_oldTradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public OldTradeModelBuilder addOldTradeIdentifier(PartyTradeIdentifier _oldTradeIdentifier, int idx) {
            this.getIndex(this.oldTradeIdentifier, idx, () -> _oldTradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public OldTradeModelBuilder addOldTradeIdentifier(List<? extends PartyTradeIdentifier> oldTradeIdentifiers) {
            if (oldTradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : oldTradeIdentifiers) {
                    this.oldTradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="oldTradeIdentifier")
        public OldTradeModelBuilder setOldTradeIdentifier(List<? extends PartyTradeIdentifier> oldTradeIdentifiers) {
            this.oldTradeIdentifier = oldTradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)oldTradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="oldTrade")
        @RuneAttribute(value="oldTrade")
        public OldTradeModelBuilder setOldTrade(Trade _oldTrade) {
            this.oldTrade = _oldTrade == null ? null : _oldTrade.toBuilder();
            return this;
        }

        @Override
        public OldTradeModel build() {
            return new OldTradeModelImpl(this);
        }

        @Override
        public OldTradeModelBuilder toBuilder() {
            return this;
        }

        @Override
        public OldTradeModelBuilder prune() {
            this.oldTradeIdentifier = this.oldTradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.oldTrade != null && !this.oldTrade.prune().hasData()) {
                this.oldTrade = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getOldTradeIdentifier() != null && this.getOldTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getOldTrade() != null && this.getOldTrade().hasData();
        }

        public OldTradeModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OldTradeModelBuilder o = (OldTradeModelBuilder)other;
            merger.mergeRosetta(this.getOldTradeIdentifier(), o.getOldTradeIdentifier(), this::getOrCreateOldTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOldTrade(), (RosettaModelObjectBuilder)o.getOldTrade(), this::setOldTrade);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OldTradeModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.oldTradeIdentifier, _that.getOldTradeIdentifier())) {
                return false;
            }
            return Objects.equals(this.oldTrade, _that.getOldTrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.oldTradeIdentifier != null ? this.oldTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.oldTrade != null ? this.oldTrade.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OldTradeModelBuilder {oldTradeIdentifier=" + this.oldTradeIdentifier + ", oldTrade=" + this.oldTrade + '}';
        }
    }

    public static interface OldTradeModelBuilder
    extends OldTradeModel,
    RosettaModelObjectBuilder {
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateOldTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getOldTradeIdentifier();

        public Trade.TradeBuilder getOrCreateOldTrade();

        @Override
        public Trade.TradeBuilder getOldTrade();

        public OldTradeModelBuilder addOldTradeIdentifier(PartyTradeIdentifier var1);

        public OldTradeModelBuilder addOldTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public OldTradeModelBuilder addOldTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OldTradeModelBuilder setOldTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OldTradeModelBuilder setOldTrade(Trade var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("oldTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getOldTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("oldTrade"), processor, Trade.TradeBuilder.class, this.getOldTrade(), new AttributeMeta[0]);
        }

        public OldTradeModelBuilder prune();
    }

    public static class OldTradeModelImpl
    implements OldTradeModel {
        private final List<? extends PartyTradeIdentifier> oldTradeIdentifier;
        private final Trade oldTrade;

        protected OldTradeModelImpl(OldTradeModelBuilder builder) {
            this.oldTradeIdentifier = Optional.ofNullable(builder.getOldTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.oldTrade = Optional.ofNullable(builder.getOldTrade()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="oldTradeIdentifier")
        @RuneAttribute(value="oldTradeIdentifier")
        public List<? extends PartyTradeIdentifier> getOldTradeIdentifier() {
            return this.oldTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="oldTrade")
        @RuneAttribute(value="oldTrade")
        public Trade getOldTrade() {
            return this.oldTrade;
        }

        @Override
        public OldTradeModel build() {
            return this;
        }

        @Override
        public OldTradeModelBuilder toBuilder() {
            OldTradeModelBuilder builder = OldTradeModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OldTradeModelBuilder builder) {
            Optional.ofNullable(this.getOldTradeIdentifier()).ifPresent(builder::setOldTradeIdentifier);
            Optional.ofNullable(this.getOldTrade()).ifPresent(builder::setOldTrade);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OldTradeModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.oldTradeIdentifier, _that.getOldTradeIdentifier())) {
                return false;
            }
            return Objects.equals(this.oldTrade, _that.getOldTrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.oldTradeIdentifier != null ? this.oldTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.oldTrade != null ? this.oldTrade.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OldTradeModel {oldTradeIdentifier=" + this.oldTradeIdentifier + ", oldTrade=" + this.oldTrade + '}';
        }
    }
}

