/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.CreditLimitBase;
import fpml.consolidated.business.events.LimitApplicable;
import fpml.consolidated.business.events.LimitId;
import fpml.consolidated.business.events.meta.CreditLimitMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.Period;
import fpml.consolidated.shared.ProductModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditLimit", builder=CreditLimitBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CreditLimit", model="fpml", builder=CreditLimitBuilderImpl.class, version="1.1.0")
public interface CreditLimit
extends CreditLimitBase {
    public static final CreditLimitMeta metaData = new CreditLimitMeta();

    public List<? extends LimitApplicable> getLimitApplicable();

    public ZonedDateTime getExpirationDate();

    @Override
    public CreditLimit build();

    @Override
    public CreditLimitBuilder toBuilder();

    public static CreditLimitBuilder builder() {
        return new CreditLimitBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditLimit> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditLimit> getType() {
        return CreditLimit.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("limitId"), processor, LimitId.class, this.getLimitId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tenor"), processor, Period.class, this.getTenor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("limitApplicable"), processor, LimitApplicable.class, this.getLimitApplicable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), ZonedDateTime.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CreditLimitBuilderImpl
    extends CreditLimitBase.CreditLimitBaseBuilderImpl
    implements CreditLimitBuilder {
        protected List<LimitApplicable.LimitApplicableBuilder> limitApplicable = new ArrayList<LimitApplicable.LimitApplicableBuilder>();
        protected ZonedDateTime expirationDate;

        @Override
        @RosettaAttribute(value="limitApplicable", isRequired=true)
        @RuneAttribute(value="limitApplicable", isRequired=true)
        public List<? extends LimitApplicable.LimitApplicableBuilder> getLimitApplicable() {
            return this.limitApplicable;
        }

        @Override
        public LimitApplicable.LimitApplicableBuilder getOrCreateLimitApplicable(int index) {
            if (this.limitApplicable == null) {
                this.limitApplicable = new ArrayList<LimitApplicable.LimitApplicableBuilder>();
            }
            return (LimitApplicable.LimitApplicableBuilder)this.getIndex(this.limitApplicable, index, () -> {
                LimitApplicable.LimitApplicableBuilder newLimitApplicable = LimitApplicable.builder();
                return newLimitApplicable;
            });
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public ZonedDateTime getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="limitId", isRequired=true)
        @RuneAttribute(value="limitId", isRequired=true)
        public CreditLimitBuilder setLimitId(LimitId _limitId) {
            this.limitId = _limitId == null ? null : _limitId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="productModel", isRequired=true)
        @RuneAttribute(value="productModel", isRequired=true)
        public CreditLimitBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public CreditLimitBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tenor", isRequired=true)
        @RuneAttribute(value="tenor", isRequired=true)
        public CreditLimitBuilder setTenor(Period _tenor) {
            this.tenor = _tenor == null ? null : _tenor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="limitApplicable", isRequired=true)
        @RuneAttribute(value="limitApplicable", isRequired=true)
        public CreditLimitBuilder addLimitApplicable(LimitApplicable _limitApplicable) {
            if (_limitApplicable != null) {
                this.limitApplicable.add(_limitApplicable.toBuilder());
            }
            return this;
        }

        @Override
        public CreditLimitBuilder addLimitApplicable(LimitApplicable _limitApplicable, int idx) {
            this.getIndex(this.limitApplicable, idx, () -> _limitApplicable.toBuilder());
            return this;
        }

        @Override
        public CreditLimitBuilder addLimitApplicable(List<? extends LimitApplicable> limitApplicables) {
            if (limitApplicables != null) {
                for (LimitApplicable limitApplicable : limitApplicables) {
                    this.limitApplicable.add(limitApplicable.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="limitApplicable")
        public CreditLimitBuilder setLimitApplicable(List<? extends LimitApplicable> limitApplicables) {
            this.limitApplicable = limitApplicables == null ? new ArrayList<LimitApplicable.LimitApplicableBuilder>() : (List)limitApplicables.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public CreditLimitBuilder setExpirationDate(ZonedDateTime _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        public CreditLimit build() {
            return new CreditLimitImpl(this);
        }

        @Override
        public CreditLimitBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditLimitBuilder prune() {
            super.prune();
            this.limitApplicable = this.limitApplicable.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLimitApplicable() != null && this.getLimitApplicable().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getExpirationDate() != null;
        }

        @Override
        public CreditLimitBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CreditLimitBuilder o = (CreditLimitBuilder)other;
            merger.mergeRosetta(this.getLimitApplicable(), o.getLimitApplicable(), this::getOrCreateLimitApplicable);
            merger.mergeBasic((Object)this.getExpirationDate(), (Object)o.getExpirationDate(), this::setExpirationDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditLimit _that = (CreditLimit)this.getType().cast(o);
            if (!ListEquals.listEquals(this.limitApplicable, _that.getLimitApplicable())) {
                return false;
            }
            return Objects.equals(this.expirationDate, _that.getExpirationDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.limitApplicable != null ? this.limitApplicable.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditLimitBuilder {limitApplicable=" + this.limitApplicable + ", expirationDate=" + this.expirationDate + '}' + " " + super.toString();
        }
    }

    public static interface CreditLimitBuilder
    extends CreditLimit,
    CreditLimitBase.CreditLimitBaseBuilder {
        public LimitApplicable.LimitApplicableBuilder getOrCreateLimitApplicable(int var1);

        public List<? extends LimitApplicable.LimitApplicableBuilder> getLimitApplicable();

        @Override
        public CreditLimitBuilder setLimitId(LimitId var1);

        @Override
        public CreditLimitBuilder setProductModel(ProductModel var1);

        @Override
        public CreditLimitBuilder setCurrency(Currency var1);

        @Override
        public CreditLimitBuilder setTenor(Period var1);

        public CreditLimitBuilder addLimitApplicable(LimitApplicable var1);

        public CreditLimitBuilder addLimitApplicable(LimitApplicable var1, int var2);

        public CreditLimitBuilder addLimitApplicable(List<? extends LimitApplicable> var1);

        public CreditLimitBuilder setLimitApplicable(List<? extends LimitApplicable> var1);

        public CreditLimitBuilder setExpirationDate(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("limitId"), processor, LimitId.LimitIdBuilder.class, (RosettaModelObjectBuilder)this.getLimitId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tenor"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getTenor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("limitApplicable"), processor, LimitApplicable.LimitApplicableBuilder.class, this.getLimitApplicable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), ZonedDateTime.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CreditLimitBuilder prune();
    }

    public static class CreditLimitImpl
    extends CreditLimitBase.CreditLimitBaseImpl
    implements CreditLimit {
        private final List<? extends LimitApplicable> limitApplicable;
        private final ZonedDateTime expirationDate;

        protected CreditLimitImpl(CreditLimitBuilder builder) {
            super(builder);
            this.limitApplicable = Optional.ofNullable(builder.getLimitApplicable()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.expirationDate = builder.getExpirationDate();
        }

        @Override
        @RosettaAttribute(value="limitApplicable", isRequired=true)
        @RuneAttribute(value="limitApplicable", isRequired=true)
        public List<? extends LimitApplicable> getLimitApplicable() {
            return this.limitApplicable;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public ZonedDateTime getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public CreditLimit build() {
            return this;
        }

        @Override
        public CreditLimitBuilder toBuilder() {
            CreditLimitBuilder builder = CreditLimit.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditLimitBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLimitApplicable()).ifPresent(builder::setLimitApplicable);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreditLimit _that = (CreditLimit)this.getType().cast(o);
            if (!ListEquals.listEquals(this.limitApplicable, _that.getLimitApplicable())) {
                return false;
            }
            return Objects.equals(this.expirationDate, _that.getExpirationDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.limitApplicable != null ? this.limitApplicable.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CreditLimit {limitApplicable=" + this.limitApplicable + ", expirationDate=" + this.expirationDate + '}' + " " + super.toString();
        }
    }
}

