/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.meta.CompressionActivitySequence1Meta;
import fpml.consolidated.shared.TradeId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CompressionActivitySequence1", builder=CompressionActivitySequence1BuilderImpl.class, version="1.1.0")
@RuneDataType(value="CompressionActivitySequence1", model="fpml", builder=CompressionActivitySequence1BuilderImpl.class, version="1.1.0")
public interface CompressionActivitySequence1
extends RosettaModelObject {
    public static final CompressionActivitySequence1Meta metaData = new CompressionActivitySequence1Meta();

    public TradeId getReplacementTradeId();

    public List<? extends TradeId> getOriginatingTradeId();

    public CompressionActivitySequence1 build();

    public CompressionActivitySequence1Builder toBuilder();

    public static CompressionActivitySequence1Builder builder() {
        return new CompressionActivitySequence1BuilderImpl();
    }

    default public RosettaMetaData<? extends CompressionActivitySequence1> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CompressionActivitySequence1> getType() {
        return CompressionActivitySequence1.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("replacementTradeId"), processor, TradeId.class, this.getReplacementTradeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originatingTradeId"), processor, TradeId.class, this.getOriginatingTradeId(), new AttributeMeta[0]);
    }

    public static class CompressionActivitySequence1BuilderImpl
    implements CompressionActivitySequence1Builder {
        protected TradeId.TradeIdBuilder replacementTradeId;
        protected List<TradeId.TradeIdBuilder> originatingTradeId = new ArrayList<TradeId.TradeIdBuilder>();

        @Override
        @RosettaAttribute(value="replacementTradeId")
        @RuneAttribute(value="replacementTradeId")
        public TradeId.TradeIdBuilder getReplacementTradeId() {
            return this.replacementTradeId;
        }

        @Override
        public TradeId.TradeIdBuilder getOrCreateReplacementTradeId() {
            TradeId.TradeIdBuilder result = this.replacementTradeId != null ? this.replacementTradeId : (this.replacementTradeId = TradeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originatingTradeId")
        @RuneAttribute(value="originatingTradeId")
        public List<? extends TradeId.TradeIdBuilder> getOriginatingTradeId() {
            return this.originatingTradeId;
        }

        @Override
        public TradeId.TradeIdBuilder getOrCreateOriginatingTradeId(int index) {
            if (this.originatingTradeId == null) {
                this.originatingTradeId = new ArrayList<TradeId.TradeIdBuilder>();
            }
            return (TradeId.TradeIdBuilder)this.getIndex(this.originatingTradeId, index, () -> {
                TradeId.TradeIdBuilder newOriginatingTradeId = TradeId.builder();
                return newOriginatingTradeId;
            });
        }

        @Override
        @RosettaAttribute(value="replacementTradeId")
        @RuneAttribute(value="replacementTradeId")
        public CompressionActivitySequence1Builder setReplacementTradeId(TradeId _replacementTradeId) {
            this.replacementTradeId = _replacementTradeId == null ? null : _replacementTradeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originatingTradeId")
        @RuneAttribute(value="originatingTradeId")
        public CompressionActivitySequence1Builder addOriginatingTradeId(TradeId _originatingTradeId) {
            if (_originatingTradeId != null) {
                this.originatingTradeId.add(_originatingTradeId.toBuilder());
            }
            return this;
        }

        @Override
        public CompressionActivitySequence1Builder addOriginatingTradeId(TradeId _originatingTradeId, int idx) {
            this.getIndex(this.originatingTradeId, idx, () -> _originatingTradeId.toBuilder());
            return this;
        }

        @Override
        public CompressionActivitySequence1Builder addOriginatingTradeId(List<? extends TradeId> originatingTradeIds) {
            if (originatingTradeIds != null) {
                for (TradeId tradeId : originatingTradeIds) {
                    this.originatingTradeId.add(tradeId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="originatingTradeId")
        public CompressionActivitySequence1Builder setOriginatingTradeId(List<? extends TradeId> originatingTradeIds) {
            this.originatingTradeId = originatingTradeIds == null ? new ArrayList<TradeId.TradeIdBuilder>() : (List)originatingTradeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CompressionActivitySequence1 build() {
            return new CompressionActivitySequence1Impl(this);
        }

        @Override
        public CompressionActivitySequence1Builder toBuilder() {
            return this;
        }

        @Override
        public CompressionActivitySequence1Builder prune() {
            if (this.replacementTradeId != null && !this.replacementTradeId.prune().hasData()) {
                this.replacementTradeId = null;
            }
            this.originatingTradeId = this.originatingTradeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getReplacementTradeId() != null && this.getReplacementTradeId().hasData()) {
                return true;
            }
            return this.getOriginatingTradeId() != null && this.getOriginatingTradeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CompressionActivitySequence1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CompressionActivitySequence1Builder o = (CompressionActivitySequence1Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReplacementTradeId(), (RosettaModelObjectBuilder)o.getReplacementTradeId(), this::setReplacementTradeId);
            merger.mergeRosetta(this.getOriginatingTradeId(), o.getOriginatingTradeId(), this::getOrCreateOriginatingTradeId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CompressionActivitySequence1 _that = this.getType().cast(o);
            if (!Objects.equals(this.replacementTradeId, _that.getReplacementTradeId())) {
                return false;
            }
            return ListEquals.listEquals(this.originatingTradeId, _that.getOriginatingTradeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.replacementTradeId != null ? this.replacementTradeId.hashCode() : 0);
            _result = 31 * _result + (this.originatingTradeId != null ? this.originatingTradeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CompressionActivitySequence1Builder {replacementTradeId=" + this.replacementTradeId + ", originatingTradeId=" + this.originatingTradeId + '}';
        }
    }

    public static interface CompressionActivitySequence1Builder
    extends CompressionActivitySequence1,
    RosettaModelObjectBuilder {
        public TradeId.TradeIdBuilder getOrCreateReplacementTradeId();

        @Override
        public TradeId.TradeIdBuilder getReplacementTradeId();

        public TradeId.TradeIdBuilder getOrCreateOriginatingTradeId(int var1);

        public List<? extends TradeId.TradeIdBuilder> getOriginatingTradeId();

        public CompressionActivitySequence1Builder setReplacementTradeId(TradeId var1);

        public CompressionActivitySequence1Builder addOriginatingTradeId(TradeId var1);

        public CompressionActivitySequence1Builder addOriginatingTradeId(TradeId var1, int var2);

        public CompressionActivitySequence1Builder addOriginatingTradeId(List<? extends TradeId> var1);

        public CompressionActivitySequence1Builder setOriginatingTradeId(List<? extends TradeId> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("replacementTradeId"), processor, TradeId.TradeIdBuilder.class, this.getReplacementTradeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originatingTradeId"), processor, TradeId.TradeIdBuilder.class, this.getOriginatingTradeId(), new AttributeMeta[0]);
        }

        public CompressionActivitySequence1Builder prune();
    }

    public static class CompressionActivitySequence1Impl
    implements CompressionActivitySequence1 {
        private final TradeId replacementTradeId;
        private final List<? extends TradeId> originatingTradeId;

        protected CompressionActivitySequence1Impl(CompressionActivitySequence1Builder builder) {
            this.replacementTradeId = Optional.ofNullable(builder.getReplacementTradeId()).map(f -> f.build()).orElse(null);
            this.originatingTradeId = Optional.ofNullable(builder.getOriginatingTradeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="replacementTradeId")
        @RuneAttribute(value="replacementTradeId")
        public TradeId getReplacementTradeId() {
            return this.replacementTradeId;
        }

        @Override
        @RosettaAttribute(value="originatingTradeId")
        @RuneAttribute(value="originatingTradeId")
        public List<? extends TradeId> getOriginatingTradeId() {
            return this.originatingTradeId;
        }

        @Override
        public CompressionActivitySequence1 build() {
            return this;
        }

        @Override
        public CompressionActivitySequence1Builder toBuilder() {
            CompressionActivitySequence1Builder builder = CompressionActivitySequence1.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CompressionActivitySequence1Builder builder) {
            Optional.ofNullable(this.getReplacementTradeId()).ifPresent(builder::setReplacementTradeId);
            Optional.ofNullable(this.getOriginatingTradeId()).ifPresent(builder::setOriginatingTradeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CompressionActivitySequence1 _that = this.getType().cast(o);
            if (!Objects.equals(this.replacementTradeId, _that.getReplacementTradeId())) {
                return false;
            }
            return ListEquals.listEquals(this.originatingTradeId, _that.getOriginatingTradeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.replacementTradeId != null ? this.replacementTradeId.hashCode() : 0);
            _result = 31 * _result + (this.originatingTradeId != null ? this.originatingTradeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CompressionActivitySequence1 {replacementTradeId=" + this.replacementTradeId + ", originatingTradeId=" + this.originatingTradeId + '}';
        }
    }
}

