/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.meta.AmountRefMeta;
import fpml.consolidated.shared.AmountReference;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AmountRef", builder=AmountRefBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AmountRef", model="fpml", builder=AmountRefBuilderImpl.class, version="1.1.0")
public interface AmountRef
extends RosettaModelObject {
    public static final AmountRefMeta metaData = new AmountRefMeta();

    public BigDecimal getAmount();

    public AmountReference getAmountReference();

    public AmountRef build();

    public AmountRefBuilder toBuilder();

    public static AmountRefBuilder builder() {
        return new AmountRefBuilderImpl();
    }

    default public RosettaMetaData<? extends AmountRef> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AmountRef> getType() {
        return AmountRef.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amountReference"), processor, AmountReference.class, this.getAmountReference(), new AttributeMeta[0]);
    }

    public static class AmountRefBuilderImpl
    implements AmountRefBuilder {
        protected BigDecimal amount;
        protected AmountReference.AmountReferenceBuilder amountReference;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="amountReference")
        @RuneAttribute(value="amountReference")
        public AmountReference.AmountReferenceBuilder getAmountReference() {
            return this.amountReference;
        }

        @Override
        public AmountReference.AmountReferenceBuilder getOrCreateAmountReference() {
            AmountReference.AmountReferenceBuilder result = this.amountReference != null ? this.amountReference : (this.amountReference = AmountReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public AmountRefBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        @RosettaAttribute(value="amountReference")
        @RuneAttribute(value="amountReference")
        public AmountRefBuilder setAmountReference(AmountReference _amountReference) {
            this.amountReference = _amountReference == null ? null : _amountReference.toBuilder();
            return this;
        }

        @Override
        public AmountRef build() {
            return new AmountRefImpl(this);
        }

        @Override
        public AmountRefBuilder toBuilder() {
            return this;
        }

        @Override
        public AmountRefBuilder prune() {
            if (this.amountReference != null && !this.amountReference.prune().hasData()) {
                this.amountReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null) {
                return true;
            }
            return this.getAmountReference() != null && this.getAmountReference().hasData();
        }

        public AmountRefBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AmountRefBuilder o = (AmountRefBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmountReference(), (RosettaModelObjectBuilder)o.getAmountReference(), this::setAmountReference);
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AmountRef _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.amountReference, _that.getAmountReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.amountReference != null ? this.amountReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AmountRefBuilder {amount=" + this.amount + ", amountReference=" + this.amountReference + '}';
        }
    }

    public static interface AmountRefBuilder
    extends AmountRef,
    RosettaModelObjectBuilder {
        public AmountReference.AmountReferenceBuilder getOrCreateAmountReference();

        @Override
        public AmountReference.AmountReferenceBuilder getAmountReference();

        public AmountRefBuilder setAmount(BigDecimal var1);

        public AmountRefBuilder setAmountReference(AmountReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amountReference"), processor, AmountReference.AmountReferenceBuilder.class, this.getAmountReference(), new AttributeMeta[0]);
        }

        public AmountRefBuilder prune();
    }

    public static class AmountRefImpl
    implements AmountRef {
        private final BigDecimal amount;
        private final AmountReference amountReference;

        protected AmountRefImpl(AmountRefBuilder builder) {
            this.amount = builder.getAmount();
            this.amountReference = Optional.ofNullable(builder.getAmountReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="amountReference")
        @RuneAttribute(value="amountReference")
        public AmountReference getAmountReference() {
            return this.amountReference;
        }

        @Override
        public AmountRef build() {
            return this;
        }

        @Override
        public AmountRefBuilder toBuilder() {
            AmountRefBuilder builder = AmountRef.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AmountRefBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getAmountReference()).ifPresent(builder::setAmountReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AmountRef _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.amountReference, _that.getAmountReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.amountReference != null ? this.amountReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AmountRef {amount=" + this.amount + ", amountReference=" + this.amountReference + '}';
        }
    }
}

