/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CreditEntityModel;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.UnderlyingAsset;
import fpml.consolidated.asset.meta.SimpleCreditDefaultSwapMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.Period;
import fpml.consolidated.shared.ProductReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SimpleCreditDefaultSwap", builder=SimpleCreditDefaultSwapBuilderImpl.class, version="1.1.0")
@RuneDataType(value="SimpleCreditDefaultSwap", model="fpml", builder=SimpleCreditDefaultSwapBuilderImpl.class, version="1.1.0")
public interface SimpleCreditDefaultSwap
extends UnderlyingAsset {
    public static final SimpleCreditDefaultSwapMeta metaData = new SimpleCreditDefaultSwapMeta();

    public CreditEntityModel getCreditEntityModel();

    public Period getTerm();

    public Period getPaymentFrequency();

    @Override
    public SimpleCreditDefaultSwap build();

    @Override
    public SimpleCreditDefaultSwapBuilder toBuilder();

    public static SimpleCreditDefaultSwapBuilder builder() {
        return new SimpleCreditDefaultSwapBuilderImpl();
    }

    default public RosettaMetaData<? extends SimpleCreditDefaultSwap> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SimpleCreditDefaultSwap> getType() {
        return SimpleCreditDefaultSwap.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEntityModel"), processor, CreditEntityModel.class, this.getCreditEntityModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("term"), processor, Period.class, this.getTerm(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
    }

    public static class SimpleCreditDefaultSwapBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements SimpleCreditDefaultSwapBuilder {
        protected CreditEntityModel.CreditEntityModelBuilder creditEntityModel;
        protected Period.PeriodBuilder term;
        protected Period.PeriodBuilder paymentFrequency;

        @Override
        @RosettaAttribute(value="creditEntityModel", isRequired=true)
        @RuneAttribute(value="creditEntityModel", isRequired=true)
        public CreditEntityModel.CreditEntityModelBuilder getCreditEntityModel() {
            return this.creditEntityModel;
        }

        @Override
        public CreditEntityModel.CreditEntityModelBuilder getOrCreateCreditEntityModel() {
            CreditEntityModel.CreditEntityModelBuilder result = this.creditEntityModel != null ? this.creditEntityModel : (this.creditEntityModel = CreditEntityModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="term")
        @RuneAttribute(value="term")
        public Period.PeriodBuilder getTerm() {
            return this.term;
        }

        @Override
        public Period.PeriodBuilder getOrCreateTerm() {
            Period.PeriodBuilder result = this.term != null ? this.term : (this.term = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period.PeriodBuilder getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Period.PeriodBuilder getOrCreatePaymentFrequency() {
            Period.PeriodBuilder result = this.paymentFrequency != null ? this.paymentFrequency : (this.paymentFrequency = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SimpleCreditDefaultSwapBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public SimpleCreditDefaultSwapBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public SimpleCreditDefaultSwapBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public SimpleCreditDefaultSwapBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public SimpleCreditDefaultSwapBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public SimpleCreditDefaultSwapBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public SimpleCreditDefaultSwapBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public SimpleCreditDefaultSwapBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public SimpleCreditDefaultSwapBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public SimpleCreditDefaultSwapBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEntityModel", isRequired=true)
        @RuneAttribute(value="creditEntityModel", isRequired=true)
        public SimpleCreditDefaultSwapBuilder setCreditEntityModel(CreditEntityModel _creditEntityModel) {
            this.creditEntityModel = _creditEntityModel == null ? null : _creditEntityModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="term")
        @RuneAttribute(value="term")
        public SimpleCreditDefaultSwapBuilder setTerm(Period _term) {
            this.term = _term == null ? null : _term.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public SimpleCreditDefaultSwapBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        public SimpleCreditDefaultSwap build() {
            return new SimpleCreditDefaultSwapImpl(this);
        }

        @Override
        public SimpleCreditDefaultSwapBuilder toBuilder() {
            return this;
        }

        @Override
        public SimpleCreditDefaultSwapBuilder prune() {
            super.prune();
            if (this.creditEntityModel != null && !this.creditEntityModel.prune().hasData()) {
                this.creditEntityModel = null;
            }
            if (this.term != null && !this.term.prune().hasData()) {
                this.term = null;
            }
            if (this.paymentFrequency != null && !this.paymentFrequency.prune().hasData()) {
                this.paymentFrequency = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCreditEntityModel() != null && this.getCreditEntityModel().hasData()) {
                return true;
            }
            if (this.getTerm() != null && this.getTerm().hasData()) {
                return true;
            }
            return this.getPaymentFrequency() != null && this.getPaymentFrequency().hasData();
        }

        @Override
        public SimpleCreditDefaultSwapBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SimpleCreditDefaultSwapBuilder o = (SimpleCreditDefaultSwapBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEntityModel(), (RosettaModelObjectBuilder)o.getCreditEntityModel(), this::setCreditEntityModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerm(), (RosettaModelObjectBuilder)o.getTerm(), this::setTerm);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentFrequency(), (RosettaModelObjectBuilder)o.getPaymentFrequency(), this::setPaymentFrequency);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleCreditDefaultSwap _that = (SimpleCreditDefaultSwap)this.getType().cast(o);
            if (!Objects.equals(this.creditEntityModel, _that.getCreditEntityModel())) {
                return false;
            }
            if (!Objects.equals(this.term, _that.getTerm())) {
                return false;
            }
            return Objects.equals(this.paymentFrequency, _that.getPaymentFrequency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.creditEntityModel != null ? this.creditEntityModel.hashCode() : 0);
            _result = 31 * _result + (this.term != null ? this.term.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SimpleCreditDefaultSwapBuilder {creditEntityModel=" + this.creditEntityModel + ", term=" + this.term + ", paymentFrequency=" + this.paymentFrequency + '}' + " " + super.toString();
        }
    }

    public static interface SimpleCreditDefaultSwapBuilder
    extends SimpleCreditDefaultSwap,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public CreditEntityModel.CreditEntityModelBuilder getOrCreateCreditEntityModel();

        @Override
        public CreditEntityModel.CreditEntityModelBuilder getCreditEntityModel();

        public Period.PeriodBuilder getOrCreateTerm();

        @Override
        public Period.PeriodBuilder getTerm();

        public Period.PeriodBuilder getOrCreatePaymentFrequency();

        @Override
        public Period.PeriodBuilder getPaymentFrequency();

        @Override
        public SimpleCreditDefaultSwapBuilder setId(String var1);

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentId(InstrumentId var1);

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public SimpleCreditDefaultSwapBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentType(InstrumentType var1);

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public SimpleCreditDefaultSwapBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public SimpleCreditDefaultSwapBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public SimpleCreditDefaultSwapBuilder setDescription(String var1);

        @Override
        public SimpleCreditDefaultSwapBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public SimpleCreditDefaultSwapBuilder setExchangeId(ExchangeId var1);

        @Override
        public SimpleCreditDefaultSwapBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public SimpleCreditDefaultSwapBuilder setDefinition(ProductReference var1);

        public SimpleCreditDefaultSwapBuilder setCreditEntityModel(CreditEntityModel var1);

        public SimpleCreditDefaultSwapBuilder setTerm(Period var1);

        public SimpleCreditDefaultSwapBuilder setPaymentFrequency(Period var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEntityModel"), processor, CreditEntityModel.CreditEntityModelBuilder.class, this.getCreditEntityModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("term"), processor, Period.PeriodBuilder.class, this.getTerm(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        }

        @Override
        public SimpleCreditDefaultSwapBuilder prune();
    }

    public static class SimpleCreditDefaultSwapImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements SimpleCreditDefaultSwap {
        private final CreditEntityModel creditEntityModel;
        private final Period term;
        private final Period paymentFrequency;

        protected SimpleCreditDefaultSwapImpl(SimpleCreditDefaultSwapBuilder builder) {
            super(builder);
            this.creditEntityModel = Optional.ofNullable(builder.getCreditEntityModel()).map(f -> f.build()).orElse(null);
            this.term = Optional.ofNullable(builder.getTerm()).map(f -> f.build()).orElse(null);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="creditEntityModel", isRequired=true)
        @RuneAttribute(value="creditEntityModel", isRequired=true)
        public CreditEntityModel getCreditEntityModel() {
            return this.creditEntityModel;
        }

        @Override
        @RosettaAttribute(value="term")
        @RuneAttribute(value="term")
        public Period getTerm() {
            return this.term;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public SimpleCreditDefaultSwap build() {
            return this;
        }

        @Override
        public SimpleCreditDefaultSwapBuilder toBuilder() {
            SimpleCreditDefaultSwapBuilder builder = SimpleCreditDefaultSwap.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SimpleCreditDefaultSwapBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCreditEntityModel()).ifPresent(builder::setCreditEntityModel);
            Optional.ofNullable(this.getTerm()).ifPresent(builder::setTerm);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleCreditDefaultSwap _that = (SimpleCreditDefaultSwap)this.getType().cast(o);
            if (!Objects.equals(this.creditEntityModel, _that.getCreditEntityModel())) {
                return false;
            }
            if (!Objects.equals(this.term, _that.getTerm())) {
                return false;
            }
            return Objects.equals(this.paymentFrequency, _that.getPaymentFrequency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.creditEntityModel != null ? this.creditEntityModel.hashCode() : 0);
            _result = 31 * _result + (this.term != null ? this.term.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SimpleCreditDefaultSwap {creditEntityModel=" + this.creditEntityModel + ", term=" + this.term + ", paymentFrequency=" + this.paymentFrequency + '}' + " " + super.toString();
        }
    }
}

