/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.IdentifiedAssetMeta;
import fpml.consolidated.shared.InstrumentId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="IdentifiedAsset", builder=IdentifiedAssetBuilderImpl.class, version="1.1.0")
@RuneDataType(value="IdentifiedAsset", model="fpml", builder=IdentifiedAssetBuilderImpl.class, version="1.1.0")
public interface IdentifiedAsset
extends Asset {
    public static final IdentifiedAssetMeta metaData = new IdentifiedAssetMeta();

    public List<? extends InstrumentId> getInstrumentId();

    public List<? extends InstrumentType> getInstrumentType();

    public String getDescription();

    @Override
    public IdentifiedAsset build();

    @Override
    public IdentifiedAssetBuilder toBuilder();

    public static IdentifiedAssetBuilder builder() {
        return new IdentifiedAssetBuilderImpl();
    }

    default public RosettaMetaData<? extends IdentifiedAsset> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends IdentifiedAsset> getType() {
        return IdentifiedAsset.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class IdentifiedAssetBuilderImpl
    extends Asset.AssetBuilderImpl
    implements IdentifiedAssetBuilder {
        protected List<InstrumentId.InstrumentIdBuilder> instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
        protected List<InstrumentType.InstrumentTypeBuilder> instrumentType = new ArrayList<InstrumentType.InstrumentTypeBuilder>();
        protected String description;

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int index) {
            if (this.instrumentId == null) {
                this.instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
            }
            return (InstrumentId.InstrumentIdBuilder)this.getIndex(this.instrumentId, index, () -> {
                InstrumentId.InstrumentIdBuilder newInstrumentId = InstrumentId.builder();
                return newInstrumentId;
            });
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public List<? extends InstrumentType.InstrumentTypeBuilder> getInstrumentType() {
            return this.instrumentType;
        }

        @Override
        public InstrumentType.InstrumentTypeBuilder getOrCreateInstrumentType(int index) {
            if (this.instrumentType == null) {
                this.instrumentType = new ArrayList<InstrumentType.InstrumentTypeBuilder>();
            }
            return (InstrumentType.InstrumentTypeBuilder)this.getIndex(this.instrumentType, index, () -> {
                InstrumentType.InstrumentTypeBuilder newInstrumentType = InstrumentType.builder();
                return newInstrumentType;
            });
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public IdentifiedAssetBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public IdentifiedAssetBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public IdentifiedAssetBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public IdentifiedAssetBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public IdentifiedAssetBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList<InstrumentId.InstrumentIdBuilder>() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public IdentifiedAssetBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public IdentifiedAssetBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public IdentifiedAssetBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public IdentifiedAssetBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList<InstrumentType.InstrumentTypeBuilder>() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public IdentifiedAssetBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        public IdentifiedAsset build() {
            return new IdentifiedAssetImpl(this);
        }

        @Override
        public IdentifiedAssetBuilder toBuilder() {
            return this;
        }

        @Override
        public IdentifiedAssetBuilder prune() {
            super.prune();
            this.instrumentId = this.instrumentId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.instrumentType = this.instrumentType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInstrumentId() != null && this.getInstrumentId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getInstrumentType() != null && this.getInstrumentType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDescription() != null;
        }

        @Override
        public IdentifiedAssetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            IdentifiedAssetBuilder o = (IdentifiedAssetBuilder)other;
            merger.mergeRosetta(this.getInstrumentId(), o.getInstrumentId(), this::getOrCreateInstrumentId);
            merger.mergeRosetta(this.getInstrumentType(), o.getInstrumentType(), this::getOrCreateInstrumentType);
            merger.mergeBasic((Object)this.getDescription(), (Object)o.getDescription(), this::setDescription, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IdentifiedAsset _that = (IdentifiedAsset)this.getType().cast(o);
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.instrumentType, _that.getInstrumentType())) {
                return false;
            }
            return Objects.equals(this.description, _that.getDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.instrumentType != null ? this.instrumentType.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "IdentifiedAssetBuilder {instrumentId=" + this.instrumentId + ", instrumentType=" + this.instrumentType + ", description=" + this.description + '}' + " " + super.toString();
        }
    }

    public static interface IdentifiedAssetBuilder
    extends IdentifiedAsset,
    Asset.AssetBuilder {
        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int var1);

        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId();

        public InstrumentType.InstrumentTypeBuilder getOrCreateInstrumentType(int var1);

        public List<? extends InstrumentType.InstrumentTypeBuilder> getInstrumentType();

        @Override
        public IdentifiedAssetBuilder setId(String var1);

        public IdentifiedAssetBuilder addInstrumentId(InstrumentId var1);

        public IdentifiedAssetBuilder addInstrumentId(InstrumentId var1, int var2);

        public IdentifiedAssetBuilder addInstrumentId(List<? extends InstrumentId> var1);

        public IdentifiedAssetBuilder setInstrumentId(List<? extends InstrumentId> var1);

        public IdentifiedAssetBuilder addInstrumentType(InstrumentType var1);

        public IdentifiedAssetBuilder addInstrumentType(InstrumentType var1, int var2);

        public IdentifiedAssetBuilder addInstrumentType(List<? extends InstrumentType> var1);

        public IdentifiedAssetBuilder setInstrumentType(List<? extends InstrumentType> var1);

        public IdentifiedAssetBuilder setDescription(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public IdentifiedAssetBuilder prune();
    }

    public static class IdentifiedAssetImpl
    extends Asset.AssetImpl
    implements IdentifiedAsset {
        private final List<? extends InstrumentId> instrumentId;
        private final List<? extends InstrumentType> instrumentType;
        private final String description;

        protected IdentifiedAssetImpl(IdentifiedAssetBuilder builder) {
            super(builder);
            this.instrumentId = Optional.ofNullable(builder.getInstrumentId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.instrumentType = Optional.ofNullable(builder.getInstrumentType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.description = builder.getDescription();
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public List<? extends InstrumentId> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public List<? extends InstrumentType> getInstrumentType() {
            return this.instrumentType;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        public IdentifiedAsset build() {
            return this;
        }

        @Override
        public IdentifiedAssetBuilder toBuilder() {
            IdentifiedAssetBuilder builder = IdentifiedAsset.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IdentifiedAssetBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInstrumentId()).ifPresent(builder::setInstrumentId);
            Optional.ofNullable(this.getInstrumentType()).ifPresent(builder::setInstrumentType);
            Optional.ofNullable(this.getDescription()).ifPresent(builder::setDescription);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IdentifiedAsset _that = (IdentifiedAsset)this.getType().cast(o);
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.instrumentType, _that.getInstrumentType())) {
                return false;
            }
            return Objects.equals(this.description, _that.getDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.instrumentType != null ? this.instrumentType.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "IdentifiedAsset {instrumentId=" + this.instrumentId + ", instrumentType=" + this.instrumentType + ", description=" + this.description + '}' + " " + super.toString();
        }
    }
}

